/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.consent;

import com.google.ads.consent.AdProvider;
import com.google.ads.consent.ConsentStatus;
import com.google.gson.annotations.SerializedName;
import java.util.HashSet;

class ConsentData {
    private static final String SDK_PLATFORM = "android";
    private static final String SDK_VERSION = "1.0.6";
    @SerializedName(value="providers")
    private HashSet<AdProvider> adProviders = new HashSet();
    @SerializedName(value="is_request_in_eea_or_unknown")
    private boolean isRequestLocationInEeaOrUnknown = false;
    @SerializedName(value="consented_providers")
    private HashSet<AdProvider> consentedAdProviders = new HashSet();
    @SerializedName(value="tag_for_under_age_of_consent")
    private Boolean underAgeOfConsent = false;
    @SerializedName(value="consent_state")
    private ConsentStatus consentStatus;
    @SerializedName(value="pub_ids")
    private HashSet<String> publisherIds = new HashSet();
    @SerializedName(value="has_any_npa_pub_id")
    private boolean hasNonPersonalizedPublisherId = false;
    @SerializedName(value="consent_source")
    private String consentSource;
    @SerializedName(value="version")
    private final String sdkVersionString;
    @SerializedName(value="plat")
    private final String sdkPlatformString;
    @SerializedName(value="raw_response")
    private String rawResponse = "";

    ConsentData() {
        this.consentStatus = ConsentStatus.UNKNOWN;
        this.sdkVersionString = SDK_VERSION;
        this.sdkPlatformString = SDK_PLATFORM;
    }

    boolean isTaggedForUnderAgeOfConsent() {
        return this.underAgeOfConsent;
    }

    void tagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        this.underAgeOfConsent = underAgeOfConsent;
    }

    HashSet<AdProvider> getAdProviders() {
        return this.adProviders;
    }

    void setAdProviders(HashSet<AdProvider> adProviders) {
        this.adProviders = adProviders;
    }

    ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    HashSet<String> getPublisherIds() {
        return this.publisherIds;
    }

    void setPublisherIds(HashSet<String> publisherIds) {
        this.publisherIds = publisherIds;
    }

    boolean isRequestLocationInEeaOrUnknown() {
        return this.isRequestLocationInEeaOrUnknown;
    }

    void setRequestLocationInEeaOrUnknown(boolean eeaRequestLocationOrUnknown) {
        this.isRequestLocationInEeaOrUnknown = eeaRequestLocationOrUnknown;
    }

    HashSet<AdProvider> getConsentedAdProviders() {
        return this.consentedAdProviders;
    }

    void setConsentedAdProviders(HashSet<AdProvider> consentedAdProviders) {
        this.consentedAdProviders = consentedAdProviders;
    }

    boolean hasNonPersonalizedPublisherId() {
        return this.hasNonPersonalizedPublisherId;
    }

    void setHasNonPersonalizedPublisherId(boolean hasNonPersonalizedPublisherId) {
        this.hasNonPersonalizedPublisherId = hasNonPersonalizedPublisherId;
    }

    public String getSDKVersionString() {
        return this.sdkVersionString;
    }

    public String getSDKPlatformString() {
        return this.sdkPlatformString;
    }

    public String getConsentSource() {
        return this.consentSource;
    }

    public void setConsentSource(String consentSource) {
        this.consentSource = consentSource;
    }

    String getRawResponse() {
        return this.rawResponse;
    }

    void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }
}

