/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.consent;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.ads.consent.ConsentData;
import com.google.ads.consent.ConsentFormListener;
import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;

public class ConsentForm {
    private final ConsentFormListener listener;
    private final Context context;
    private final boolean personalizedAdsOption;
    private final boolean nonPersonalizedAdsOption;
    private final boolean adFreeOption;
    private final URL appPrivacyPolicyURL;
    private final Dialog dialog;
    private final WebView webView;
    private LoadState loadState;

    private ConsentForm(Builder builder) {
        this.context = builder.context;
        this.listener = builder.listener == null ? new ConsentFormListener(this){} : builder.listener;
        this.personalizedAdsOption = builder.personalizedAdsOption;
        this.nonPersonalizedAdsOption = builder.nonPersonalizedAdsOption;
        this.adFreeOption = builder.adFreeOption;
        this.appPrivacyPolicyURL = builder.appPrivacyPolicyURL;
        this.dialog = new Dialog(this.context, 0x1030010);
        this.loadState = LoadState.NOT_READY;
        this.webView = new WebView(this.context);
        this.webView.setBackgroundColor(0);
        this.dialog.setContentView((View)this.webView);
        this.dialog.setCancelable(false);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new WebViewClient(){
            boolean isInternalRedirect;

            private boolean isConsentFormUrl(String url) {
                return !TextUtils.isEmpty((CharSequence)url) && url.startsWith("consent://");
            }

            private void handleUrl(String url) {
                if (!this.isConsentFormUrl(url)) {
                    return;
                }
                this.isInternalRedirect = true;
                Uri uri = Uri.parse((String)url);
                String action = uri.getQueryParameter("action");
                String status = uri.getQueryParameter("status");
                String browserUrl = uri.getQueryParameter("url");
                switch (action) {
                    case "load_complete": {
                        ConsentForm.this.handleLoadComplete(status);
                        break;
                    }
                    case "dismiss": {
                        this.isInternalRedirect = false;
                        ConsentForm.this.handleDismiss(status);
                        break;
                    }
                    case "browser": {
                        ConsentForm.this.handleOpenBrowser(browserUrl);
                        break;
                    }
                }
            }

            public void onLoadResource(WebView view, String url) {
                this.handleUrl(url);
            }

            @TargetApi(value=24)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url = request.getUrl().toString();
                if (this.isConsentFormUrl(url)) {
                    this.handleUrl(url);
                    return true;
                }
                return false;
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (this.isConsentFormUrl(url)) {
                    this.handleUrl(url);
                    return true;
                }
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                if (!this.isInternalRedirect) {
                    ConsentForm.this.updateDialogContent(view);
                }
                super.onPageFinished(view, url);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                ConsentForm.this.loadState = LoadState.NOT_READY;
                ConsentForm.this.listener.onConsentFormError(error.toString());
            }
        });
    }

    private static String getApplicationName(Context context) {
        return context.getApplicationInfo().loadLabel(context.getPackageManager()).toString();
    }

    private static String getAppIconURIString(Context context) {
        Drawable iconDrawable = context.getPackageManager().getApplicationIcon(context.getApplicationInfo());
        Bitmap bitmap = Bitmap.createBitmap((int)iconDrawable.getIntrinsicWidth(), (int)iconDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        iconDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        iconDrawable.draw(canvas);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        String string = String.valueOf(Base64.encodeToString((byte[])byteArray, (int)0));
        return string.length() != 0 ? "data:image/png;base64,".concat(string) : new String("data:image/png;base64,");
    }

    private static String createJavascriptCommand(String command, String argumentsJSON) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("info", argumentsJSON);
        HashMap<String, HashMap<String, String>> wrappedArgs = new HashMap<String, HashMap<String, String>>();
        wrappedArgs.put("args", args);
        return String.format("javascript:%s(%s)", command, new Gson().toJson(wrappedArgs));
    }

    private void updateDialogContent(WebView webView) {
        HashMap<String, Object> formInfo = new HashMap<String, Object>();
        formInfo.put("app_name", ConsentForm.getApplicationName(this.context));
        formInfo.put("app_icon", ConsentForm.getAppIconURIString(this.context));
        formInfo.put("offer_personalized", this.personalizedAdsOption);
        formInfo.put("offer_non_personalized", this.nonPersonalizedAdsOption);
        formInfo.put("offer_ad_free", this.adFreeOption);
        formInfo.put("is_request_in_eea_or_unknown", ConsentInformation.getInstance(this.context).isRequestLocationInEeaOrUnknown());
        formInfo.put("app_privacy_url", this.appPrivacyPolicyURL);
        ConsentData consentData = ConsentInformation.getInstance(this.context).loadConsentData();
        formInfo.put("plat", consentData.getSDKPlatformString());
        formInfo.put("consent_info", consentData);
        String argumentsJSON = new Gson().toJson(formInfo);
        String javascriptCommand = ConsentForm.createJavascriptCommand("setUpConsentDialog", argumentsJSON);
        webView.loadUrl(javascriptCommand);
    }

    public void load() {
        if (this.loadState == LoadState.LOADING) {
            this.listener.onConsentFormError("Cannot simultaneously load multiple consent forms.");
            return;
        }
        if (this.loadState == LoadState.LOADED) {
            this.listener.onConsentFormLoaded();
            return;
        }
        this.loadState = LoadState.LOADING;
        this.webView.loadUrl("file:///android_asset/consentform.html");
    }

    private void handleLoadComplete(String status) {
        if (TextUtils.isEmpty((CharSequence)status)) {
            this.loadState = LoadState.NOT_READY;
            this.listener.onConsentFormError("No information");
        } else if (status.contains("Error")) {
            this.loadState = LoadState.NOT_READY;
            this.listener.onConsentFormError(status);
        } else {
            this.loadState = LoadState.LOADED;
            this.listener.onConsentFormLoaded();
        }
    }

    private void handleOpenBrowser(String urlString) {
        if (TextUtils.isEmpty((CharSequence)urlString)) {
            this.listener.onConsentFormError("No valid URL for browser navigation.");
            return;
        }
        try {
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)urlString));
            this.context.startActivity(browserIntent);
        }
        catch (ActivityNotFoundException exception) {
            this.listener.onConsentFormError("No Activity found to handle browser intent.");
        }
    }

    private void handleDismiss(String status) {
        ConsentStatus consentStatus;
        this.loadState = LoadState.NOT_READY;
        this.dialog.dismiss();
        if (TextUtils.isEmpty((CharSequence)status)) {
            this.listener.onConsentFormError("No information provided.");
            return;
        }
        if (status.contains("Error")) {
            this.listener.onConsentFormError(status);
            return;
        }
        boolean userPrefersAdFree = false;
        switch (status) {
            case "personalized": {
                consentStatus = ConsentStatus.PERSONALIZED;
                break;
            }
            case "non_personalized": {
                consentStatus = ConsentStatus.NON_PERSONALIZED;
                break;
            }
            case "ad_free": {
                userPrefersAdFree = true;
                consentStatus = ConsentStatus.UNKNOWN;
                break;
            }
            default: {
                consentStatus = ConsentStatus.UNKNOWN;
            }
        }
        ConsentInformation.getInstance(this.context).setConsentStatus(consentStatus, "form");
        this.listener.onConsentFormClosed(consentStatus, userPrefersAdFree);
    }

    public void show() {
        if (this.loadState != LoadState.LOADED) {
            this.listener.onConsentFormError("Consent form is not ready to be displayed.");
            return;
        }
        if (ConsentInformation.getInstance(this.context).isTaggedForUnderAgeOfConsent()) {
            this.listener.onConsentFormError("Error: tagged for under age of consent");
            return;
        }
        this.dialog.getWindow().setLayout(-1, -1);
        this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                ConsentForm.this.listener.onConsentFormOpened();
            }
        });
        this.dialog.show();
        if (!this.dialog.isShowing()) {
            this.listener.onConsentFormError("Consent form could not be displayed.");
        }
    }

    public boolean isShowing() {
        return this.dialog.isShowing();
    }

    public static class Builder {
        private final Context context;
        private ConsentFormListener listener;
        private boolean personalizedAdsOption;
        private boolean nonPersonalizedAdsOption;
        private boolean adFreeOption;
        private final URL appPrivacyPolicyURL;

        public Builder(Context context, URL appPrivacyPolicyURL) {
            this.context = context;
            this.personalizedAdsOption = false;
            this.nonPersonalizedAdsOption = false;
            this.adFreeOption = false;
            this.appPrivacyPolicyURL = appPrivacyPolicyURL;
            if (this.appPrivacyPolicyURL == null) {
                throw new IllegalArgumentException("Must provide valid app privacy policy url to create a ConsentForm");
            }
        }

        public Builder withListener(ConsentFormListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withPersonalizedAdsOption() {
            this.personalizedAdsOption = true;
            return this;
        }

        public Builder withNonPersonalizedAdsOption() {
            this.nonPersonalizedAdsOption = true;
            return this;
        }

        public Builder withAdFreeOption() {
            this.adFreeOption = true;
            return this;
        }

        public ConsentForm build() {
            return new ConsentForm(this);
        }
    }

    private static enum LoadState {
        NOT_READY,
        LOADING,
        LOADED;

    }
}

