/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.consent;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import com.google.ads.consent.AdProvider;
import com.google.ads.consent.ConsentData;
import com.google.ads.consent.ConsentInfoUpdateListener;
import com.google.ads.consent.ConsentStatus;
import com.google.ads.consent.DebugGeography;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class ConsentInformation {
    private static final String MOBILE_ADS_SERVER_URL = "https://adservice.google.com/getconfig/pubvendors";
    private static final String TAG = "ConsentInformation";
    private static final String PREFERENCES_FILE_KEY = "mobileads_consent";
    private static final String CONSENT_DATA_KEY = "consent_string";
    private static ConsentInformation instance;
    private final Context context;
    private List<String> testDevices;
    private String hashedDeviceId;
    private DebugGeography debugGeography;

    private ConsentInformation(Context context) {
        this.context = context.getApplicationContext();
        this.debugGeography = DebugGeography.DEBUG_GEOGRAPHY_DISABLED;
        this.testDevices = new ArrayList<String>();
        this.hashedDeviceId = this.getHashedDeviceId();
    }

    public static synchronized ConsentInformation getInstance(Context context) {
        if (instance == null) {
            instance = new ConsentInformation(context);
        }
        return instance;
    }

    private String getHashedDeviceId() {
        ContentResolver contentResolver = this.context.getContentResolver();
        String androidId = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return this.md5(androidId == null || this.isEmulator() ? "emulator" : androidId);
    }

    private String md5(String string) {
        for (int i = 0; i < 3; ++i) {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, md5.digest()));
            }
            catch (NoSuchAlgorithmException md5) {
                continue;
            }
            catch (ArithmeticException ex) {
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    protected void setHashedDeviceId(String hashedDeviceId) {
        this.hashedDeviceId = hashedDeviceId;
    }

    private boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public boolean isTestDevice() {
        return this.isEmulator() || this.testDevices.contains(this.hashedDeviceId);
    }

    public void addTestDevice(String hashedDeviceId) {
        this.testDevices.add(hashedDeviceId);
    }

    public DebugGeography getDebugGeography() {
        return this.debugGeography;
    }

    public void setDebugGeography(DebugGeography debugGeography) {
        this.debugGeography = debugGeography;
    }

    public synchronized void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        ConsentData consentData = this.loadConsentData();
        consentData.tagForUnderAgeOfConsent(underAgeOfConsent);
        this.saveConsentData(consentData);
    }

    public synchronized boolean isTaggedForUnderAgeOfConsent() {
        return this.loadConsentData().isTaggedForUnderAgeOfConsent();
    }

    public synchronized void reset() {
        SharedPreferences.Editor editor = this.context.getSharedPreferences(PREFERENCES_FILE_KEY, 0).edit();
        editor.clear();
        editor.apply();
        this.testDevices = new ArrayList<String>();
    }

    public void requestConsentInfoUpdate(String[] publisherIds, ConsentInfoUpdateListener listener) {
        this.requestConsentInfoUpdate(publisherIds, MOBILE_ADS_SERVER_URL, listener);
    }

    @VisibleForTesting
    protected void requestConsentInfoUpdate(String[] publisherIds, String url, ConsentInfoUpdateListener listener) {
        if (this.isTestDevice()) {
            Log.i((String)TAG, (String)"This request is sent from a test device.");
        } else {
            String string = this.getHashedDeviceId();
            Log.i((String)TAG, (String)new StringBuilder(93 + String.valueOf(string).length()).append("Use ConsentInformation.getInstance(context).addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        new ConsentInfoUpdateTask(url, this, Arrays.asList(publisherIds), listener).execute(new Void[0]);
    }

    private void validatePublisherIds(ServerResponse response) throws Exception {
        if (response.isRequestLocationInEeaOrUnknown == null) {
            throw new Exception("Could not parse Event FE preflight response.");
        }
        if (response.companies == null && response.isRequestLocationInEeaOrUnknown.booleanValue()) {
            throw new Exception("Could not parse Event FE preflight response.");
        }
        if (!response.isRequestLocationInEeaOrUnknown.booleanValue()) {
            return;
        }
        HashSet<String> lookupFailedPublisherIds = new HashSet<String>();
        HashSet<String> notFoundPublisherIds = new HashSet<String>();
        for (AdNetworkLookupResponse adNetworkLookupResponse : response.adNetworkLookupResponses) {
            if (adNetworkLookupResponse.lookupFailed) {
                lookupFailedPublisherIds.add(adNetworkLookupResponse.id);
            }
            if (!adNetworkLookupResponse.notFound) continue;
            notFoundPublisherIds.add(adNetworkLookupResponse.id);
        }
        if (lookupFailedPublisherIds.isEmpty() && notFoundPublisherIds.isEmpty()) {
            return;
        }
        StringBuilder errorString = new StringBuilder("Response error.");
        if (!lookupFailedPublisherIds.isEmpty()) {
            String lookupFailedPublisherIdsString = TextUtils.join((CharSequence)",", lookupFailedPublisherIds);
            errorString.append(String.format(" Lookup failure for: %s.", lookupFailedPublisherIdsString));
        }
        if (!notFoundPublisherIds.isEmpty()) {
            String notFoundPublisherIdsString = TextUtils.join((CharSequence)",", notFoundPublisherIds);
            errorString.append(String.format(" Publisher Ids not found: %s", notFoundPublisherIdsString));
        }
        throw new Exception(errorString.toString());
    }

    private HashSet<AdProvider> getNonPersonalizedAdProviders(List<AdProvider> adProviders, HashSet<String> nonPersonalizedAdProviderIds) {
        ArrayList<AdProvider> nonPersonalizedAdProviders = new ArrayList<AdProvider>();
        for (AdProvider adProvider : adProviders) {
            if (!nonPersonalizedAdProviderIds.contains(adProvider.getId())) continue;
            nonPersonalizedAdProviders.add(adProvider);
        }
        return new HashSet<AdProvider>(nonPersonalizedAdProviders);
    }

    private synchronized void updateConsentData(String responseString, List<String> publisherIds) throws Exception {
        ServerResponse response = (ServerResponse)new Gson().fromJson(responseString, ServerResponse.class);
        this.validatePublisherIds(response);
        boolean hasNonPersonalizedPublisherId = false;
        HashSet<String> nonPersonalizedAdProvidersIds = new HashSet<String>();
        if (response.adNetworkLookupResponses != null) {
            for (AdNetworkLookupResponse adNetworkLookupResponse : response.adNetworkLookupResponses) {
                if (!adNetworkLookupResponse.isNPA) continue;
                hasNonPersonalizedPublisherId = true;
                List companyIds = adNetworkLookupResponse.companyIds;
                if (companyIds == null) continue;
                nonPersonalizedAdProvidersIds.addAll(companyIds);
            }
        }
        HashSet<Object> newAdProviderSet = response.companies == null ? new HashSet() : (hasNonPersonalizedPublisherId ? this.getNonPersonalizedAdProviders(response.companies, nonPersonalizedAdProvidersIds) : new HashSet<AdProvider>(response.companies));
        ConsentData consentData = this.loadConsentData();
        boolean hasNonPersonalizedPublisherIdChanged = consentData.hasNonPersonalizedPublisherId() != hasNonPersonalizedPublisherId;
        consentData.setHasNonPersonalizedPublisherId(hasNonPersonalizedPublisherId);
        consentData.setRawResponse(responseString);
        consentData.setPublisherIds(new HashSet<String>(publisherIds));
        consentData.setAdProviders(newAdProviderSet);
        consentData.setRequestLocationInEeaOrUnknown(response.isRequestLocationInEeaOrUnknown);
        if (!response.isRequestLocationInEeaOrUnknown.booleanValue()) {
            this.saveConsentData(consentData);
            return;
        }
        if (!consentData.getAdProviders().equals(consentData.getConsentedAdProviders()) || hasNonPersonalizedPublisherIdChanged) {
            consentData.setConsentSource("sdk");
            consentData.setConsentStatus(ConsentStatus.UNKNOWN);
            consentData.setConsentedAdProviders(new HashSet<AdProvider>());
        }
        this.saveConsentData(consentData);
    }

    public synchronized List<AdProvider> getAdProviders() {
        ConsentData consentData = this.loadConsentData();
        return new ArrayList<AdProvider>(consentData.getAdProviders());
    }

    protected ConsentData loadConsentData() {
        SharedPreferences sharedPref = this.context.getSharedPreferences(PREFERENCES_FILE_KEY, 0);
        String consentDataString = sharedPref.getString(CONSENT_DATA_KEY, "");
        if (TextUtils.isEmpty((CharSequence)consentDataString)) {
            return new ConsentData();
        }
        return (ConsentData)new Gson().fromJson(consentDataString, ConsentData.class);
    }

    private void saveConsentData(ConsentData consentData) {
        SharedPreferences sharedPref = this.context.getSharedPreferences(PREFERENCES_FILE_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        String consentDataString = new Gson().toJson((Object)consentData);
        editor.putString(CONSENT_DATA_KEY, consentDataString);
        editor.apply();
    }

    public boolean isRequestLocationInEeaOrUnknown() {
        ConsentData consentData = this.loadConsentData();
        return consentData.isRequestLocationInEeaOrUnknown();
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.setConsentStatus(consentStatus, "programmatic");
    }

    protected synchronized void setConsentStatus(ConsentStatus consentStatus, String source) {
        ConsentData consentData = this.loadConsentData();
        if (consentStatus == ConsentStatus.UNKNOWN) {
            consentData.setConsentedAdProviders(new HashSet<AdProvider>());
        } else {
            consentData.setConsentedAdProviders(consentData.getAdProviders());
        }
        consentData.setConsentSource(source);
        consentData.setConsentStatus(consentStatus);
        this.saveConsentData(consentData);
    }

    public synchronized ConsentStatus getConsentStatus() {
        ConsentData consentData = this.loadConsentData();
        return consentData.getConsentStatus();
    }

    private static class ConsentInfoUpdateTask
    extends AsyncTask<Void, Void, ConsentInfoUpdateResponse> {
        private static final String UPDATE_SUCCESS = "Consent update successful.";
        private final String url;
        private final ConsentInformation consentInformation;
        private final List<String> publisherIds;
        private final ConsentInfoUpdateListener listener;

        ConsentInfoUpdateTask(String url, ConsentInformation consentInformation, List<String> publisherIds, ConsentInfoUpdateListener listener) {
            this.url = url;
            this.listener = listener;
            this.publisherIds = publisherIds;
            this.consentInformation = consentInformation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readStream(InputStream inputStream) {
            byte[] contents = new byte[1024];
            StringBuilder strFileContents = new StringBuilder();
            BufferedInputStream stream = new BufferedInputStream(inputStream);
            try {
                int bytesRead;
                while ((bytesRead = ((InputStream)stream).read(contents)) != -1) {
                    strFileContents.append(new String(contents, 0, bytesRead));
                }
            }
            catch (IOException e) {
                Log.e((String)ConsentInformation.TAG, (String)e.getLocalizedMessage());
                String string = null;
                return string;
            }
            finally {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    Log.e((String)ConsentInformation.TAG, (String)e.getLocalizedMessage());
                }
            }
            return strFileContents.toString();
        }

        private ConsentInfoUpdateResponse makeConsentLookupRequest(String urlString) {
            try {
                URL url = new URL(urlString);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                if (urlConnection.getResponseCode() == 200) {
                    String responseString = this.readStream(urlConnection.getInputStream());
                    urlConnection.disconnect();
                    this.consentInformation.updateConsentData(responseString, this.publisherIds);
                    return new ConsentInfoUpdateResponse(true, UPDATE_SUCCESS);
                }
                return new ConsentInfoUpdateResponse(false, urlConnection.getResponseMessage());
            }
            catch (Exception e) {
                return new ConsentInfoUpdateResponse(false, e.getLocalizedMessage());
            }
        }

        public ConsentInfoUpdateResponse doInBackground(Void ... unused) {
            String publisherIdsString = TextUtils.join((CharSequence)",", this.publisherIds);
            ConsentData consentData = this.consentInformation.loadConsentData();
            Uri.Builder uriBuilder = Uri.parse((String)this.url).buildUpon().appendQueryParameter("pubs", publisherIdsString).appendQueryParameter("es", "2").appendQueryParameter("plat", consentData.getSDKPlatformString()).appendQueryParameter("v", consentData.getSDKVersionString());
            if (this.consentInformation.isTestDevice() && this.consentInformation.getDebugGeography() != DebugGeography.DEBUG_GEOGRAPHY_DISABLED) {
                uriBuilder = uriBuilder.appendQueryParameter("debug_geo", this.consentInformation.getDebugGeography().getCode().toString());
            }
            return this.makeConsentLookupRequest(uriBuilder.build().toString());
        }

        protected void onPostExecute(ConsentInfoUpdateResponse result) {
            if (result.success) {
                this.listener.onConsentInfoUpdated(this.consentInformation.getConsentStatus());
            } else {
                this.listener.onFailedToUpdateConsentInfo(result.responseInfo);
            }
        }
    }

    @VisibleForTesting
    protected static class ServerResponse {
        List<AdProvider> companies;
        @SerializedName(value="ad_network_ids")
        List<AdNetworkLookupResponse> adNetworkLookupResponses;
        @SerializedName(value="is_request_in_eea_or_unknown")
        Boolean isRequestLocationInEeaOrUnknown;

        protected ServerResponse() {
        }
    }

    private static class AdNetworkLookupResponse {
        @SerializedName(value="ad_network_id")
        private String id;
        @SerializedName(value="company_ids")
        private List<String> companyIds;
        @SerializedName(value="lookup_failed")
        private boolean lookupFailed;
        @SerializedName(value="not_found")
        private boolean notFound;
        @SerializedName(value="is_npa")
        private boolean isNPA;

        private AdNetworkLookupResponse() {
        }
    }

    private static class ConsentInfoUpdateResponse {
        boolean success;
        String responseInfo;

        ConsentInfoUpdateResponse(boolean success, String responseInfo) {
            this.success = success;
            this.responseInfo = responseInfo;
        }
    }
}

