/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.Process;
import android.os.StrictMode;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.IOUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.annotation.Nullable;

@KeepForSdk
public class ProcessUtils {
    private static String zzhd = null;
    private static int zzhe = 0;

    private ProcessUtils() {
    }

    @Nullable
    @KeepForSdk
    public static String getMyProcessName() {
        if (zzhd == null) {
            if (zzhe == 0) {
                zzhe = Process.myPid();
            }
            zzhd = ProcessUtils.zzd(zzhe);
        }
        return zzhd;
    }

    @Nullable
    private static String zzd(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            bufferedReader = ProcessUtils.zzj(new StringBuilder(25).append("/proc/").append(n).append("/cmdline").toString());
            string2 = bufferedReader.readLine().trim();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(bufferedReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        return string2;
    }

    private static BufferedReader zzj(String string2) throws IOException {
        BufferedReader bufferedReader;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        return bufferedReader;
    }
}

