/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final GoogleApiAvailabilityLight zziu = GoogleApiAvailabilityLight.getInstance();
    private static final Object lock = new Object();
    private static Method zziv = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    public ProviderInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Context context2;
        Preconditions.checkNotNull(context, "Context must not be null");
        zziu.verifyGooglePlayServicesIsAvailable(context, 11925000);
        try {
            context2 = GooglePlayServicesUtilLight.getRemoteContext(context);
        }
        catch (Resources.NotFoundException notFoundException) {
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                Log.e((String)"ProviderInstaller", (String)"Failed to get remote context - resource not found");
            }
            throw new GooglePlayServicesNotAvailableException(8);
        }
        if (context2 == null) {
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            }
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = lock;
        synchronized (object) {
            try {
                if (zziv == null) {
                    Class<?> clazz = context2.getClassLoader().loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
                    Class[] classArray = new Class[]{Context.class};
                    zziv = clazz.getMethod("insertProvider", classArray);
                }
                zziv.invoke(null, context2);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                Throwable throwable = exception.getCause();
                if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                    String string2 = throwable == null ? exception2.getMessage() : throwable.getMessage();
                    String string3 = String.valueOf(string2);
                    Log.e((String)"ProviderInstaller", (String)(string3.length() != 0 ? "Failed to install provider: ".concat(string3) : new String("Failed to install provider: ")));
                }
                throw new GooglePlayServicesNotAvailableException(8);
            }
            return;
        }
    }

    public static void installIfNeededAsync(Context context, ProviderInstallListener providerInstallListener) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(providerInstallListener, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        new zza(context, providerInstallListener).execute(new Void[0]);
    }

    static /* synthetic */ GoogleApiAvailabilityLight zzak() {
        return zziu;
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

