/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.EmptyActivityLifecycleCallbacks;
import android.arch.lifecycle.ViewModelStore;
import android.arch.lifecycle.ViewModelStoreOwner;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class HolderFragment
extends Fragment
implements ViewModelStoreOwner {
    private static final String LOG_TAG = "ViewModelStores";
    private static final HolderFragmentManager sHolderFragmentManager = new HolderFragmentManager();
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String HOLDER_TAG = "android.arch.lifecycle.state.StateProviderHolderFragment";
    private ViewModelStore mViewModelStore = new ViewModelStore();

    public HolderFragment() {
        this.setRetainInstance(true);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        sHolderFragmentManager.holderFragmentCreated(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mViewModelStore.clear();
    }

    @NonNull
    public ViewModelStore getViewModelStore() {
        return this.mViewModelStore;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static HolderFragment holderFragmentFor(FragmentActivity activity) {
        return sHolderFragmentManager.holderFragmentFor(activity);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static HolderFragment holderFragmentFor(Fragment fragment) {
        return sHolderFragmentManager.holderFragmentFor(fragment);
    }

    static class HolderFragmentManager {
        private Map<Activity, HolderFragment> mNotCommittedActivityHolders = new HashMap<Activity, HolderFragment>();
        private Map<Fragment, HolderFragment> mNotCommittedFragmentHolders = new HashMap<Fragment, HolderFragment>();
        private Application.ActivityLifecycleCallbacks mActivityCallbacks = new EmptyActivityLifecycleCallbacks(){

            @Override
            public void onActivityDestroyed(Activity activity) {
                HolderFragment fragment = (HolderFragment)((Object)HolderFragmentManager.this.mNotCommittedActivityHolders.remove(activity));
                if (fragment != null) {
                    Log.e((String)HolderFragment.LOG_TAG, (String)("Failed to save a ViewModel for " + activity));
                }
            }
        };
        private boolean mActivityCallbacksIsAdded = false;
        private FragmentManager.FragmentLifecycleCallbacks mParentDestroyedCallback = new FragmentManager.FragmentLifecycleCallbacks(){

            public void onFragmentDestroyed(FragmentManager fm, Fragment parentFragment) {
                super.onFragmentDestroyed(fm, parentFragment);
                HolderFragment fragment = (HolderFragment)((Object)HolderFragmentManager.this.mNotCommittedFragmentHolders.remove(parentFragment));
                if (fragment != null) {
                    Log.e((String)HolderFragment.LOG_TAG, (String)("Failed to save a ViewModel for " + parentFragment));
                }
            }
        };

        HolderFragmentManager() {
        }

        void holderFragmentCreated(Fragment holderFragment) {
            Fragment parentFragment = holderFragment.getParentFragment();
            if (parentFragment != null) {
                this.mNotCommittedFragmentHolders.remove(parentFragment);
                parentFragment.getFragmentManager().unregisterFragmentLifecycleCallbacks(this.mParentDestroyedCallback);
            } else {
                this.mNotCommittedActivityHolders.remove(holderFragment.getActivity());
            }
        }

        private static HolderFragment findHolderFragment(FragmentManager manager) {
            if (manager.isDestroyed()) {
                throw new IllegalStateException("Can't access ViewModels from onDestroy");
            }
            Fragment fragmentByTag = manager.findFragmentByTag(HolderFragment.HOLDER_TAG);
            if (fragmentByTag != null && !(fragmentByTag instanceof HolderFragment)) {
                throw new IllegalStateException("Unexpected fragment instance was returned by HOLDER_TAG");
            }
            return (HolderFragment)fragmentByTag;
        }

        private static HolderFragment createHolderFragment(FragmentManager fragmentManager) {
            HolderFragment holder = new HolderFragment();
            fragmentManager.beginTransaction().add((Fragment)holder, HolderFragment.HOLDER_TAG).commitAllowingStateLoss();
            return holder;
        }

        HolderFragment holderFragmentFor(FragmentActivity activity) {
            FragmentManager fm = activity.getSupportFragmentManager();
            HolderFragment holder = HolderFragmentManager.findHolderFragment(fm);
            if (holder != null) {
                return holder;
            }
            holder = this.mNotCommittedActivityHolders.get(activity);
            if (holder != null) {
                return holder;
            }
            if (!this.mActivityCallbacksIsAdded) {
                this.mActivityCallbacksIsAdded = true;
                activity.getApplication().registerActivityLifecycleCallbacks(this.mActivityCallbacks);
            }
            holder = HolderFragmentManager.createHolderFragment(fm);
            this.mNotCommittedActivityHolders.put((Activity)activity, holder);
            return holder;
        }

        HolderFragment holderFragmentFor(Fragment parentFragment) {
            FragmentManager fm = parentFragment.getChildFragmentManager();
            HolderFragment holder = HolderFragmentManager.findHolderFragment(fm);
            if (holder != null) {
                return holder;
            }
            holder = this.mNotCommittedFragmentHolders.get(parentFragment);
            if (holder != null) {
                return holder;
            }
            parentFragment.getFragmentManager().registerFragmentLifecycleCallbacks(this.mParentDestroyedCallback, false);
            holder = HolderFragmentManager.createHolderFragment(fm);
            this.mNotCommittedFragmentHolders.put(parentFragment, holder);
            return holder;
        }
    }
}

