/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaax;
import com.google.android.gms.internal.ads.zzaay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import java.util.Set;

@VisibleForTesting
public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzaax zzaam;

    private AdRequest(Builder builder) {
        this.zzaam = new zzaax(builder.zzaan);
    }

    @Deprecated
    public final Date getBirthday() {
        return this.zzaam.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzaam.getContentUrl();
    }

    @Deprecated
    public final int getGender() {
        return this.zzaam.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzaam.getKeywords();
    }

    public final Location getLocation() {
        return this.zzaam.getLocation();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzaam.getNetworkExtras(clazz);
    }

    public final <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzaam.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzaam.getCustomEventExtrasBundle(clazz);
    }

    public final boolean isTestDevice(Context context) {
        return this.zzaam.isTestDevice(context);
    }

    public final zzaax zzde() {
        return this.zzaam;
    }

    /* synthetic */ AdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @VisibleForTesting
    public static final class Builder {
        private final zzaay zzaan = new zzaay();

        public Builder() {
            this.zzaan.zzbx(AdRequest.DEVICE_ID_EMULATOR);
        }

        public final Builder addKeyword(String string) {
            this.zzaan.zzbw(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzaan.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationExtrasReceiver> clazz, Bundle bundle) {
            this.zzaan.zza(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zzaan.zzby(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzaan.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzaan.zzbx(string);
            return this;
        }

        public final AdRequest build() {
            return new AdRequest(this, null);
        }

        @Deprecated
        public final Builder setBirthday(Date date) {
            this.zzaan.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            Preconditions.checkArgument((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzaan.zzbz(string);
            return this;
        }

        @Deprecated
        public final Builder setGender(int n) {
            this.zzaan.zzcn(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzaan.zza(location);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzaan.zzcb(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzaan.zzt(bl);
            return this;
        }

        @Deprecated
        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzaan.zzu(bl);
            return this;
        }

        public final Builder setTagForUnderAgeOfConsent(int n) {
            this.zzaan.zzco(n);
            return this;
        }

        public final Builder setMaxAdContentRating(String string) {
            this.zzaan.zzcd(string);
            return this;
        }
    }
}

