/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaap;
import com.google.android.gms.internal.ads.zzaeh;
import com.google.android.gms.internal.ads.zzaek;
import com.google.android.gms.internal.ads.zzafd;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzbae;
import java.util.List;
import java.util.WeakHashMap;

@zzare
public final class zzafg
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzafg> zzcyy = new WeakHashMap();
    private final zzafd zzcyz;
    private final MediaView zzcza;
    private final VideoController zzcjf = new VideoController();

    @VisibleForTesting
    private zzafg(zzafd zzafd2) {
        this.zzcyz = zzafd2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzafd2.zzrm());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzbae.zzc("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzcyz.zzp(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzbae.zzc("", (Throwable)object);
            }
        }
        this.zzcza = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzafg zza(zzafd zzafd2) {
        WeakHashMap<IBinder, zzafg> weakHashMap = zzcyy;
        synchronized (weakHashMap) {
            zzafg zzafg2 = zzcyy.get(zzafd2.asBinder());
            if (zzafg2 != null) {
                return zzafg2;
            }
            zzafg2 = new zzafg(zzafd2);
            zzcyy.put(zzafd2.asBinder(), zzafg2);
            return zzafg2;
        }
    }

    public final zzafd zzrn() {
        return this.zzcyz;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzcyz.zzcj(string);
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzaeh zzaeh2 = this.zzcyz.zzck(string);
            if (zzaeh2 != null) {
                return new zzaek(zzaeh2);
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzaap zzaap2 = this.zzcyz.getVideoController();
            if (zzaap2 != null) {
                this.zzcjf.zza(zzaap2);
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Exception occurred while getting video controller", remoteException);
        }
        return this.zzcjf;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzcza;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzcyz.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzcyz.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzcyz.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzcyz.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzcyz.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("", remoteException);
            return;
        }
    }
}

