/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuj;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwd;
import com.google.android.gms.internal.measurement.zzxp;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzul
extends zzuj<Boolean>
implements zzwd<Boolean>,
zzxp,
RandomAccess {
    private static final zzul zzbus = new zzul();
    private boolean[] zzbut;
    private int size;

    zzul() {
        this(new boolean[10], 0);
    }

    private zzul(boolean[] blArray, int n) {
        this.zzbut = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzuh();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbut, n2, this.zzbut, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzul)) {
            return super.equals(object);
        }
        zzul zzul2 = (zzul)object;
        if (this.size != zzul2.size) {
            return false;
        }
        boolean[] blArray = zzul2.zzbut;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbut[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzvz.zzu(this.zzbut[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzuh();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzbut.length) {
            System.arraycopy(this.zzbut, n, this.zzbut, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbut, 0, blArray, 0, n);
            System.arraycopy(this.zzbut, n, blArray, n + 1, this.size - n);
            this.zzbut = blArray;
        }
        this.zzbut[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzuh();
        zzvz.checkNotNull(collection);
        if (!(collection instanceof zzul)) {
            return super.addAll(collection);
        }
        zzul zzul2 = (zzul)collection;
        if (zzul2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzul2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzul2.size;
        if (n > this.zzbut.length) {
            this.zzbut = Arrays.copyOf(this.zzbut, n);
        }
        System.arraycopy(zzul2.zzbut, 0, this.zzbut, this.size, zzul2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzuh();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbut[i])) continue;
            System.arraycopy(this.zzbut, i + 1, this.zzbut, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzul zzul2 = this;
        zzul2.zzuh();
        zzul2.zzai(n);
        boolean bl3 = zzul2.zzbut[n];
        zzul2.zzbut[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzul zzul2 = this;
        zzul2.zzuh();
        zzul2.zzai(n);
        boolean bl = zzul2.zzbut[n];
        if (n < zzul2.size - 1) {
            System.arraycopy(zzul2.zzbut, n + 1, zzul2.zzbut, n, zzul2.size - n);
        }
        --zzul2.size;
        ++zzul2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzwd zzak(int n) {
        int n2 = n;
        zzul zzul2 = this;
        if (n2 < zzul2.size) {
            throw new IllegalArgumentException();
        }
        return new zzul(Arrays.copyOf(zzul2.zzbut, n2), zzul2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzul zzul2 = this;
        zzul2.zzai(n);
        return zzul2.zzbut[n];
    }

    static {
        zzbus.zzsw();
    }
}

