/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuj;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwd;
import com.google.android.gms.internal.measurement.zzxp;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvu
extends zzuj<Float>
implements zzwd<Float>,
zzxp,
RandomAccess {
    private static final zzvu zzbzd = new zzvu();
    private float[] zzbze;
    private int size;

    zzvu() {
        this(new float[10], 0);
    }

    private zzvu(float[] fArray, int n) {
        this.zzbze = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzuh();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbze, n2, this.zzbze, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvu)) {
            return super.equals(object);
        }
        zzvu zzvu2 = (zzvu)object;
        if (this.size != zzvu2.size) {
            return false;
        }
        float[] fArray = zzvu2.zzbze;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzbze[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzbze[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzuh();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzbze.length) {
            System.arraycopy(this.zzbze, n, this.zzbze, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbze, 0, fArray, 0, n);
            System.arraycopy(this.zzbze, n, fArray, n + 1, this.size - n);
            this.zzbze = fArray;
        }
        this.zzbze[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzuh();
        zzvz.checkNotNull(collection);
        if (!(collection instanceof zzvu)) {
            return super.addAll(collection);
        }
        zzvu zzvu2 = (zzvu)collection;
        if (zzvu2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvu2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvu2.size;
        if (n > this.zzbze.length) {
            this.zzbze = Arrays.copyOf(this.zzbze, n);
        }
        System.arraycopy(zzvu2.zzbze, 0, this.zzbze, this.size, zzvu2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzuh();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzbze[i]))) continue;
            System.arraycopy(this.zzbze, i + 1, this.zzbze, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzvu zzvu2 = this;
        zzvu2.zzuh();
        zzvu2.zzai(n);
        float f3 = zzvu2.zzbze[n];
        zzvu2.zzbze[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvu zzvu2 = this;
        zzvu2.zzuh();
        zzvu2.zzai(n);
        float f = zzvu2.zzbze[n];
        if (n < zzvu2.size - 1) {
            System.arraycopy(zzvu2.zzbze, n + 1, zzvu2.zzbze, n, zzvu2.size - n);
        }
        --zzvu2.size;
        ++zzvu2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzwd zzak(int n) {
        int n2 = n;
        zzvu zzvu2 = this;
        if (n2 < zzvu2.size) {
            throw new IllegalArgumentException();
        }
        return new zzvu(Arrays.copyOf(zzvu2.zzbze, n2), zzvu2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzvu zzvu2 = this;
        zzvu2.zzai(n);
        return Float.valueOf(zzvu2.zzbze[n]);
    }

    static {
        zzbzd.zzsw();
    }
}

