/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuj;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwd;
import com.google.android.gms.internal.measurement.zzxp;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvy
extends zzuj<Integer>
implements zzwd<Integer>,
zzxp,
RandomAccess {
    private static final zzvy zzcac = new zzvy();
    private int[] zzcad;
    private int size;

    zzvy() {
        this(new int[10], 0);
    }

    private zzvy(int[] nArray, int n) {
        this.zzcad = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzuh();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzcad, n2, this.zzcad, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvy)) {
            return super.equals(object);
        }
        zzvy zzvy2 = (zzvy)object;
        if (this.size != zzvy2.size) {
            return false;
        }
        int[] nArray = zzvy2.zzcad;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzcad[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzcad[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzai(n);
        return this.zzcad[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbn(int n) {
        this.zzp(this.size, n);
    }

    private final void zzp(int n, int n2) {
        this.zzuh();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzcad.length) {
            System.arraycopy(this.zzcad, n, this.zzcad, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzcad, 0, nArray, 0, n);
            System.arraycopy(this.zzcad, n, nArray, n + 1, this.size - n);
            this.zzcad = nArray;
        }
        this.zzcad[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzuh();
        zzvz.checkNotNull(collection);
        if (!(collection instanceof zzvy)) {
            return super.addAll(collection);
        }
        zzvy zzvy2 = (zzvy)collection;
        if (zzvy2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvy2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvy2.size;
        if (n > this.zzcad.length) {
            this.zzcad = Arrays.copyOf(this.zzcad, n);
        }
        System.arraycopy(zzvy2.zzcad, 0, this.zzcad, this.size, zzvy2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzuh();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzcad[i])) continue;
            System.arraycopy(this.zzcad, i + 1, this.zzcad, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzvy zzvy2 = this;
        zzvy2.zzuh();
        zzvy2.zzai(n);
        int n4 = zzvy2.zzcad[n];
        zzvy2.zzcad[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvy zzvy2 = this;
        zzvy2.zzuh();
        zzvy2.zzai(n);
        int n2 = zzvy2.zzcad[n];
        if (n < zzvy2.size - 1) {
            System.arraycopy(zzvy2.zzcad, n + 1, zzvy2.zzcad, n, zzvy2.size - n);
        }
        --zzvy2.size;
        ++zzvy2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzp(n, n2);
    }

    @Override
    public final /* synthetic */ zzwd zzak(int n) {
        int n2 = n;
        zzvy zzvy2 = this;
        if (n2 < zzvy2.size) {
            throw new IllegalArgumentException();
        }
        return new zzvy(Arrays.copyOf(zzvy2.zzcad, n2), zzvy2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzcac.zzsw();
    }
}

