/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.internal.zacs;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zadm = new zap();
    private final Object zadn = new Object();
    private final CallbackHandler<R> zado;
    private final WeakReference<GoogleApiClient> zadp;
    private final CountDownLatch zadq = new CountDownLatch(1);
    private final ArrayList<PendingResult.StatusListener> zadr = new ArrayList();
    private ResultCallback<? super R> zads;
    private final AtomicReference<zacs> zadt = new AtomicReference();
    private R zaci;
    private Status mStatus;
    @KeepName
    private zaa mResultGuardian;
    private volatile boolean zadu;
    private boolean zadv;
    private boolean zadw;
    private ICancelToken zadx;
    private volatile zacm<R> zady;
    private boolean zadz = false;

    @Deprecated
    BasePendingResult() {
        this.zado = new CallbackHandler(Looper.getMainLooper());
        this.zadp = new WeakReference<Object>(null);
    }

    @KeepForSdk
    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zado = new CallbackHandler(looper);
        this.zadp = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(Looper looper) {
        this.zado = new CallbackHandler(looper);
        this.zadp = new WeakReference<Object>(null);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        this.zado = (CallbackHandler)((Object)Preconditions.checkNotNull(callbackHandler, (Object)"CallbackHandler must not be null"));
        this.zadp = new WeakReference<Object>(null);
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zadq.getCount() == 0L;
    }

    @Override
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed");
        Preconditions.checkState((this.zady == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zadq.await();
        }
        catch (InterruptedException interruptedException) {
            this.zab(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Preconditions.checkState((this.zady == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zadq.await(l, timeUnit)) {
                this.zab(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zab(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zadn;
        synchronized (object) {
            if (resultCallback == null) {
                this.zads = null;
                return;
            }
            Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zady == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zado.zaa(resultCallback, (R)this.get());
            } else {
                this.zads = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zadn;
        synchronized (object) {
            if (resultCallback == null) {
                this.zads = null;
                return;
            }
            Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zady == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zado.zaa(resultCallback, (R)this.get());
            } else {
                this.zads = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                CallbackHandler<R> callbackHandler = this.zado;
                callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatusListener(PendingResult.StatusListener statusListener) {
        Preconditions.checkArgument((statusListener != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zadn;
        synchronized (object) {
            if (this.isReady()) {
                statusListener.onComplete(this.mStatus);
            } else {
                this.zadr.add(statusListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zadn;
        synchronized (object) {
            if (this.zadv || this.zadu) {
                return;
            }
            if (this.zadx != null) {
                try {
                    this.zadx.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zab(this.zaci);
            this.zadv = true;
            this.zaa(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zat() {
        Object object = this.zadn;
        synchronized (object) {
            if ((GoogleApiClient)this.zadp.get() == null || !this.zadz) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zadn;
        synchronized (object) {
            return this.zadv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zadn;
        synchronized (object) {
            Preconditions.checkState((this.zady == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zads == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            Preconditions.checkState((!this.zadv ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zadz = true;
            this.zady = new zacm(this.zadp);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zady).then(resultTransform);
            if (this.isReady()) {
                this.zado.zaa(this.zady, this.get());
            } else {
                this.zads = this.zady;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void setResult(R r) {
        Object object = this.zadn;
        synchronized (object) {
            if (!this.zadw && !this.zadv) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zab(r);
                return;
            }
            Preconditions.checkState((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zaa(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zab(Status status) {
        Object object = this.zadn;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zadw = true;
            }
            return;
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(Status var1);

    public final void zaa(zacs zacs2) {
        this.zadt.set(zacs2);
    }

    @Override
    public final Integer zam() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    protected final void setCancelToken(ICancelToken iCancelToken) {
        Object object = this.zadn;
        synchronized (object) {
            this.zadx = iCancelToken;
            return;
        }
    }

    public final void zau() {
        this.zadz = this.zadz || zadm.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zadn;
        synchronized (object) {
            Preconditions.checkState((!this.zadu ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zaci;
            this.zaci = null;
            this.zads = null;
            this.zadu = true;
        }
        BasePendingResult basePendingResult = this;
        zacs zacs2 = basePendingResult.zadt.getAndSet(null);
        if (zacs2 != null) {
            zacs2.zac(basePendingResult);
        }
        return r;
    }

    private final void zaa(R r) {
        this.zaci = r;
        this.zadx = null;
        this.zadq.countDown();
        this.mStatus = this.zaci.getStatus();
        if (this.zadv) {
            this.zads = null;
        } else if (this.zads == null) {
            if (this.zaci instanceof Releasable) {
                this.mResultGuardian = new zaa(null);
            }
        } else {
            this.zado.removeMessages(2);
            this.zado.zaa(this.zads, (R)this.get());
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zadr;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.StatusListener statusListener = arrayList.get(i);
            statusListener.onComplete(this.mStatus);
        }
        this.zadr.clear();
    }

    public static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zaa {
        private zaa() {
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zab(BasePendingResult.this.zaci);
            super.finalize();
        }

        /* synthetic */ zaa(zap zap2) {
            this();
        }
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends zal {
        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public final void zaa(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zab(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zab(Status.RESULT_TIMEOUT);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

