/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zal;

@KeepForSdk
public final class ListenerHolder<L> {
    private final zaa zaji;
    private volatile L zajj;
    private final ListenerKey<L> zajk;

    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L l, @NonNull String string2) {
        this.zaji = new zaa(looper);
        this.zajj = Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        this.zajk = new ListenerKey<L>(l, Preconditions.checkNotEmpty((String)string2));
    }

    @KeepForSdk
    public final void notifyListener(Notifier<? super L> notifier) {
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        Message message = this.zaji.obtainMessage(1, notifier);
        this.zaji.sendMessage(message);
    }

    @KeepForSdk
    public final boolean hasListener() {
        return this.zajj != null;
    }

    @KeepForSdk
    public final void clear() {
        this.zajj = null;
    }

    @NonNull
    @KeepForSdk
    public final ListenerKey<L> getListenerKey() {
        return this.zajk;
    }

    @KeepForSdk
    final void notifyListenerInternal(Notifier<? super L> notifier) {
        L l = this.zajj;
        if (l == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(l);
            return;
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final L zajj;
        private final String zajm;

        @KeepForSdk
        ListenerKey(L l, String string2) {
            this.zajj = l;
            this.zajm = string2;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerKey)) {
                return false;
            }
            ListenerKey listenerKey = (ListenerKey)object;
            return this.zajj == listenerKey.zajj && this.zajm.equals(listenerKey.zajm);
        }

        public final int hashCode() {
            int n = System.identityHashCode(this.zajj);
            return n * 31 + this.zajm.hashCode();
        }
    }

    private final class zaa
    extends zal {
        public zaa(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            Preconditions.checkArgument((message.what == 1 ? 1 : 0) != 0);
            ListenerHolder.this.notifyListenerInternal((Notifier)message.obj);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

