/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.internal.zacp;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zax;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaaw
extends GoogleApiClient
implements zabt {
    private final Lock zaen;
    private boolean zacg;
    private final GmsClientEventManager zagr;
    private zabs zags = null;
    private final int zaca;
    private final Context mContext;
    private final Looper zabj;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafb = new LinkedList();
    private volatile boolean zagt;
    private long zagu = ClientLibraryUtils.isPackageSide() ? 10000L : 120000L;
    private long zagv = 5000L;
    private final zabb zagw;
    private final GoogleApiAvailability zacc;
    @VisibleForTesting
    private zabq zagx;
    final Map<Api.AnyClientKey<?>, Api.Client> zagy;
    Set<Scope> zagz = new HashSet<Scope>();
    private final ClientSettings zaes;
    private final Map<Api<?>, Boolean> zaev;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zacd;
    private final ListenerHolders zaha = new ListenerHolders();
    private final ArrayList<zaq> zahb;
    private Integer zahc = null;
    Set<zacm> zahd = null;
    final zacp zahe;
    private final GmsClientEventManager.GmsClientEventState zahf = new zaax(this);

    public zaaw(Context context, Lock lock, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zaq> arrayList, boolean bl) {
        this.mContext = context;
        this.zaen = lock;
        this.zacg = false;
        this.zagr = new GmsClientEventManager(looper, this.zahf);
        this.zabj = looper;
        this.zagw = new zabb(this, looper);
        this.zacc = googleApiAvailability;
        this.zaca = n;
        if (this.zaca >= 0) {
            this.zahc = n2;
        }
        this.zaev = map;
        this.zagy = map2;
        this.zahb = arrayList;
        this.zahe = new zacp(this.zagy);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zagr.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zagr.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zaes = clientSettings;
        this.zacd = abstractClientBuilder;
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zagy.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zaen.lock();
        try {
            if (this.zags == null) {
                this.zafb.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zags.enqueue(t);
            return (T)string2;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zagy.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zaen.lock();
        try {
            if (this.zags == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zagt) {
                this.zafb.add(t);
                while (!this.zafb.isEmpty()) {
                    object = this.zafb.remove();
                    this.zahe.zab((BasePendingResult<? extends Result>)object);
                    ((BaseImplementation.ApiMethodImpl)object).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object = t;
                return (T)object;
            }
            object = this.zags.execute(t);
            return (T)object;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L l) {
        this.zaen.lock();
        try {
            Looper looper = this.zabj;
            L l2 = l;
            ListenerHolder<L> listenerHolder = this.zaha.zaa(l2, looper, "NO_TYPE");
            return listenerHolder;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = this.zagy.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zagy.containsKey(api.getClientKey());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.Client client = this.zagy.get(api.getClientKey());
        return client != null && client.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zaen.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zagt) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zagy.containsKey(api.getClientKey())) break block6;
                    connectionResult = this.zags.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zagt) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.RESULT_SUCCESS;
                    this.zaen.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zaay());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zaen.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zaen.lock();
        try {
            if (this.zaca >= 0) {
                Preconditions.checkState((this.zahc != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahc == null) {
                this.zahc = zaaw.zaa(this.zagy.values(), false);
            } else if (this.zahc == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zahc);
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zaen.lock();
        try {
            Preconditions.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zae(n);
            this.zaau();
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaen.lock();
        try {
            if (this.zaca >= 0) {
                Preconditions.checkState((this.zahc != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahc == null) {
                this.zahc = zaaw.zaa(this.zagy.values(), false);
            } else if (this.zahc == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahc);
            this.zagr.enableCallbacks();
            ConnectionResult connectionResult = this.zags.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zaen.lock();
        try {
            if (this.zahc == null) {
                this.zahc = zaaw.zaa(this.zagy.values(), false);
            } else if (this.zahc == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahc);
            this.zagr.enableCallbacks();
            ConnectionResult connectionResult = this.zags.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zaen.lock();
        try {
            this.zahe.release();
            if (this.zags != null) {
                this.zags.disconnect();
            }
            this.zaha.release();
            for (BaseImplementation.ApiMethodImpl apiMethodImpl : this.zafb) {
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zafb.clear();
            if (this.zags == null) {
                return;
            }
            this.zaaw();
            this.zagr.disableCallbacks();
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Preconditions.checkState((this.zahc != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zagy.containsKey(Common.CLIENT_KEY)) {
            this.zaa(this, statusPendingResult, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zaay zaay2 = new zaay(this, atomicReference, statusPendingResult);
            zaaz zaaz2 = new zaaz(this, statusPendingResult);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(Common.API).addConnectionCallbacks(zaay2).addOnConnectionFailedListener(zaaz2).setHandler(this.zagw).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return statusPendingResult;
    }

    private final void zaa(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zaph.zaa(googleApiClient).setResultCallback(new zaba(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        zaaw zaaw2 = this;
        if (zaaw2.zaca >= 0) {
            zaj.zaa(lifecycleActivity).zaa(zaaw2.zaca);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zags != null && this.zags.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zags != null && this.zags.isConnecting();
    }

    private final void zae(int n) {
        if (this.zahc == null) {
            this.zahc = n;
        } else if (this.zahc != n) {
            String string2 = zaaw.zaf(n);
            String string3 = zaaw.zaf(this.zahc);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zags != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.Client client : this.zagy.values()) {
            if (client.requiresSignIn()) {
                bl = true;
            }
            if (!client.providesSignIn()) continue;
            bl2 = true;
        }
        switch (this.zahc) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zacg) {
                    this.zags = new zax(this.mContext, this.zaen, this.zabj, this.zacc, this.zagy, this.zaes, this.zaev, this.zacd, this.zahb, this, true);
                    return;
                }
                this.zags = zas.zaa(this.mContext, this, this.zaen, this.zabj, this.zacc, this.zagy, this.zaes, this.zaev, this.zacd, this.zahb);
                return;
            }
        }
        if (this.zacg && !bl2) {
            this.zags = new zax(this.mContext, this.zaen, this.zabj, this.zacc, this.zagy, this.zaes, this.zaev, this.zacd, this.zahb, this, false);
            return;
        }
        this.zags = new zabe(this.mContext, this, this.zaen, this.zabj, this.zacc, this.zagy, this.zaes, this.zaev, this.zacd, this.zahb, this);
    }

    @GuardedBy(value="mLock")
    private final void zaau() {
        this.zagr.enableCallbacks();
        this.zags.connect();
    }

    private final void resume() {
        this.zaen.lock();
        try {
            if (this.zagt) {
                this.zaau();
            }
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    private final void zaav() {
        this.zaen.lock();
        try {
            if (this.zaaw()) {
                this.zaau();
            }
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @GuardedBy(value="mLock")
    final boolean zaaw() {
        if (!this.zagt) {
            return false;
        }
        this.zagt = false;
        this.zagw.removeMessages(2);
        this.zagw.removeMessages(1);
        if (this.zagx != null) {
            this.zagx.unregister();
            this.zagx = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zagr.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zagr.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zagr.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zagr.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zagr.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zagr.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(Bundle bundle) {
        while (!this.zafb.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zafb.remove());
        }
        this.zagr.onConnectionSuccess(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zac(ConnectionResult connectionResult) {
        if (!this.zacc.isPlayServicesPossiblyUpdating(this.mContext, connectionResult.getErrorCode())) {
            this.zaaw();
        }
        if (!this.zagt) {
            this.zagr.onConnectionFailure(connectionResult);
            this.zagr.disableCallbacks();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(int n, boolean bl) {
        if (n == 1 && !bl) {
            zaaw zaaw2 = this;
            if (!zaaw2.zagt) {
                zaaw2.zagt = true;
                if (zaaw2.zagx == null && !ClientLibraryUtils.isPackageSide()) {
                    zaaw2.zagx = zaaw2.zacc.zaa(zaaw2.mContext.getApplicationContext(), new zabc(zaaw2));
                }
                zaaw2.zagw.sendMessageDelayed(zaaw2.zagw.obtainMessage(1), zaaw2.zagu);
                zaaw2.zagw.sendMessageDelayed(zaaw2.zagw.obtainMessage(2), zaaw2.zagv);
            }
        }
        this.zahe.zabx();
        this.zagr.onUnintentionalDisconnection(n);
        this.zagr.disableCallbacks();
        if (n == 2) {
            this.zaau();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zabj;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return this.zags != null && this.zags.maybeSignIn(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        if (this.zags != null) {
            this.zags.maybeSignOut();
        }
    }

    @Override
    public final void zaa(zacm zacm2) {
        this.zaen.lock();
        try {
            if (this.zahd == null) {
                this.zahd = new HashSet<zacm>();
            }
            this.zahd.add(zacm2);
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void zab(zacm zacm2) {
        this.zaen.lock();
        try {
            if (this.zahd == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zahd.remove(zacm2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zaax()) {
                this.zags.zaw();
            }
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    final boolean zaax() {
        this.zaen.lock();
        try {
            if (this.zahd == null) {
                return false;
            }
            boolean bl = !this.zahd.isEmpty();
            return bl;
        }
        finally {
            this.zaen.unlock();
        }
    }

    final String zaay() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zagt);
        printWriter.append(" mWorkQueue.size()=").print(this.zafb.size());
        PrintWriter printWriter2 = printWriter;
        zacp zacp2 = this.zahe;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zacp2.zaky.size());
        if (this.zags != null) {
            this.zags.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zaa(Iterable<Api.Client> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.Client client : iterable) {
            if (client.requiresSignIn()) {
                bl2 = true;
            }
            if (!client.providesSignIn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zaf(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zaa(zaaw zaaw2) {
        zaaw2.resume();
    }

    static /* synthetic */ void zab(zaaw zaaw2) {
        zaaw2.zaav();
    }

    static /* synthetic */ void zaa(zaaw zaaw2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zaaw2.zaa(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zac(zaaw zaaw2) {
        return zaaw2.mContext;
    }
}

