/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zam;
import com.google.android.gms.common.api.internal.zan;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zal
extends LifecycleCallback
implements DialogInterface.OnCancelListener {
    protected volatile boolean mStarted;
    protected final AtomicReference<zam> zade = new AtomicReference<Object>(null);
    private final Handler zadf = new com.google.android.gms.internal.base.zal(Looper.getMainLooper());
    protected final GoogleApiAvailability zacc;

    protected zal(LifecycleFragment lifecycleFragment) {
        this(lifecycleFragment, GoogleApiAvailability.getInstance());
    }

    @VisibleForTesting
    private zal(LifecycleFragment lifecycleFragment, GoogleApiAvailability googleApiAvailability) {
        super(lifecycleFragment);
        this.zacc = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zaa(new ConnectionResult(13, null), zal.zaa(this.zade.get()));
        this.zaq();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zam zam2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zam2 = new zam(connectionResult, n);
            } else {
                zam2 = null;
            }
            this.zade.set(zam2);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zam zam2 = this.zade.get();
        if (zam2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zam2.zar());
            bundle2.putInt("failed_status", zam2.getConnectionResult().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zam2.getConnectionResult().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zam zam2 = this.zade.get();
        switch (n) {
            case 2: {
                int n3 = this.zacc.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zam2 == null) {
                    return;
                }
                if (zam2.getConnectionResult().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zam2 = new zam(new ConnectionResult(n4, null), zal.zaa(zam2));
                this.zade.set(zam2);
            }
        }
        if (bl) {
            this.zaq();
            return;
        }
        if (zam2 != null) {
            this.zaa(zam2.getConnectionResult(), zam2.zar());
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zaa(ConnectionResult var1, int var2);

    protected abstract void zao();

    protected final void zaq() {
        this.zade.set(null);
        this.zao();
    }

    public final void zab(ConnectionResult connectionResult, int n) {
        zam zam2 = new zam(connectionResult, n);
        if (this.zade.compareAndSet(null, zam2)) {
            this.zadf.post((Runnable)new zan(this, zam2));
        }
    }

    private static int zaa(@Nullable zam zam2) {
        if (zam2 == null) {
            return -1;
        }
        return zam2.zar();
    }
}

