--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
--[[    工具类
--]]
local M = {}

-- node：执行对象
-- size: 初始大小
-- angle: 初始旋转角度
-- 植物呼吸动作
function M:breathing(node, size, angle, strength)

    if not node then
        print("node为空")
        return
    end

    local size = size or 1
    local angle = angle or 0
    strength = ifnil(strength, 1)
    local num = math.random(10, 12)
    node:cycle({
        A.union({
            {"scaleTo", num/10, size, (size - 0.05* strength)},
            {"rotateTo", num/10, angle - 2* strength},
        }),
        A.union({
            {"rotateTo", num/10, angle},
            {"scaleTo", num/10, size},
        }),
        A.union({
            {"rotateTo", num/10, angle + 2},
            {"scaleTo", num/10, size, size - 0.05 * strength},
        }),
        A.union({
            {"rotateTo", num/10, angle},
            {"scaleTo", num/10, size},
        })
    })
end

function M:breathing2(node, size)

    if not node then
        print("node为空")
        return
    end

    local size = size or 1

    local num = math.random(10, 12)
    node:cycle({
        A.union({
            { "skewto", num / 10, 3, 0 },
            { "scaleTo", num / 10, size, size - 0.05 },
        }),
        A.union({
            { "skewto", num / 10, -3, 0 },
            { "scaleTo", num / 10, size },
        }),
        A.union({
            { "skewto", num / 10, 2, 0 },
            { "scaleTo", num / 10, size, size - 0.05 },
        }),
        A.union({
            { "skewto", num / 10, -2, 0 },
            { "scaleTo", num / 10, size },
        })
    })
end

-- 放入物品反馈
-- 缓动缩放
-- node:执行动作对象
-- strength:强度
function M:feedback(node,strengthX,strengthY,time)
    
    if node.commonActScaleLock then return end
    node.commonActScaleLock = true

    local strengthX = strengthX or 1
    strengthY = strengthY or strengthX
    local sizeX = node:scaleX()
    local sizeY = node:scaleY()
    time = time or .1
    node.commonScaleAct = A.line({
        {"scaleTo", time, sizeX * (1 + 0.15 * strengthX), sizeY * (1 - 0.1 * strengthY)},
        {"scaleTo", time, sizeX * (1 + 0.1 * strengthX), sizeY * (1 - 0.05 * strengthY)},
        {"scaleTo", time, sizeX, sizeY},
        {"scaleTo", time, sizeX * (1 + 0.1 * strengthX), sizeY * (1 - 0.05 * strengthY)},
        {"scaleTo", time, sizeX, sizeY},
        {"fn", function ()
            node.commonActScaleLock = false
        end}
    }):at(node)
end
M.nodeScale = M.feedback

function M:nodeScaleCycle(node,strengthX,strengthY)
    local strengthX = strengthX or 1
    strengthY = strengthY or strengthX
    local sizeX = node:scaleX()
    local sizeY = node:scaleY()

    node:cycle({
        {"scaleTo", 0.15, sizeX * (1 + 0.15 * strengthX), sizeY * (1 - 0.1 * strengthY)},
        {"scaleTo", 0.15, sizeX * (1 + 0.1 * strengthX), sizeY * (1 - 0.05 * strengthY)},
        {"scaleTo", 0.15, sizeX, sizeY},
        {"scaleTo", 0.15, sizeX * (1 + 0.1 * strengthX), sizeY * (1 - 0.05 * strengthY)},
        {"scaleTo", 0.15, sizeX, sizeY},
        {"delay", 0.5}
    })
end

-- 浮想框上下浮动
function M:thinkMove(think1, think2, think3)
    local time = 0.4
    think1:cycle({
        {"moveby", time, ccp(0, 8)},
        {"moveby", time, ccp(0, -8)},
        {"moveby", time, ccp(0, -8)},
        {"moveby", time, ccp(0, 8)},
    })
    think2:cycle({
        {"moveby", time, ccp(0, 6)},
        {"moveby", time, ccp(0, -6)},
        {"moveby", time, ccp(0, -6)},
        {"moveby", time, ccp(0, 6)},
    })
    think3:cycle({
        {"moveby", time, ccp(0, 3)},
        {"moveby", time, ccp(0, -3)},
        {"moveby", time, ccp(0, -3)},
        {"moveby", time, ccp(0, 3)},
    })
end

-- 道具进场
function M:enter(node, pos, callback)
    local time = nil
    if node:px() - pos.x > 0 then
        time = math.abs(0.5 * (node:px() - pos.x)/V.w_2)
    else
        time = math.abs(0.5 * (pos.y - node:py()) / V.h_2)
    end
    time = 0.4
    node:unbindTouch()
    node:line({
        -- { "easing", "BACKOUT", { "moveTo", time, pos } },
        {"moveTo", time, pos},
        {"fn", function()
            node:bindTouch()
            if callback then
                callback()
            end
        end},
    }) 
end

-- 从某处进入[对于单个]
-- way 1234 上下左右
function M:enterFrom(node, way, easing, delay, callback)

    if not node or not way then
        print("commonAction:enterFrom() 参数为空")
        return
    end

    node.pos = node:point()
    if way == 1 then 
        node:p(node.pos.x , V.h+node:ch())
    elseif way == 2 then 
        node:p(node.pos.x , -node:ch())
    elseif way == 3 then
        node:p(-node:cw() , node.pos.y)
    elseif way == 4 then 
        node:p(V.w_2+node:px() , node.pos.y)
    end
    local time = 0.4

    local delay = delay or 0.01 

    node:unbindTouch()
    
    local moveAct = A.one({"easing", "backout",{"moveTo", time, node.pos }}) -- backout sineOut BACKINOUT
    if easing then
        moveAct =A.one({"moveTo", time, node.pos })
    end

    node:line({
        {"delay" , delay},
        {"show"},
        moveAct,
        {"fn", function()
            node:bindTouch()
            if callback then
                callback()
            end
        end},
    }) 
end

-- 和上面的进入一样 只是没有触控绑定
function M:enterFromUnbind(node, way, easing, delay, callback)

    if not node or not way then
        print("commonAction:enterFrom() 参数为空")
        return
    end

    node.enterFromFunPos = node:point()
    if way == 1 then 
        node:p(node.enterFromFunPos.x , V.h+node:ch())
    elseif way == 2 then 
        node:p(node.enterFromFunPos.x , -node:ch())
    elseif way == 3 then
        node:p(-node:cw() , node.enterFromFunPos.y)
    elseif way == 4 then 
        node:p(V.w+node:cw() , node.enterFromFunPos.y)
    end
    local time = 0.4

    local delay = delay or 0.01 

    local moveAct = A.one({"easing", "backout",{"moveTo", time, node.enterFromFunPos }}) -- backout sineOut BACKINOUT
    if easing then
        moveAct =A.one({"moveTo", time, node.enterFromFunPos })
    end

    node:line({
        {"delay" , delay},
        {"show"},
        moveAct,
        {"fn", function()
            if callback then
                callback()
            end
        end},
    }) 
end

-- 从上进入 Q弹
function M:enterAndBouncy(node)

    if not node then
        print("道具离场commonAction:enterAndBouncy() 参数为空")
        return
    end

    local toPos = node:point()
        node:p(toPos.x , V.h+node:ch())
    
    local time = 0.4

    node:line({
        {"show"},
        {"moveTo", time, toPos},
        {"fn", function()
            self:feedback(node)
        end},
    }) 
end

-- node位置偏移后 移动回来[对于多个]
function M:enterOffset(node, offstX, offstY, delay, callback)
    if not node or not offstX or not offstY then
        print("道具离场commonAction:enterOffset() 参数为空")
        return
    end
    node:p(ccpAdd(node:point(), ccp(offstX,offstY)))
    local delay = delay or 0.01
    node:hide()
    node:line({
        {"delay" , delay},
        {"show"},
        {"easing", "backout", {"moveby" , 0.4 , ccp(-offstX ,-offstY)} },
        {"fn", function()
            -- node:bindTouch()
            if callback then
                callback()
            end
        end},
    })
end

-- 道具离场
-- way -1 1 左右 2下
function M:leave(node, way, easing, time, callback)
    if not node then
        print("道具离场commonAction:leave() 参数node为空")
        return
    end

    local pos
    if not way or way == 1 then
        pos = cc.p(V.w + node:cw(), node:py())
    end
    if way == -1 then
        pos = cc.p(-node:cw(), node:py())
    end
    if way == 2 then
        pos = cc.p(node:px(), -node:ch())
    end
    
    -- time = math.abs(0.4 * (pos.x - node:px()) / V.w_2)
    local time = time or 0.6

    node:unbindTouch()

    local moveAct = A.one({"easing", "backin", {"moveTo", time, pos }})
    if easing then
        moveAct = A.one({"moveTo", time, pos})
    end
    
    node:line({
        moveAct,
        { "fn", function()
            if callback then
                callback()
            end
            if node.stopGuide then
                node:stopGuide()
            end
        end},
    })
end

-- 送道具的手离开
function M:handLeave(node)
    if node and node.enterHand and not node.enterHand.isLeave then
        node.enterHand.isLeave = true
        commonAct:leave(node.enterHand, 1)
    end 
end

-- 长按引导
-- node:需要引导的对象
function M:guideLongPress(node)
    if not node then 
        print("缺参")
        return 
    end

    if GUIDE_LONG_PRESS then
        return 
    end

    GUIDE_LONG_PRESS = true

    -- local x = parent:cw()/2
    -- local y = parent:ch()/2
    -- local pos = node:getParent():convertToWorldSpace(node:point())
    local hand = D.img("common/guide/hand1.png"):to(node:getParent(),1000):p(node:point())
    self.hand = hand
    self.hand:line({
        {"delay" , 0.5},
        {"fn" , function()
            hand:display("common/guide/hand2.png")
            -- 手指下的光圈
            local circle =  D.img("common/guide/circle/10001.png"):to(self.hand,-1):p(self.hand:cw()/2,self.hand:ch()/2)
            circle:cycle({
                {"image" , "common/guide/circle/1000" , 6, 0.2},
            })
        end},
    })

    return hand
end

-- 隐藏长按引导
function M:hideLongPress()
    self:hideGuideHand()
end

-- 隐藏引导手
function M:hideGuideHand()
    if self.hand and not tolua.isnull(self.hand) then
        self.hand:stopAllActions()
        self.hand:remove()
        self.hand = nil
    end
end

-- 手指点击引导
-- node:需要引导的对象
function M:guideTouch(node)
    if not node then 
        print("缺参")
        return 
    end

    local hand = D.img("common/guide/hand1.png"):to(node:getParent(),1000):p(node:point())
    self.hand = hand
    self.hand:cycle({
        {"delay" , 0.5},
        {"fn" , function()
            hand:display("common/guide/hand2.png")
        end},
        {"delay" , 0.5},
        {"fn" , function()
            hand:display("common/guide/hand1.png")
        end},
    })

    return hand
end


-- 加载呼吸动画
function M:loadBreathe()

    -- 中间的白花    
    self.flower:cycle({
        {"scaleto" , 1 , 0.95},
        {"scaleto" , 1 , 1},
    })

    -- 两边的绿叶
    local left = D.img("excitation/garland/left.png"):p(519 + X_OFFSET, 22 + Y_OFFSET):to(self.parent, 12):anchor(ccp(1,0))
    local right = D.img("excitation/garland/right.png"):p(528 + X_OFFSET, 32 + Y_OFFSET):to(self.parent, 12):anchor(ccp(0,0))

    left:cycle({
        {"rotateby" , 1 , -2},
        {"rotateby" , 1 , 2},
    })
    left:cycle({
        {"scaleto" , 1 , 0.98},
        {"scaleto" , 1 , 1},
    })
    right:cycle({
        {"rotateby" , 1 , 2},
        {"rotateby" , 1 , -2},
    })
    right:cycle({
        {"scaleto" , 1 , 0.98},
        {"scaleto" , 1 , 1},
    })
end

-- 回到选择场景
function M:nextScene()
    ST.setBool("IS_FIRST_IN", false)
    -- 有最新花制品
    HAVE_NEW_PRODUCT = true
    game:enterScene("select")
end

-- 拍照
function M:photograph(pTable)
    local rect = {
                CCRect(322 + X_OFFSET, 102 + Y_OFFSET, 355, 307),
                CCRect(315 + X_OFFSET, 55 + Y_OFFSET, 400, 485),
                CCRect(355 + X_OFFSET, 41 + Y_OFFSET, 315, 400),
                CCRect(310 + X_OFFSET, 100 + Y_OFFSET, 400, 365), 
                CCRect(230 + X_OFFSET, 55 + Y_OFFSET, 550, 410)
                }
    local path = SO.shot({
		renderBackground = false,
        backgroundColor = ccc4(0,0,0,0),
        category = PRODUCT_TYPE,
		nodes  = pTable,   -- 渲染结点集合
        -- rect = CCRect(230, 50, 530, 445),
        rect = rect[PRODUCT_TYPE],
        isClippingNode = true
	})
end

-- 加载灯光
function M.light(parent, zNum)
    if not parent then return end

	function test(node, delayTime)
	    node:line({
	        {"delay", delayTime},
	        {"fn", function()
	            node:cycle({
	                A.union({
	                    {"scaleTo", 1.5, 1.1},
	                    {"fadeOut", 1.5},
	                }),
	                {"fn", function()
	                    node:scale(0)
	                    node:setOpacity(100)
	                end},
	            })
	        end},
	    })
	end

    local nodeTab = {}

	-- 加载光环
	local light1_1 = D.img("excitation/light_1.png"):scale(0):p(V.w_2 + 20, V.h_2 - 20):to(parent, zNum)
	local light1_2 = D.img("excitation/light_1.png"):scale(0):p(V.w_2 + 20, V.h_2 - 20):to(parent, zNum)
	local light1_3 = D.img("excitation/light_1.png"):scale(0):p(V.w_2 + 20, V.h_2 - 20):to(parent, zNum)
	test(light1_1, 0)
	test(light1_2, 0.5)
	test(light1_3, 1)
	-- 加载光束
	local light2 = D.img("excitation/light_2.png"):p(V.w_2 + 20, V.h_2 - 20):to(parent, zNum):scale(0)
	light2:line({
		{"scaleTo", 0.5, 0.8},
		{"fn", function()
			light2:cycle({
			    {"rotateBy", 8, 360}
			})
		end},
	})

    table.insert(nodeTab, light1_1)
    table.insert(nodeTab, light1_2)
    table.insert(nodeTab, light1_3)
    table.insert(nodeTab, light2)

    return nodeTab
end

-- 加载粒子
function M.loadParticle(parent, zNum)
	local particlePos = {cc.p(240 + X_OFFSET, V.h_2), cc.p(735 + X_OFFSET, V.h_2), cc.p(V.w_2, 85 + Y_OFFSET)}
	parent:line({
		{"delay", 0.5},
		{"fn", function()
			local particle1 = P.newParticle("particle/dajili1.plist"):to(parent, zNum + 100):p(particlePos[1])
            particle1:setAutoRemoveOnFinish(true)
		end},
		{"delay", 0.5},
		{"fn", function()
		 	local particle1 = P.newParticle("particle/dajili1.plist"):to(parent, zNum + 100):p(particlePos[2])
            particle1:setAutoRemoveOnFinish(true) 
		end},
		{"delay", 0.5},
		{"fn", function()
		 	local particle1 = P.newParticle("particle/dajili1.plist"):to(parent, zNum + 100):p(particlePos[3]) 
            particle1:setAutoRemoveOnFinish(true)
		end},
	})				 
end

-- local sea   = D.img("gameplay/floor.png"):anchor(ccp(0.5, 0)):p(V.w_2, 25):to(self):scale(BG_SCALE)
-- commonAct:shaderWave(sea, 0.015, 2.0, 6.0, 0.02)

-- shader网格
function M:shaderWave(node, u_high, u_speed, u_waveNum, u_offY)
    node.u_high = u_high
    local vert = [[
            attribute vec4 a_position; 
            attribute vec2 a_texCoord; 
            attribute vec4 a_color; 
            #ifdef GL_ES  
            varying lowp vec4 v_fragmentColor;
            varying mediump vec2 v_texCoord;
            #else                      
            varying vec4 v_fragmentColor; 
            varying vec2 v_texCoord;  
            #endif    
            void main() 
            {
                gl_Position = CC_PMatrix * a_position; 
                v_fragmentColor = a_color;
                v_texCoord = a_texCoord;
            }
        ]]
    local frag = [[
            #ifdef GL_ES 
            precision mediump float; 
            #endif 
            varying vec4 v_fragmentColor; 
            varying vec2 v_texCoord; 
            uniform float u_time;  
            uniform float u_high;   
            uniform float u_speed; 
            uniform float u_waveNum; 
            uniform float u_offY;                                                                          
            void main(void) 
            { 
                float y = v_texCoord.y-u_offY+u_high*sin(u_time*u_speed+v_texCoord.x*3.1415*u_waveNum);
                if(y<0.0){
                    gl_FragColor = vec4(0.0,0.0,0.0,0.0);
                }else{
                    gl_FragColor = texture2D(CC_Texture0, vec2(v_texCoord.x, y));
                }
            }
        ]]
    local glProgram = cc.GLProgram:createWithByteArrays(vert, frag)
    node:setGLProgram(glProgram)
    node:setProgramFloat("u_high", node.u_high)
    node:setProgramFloat("u_speed", u_speed)
    node:setProgramFloat("u_waveNum", u_waveNum)
    node:setProgramFloat("u_offY", u_offY)
    local delta = 1/30
    local time = 0
    node.shaderWaveAct = A.cycle({
        {"fn",function ()
            node:setProgramFloat("u_high", node.u_high)
            node:setProgramFloat("u_time",time)
            time = time + delta
        end},
        {"delay",delta},
    }):at(node)
end

--区域限定
function M:dragLimit(node, x, y, offsetXm, offsetXn, offsetYm, offsetYn)
    if tolua.isnull(node) then return x, y end
    local px = x
    local py = y
    if x < offsetXm then px = offsetXm end
    if x > offsetXn then px = offsetXn end
    if y < offsetYm then py = offsetYm end
    if y > offsetYn then py = offsetYn end
    return px, py
end

--预加载帧动画
-- 同步加载
function M:addTexture(prefix, fromNum, toNum)
    for i = fromNum, toNum do
        local img = prefix .. i .. ".png"
        R.loadTexture(img)
    end
end

-- -- 异步加载
-- function M:addTexture(prefix, fromNum, toNum)
--     for i = fromNum, toNum do
--         local img = prefix .. i .. ".png"
--         R.loadTextureAsync(img, function() end)
--     end
-- end

-- 呼吸动作
function M:loadBreathAction(node, time, distance)
    A.cycle({
        {"moveBy", time, ccp(0, distance)},
        {"moveBy", time, ccp(0, -distance)},
    }):at(node)
end

-------------------------------------------- 3D飘落的动作 --------------------------------------------

-- commonAct:down(node) 这样调用

function M:down(node)
    -- 飘落的区间
    local xPos = math.random(-100, 130)
    local yPos = math.random(-200, -250)
    self.playLeafAnim(node, ccp(xPos, yPos), false, 280)
end

--[m_spObj:对象, m_posEnd：结束坐标, m_bIsRemove:是否移除]
-- 调用play函数播实现动作
function M.playLeafAnim(m_spObj, m_posEnd, m_bIsRemove, m_dVelocity, m_fun)
    local roTime, actionTime
    local fAngle1, fAngle2
    local positionEnd = m_posEnd
    actionTime = bb.URandom.number(1, 10)
    if (bb.URandom.boolean()) then
        roTime  = 2.5    --//单向摆动一次时间
        fAngle1 = -80    --//逆时针摆动角度
        fAngle2 = 80/2     --//顺时针摆动角度
    else
        roTime  = 3.2;
        fAngle1 = -100;
        fAngle2 = 100/2;
    end
    local time = M.getTime(positionEnd, m_spObj, m_dVelocity)
    -- 所运动到的位置
    local function resetLeafPos(callback)
        A.line({
            {"moveby", time, positionEnd},
            {"fn", function()
                m_spObj:stopAllActions()
                m_spObj:rotate(0)
                if (m_bIsRemove) then
                    m_spObj:remove()
                    m_spObj = nil
                end
                if (m_fun) then
                    m_fun()
                end
            end}
        }):at(m_spObj)
    end  
    resetLeafPos()
    -- 翻转动作
    -- m_spObj:setVertexZ(60) --设置深度抬高60，避免出现使用CCOrbitCamera实现空间翻转时产生错位和遮挡等问题
    -- CCDirector:sharedDirector():setDepthTest(false) 
    -- 关闭深度测试同样可以避免上述问题，不过，推荐使用深度设置setVertexZ来正确解决，
    -- 因为有时你可能需要遮挡的效果，关闭深度测试后将造成遮挡效果的缺失
    -- local orbit = tolua.cast(CCOrbitCamera:create(8, 1, 0, 0, 360, 45, 0), "CCAction") 
    -- 让精灵始终执行三维翻转的动作
    -- local function fz3d(callback)
    --     A.line({
    --         tolua.cast(CCOrbitCamera:create(actionTime, 1, 0, 0, 360, 45, 0), "cc.Action"),
    --         {"fn",function() 
    --             fz3d(callback)
    --         end}
    --     }):at(m_spObj)
    -- end 
    -- fz3d() -- 无限循环执行翻转的动作 
    -- A.cycle({
    --     {"easing", "inout", {"rotateby", actionTime, fAngle1}, actionTime},
    --     {"easing", "inout", {"rotateby", actionTime, fAngle2}, actionTime},
    -- }):at(m_spObj)
end

-- 获取时间
function M.getTime(m_posEnd, m_spObj, m_dVelocity, m_posStart)
    local t_posStart    = m_posStart or ccp(m_spObj:getPositionX(), m_spObj:getPositionY()) 
    local distance      = bb.UPoint.distance(m_posEnd.x, m_posEnd.y, t_posStart.x, t_posStart.y)
    local m_dVelocity   = m_dVelocity or M.getVelocity()
    local time          = distance / m_dVelocity
    return time
end

-- 获得速度
function M.getVelocity()
    local range = M.getRangeVelocity()
    return bb.URandom.num(range.min, range.max)
end

M.VelocityMin = 400
M.VelocityMax = 500

-- 获得速度区间
function M.getRangeVelocity()
    return {min = M.VelocityMin, max = M.VelocityMax}
end

-- 设置速度区间
function M.setVelocityMin(l_dVelocityMin)
    M.VelocityMin = l_dVelocityMin
end

function M.setVelocityMax(l_dVelocityMax)
    M.VelocityMax = l_dVelocityMax
end

---------------------------------------------------------------------------------------------------

-- 气球浮动
function M:balloonAct(node)
    local time = math.random(12, 16)/10
    local num = math.random(40, 80)/ 10
    A.line({
        {"moveby", time, ccp(0, num)},
        {"moveby", time, ccp(0, -num)},
        {"moveby", time, ccp(0, -num)},
        {"moveby", time, ccp(0, num)},
        {"fn", function ()
            return self:balloonAct(node)
        end}
    }):at(node)
end

-- 随机范围内内移动
function M:moveAround(node)
    local x = N.random(-10, 10)
    local y = N.random(-15, 15)
    local time = N.random(10, 20) * 0.25
    local rNum = N.random(-20, 20)
    self._moveAction = A.line({
        {"union", {
            {"moveBy", time, ccp(x, y)},
            {"rotateTo", time, rNum},            
        }},
        {"fn", function()
            self:moveAround(node)
        end}
    }):at(node)
end

-- 鱼的随机范围内内移动
function M:moveAroundFish(node, minX, maxX, minY, maxY)
    minX = minX or 40
    maxX = maxX or 255
    minY = minY or 25
    maxY = maxY or 100
    local x = N.random(-40, 40)
    local y = N.random(-3, 3)
    local pos = node:point()
    if pos.x <= minX then x = 50 end
    if pos.x >= maxX then x = -50  end
    if pos.y <= minY then y = 10 end
    if pos.y >= maxY then y = -10 end
    if x > 0 then 
        node:flipX(true)
    else
        node:flipX(false)
    end
    local time = N.random(10, 20) * 0.25
    self._moveAction = A.line({
        {"union", {
            {"moveBy", time, ccp(x, y)},
        }},
        {"fn", function()
            self:moveAroundFish(node, minX, maxX, minY, maxY)
        end}
    }):at(node)
end

-- 风车旋转
function M:windmillAction(node)
    local time = math.random(8, 12)/10
    self._swingAct = A.line({
        {"rotateby", time, 360},
        {"fn", function ()
            return self:windmillAction(node)
        end}
    }):at(node)
end

--摇摆动作
function M:swingAction(node, min, max)
    min = min or 2
    max = max or 4
    local num = math.random(min, max)
    local time = math.random(8, 12)/10
    self._swingAct = A.line({
        {"rotateby", time, -num},
        {"rotateby", time, num},
        {"rotateby", time, num},
        {"rotateby", time, -num},
        {"fn", function ()
            return self:swingAction(node, min, max)
        end}
    }):at(node)
end


return M





