--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
--[[
    引导工具类
--]]
local M = {}

-- 点击遮罩 
function M:focusOn(layer, nodePos, scale, x, y, z)
	x = ifnil(x, 0)
    y = ifnil(y, 0)
    z = ifnil(z, 5000)
	scale = ifnil(scale, 1)
	local mask = U.loadNodeMask({
		contentSize = CCSize(V.w + 20, V.h + 20),
		color 		 = ccc3(0, 0, 0)
    }):anchor(cc.p(0, 0)):p(0, 0):opacity(180)
    
	-- local nodePos = node:convertToWorldSpaceAR(ccp(0,0))
	nodePos = cc.p(nodePos.x + x , nodePos.y + y)
	-- 洞
	local hole  = D.img("common/focus.png"):p(nodePos):scale(scale)
	local hole1 = D.img("common/focus.png"):p(nodePos):scale(scale):to(layer, z):opacity(180)
    layer.focushole  = hole1
    
	layer._clip = CCNodeExtend.extend(cc.ClippingNode:create(hole)):to(layer, z)
	layer._clip:setInverted(true)
	layer._clip:setAlphaThreshold(0) -- 显示透明区域
	layer._clip:addChild(mask)
	layer._clip.hole = hole  
end

-- 遮罩移动到指定位置
function M:focusOnMoveto(layer, time, endPoint, size)
    if layer.focushole then
        size = ifnil(size, layer.focushole:scale())
		layer.focushole:union({
            {"moveTo", time, endPoint},
            {"scaleTo", time, size}
		})
	end
    if layer._clip and layer._clip.hole then
        size = ifnil(size, layer._clip.hole:scale())
		layer._clip.hole:union({
            {"moveTo", time, endPoint},
            {"scaleTo", time, size}
		})
	end
end

-- 点击遮罩呼吸
function M:focusBreath(layer)
    if not layer._clip then return end
    if layer._clip.hole then
        local sx = layer._clip.hole:scaleX()
        local sy = layer._clip.hole:scaleY()
		layer._clip.hole:cycle({
			{"scaleBy", 1, 1.1, 1.1},
			{"scaleTo", 1, sx, sy}
		})
	end

    if layer.focushole then
        local size = layer.focushole:scale()
		layer.focushole:cycle({
			{"scaleBy", 1, 1.1},
			{"scaleTo", 1, size}
		})
    end
end

-- 移除点击遮罩
function M:removefocus(layer)
    if  layer.focushole then
		layer.focushole:remove()
		layer._clip:remove()
		layer.focushole = nil
		layer._clip = nil
	end
end

-- 开启引导
function M:openGuide(node, size, time, nodeSize, rate)
    local size          = ifnil(size, 0.2)
    local scaleSize     = nodeSize or node:scale()
	node._scaleSize     = scaleSize
    time = ifnil(time, 3)
    rate = rate or 0.2
	if not tolua.isnull(node._guideAct) then 
		node:stopAction(node._guideAct) 
		node._guideAct = nil 
	end 
    local act = A.cycle({
		{"delay", time},
        {"fn", function()
            -- 音效[sfx05700004]
     	    soundEffect:playEffectsfx05700004()
		end},
        {"scaleTo", rate, scaleSize + size},
        {"scaleTo", rate, scaleSize},
        {"scaleTo", rate, scaleSize + size},
        {"scaleTo", rate, scaleSize},
    })
    node:runAction(act)
    node._guideAct = act
end

-- 关闭引导(节点)
function M:stopGuide(node)
    if not node._guideAct then return end
    node:stopAction(node._guideAct)
    node._guideAct = nil
    node:scale(node._scaleSize)
end

-- 添加烟雾
function M:addInstallSmokeAction(node, pos, size, callback)
    size    = ifnil(size, 1)
    soundEffect:playEffectsfx24601018()
    local rect = U.loadNode({contentSize = cc.size(10, 10)}):to(node, 100):scale(size):p(pos):anchor(cc.p(0.5, 0.5))
    local smokes = {}
    for i = 1, 2 do
        local smoke = D.img("common/diysmoke/"..i.."/1.png"):to(rect, i * 10)
        if i == 1 then smoke:p(9, 5):scale(0.6) end
        smoke:cycle({
            {"image", "common/diysmoke/"..i.."/", 5, .15}
        })

        table.insert(smokes, smoke)
    end

    -- 添加锤子
    local hammer = D.img("common/hammer/3.png"):to(smokes[1], -1):scale(0.8 / rect:scale()):p(400.5, 221.0):anchor(cc.p(0.3, 0.43)):rotate(-135)
    self:hammerAction(hammer)
    rect:line({
        {"delay", .1},
        {"fn", function()
            local hammer2 = D.img("common/hammer/3.png"):to(smokes[1], 1):scale(0.8 / rect:scale()):scaleX(-0.9 / rect:scale()):p(80, 100):anchor(cc.p(0.3, 0.43)):rotate(135)
            self:hammerAction(hammer2, function ()
                self:smokedisAppear(rect, callback)

                for i, v in pairs(smokes) do
                    v:remove()
                end
            end)
        end},
    })
end

-- 烟雾消散
function M:smokedisAppear(rect, callback)
    local smoke = D.img("common/diysmoke/3/1.png"):to(rect, 30):scale(0.8)
    if callback then
        callback()
    end
    smoke:line({
        {"image", "common/diysmoke/3/", 6, .1},
        {"fn", function()
            rect:remove()
        end},
    })
end

-- 锤子动作
function M:hammerAction(hammer, callback)
    local sx = hammer:scaleX()
    local sy = hammer:scaleY()
    local k = 0
    hammer:cycle({
        {"union",{
            {"rotateBy", .1, - hammer:z() * 45},
            {"scaleBy", .1, 1.1},
        }},
        {"union",{
            {"rotateBy", .15, hammer:z() * 90},
            {"scaleTo", .15, sx, sy},
        }},
        {"rotateBy", .15, - hammer:z() * 45},
        {"delay", .05},
        {"fn", function()
            k = k + 1 
            if k == 2 and callback then
                callback()
            end
        end},
    }, 2)
end

-- 预加载烟雾帧动画
function M:preloadSmokePic()
    -- 预加载烟雾
    for i = 1, 3 do
        for j = 1, 5 do
            R.loadTextureAsync("common/diysmoke/"..i.."/"..j..".png", function ()
            end)
        end
	end
end

return M
