--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[	工具类
--]]
local M    = {}
M.TAG        = "Tools"

------------------------------
-- 替换父节点
------------------------------
function M:resetParent(node, parent, order)
    order = ifnil(order, 10)      --  层级
    -- 坐标
    local pos        = nil
    -- 缩放大小
    local scaleSizeX    = 1
    local scaleSizeY    = 1
    -- 旋转角度
    local rotateSize    = 0

    local nodeParent = node:getParent()
    local wPoint    = node:convertToWorldSpaceAR(ccp(0, 0))
    local nPoint    = parent:convertToNodeSpace(wPoint)

    scaleSizeX    = node:scaleX() * node:getParent():scaleX() / parent:scaleX()
    scaleSizeY    = node:scaleY() * node:getParent():scaleY() / parent:scaleY()
    rotateSize    = node:rotate() + node:getParent():rotate() - parent:rotate()

    node:retain()
    node:removeFromParent()
    node:to(parent, order):p(nPoint):rotate(rotateSize)
    node:scaleX(scaleSizeX):scaleY(scaleSizeY)
    node:release()
end

------------------------------
-- 加载场景中的雪花 #层（父节点） #默认层级Z值 #需要检查Z值的精灵集合（在精灵前面落地Z值高于精灵，在精灵后面落地Z值低于精灵  ）
------------------------------
function M:loadSnows(layer, zOrder, checkZNodes, roundNum, isDoor, config, imageTb, forcedOpen)
    if not forcedOpen then
        if BB_CHANNEL_ID == "A005" and IS_AD_ON then return end
    end
    config = ifnil(config, {})
    local posY = ifnil(config.posY, V.h)
    local scaleSize = ifnil(config.scaleSize, cc.p(3, 5))
    if imageTb then
        if #imageTb == 0 then
            imageTb = { "common/snow/1.png" }
        end
    else
        imageTb = { "common/snow/1.png" }
    end
    if isDoor then
        posY = layer:py() * 2
    end
    if not layer then return end
    zOrder = zOrder or 9999
    roundNum = roundNum or 13
    local actionNode = U.loadNode():to(layer)
    local function createSnow(index, posX)
        local randX = math.random() < 0.5 and -1 or 1
        local imgIndex = math.random(1, #imageTb)
        local snow = D.img(imageTb[imgIndex]):to(layer, zOrder):p(posX, posY + 30 + randX * math.random(0, 20)):scale(math.random(scaleSize.x, scaleSize.y) / 10)
        local dir = math.random() < 0.5 and -1 or 1
        local speed = math.random(90, 130)
        local endPy = math.random(0, 50)
        local time = (V.h + 30 - endPy) / speed
        snow._endPy = endPy
        snow:line({
            A.union({
                { "moveBy", time, cc.p(0, -(V.h + 30 - endPy)) },
                { "rotateBy", time, dir * math.random(90, 180) },
            }),
            { "fn", function()
                snow:stopAllActions()
                snow:line({
                    { "fadeTo", 0.5, 0 },
                    { "remove" },
                })
            end }
        })

        -- 递归左右飘动动作
        local function snowFloat()
            dir = -dir
            local dis = math.random(0, 15)
            local time = dis / 10
            snow:line({
                { "easing", "SINEINOUT", { "moveBy", time, cc.p(dis * dir, 0) } },
                { "fn", function()
                    snowFloat()
                end },
            })
        end
        snowFloat()

        -- 根据最后落地的位置决定在精灵前或是在精灵后
        if checkZNodes then
            -- 找出X轴距离最短的节点
            local disMin = 999
            local targetNode = nil
            for i, v in ipairs(checkZNodes) do
                local dis = math.abs(snow:px(), v:px())
                if dis < disMin then
                    disMin = dis
                    targetNode = v
                end
            end

            if targetNode then
                if snow._endPy > targetNode:py() - targetNode:ch() * targetNode:a().y + snow:ch() / 2 then
                    snow:z(targetNode:z() - 1)
                else
                    snow:z(targetNode:z() + 1)
                end
            end
        end
        -- if updateFn then
        --     leaf:scheduleUpdateWithPriorityLua(function (dt)
        --         updateFn(leaf, dt)
        --     end, 0)
        -- end
    end

    local function delayFn()
        local num1 = ifnil(config.offset1, 0)
        local num2 = ifnil(config.offset2, V.w)
        if isDoor then
            num1, num2 = layer:px() - layer:cw(), layer:px() + layer:cw() / 2
        end
        for i = 1, math.random(1, roundNum) do
            createSnow(math.random(1, 3), math.random(num1, num2))
        end
        actionNode:line({
            { "delay", math.random(30, 50) / 50 },
            { "fn", function()
                delayFn()
            end },
        })
    end
    delayFn()
end

------------------------------
-- 进入下个场景前资源的处理
------------------------------
function M:beforeInNextSceneOperation()
    DragonBone.removeAll()
    R.removeAllTextures()
    R.removeAllFrames()
end

------------------------------
-- 更换锚点，保持位置不变
------------------------------
function M:changeAnchorP(node, newAP)
    local nowAP = node:anchor()
    local box = node:getBoundingBox()
    local dx    = (newAP.x - nowAP.x) * box.width
    local dy    = (newAP.y - nowAP.y) * box.height

    node:px(node:px() + dx)
    node:py(node:py() + dy)
    node:anchor(newAP)
end

------------------------------
-- 调整锚点 
-- 如果是在传入的节点是节点类中，如传入self，则获取到的anchor()是ccp(0.5, .5)
------------------------------
function M:adjustAnchor(parent)
    -- local box = parent:getBoundingBox()
    local node = U.loadNodeMask({
        contentSize = cc.size(10, 10),
        color = ccc3(255, 255, 0)
    }):to(parent, 9999):bindTouch():opacity(255)
    -- :p(box.width * parent:anchor().x, box.height * parent:anchor().y)
    :p(parent:cw() * parent:anchor().x, parent:ch() * parent:anchor().y)
    function node:onTouchBegan(x, y, touches)
        local pos = parent:convertToNodeSpace(ccp(x, y))
        self:p(pos)
        return true
    end
    function node:onTouchMoved(x, y, touches)
        local pos = parent:convertToNodeSpace(ccp(x, y))
        self:p(pos)
    end
    function node:onTouchEnded(x, y, touches)
        local pos = parent:convertToNodeSpace(ccp(x, y))
        self:p(pos)
        local x = string.format("%.2f", pos.x / parent:cw())
        local y = string.format("%.2f", pos.y / parent:ch())
        -- print("anchor = ", pos.x / box.width, pos.y / box.height)
        print("锚点坐标 ================== anchor = cc.p(" .. x .. ", " .. y .. ")")
    end
end

--转为刚体坐标
function M:b2Vec2FromCCPoint(vec)
    local PTM = ifnil(PTM_RATIO, 32)
    return b2Vec2(vec.x / PTM, vec.y / PTM)
end

--手指滑动引导动作
function M:fingerMoveAction(finger, startPos, endPos)
    finger:line({
        { "show" },
        { "fn", function()
            finger:p(startPos)
        end },
        { "imageRange", "common/finger/1000", 1, 3, 3 / 60 },
        { "delay", 0.1 },
        { "moveto", 0.7, endPos },
        { "delay", 0.2 },
        { "hide" },
    })
end

--手指点击引导
function M:fingerTouchGuide(finger, light, pos)
    light:scale(0):opacity(255)
    light:cycle({
        { "delay", 0.3 },
        { "scaleTo", 0.4, 1 },
        { "fadeTo", 0.1, 0 },
        { "fn", function()
            light:scale(0):opacity(255)
        end },
        { "delay", 0.3 },

    })
    finger:cycle({
        { "show" },
        -- {"delay", 0.2},
        { "imageRange", "common/finger/1000", 1, 3, 10 / 60 },
        { "fn", function()
        end },
        { "delay", 0.6 },
    -- { "imageRange", "common/finger/1000", 1, 3, 10 / 60 },
    -- {"hide"}
    })
end

-- 显示自身包围盒（废弃）
function M:showSelfBox(node, scaleX, scaleY)
    scaleX = scaleX or 1
    scaleY = scaleY or 1
    local anchor = node:anchor()
    local box = node:getBoundingBox()
    local pos = ccp(box.width * scaleX / 2, box.height * scaleY / 2)
    local maskBox = U.loadNodeMask({
        contentSize = cc.size(box.width * scaleX, box.height * scaleY)
    }):to(node, -1):p(pos):anchor(anchor)
end

-- 放入物品反馈
-- node:执行动作对象
-- strength:强度
function M:feedback(node, strength)
    if node.isfirst then return end
    local strength = strength or 1
    node.isfirst = true
    local size
    if node:scaleX() > node:scaleY() then
        size = node:scaleX() - (node:scaleX() - node:scaleY()) / 2
    elseif node:scaleX() < node:scaleY() then
        size = node:scaleX() + (node:scaleX() - node:scaleY()) / 2
    else
        size = node:scaleX()
    end

    node:line({
        { "scaleTo", 0.1, size + 0.15 * strength, size - 0.1 * strength },
        -- {"scaleTo", 0.1, size + 0.1 * strength, size - 0.05 * strength},
        { "scaleTo", 0.1, size },
        { "scaleTo", 0.1, size + 0.1 * strength, size - 0.05 * strength },
        { "scaleTo", 0.1, size },
        { "fn", function()
            node.isfirst = false
        end }
    })
end

--放置反馈1
function M:feedback1(node)
    node:line({
        A.union({
            { "jumpBy", 0.2, cc.p(0, 0), 40, 1 },
            { "rotateTo", 0.1, -4 },
        }),
        A.union({
            { "jumpBy", 0.2, cc.p(0, 0), 25, 1 },
            { "rotateTo", 0.1, 3 },
        }),
        A.union({
            { "jumpBy", 0.1, cc.p(0, 0), 10, 1 },
            { "rotateTo", 0.05, -2 },
        }),
        { "rotateTo", 0.05, 2 },
        { "rotateTo", 0.05, -2 },
        { "rotateTo", 0.04, 2 },
        { "rotateTo", 0.04, -2 },
        { "rotateTo", 0.03, 1 },
        { "rotateTo", 0.03, -1 },
        { "rotateTo", 0.02, 0 },
    })
end

--放置反馈1
function M:feedback2(node, angle)
    angle = ifnil(angle, node:rotate())
    local sizeX = node:scaleX()
    local sizeY = node:scaleY()
    local action = A.line({
        -- A.union({
        --     { "jumpBy", 0.2, cc.p(0, 0), 10, 1 },
        --     { "rotateTo", 0.1, angle + 3 },
        -- }),
        -- A.union({
        --     { "jumpBy", 0.1, cc.p(0, 0), 5, 1 },
        --     { "rotateTo", 0.05, angle - 2 },
        -- }),
        { "union", {
            { "jumpBy", 0.2, cc.p(0, 0), 10, 1 },
            { "rotateTo", 0.1, angle + 3 },
            { "line", {
                { "scaleTo", 0.1, sizeX * 0.95, sizeY * 1.05 },
                { "scaleTo", 0.1, sizeX * 1.05, sizeY * 0.95 },
            } }
        } },
        { "union", {
            { "jumpBy", 0.1, cc.p(0, 0), 5, 1 },
            { "rotateTo", 0.05, angle - 2 },
            { "scaleTo", 0.1, sizeX * 1 },
        } },
        { "rotateTo", 0.05, angle + 2 },
        { "rotateTo", 0.05, angle - 2 },
        { "rotateTo", 0.04, angle + 2 },
        { "rotateTo", 0.04, angle - 2 },
        { "rotateTo", 0.03, angle + 1 },
        { "rotateTo", 0.03, angle - 1 },
        { "rotateTo", 0.02, angle + 0 },
    })
    return action
end


--叶子掉落
function M:leafFall(node, layer)
    soundEffect:playEffect23202002()
    self:resetParent(node, layer, 40)
    local pos = ccp(math.random(1, 960), -250)
    local time = self.getTime(pos, node, 500)
    local angle = N.random(-180, 180)
    if angle == 0 then angle = 10 end
    node:line({
        -- { "scaleTo", 0.15, 0.8, 1.3 },
        { "easing", "elasticOut", { "scaleTo", 0.1, 1 }, 0.2 },
        { "union", {
            { "moveTo", time, pos },
            { "rotateBy", time, angle },
        } },

        { "fn", function()
            node:remove()
            node = nil
        end }
    })
end

--[m_spObj:对象, m_posEnd：结束坐标, m_bIsRemove:是否移除]
-- 调用play函数播实现叶动作
function M:playLeafAnim(m_spObj, m_posEnd, m_bIsRemove, m_dVelocity, m_fun)
    local roTime, actionTime
    local fAngle1, fAngle2
    local positionEnd = m_posEnd
    actionTime = bb.URandom.number(2, 6)
    if (bb.URandom.boolean()) then
        roTime = 2.5    --//叶子单向摆动一次时间
        fAngle1 = -80    --//叶子逆时针摆动角度
        fAngle2 = 80 / 2     --//顺时针摆动角度
    else
        roTime = 3.2;
        fAngle1 = -100;
        fAngle2 = 100 / 2;
    end
    --随机生成叶子横向偏移值
    local time = M.getTime(positionEnd, m_spObj, m_dVelocity)
    --叶子所运动到的位置
    local function resetLeafPos(callback)
        A.line({
            { "moveto", time, positionEnd },
            { "fn", function()
                m_spObj:stopAllActions()
                if (m_bIsRemove) then
                    m_spObj:remove()
                end
                if (m_fun) then
                    m_fun()
                end

            end }
        }):at(m_spObj)
    end
    resetLeafPos()
    -- //叶子翻转动作
    m_spObj:setVertexZ(60) --设置深度抬高60，避免出现使用CCOrbitCamera实现空间翻转时产生错位和遮挡等问题
    --让树叶精灵始终执行三维翻转的动作
    local function fz3d(callback)
        A.line({
            tolua.cast(cc.OrbitCamera:create(actionTime, 1, 0, 0, 360, 45, 0), "cc.Action"),
            { "fn", function()
                fz3d(callback)
            end }
        }):at(m_spObj)
    end
    fz3d() -- 无限循环执行叶片翻转的动作
    A.cycle({
        { "easing", "inout", { "rotateby", actionTime, fAngle1 }, actionTime },
        { "easing", "inout", { "rotateby", actionTime, fAngle2 }, actionTime },
    }):at(m_spObj)
end

-- 获取时间
function M.getTime(m_posEnd, m_spObj, m_dVelocity, m_posStart)
    local t_posStart = m_posStart or ccp(m_spObj:getPositionX(), m_spObj:getPositionY())
    local distance = bb.UPoint.distance(m_posEnd.x, m_posEnd.y, t_posStart.x, t_posStart.y)
    local m_dVelocity = m_dVelocity or M.getVelocity()
    local time    = distance / m_dVelocity
    return time
end

-- 获得速度
function M.getVelocity()
    local range    = M.getRangeVelocity()
    return bb.URandom.num(range.min, range.max)
end


-- 获得速度区间
function M.getRangeVelocity()
    return { min = 400, max = 500 }
end


-- 手动释放资源
function M:releaseGame()
    -- 卸载图片
    R.removeAllTextures()
    R.removeAllFrames()
    DragonBone.removeAll()
    -- 卸载所有音频
    sound.unloadAllSound()
    sound.stopAll()
    sound.uncacheAll()
end


--拍照(路径，结点，区域)
function M:takeShot(path, nodes, rect, color, isClippingNode)
    if IO.exists(path) then
        -- 存在图片，清空缓存
        R.removeSpriteFrameByImageName(path)
    end
    local color = color or ccc4(0, 0, 0, 0)
    local isClippingNode = isClippingNode or false
    return SO.shot({
        renderBackground = true,
        backgroundColor = color,
        path = path,
        nodes = nodes,
        rect = rect,
        isClippingNode = isClippingNode
    })
end


--[[--

切屏效果：裁切退出

### Useage:

### Aliases:

### Notice:

### Example:

### Parameters:
-   CCNode              **node**               			[必选] 挂载的结点
-   string              **imgpath**            			[必选] 裁切的图片
-   layer               **originLayer**                 [必选] 原图层
-   nim                 **callBack**  	   			    [必选] 回调函数
-   string              **sceneOrLayerName**            [必选] 场景名

### OptionParameters

### Returns: 
-   nil   

--]]
-- 裁切进入
function M:exitSceneScale(node, imgPath, time, pos, scaleNum, anchorNum, delayTime, callBack, bgImg, flowerOffset)
    if not node then return end
    flowerOffset = ifnil(flowerOffset, ccp(1, 1))
    node:bindTouch()
    node.mask = U.loadLayer({ color = ccc4(255, 255, 255, 255) })
    local flowerMask = U.loadNode({}):to(node, 10000001):bindTouch()
    local bgImg = ifnil(bgImg, "common/exitbg/3.png")
    local bg = U.loadBg(bgImg):to(node.mask):bindTouch()
    -- 模板
    imgPath = imgPath or "common/help1.png"
    anchorNum = ifnil(anchorNum, cc.p(0.5, 0.5))
    node.templet = D.img(imgPath):p(pos)
    node.templet:scale(10):anchor(anchorNum)
    local m_clip = CCClippingNode:create()
    --或直接在create(self.templet)传入
    m_clip:setStencil(node.templet)
    --设置遮罩模式[true：显示模板区域，false：显示模板外区域]
    m_clip:setInverted(true)
    --设置ALPHA的测试参考值    
    m_clip:setAlphaThreshold(0)
    node:addChild(m_clip, 10000000)
    m_clip:addChild(node.mask, 10000000)
    -- 播放音效[sfx05700010]洞窥框
    soundEffect:playEffectsfx05700010()
    local time = ifnil(time, 0.6)
    local scaleNum = scaleNum or 0.7
    local delayTime = delayTime or 0.3

    local flyTb = {}
    local posTb = {
        ccp(-120, 50), ccp(10, -20), ccp(-85, -20), ccp(-20, 50), ccp(-62, 120), ccp(25, 118),
    }
    local function flyFlowerAct(flower)
        local dir = math.random() < 0.5 and -1 or 1
        local time = math.random(80, 110) / 100
        flower:line({
            { "Delay", math.random(12, 15) / 100 },
            { "fn", function()
                flower:cycle({
                    { "fn", function()
                        flower:p(flower._pos):opacity(255)
                    end },
                    A.union({
                        { "fadeTo", math.random(30, 50) / 100, 255 },
                        { "moveby", time, cc.p(math.random(60, 100), math.random(-50, -60)) },
                        { "rotateBy", time, dir * math.random(90, 180) },
                    }),
                    { "fadeTo", 0.5, 0 },
                })
            end },
        -- { "remove" },
        })
    end
    for i, v in ipairs(posTb) do
        local downFlower = D.img("common/exitbg/flower/" .. math.random(3, 4) .. ".png"):to(flowerMask, 88888):opacity(0)
        :p(pos.x + posTb[i].x * flowerOffset.x, pos.y + posTb[i].y * flowerOffset.y):bindTouchLocate()
        downFlower._pos = ccp(pos.x + posTb[i].x * flowerOffset.x, pos.y + posTb[i].y * flowerOffset.y)
        table.insert(flyTb, downFlower)
    end

    local flowerTb = {}
    local posTb = {
        ccp(-75, 60), ccp(75, -36), ccp(85, 40),
    }
    local function flowerShow(flower)
        flower:line({
            { "Delay", math.random(12, 15) / 100 },
            { "union", {
                { "easing", "backout", { "scaleTo", 0.5, math.random(78, 90) / 100 } },
                { "fadeTo", 0.5, 255 }
            } },
        })
    end
    local function hideFlower(flower)
        flower:line({
            { "fadeto", 0.3, 0 },
            { "hide" }
        })
    end
    for i, v in ipairs(posTb) do
        local flower = D.img("common/exitbg/flower/" .. math.random(1, 2) .. ".png")
        :to(flowerMask, 88888):p(pos.x + posTb[i].x * flowerOffset.x, pos.y + posTb[i].y * flowerOffset.y):opacity(0):scale(0):bindTouchLocate()
        flower:cycle({
            { "rotateBy", 1.5, 360 }
        })
        table.insert(flowerTb, flower)
    end
    flowerMask:line({
        { "Delay", time * 0.6 },
        { "fn", function()
            for i, v in ipairs(flowerTb) do
                flowerShow(v)
            end
            for i, v in ipairs(flyTb) do
                flyFlowerAct(v)
            end
        end },
    })
    --加载小花
    node.templet:line({
        { "scaleTo", time, scaleNum },

        { "delay", delayTime },
        { "fn", function()
            -- 播放音效[sfx05700014]洞窥框-合闭
            soundEffect:playEffectsfx05700014()
            for i, v in ipairs(flowerTb) do
                hideFlower(v)
            end
            for i, v in ipairs(flyTb) do
                hideFlower(v)
            end
            -- soundEffect:playEffect23209017()
        end },
        { "scaleTo", 0.4, scaleNum * 1.2 },
        { "scaleTo", 0.15, 0 },
        { "delay", 0.1 },
        { "fn", function()
            if callBack and isfunction(callBack) then
                callBack()
            end
        end },
    })
end
-- function M:exitSceneScale(main, imgPath, time, nodePos, scaleNum, delayTime, callBack)
--     local scale = ifnil(scaleNum, 1.5)
--     local mask = U.loadNodeMask({
--         contentSize = cc.size(V.w * 3 + 2, V.h * 1.2),
--         color    = ccc3(0, 0, 0)
--     }):anchor(cc.p(0.5, 0)):p(V.w_2, 0):opacity(255)
--     local nodePos = ifnil(nodePos, cc.p(V.w_2, V.h_2))
--     -- 洞
--     local hole = D.img("common/focusguide/2.png"):p(nodePos):scale(6)--:scale(scale)
--     local hole1 = D.img("common/focusguide/2.png"):p(nodePos):to(main, 20001):opacity(255):scale(6)--:scale(scale)
--     -- ClippingNode 
--     local m_clip = CCNodeExtend.extend(cc.ClippingNode:create(hole)):to(main, 20000)
--     m_clip:setInverted(true)
--     m_clip:setAlphaThreshold(0) -- 显示透明区域
--     m_clip:addChild(mask)
--     -- 播放音效[sfx25501005]洞窥框出现
--     soundEffect:playEffectsfx25501005()
--     local time = ifnil(time, 0.6)
--     local scaleNum = ifnil(scaleNum, 0.7) * 1.2
--     local delayTime = ifnil(delayTime, 0.3)
--     hole:line({
--         { "scaleTo", time, scaleNum },
--         { "delay", delayTime },
--         { "fn", function()
--             -- soundEffect:playEffect23209017()
--         end },
--         { "scaleTo", 0.4, scaleNum * 1.2 },
--         { "scaleTo", 0.15, 0 },
--         { "delay", 0.1 },
--         { "fn", function()
--             m_clip:remove()
--             m_clip = nil
--             if callBack and isfunction(callBack) then
--                 callBack()
--             end
--         end },
--         {"remove"}
--     })
--     hole1:line({
--         { "scaleTo", time, scaleNum },
--         { "delay", delayTime },
--         { "scaleTo", 0.4, scaleNum * 1.2 },
--         { "scaleTo", 0.15, 0 },
--         { "delay", 0.1 },
--         { "remove" }
--     })
-- end
--[[--

切屏效果：裁切进入
### Parameters:
-   CCNode              **node**               [必选] 挂载的结点
-   string              **imgpath**            [必选] 裁切的图片
-   function            **cb**                 [可选] 回调函数
### OptionParameters

### Returns: 
-   nil   
--]]
--
-- 裁切进入
function M:enterSceneScale(node, imgPath, time, pos, bgImg)
    node.mask = U.loadLayer({ color = ccc4(255, 255, 255, 255) })
    local bgImg = ifnil(bgImg, "common/exitbg/3.png")
    local bg = U.loadBg(bgImg):to(node.mask)
    pos = pos or cc.p(480 + X_OFFSET, 270 * Y_FACTOR)
    -- 模板
    node.templet = D.img(imgPath):p(pos)
    node.templet:scale(0)
    local m_clip = CCClippingNode:create()
    --或直接在create(self.templet)传入
    m_clip:setStencil(node.templet)
    --设置遮罩模式[true：显示模板区域，false：显示模板外区域]
    m_clip:setInverted(true)
    --设置ALPHA的测试参考值    
    m_clip:setAlphaThreshold(0)
    node:addChild(m_clip, 1000)
    m_clip:addChild(node.mask, 1000)
    CCNodeExtend.extend(m_clip)
    time = time or 0.8
    -- 播放音效[sfx05700011]白色框展开
    soundEffect:playEffectsfx05700011()
    node.templet:line({
        { "scaleTo", time, 20 },
        { "fn", function()
            m_clip:remove()
            m_clip = nil
        end },
        { "remove" }
    })
end
-- function M:enterSceneScale(main, imgPath, time, nodePos)
--     local mask = U.loadNodeMask({
--         contentSize = cc.size(V.w * 3 + 2, V.h * 1.2),
--         color    = ccc3(0, 0, 0)
--     }):anchor(cc.p(0.5, 0)):p(V.w_2, 0):opacity(255)
--     local nodePos = ifnil(nodePos,cc.p(V.w_2, V.h_2))
--     -- 洞
--     local hole = D.img("common/focusguide/2.png"):p(nodePos):scale(0)--:scale(scale)
--     local hole1 = D.img("common/focusguide/2.png"):p(nodePos):to(main, 2001):opacity(255):scale(0)--:scale(scale)
--     -- ClippingNode 
--     local m_clip = CCNodeExtend.extend(cc.ClippingNode:create(hole)):to(main, 2000)
--     m_clip:setInverted(true)
--     m_clip:setAlphaThreshold(0) -- 显示透明区域
--     m_clip:addChild(mask)
--     local time = ifnil(time, 0.8)
--     -- 播放音效[sfx25502001]进场景洞窥放大
--     soundEffect:playEffectsfx25502001()
--     hole:line({
--         { "scaleTo", time, 20 },
--         { "fn", function()
--         end },
--         { "remove" }
--     })
--     hole1:line({
--         { "scaleTo", time, 20 },
--         { "fn", function()
--             m_clip:remove()
--             m_clip = nil
--         end },
--         { "remove" }
--     })
-- end
--  通过Loading场景来过渡
function M:enterSceneLoading(moduleName, args, foodId, transitionType, time, more)
    game:enterScene("loading", { moduleName = moduleName, foodId = foodId, args = args }, "fade", 0.5, COLOR3_WHITE)
    return scene
end


--[[--
预加载资源

### Useage:

### Aliases:

### Notice:

### Example:

### Parameters:
-   prefix                     [必选] 帧动画前缀
-   from             	   	   [必选] 帧动画开始序号
-   to                         [必选] 帧动画结束序号
### OptionParameters
    CommomFunc:addTexture("steak/cook/flip/", 1, 13)
### Returns: 
-   nil   
--]]
function M:addTexture(prefix, fromNum, toNum)
    for i = fromNum, toNum do
        local img = prefix .. i .. ".png"
        R.loadTexture(img, function() end)
    end
end


function M:addTextureAsync(prefix, fromNum, toNum)
    for i = fromNum, toNum do
        local img = prefix .. i .. ".png"
        R.loadTextureAsync(img, function() end)
    end
end

function M:unloadTexure(prefix, fromNum, toNum)
    for i = fromNum, toNum do
        local img = prefix .. i .. ".png"
        R.unloadTexture(img)
    end
end


-- 请资源
function M:removeAllBySelf()
    R.removeAllTextures()
    R.removeAllFrames()
    DragonBone.removeAll()
    sound.stopAllEffects()
end

--缩放音效
function M:guideEffect(guideNode)
    -- 播放音效[sfx05700004]缩放提示
    guideNode._guideEffect = soundEffect:playEffectsfx05700004()
end

function M:stopGuideEffect(guideNode)
    if guideNode._guideEffect then
        sound.stopSound(guideNode._guideEffect)
        guideNode._guideEffect = nil
    end
end

function M:openGuide(guideNode, scaleSize)
    if tolua.isnull(guideNode) then print("必须设置 guideNode 参数") return end
    scaleSize = ifnil(scaleSize, 1)
    if guideNode._guideAction then return end
    guideNode._guideAction = A.cycle({
        { "delay", 3 },
        { "fn", function()
            self:guideEffect(guideNode)
        end },
        { "scaleto", 0.2, scaleSize * 1.1 },
        { "scaleto", 0.1, scaleSize },
        { "scaleto", 0.2, scaleSize * 1.1 },
        { "scaleto", 0.1, scaleSize },
    }):at(guideNode)
end

function M:stopGuide(guideNode)
    if tolua.isnull(guideNode) then print("必须设置 guideNode 参数") return end
    if not guideNode._guideAction then return end
    self:stopGuideEffect(guideNode)
    guideNode:stopAction(guideNode._guideAction)
    guideNode._guideAction = nil
end


-- shader网格
-- 参数：1:图片结点，必须是图片；2、波浪的振幅；3、波动的速度；4、波浪的个数（个数是参数/2） 5：图片的向下偏移量
function M:shaderWave(node, u_high, u_speed, u_waveNum, u_offY)
    local bg = node
    local vert = [[
            attribute vec4 a_position; 
            attribute vec2 a_texCoord; 
            attribute vec4 a_color; 
            #ifdef GL_ES  
            varying lowp vec4 v_fragmentColor;
            varying mediump vec2 v_texCoord;
            #else                      
            varying vec4 v_fragmentColor; 
            varying vec2 v_texCoord;  
            #endif    
            void main() 
            {
                gl_Position = CC_PMatrix * a_position; 
                v_fragmentColor = a_color;
                v_texCoord = a_texCoord;
            }
        ]]
    local frag = [[
            #ifdef GL_ES 
            precision mediump float; 
            #endif 
            varying vec4 v_fragmentColor; 
            varying vec2 v_texCoord; 
            uniform float u_time;  
            uniform float u_high;   
            uniform float u_speed; 
            uniform float u_waveNum; 
            uniform float u_offY;                                                                          
            uniform float u_opa;                                                                          
            void main(void) 
            { 
                float y = v_texCoord.y-u_offY+u_high*sin(u_time*u_speed+v_texCoord.x*3.1415*u_waveNum);
                if(y<0.0){
                    gl_FragColor = vec4(0.0,0.0,0.0,0.0);
                }else{
                    vec4 c = texture2D(CC_Texture0, vec2(v_texCoord.x, y));
                    c.a = c.a * u_opa;
                    gl_FragColor = c;
                }
            }
        ]]
    local glProgram = cc.GLProgram:createWithByteArrays(vert, frag)
    bg:setGLProgram(glProgram)
    bg:setProgramFloat("u_high", u_high)
    bg:setProgramFloat("u_speed", u_speed)
    bg:setProgramFloat("u_waveNum", u_waveNum)
    bg:setProgramFloat("u_offY", u_offY)
    local delta = 1 / 30
    local time = 0
    A.cycle({
        { "fn", function()
            bg:setProgramFloat("u_time", time)
            bg:setProgramFloat("u_opa", node:opacity() / 255)
            time = time + delta
        end },
        { "delay", delta },
    }):at(bg)
end

--高斯模糊
function M:shaderGaussianBlur(spr, time)
    local vert = [[
            attribute vec4 a_position; 
            attribute vec2 a_texCoord; 
            attribute vec4 a_color; 
            #ifdef GL_ES  
            varying lowp vec4 v_fragmentColor;
            varying mediump vec2 v_texCoord;
            #else                      
            varying vec4 v_fragmentColor; 
            varying vec2 v_texCoord;  
            #endif    
            void main() 
            {
                gl_Position = CC_PMatrix * a_position; 
                v_fragmentColor = a_color;
                v_texCoord = a_texCoord;
            }
        ]]
    local frag = [[
            #ifdef GL_ES 
            precision mediump float; 
            #endif 
            varying vec4 v_fragmentColor;
            varying vec2 v_texCoord;
            uniform vec2 resolution;
            uniform float blurRadius;
            uniform float sampleNum;
            uniform vec2 pix_size;
            vec4 blur(vec2);


            vec4 blur(vec2 p)
            {
                if (blurRadius > 0.0 && sampleNum > 1.0)
                {
                    vec4 col = vec4(0);
                    vec2 unit = 1.0 / resolution.xy;
                    
                    float r = blurRadius;
                    float sampleStep = r / sampleNum;
                    
                    float count = 0.0;
                    
                    for(float x = -r; x < r; x += sampleStep)
                    {
                        for(float y = -r; y < r; y += sampleStep)
                        {
                            float weight = (r - abs(x)) * (r - abs(y));
                            col += texture2D(CC_Texture0, p + vec2(x * unit.x, y * unit.y)) * weight;
                            count += weight;
                        }
                    }
                    
                    return col / count;
                }
            
                return texture2D(CC_Texture0, p);
            }
            void main(void)
            {
                vec4 col = blur(v_texCoord);
                gl_FragColor = vec4(col) * v_fragmentColor;
            }
        ]]

    local maskOpacity = 0
    local pProgram = cc.GLProgram:createWithByteArrays(vert, frag)
    local glprogramstate = cc.GLProgramState:getOrCreateWithGLProgram(pProgram)

    local size = spr:getTexture():getContentSizeInPixels()
    spr:setGLProgramState(glprogramstate)
    glprogramstate:setUniformVec2("resolution", cc.p(size.width, size.height));
    glprogramstate:setUniformFloat("blurRadius", 1);
    glprogramstate:setUniformFloat("sampleNum", 3)
    -- glprogramstate:setUniformVec2("pix_size", cc.p(0,0));
    local delta = 1 / 40
    local time = 1
    A.cycle({
        { "fn", function()
            time = time + 0.1
            glprogramstate:setUniformFloat("blurRadius", time)
        end },
        { "delay", delta },
    }, 50):at(spr)
end


--高斯模糊 //0普通模糊 1高斯模糊 2动感模糊
function M:shaderBlur(spr, mode)
    local vert = [[
            attribute vec4 a_position; 
            attribute vec2 a_texCoord; 
            attribute vec4 a_color; 
            #ifdef GL_ES  
            varying lowp vec4 v_fragmentColor;
            varying mediump vec2 v_texCoord;
            #else                      
            varying vec4 v_fragmentColor; 
            varying vec2 v_texCoord;  
            #endif    
            void main() 
            {
                gl_Position = CC_PMatrix * a_position; 
                v_fragmentColor = a_color;
                v_texCoord = a_texCoord;
            }
        ]]
    local frag = [[
            #ifdef GL_ES 
            precision mediump float; 
            #endif 
            uniform float mode;//0普通模糊 1高斯模糊 2动感模糊
            uniform vec2 TextureSize;
            uniform float GlowRange; //模糊半径
            uniform float GlowExpand; //动感模糊角度
            varying vec4 v_fragmentColor;
            varying vec2 v_texCoord;

            vec4 blur(vec2);

            void main()                      
            {    
                vec4 clraverge=vec4(0,0,0,0);                                                                                                                
                if( GlowRange > 0.0 )                                                                                                         
                {   
                if(mode==2)
                {
                    float samplerPre =1;                               
                float range=GlowRange*3;
                float rad=GlowExpand;
                    for( float j = 1; j<=range ; j += samplerPre )  
                        {  
                float dx=0.002*cos(rad);
                float dy=0.002*sin(rad);
                vec2 samplerTexCoord = vec2( v_texCoord.x + j*dx, v_texCoord.y+j*dy );  
                        vec2 samplerTexCoord1= vec2( v_texCoord.x - j*dx,v_texCoord.y-j*dy);        
                if( samplerTexCoord.x < 0.0 || samplerTexCoord.x > 1.0 ||samplerTexCoord1.x < 0.0 || samplerTexCoord1.x > 1.0||
                samplerTexCoord.y < 0.0 || samplerTexCoord.y > 1.0 ||samplerTexCoord1.y < 0.0 || samplerTexCoord1.y > 1.0)
                        {      
                    continue;
                }
                vec4 tc= texture2D( CC_Texture0, samplerTexCoord );
                vec4 tc1= texture2D( CC_Texture0, samplerTexCoord1 );
                        clraverge+=tc; 
                        clraverge+=tc1;      
                        } 
                        clraverge/=(range*2);
                    } 
                else{  
                    float samplerPre = 3.0;
                    float radiusX = 1.0 / TextureSize.x;                                                                                       
                    float radiusY = 1.0 / TextureSize.y;         
                    float count = 0.0;   
                    float  range=GlowRange*2.0;
                    for( float i = -range ; i <= range ; i += samplerPre )                                                            
                        {                                                                                                                         
                        for( float j = -range ; j <= range ; j += samplerPre )                                                        
                        {    
                float nx=j;
                float ny=i;
                float q=range/1.75;
                            float  gr=(1.0/(2*3.14159*q*q))*exp(-(nx*nx+ny*ny)/(2*q*q))*9.0;   
                            vec2 samplerTexCoord = vec2( v_texCoord.x + j * radiusX , v_texCoord.y + i * radiusY );  
                            if( samplerTexCoord.x < 0.0)
                        samplerTexCoord.x=-samplerTexCoord.x;
                            else if(samplerTexCoord.x > 1.0)
                            samplerTexCoord.x =2-samplerTexCoord.x;

                            if(samplerTexCoord.y < 0.0)
                        samplerTexCoord.y=-samplerTexCoord.y;
                            else if(samplerTexCoord.y > 1.0)
                            samplerTexCoord.y =2-samplerTexCoord.y;                                                                                       

                            vec4 tc= texture2D( CC_Texture0, samplerTexCoord ); 
                            if(mode==0)
                            clraverge+=tc;  
                            else  if(mode==1)
                            clraverge+=tc*gr;  
                            count+=1;    
                            }       
                        }  
                        if(mode==0)
                        clraverge/=count;   
                    } 
                }  
                gl_FragColor =clraverge;
            }
        ]]

    local maskOpacity = 0
    local pProgram = cc.GLProgram:createWithByteArrays(vert, frag)
    local glprogramstate = cc.GLProgramState:getOrCreateWithGLProgram(pProgram)

    local size = spr:getTexture():getContentSizeInPixels()
    spr:setGLProgramState(glprogramstate)
    glprogramstate:setUniformFloat("mode", mode);
    glprogramstate:setUniformVec2("TextureSize", cc.p(size.width, size.height));
    glprogramstate:setUniformFloat("GlowRange", 3);


    local delta = 1 / 60
    local time = 1
    A.cycle({
        { "fn", function()
            time = time * 1.01
            glprogramstate:setUniformFloat("GlowRange", time)
        end },
        { "delay", delta },
    }, 100):at(spr)
end

--查出轨迹 drawNode:画板所属于的那个结点,   pos:坐标, scaleSize:笔触擦除缩放大小
function M:brushTrace(drawNode, pos, scaleSize, time)
    time = ifnil(time, 1 / 60)
    if not drawNode:isTouchInside(pos) then
        return
    end
    if drawNode._drawLock then return end
    drawNode._drawLock = true
    drawNode:performWithDelay(function()
        drawNode._drawLock = false
    end, time)

    --判断是否擦除到点
    drawNode:washPoint(pos)
    local pos = drawNode:convertToNodeSpace(cc.p(pos))
    scaleSize = ifnil(scaleSize, 2)
    --画板渲染动作集合，不得大于50个
    local maxRenderActions = 40
    local renderAction = nil
    -- A.line({
    -- {"fn",function ()
    renderAction = A.cycle({
        { "fn", function()
            local renderNode = D.img("common/point2.png"):scale(scaleSize)
            renderNode:setBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_ALPHA)
            renderNode:setPosition(pos)
            drawNode._draw:begin()
            renderNode:visit()
            drawNode._draw:endToLua()
            scaleSize = scaleSize * 1.01
        end },
        { "delay", 0.1 },
    }, 15):at(drawNode)
    --画板渲染动作集合，不得大于50个
    -- if not drawNode._totalRenders then
    --     drawNode._totalRenders = {}
    -- end
    -- table.insert(drawNode._totalRenders, renderAction)
    -- if #drawNode._totalRenders > maxRenderActions then
    --     if drawNode._totalRenders[1] then
    --         drawNode:stopAction(drawNode._totalRenders[1])
    --         drawNode._totalRenders[1] = nil
    --         table.remove(drawNode._totalRenders, 1)
    --     end
    -- end
    -- end},
    -- { "delay", 0.1 * 15 },
    -- { "fn", function()
    --     if renderAction then
    --         drawNode:stopAction(renderAction)
    --         renderAction = nil
    --         table.remove(drawNode._totalRenders, renderAction)
    --     end
    -- end },
    -- }):at(drawNode)
end


-- 粒子加载，带自动删除
function M:newParticle(fileParticle, x, y)
    local particle = P.newParticle(fileParticle, x, y)
    local duration = particle:getDuration()
    if duration ~= -1 then
        local lifeSpan = particle:getLife()
        local lifeSpanVar = particle:getLifeVar()
        if isnumber(lifeSpan) then
            duration = duration + lifeSpan
        end
        if isnumber(lifeSpanVar) then
            duration = duration + lifeSpanVar
        end
        particle:line({
            { "delay", duration },
            { "remove" }
        })
    end
    return particle
end

-- 停止背景音乐(渐隐)
function M:stopMusic()
    -- 音频渐隐
    sound.voiceFadeOut(sound.getMusicHandle())
end

-----------------晃动引导------------------------------
-- 手指晃动引导
function M:handGuide(main, node, holePos, arrowPath)
    local holePos = ifnil(holePos, cc.p(node:point().x, node:point().y + 80))
    local guide = D.img("common/handguide/1.png"):to(main, 20000):p(holePos):hide()--:scale(0)
    main._guide = guide
    arrowPath = ifnil(arrowPath, "common/handguide/0.png")
    local arrow = D.img(arrowPath):to(main._guide, -1):p(95, 105)--:scale(0)
    main._arrow = arrow
    A.cycle({
        { "fn", function()
            main._guide:p(holePos.x - 43, holePos.y - 30)
        end },
        { "show" },

        A.union({
            { "image", "common/handguide/", 3, 0.1 },
            { "fn", function()
                arrow:p(95, 105)
                A.line({
                    { "delay", 0.3 },
                    { "fn", function()
                        A.line({
                            { "show" },
                            { "moveBy", 0.5, cc.p(10, 0) },
                            { "moveBy", 0.5, cc.p(-10, -10) },
                            { "moveBy", 0.5, cc.p(-10, 10) },
                            { "moveBy", 0.5, cc.p(10, 10) },
                            { "moveBy", 0.5, cc.p(10, -10) },
                            { "moveBy", 0.5, cc.p(-10, -10) },
                            { "moveBy", 0.5, cc.p(-10, 10) },
                            { "moveBy", 0.5, cc.p(10, 10) },
                            { "delay", 0.3 },
                            { "hide" },
                        }):at(arrow)
                    end }
                }):at(main._guide)
            end },
        }),
        { "moveBy", 0.5, cc.p(50, 0) },
        { "moveBy", 0.5, cc.p(-50, -50) },
        { "moveBy", 0.5, cc.p(-50, 50) },
        { "moveBy", 0.5, cc.p(50, 50) },
        { "moveBy", 0.5, cc.p(50, -50) },
        { "moveBy", 0.5, cc.p(-50, -50) },
        { "moveBy", 0.5, cc.p(-50, 50) },
        { "moveBy", 0.5, cc.p(50, 50) },
        { "hide" },
        { "delay", 3 }
    }):at(main._guide)
    -- 播放音效[24405001]引导
    -- soundEffect:playEffect24405001()
end

-- 移除手指晃动引导
function M:removeHandGuide(main)
    if main._guide then
        main._guide:remove()
        main._guide = nil
    end
end

-- 红光闪烁
function M:warnFlash(layer, num)
    if layer._warn then return end
    local light = D.img("common/warn.png"):pc():to(layer, 999):opacity(0)
    light:scaleY(V.h / light:ch())
    light:scaleX(V.w / light:cw())
    layer._warn = light
    num = num or 1
    A.line({
        { "cycle", {
            { "fadeTo", 0.25, 255 },
            { "fadeTo", 0.25, 180 },
            { "fadeTo", 0.25, 255 },
            { "fadeTo", 0.25, 80 },
            { "fadeTo", 0.25, 255 },
        }, num },
        { "fadeTo", 0.25, 0 },
        { "fn", function()
            self:removeWarnFlash(layer)
        end }
    }):at(light)

    -- 播放音效[sfx25503023]被打时警报
    soundEffect:playEffectsfx25503023()
end

function M:removeWarnFlash(layer)
    if not layer._warn then return end
    layer._warn:hide():stopAllActions()
    layer._warn:remove()
    layer._warn = nil
end

-----------------点击引导------------------------------
-- 引导遮罩 
function M:loadGuideMask(main, node, offSetX, offSetY, scale, callBack)
    if not node then return end
    offSetX = ifnil(offSetX, 0)
    offSetY = ifnil(offSetY, 0)
    scale = ifnil(scale, 1.2)
    local mask = U.loadNodeMask({
        contentSize = cc.size(V.w * 3 + 2, V.h * 3),
        color    = ccc3(0, 0, 0)
    }):anchor(cc.p(0.5, 0.5)):p(V.w_2, 0):opacity(150)

    local nodePos = node:convertToWorldSpaceAR(ccp(0, 0))
    nodePos = cc.p(nodePos.x + offSetX, nodePos.y + offSetY)
    -- 洞
    local hole = D.img("common/focusguide/2.png"):p(nodePos):scale(5)--:scale(scale)
    local hole1 = D.img("common/focusguide/2.png"):p(nodePos):to(main, 2001):opacity(150):scale(5)--:scale(scale)
    main._hole1 = hole1
    -- ClippingNode 
    main._clip = CCNodeExtend.extend(cc.ClippingNode:create(hole)):to(main, 2000)
    main._clip:setInverted(true)
    main._clip:setAlphaThreshold(0) -- 显示透明区域
    main._clip:addChild(mask)

    hole1:line({
        { "scaleTo", 0.5, scale },
        { "fn", function()
            if callBack then
                callBack()
            else
                self:addHand(main, nodePos)
            end
        end }
    })
    hole:line({
        { "scaleTo", 0.5, scale },
    })
end

-- 出现手指 
-- x,y  偏移量
-- isneedLight 是否需要光圈
function M:addHand(layer, pos, isneedLight)
    isneedLight = ifnil(isneedLight, true)
    local targetPos = pos
    local hand = D.img("common/finger/1.png"):p(targetPos):to(layer, 6000):anchor(cc.p(0.1, 0.8)):scale(1.2)
    hand:cycle({
        A.union({
            { "file", "common/finger/", 3, 0.3 / 3 },
            { "easing", "OUT", { "moveBy", 0.3, cc.p(-10, 10) }, 1 },
            { "scaleTo", 0.3, 1 },
            { "rotateTo", 0.3, -5 },
        }),
        { "fn", function()
            -- if not layer.guideSound then 
            -- 	layer.guideSound = soundEff.playSoundEff_15322008()
            -- end
            if isneedLight then
                self:addGuideLight(targetPos, layer)
            end
        end },
        { "delay", 0.5 },
        { "fn", function()
            hand:display("common/finger/1.png")
        end },
        A.union({
            { "easing", "IN", { "moveBy", 0.6, cc.p(10, -10) }, 0.4 },
            { "scaleTo", 0.6, 1.2 },
            { "rotateTo", 0.6, 0 },
        }),
    })
    layer._hand = hand
end

function M:addGuideLight(targetPos, layer)
    local light1 = D.img("common/finger/light_1.png"):p(targetPos):scale(0):to(layer, 5000)
    local light2 = D.img("common/finger/light_2.png"):p(targetPos):opacity(0):scale(0):to(layer, 5000)
    light1:line({
        { "easing", "IN", { "scaleTo", 1, 0.8 }, 0.5 },
        { "remove" }
    })
    light1:line({
        { "delay", 0.5 },
        { "fadeTo", 0.5, 0 },
    })

    light2:line({
        { "easing", "IN", { "scaleTo", 1, 0.8 }, 0.5 },
        { "remove" },
    })
    light2:line({
        { "delay", 0.2 },
        { "fadeTo", 0.1, 150 },
        { "delay", 0.1 },
        { "fadeTo", 0.3, 0 },
    })
end


-- 移除引导遮罩
function M:removeGuideMask(main)
    if main._clip then
        main._clip:remove()
        main._clip = nil
    end
    if main._hand then
        main._hand:remove()
        main._hand = nil
    end
    if main._hole1 then
        main._hole1:remove()
        main._hole1 = nil
    end
end

-- 点击效果
function M:clickEff(parent, x, y)
    -- 粒子加载，带自动删除
    -- local particle = self:newParticle("particle/click.plist", x, y):to(parent, 10000)
    local sunshine = D.img("common/sunshine.png"):to(parent, 10000):p(x, y):scale(0)
    sunshine:line({
        { "scaleTo", 0.5, 1.2 },
        { "fn", function()
            -- particle:stopSystem()
            sunshine:remove()
        end },
    })
    sunshine:line({
        { "delay", 0.3 },
        { "fadeTo", 0.2, 0 },
    })
end

-- 点击效果
function M:clickEff2(parent, x, y)
    -- local touch = D.img("common/touch/1.png"):to(parent, 10000):p(x, y)
    -- touch:line({
    --     { "image", "common/touch/", 9, 1 / 20 },
    --     { "fn", function()
    --         touch:remove()
    --     end },
    -- })
    local light1 = D.img("common/finger/light_1.png"):p(x, y):scale(0):to(parent, 5000)
    local light2 = D.img("common/finger/light_2.png"):p(x, y):opacity(0):scale(0):to(parent, 5000)
    light1:line({
        { "easing", "IN", { "scaleTo", 1, 0.8 }, 0.5 },
        { "remove" }
    })
    light1:line({
        { "delay", 0.5 },
        { "fadeTo", 0.5, 0 },
    })

    light2:line({
        { "easing", "IN", { "scaleTo", 1, 0.8 }, 0.5 },
        { "remove" },
    })
    light2:line({
        { "delay", 0.2 },
        { "fadeTo", 0.1, 150 },
        { "delay", 0.1 },
        { "fadeTo", 0.3, 0 },
    })
end

-- 添加调试节点(层， 节点数量, 位置， 附加参数) （不作为主代码，长度不作封装）
function M:loadTestNode(parent, num, pos, params, title)
    local title = ifnil(title, "g/box/logo_shine.png")
    -- 间隔
    local span    = 25
    -- 每行最大数量
    local maxNum    = 10
    -- 默认图片
    local imgName = title
    -- 图片（先从这里读取图片名，没有则使用默认图片）
    local imgDir    = {}
    -- 坐标
    pos            = pos or {}
    -- 附加参数
    if params and istable(params) then
        -- 基本参数
        span    = params.span or span
        maxNum = params.maxNum or maxNum
        span    = params.span or span
        imgName = params.imgName or imgName
        -- 图片路径(添加路径下的图片)
        if params.dir then
            imgDir = IO.filepathesPng(PH.combine(PH.combine(PATH_STORE_APP, "res/img/" .. DEVICE_MODEL), params.dir))
            for i, v in ipairs(imgDir) do
                imgDir[i] = PH.combine(params.dir, imgDir[i])
            end
            num = num or #imgDir
        end
        -- 图片集
        if params.file then
            local path = PH.combine(PATH_STORE_APP, "res/img/" .. DEVICE_MODEL)
            for i = 1, 100 do
                local filepath = PH.combine(path, params.file .. i .. ".png")
                if IO.exists(filepath) then
                    table.insert(imgDir, params.file .. i .. ".png")
                else
                    break
                end
            end
            num = num or #imgDir
        end
    end
    -- if true then return end
    -- 判断父节点是否是层
    isWorld = isWorld or (D.getRunningScene() == parent:getParent())

    parent._testNodeTable = {}
    -- 起始坐标
    local start = parent:cw() / 2 - (num > maxNum and maxNum / 2 * span or num * 12.5)
    -- 添加节点
    for i = 1, num do
        local nodePos = pos[i] or cc.p(start + span * ((i - 1) % maxNum), parent:ch() / 3 + (math.floor((i - 1) / maxNum)) * span)
        local img = imgDir[i] or imgName
        -- V.w_2/2
        local node = D.img(img):to(parent, 9999)
        node:p(nodePos):bindTouchLocate()

        local fontSize = 14
        if img == "g/box/logo_shine.png" then
            node:scale(0.15)
            fontSize = 90
        end

        local ttf = U.loadLabelTTF({
            text        = i,
            fontSize    = fontSize,
            color    = COLOR3_BLACK,
            position    = ccp(node:cw() / 2, node:ch() / 2),
        }):to(node)

        table.insert(parent._testNodeTable, node)
    end

    -- 添加输出按钮
    if parent._printBtn then
        parent._printBtn:remove()
        parent._printBtn = nil
    end
    local btn            = D.img("g/button/btn_ok.png"):to(parent, 99999):p(parent:cw() / 2, parent:ch() / 3 * 2):bindTouch()
    btn._testNodeTable    = parent._testNodeTable
    function btn:onTouchBegan(x, y, touches)
        return true
    end
    function btn:onTouchMoved(x, y, touches)
        self:p(self:getParent():convertToNodeSpace(cc.p(x, y)))
    end
    function btn:onTouchEnded(x, y, touches)
        print("================输出调试节点坐标===============")
        Tools:printNodeTable(self._testNodeTable, isWorld)
    end

    parent._printBtn = btn

    function parent:onTouchBegan(x, y, touches)
        if not parent._time then
            parent._time = os.time()
            return
        end
        if os.time() <= parent._time then
            local node = D.img(imgName):to(parent, 9999)

            local fontSize = 14
            if imgName == "g/box/logo_shine.png" then
                node:scale(0.2)
                fontSize = 90
            end
            node:p(parent:convertToNodeSpace(cc.p(x, y))):bindTouchLocate()

            table.insert(parent._testNodeTable, node)
            U.loadLabelTTF({
                text        = #parent._testNodeTable,
                fontSize    = fontSize,
                color    = COLOR3_WHITE,
                position    = ccp(node:cw() / 2, node:ch() / 2),
            }):to(node)
            print("新增一个点")
            parent._time = nil
        else
            parent._time = os.time()
        end
    end
end


------------------------------
-- 调试节点
------------------------------
-- 输出精灵表中所有精灵的坐标或某项信息
-- nodeTable 精灵表
-- isWorld   输出世界坐标
-- colMax    最大列数
-- fun       自定义的返回精灵数据的函数
-- isXoffset  是否添加X偏移值
-- isYoffset  是否添加Y偏移值
function M:printNodeTable(nodeTable, isWorld, colMax, func, isXoffset, isYoffset)
    if not nodeTable then print("no table") return end
    isWorld    = ifnil(isWorld, false)
    colMax    = ifnil(colMax, 5)
    isXoffset = ifnil(isXoffset, isWorld)
    isYoffset = ifnil(isYoffset, false)

    local Xoffset = isXoffset and " + X_OFFSET" or ""
    local Yoffset = isYoffset and " + Y_OFFSET" or ""

    local isPos = false     -- 是否是坐标
    -- 如果没有自定义返回数据的函数
    if not func then
        isPos = true
        if isWorld then
            func = function(node)
                return node:worldpoint()
            end
        else
            func = function(node)
                return node:point()
            end
        end
    end
    -- 开头
    local str = "\n{\n\t"
    for k, v in pairs(nodeTable) do
        local data = func(v)
        -- 换行
        if (k - 1) % colMax == 0 and k ~= 1 then
            str = str .. "\n\t"
        end

        local s
        -- 如果是坐标
        if isPos then
            s = string.format("cc.p(%.1f%s, %.1f%s), ", data.x, Xoffset, data.y, Yoffset)
            str = str .. s
        else
            str = str .. string.format("%d, ", data)
        end
    end
    -- 结尾
    str = str .. "\n}"
    print(str)
end


-- 呼吸
function M:breathing(node, strength)
    if not node then
        print("node为空")
        return
    end
    strength = ifnil(strength, 1)
    local sizeX = sizeX or node:scaleX()
    local sizeY = sizeY or node:scaleY()

    local num = math.random(100, 120) / 10
    local val1 = math.random(5, 10) / 100
    local val2 = math.random(5, 10) / 100
    node:cycle({
        { "scaleTo", num / 5, sizeX + val1 * strength, sizeY - val2 * strength },
        { "scaleTo", num / 5, sizeX, sizeY },
        { "scaleTo", num / 5, sizeX + val2 * strength, sizeY - val1 * strength },
        { "scaleTo", num / 5, sizeX, sizeY },
    })
end

-- 加载居中展示的光和粒子
function M:loadLightAndParticle(node, main, pos, size, type, time, maskSize)
    maskSize = ifnil(maskSize, 1)
    time = ifnil(time, 3)
    type = ifnil(type, 2)
    local imgs = { "light", "light2" }
    pos = ifnil(pos, ccp(node:cw() / 2, node:ch() / 2))
    local mask = U.loadNodeMask({    
    contentSize    = CCSize(V.w * 1.2, V.h * 1.2),
    color        = ccc3(0, 0, 0),
    }):anchor(cc.p(0, 0)):p(0, 0):to(main, 2000):scale(maskSize):opacity(0)
    node:z(2005)
    size = size or 1
    local light = D.img("common/" .. imgs[type] .. ".png"):to(node, -2):p(pos.x, pos.y):scale(size):opacity(200)


    local newPos = cc.p(node:cw() / 2, node:ch() / 2)
    local particle = Tools:newParticle("particle/cook_finish.plist", newPos.x, newPos.y):to(node, node:z() + 100):scale(1)
    light:line({
        { "Delay", 0.8 },
        { "fn", function()
            local particle = Tools:newParticle("particle/cook_finish.plist", newPos.x, newPos.y):to(node, node:z() + 100):scale(1)
        end },
        { "Delay", 0.8 },
        { "fn", function()
            local particle = Tools:newParticle("particle/cook_finish.plist", newPos.x, newPos.y):to(node, node:z() + 100):scale(1)
        end }
    })

    light:line({
        { "rotateBy", 1.5 * time, 180 * time },
        { "remove" }
    })
    mask:line({
        { "fadeTo", 0.3, 180 },
        { "delay", 1.5 },
        { "fadeOut", 0.3 },
        { "remove" },
    })
end

-- 限制在屏幕区域
function M:limitInScreen(node, fitCascade)
    fitCascade = ifnil(fitCascade, false)
    local nodeRect = cc.rect(0, 0, 0, 0)
    if fitCascade then
        nodeRect = node:getCascadeBoundingBox(false)
    else
        nodeRect = node:getBoundingBox()
    end
    local nodeMaxy = cc.rectGetMaxY(nodeRect)
    local nodeMiny = cc.rectGetMinY(nodeRect)
    local nodeMaxx = cc.rectGetMaxX(nodeRect)
    local nodeMinx = cc.rectGetMinX(nodeRect)
    local nodeHeight = nodeRect.height
    local nodeWidth = nodeRect.width
    local anchor = node:anchor()
    if nodeMaxy > V.h then
        local posY = V.h - nodeHeight * (1 - anchor.y) - 1
        node:py(posY)
    elseif nodeMiny < 0 then
        local posY = nodeHeight * (1 - anchor.y) - 1
        node:py(posY)
    end

    if nodeMaxx > V.w then
        local posX = V.w - nodeWidth * (1 - anchor.x) - 1
        node:px(posX)
    elseif nodeMinx < 0 then
        local posX = nodeWidth * (1 - anchor.x) - 1
        node:px(posX)
    end
end


-- 加载拖尾
function M:loadMotionStreak(toWho, param)
    local imgName        = ifnil(param.imgName, "common/finger/light.png")          -- 图像名称
    local time        = ifnil(param.time, 1)                               -- 间隐时间
    local pointDistance = ifnil(param.pointDistance, 1)                      -- 间隐片段大小, 拖尾条带相邻点的最小距离
    local size        = ifnil(param.size, 5)                               -- 贴图的宽高, 拖尾条带的宽度
    local zorder        = ifnil(param.zorder, 5)                             -- 贴图的层级

    -- 拖尾渐隐时间(秒), 最小的片段长度, 渐隐条带的宽度, 片段颜色值, 纹理图片的文件名。
    local motionStreak = cc.MotionStreak:create(time, pointDistance, size, cc.c3b(255, 255, 255), imgName)
    CCNodeExtend.extend(motionStreak)
    motionStreak:to(toWho, zorder)
    motionStreak:setBlendFunc(GL_SRC_ALPHA, GL_ONE)
    -- motionStreak:setBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA)
    return motionStreak
end

-- 出现手指 
function M:handMoveGuide(layer, startPos, endPos, offsetX, OffsetY, needArrow, startCallBack, endCallBack)
    needArrow = ifnil(needArrow, false)
    offsetX = ifnil(offsetX, -5)
    OffsetY = ifnil(OffsetY, -7)
    startPos = cc.p(startPos.x + 10, startPos.y - 10)
    local hand = D.img("common/finger/1.png"):p(startPos):to(layer, 6000):anchor(cc.p(0.1, 0.8)):scale(1.2)
    local arrow = nil
    if needArrow then
        arrow = D.img("common/finger/arrow.png"):p(startPos):to(layer, 5000):anchor(cc.p(1, 0.32)):scale(1):opacity(0)
    end

    hand:cycle({
        { "show" },
        { "union", {
            { "fn", function()

                if arrow then
                    arrow:line({
                        { "union", {
                            { "fadeTo", 0.3, 255 },
                            { "scaleTo", 0.3, 0.8, 1.2 },
                        } },
                        { "scaleTo", 0.5, 1.2, 0.5 },
                    })
                end
            end },
            { "file", "common/finger/", 3, 0.3 / 3 },
            { "easing", "OUT", { "moveBy", 0.3, cc.p(-10, 10) }, 1 },
            { "scaleTo", 0.3, 1 },
            { "rotateTo", 0.3, -5 },
            { "fadeto", 0.1, 255 }
        } },
        { "fn", function()
            layer._motionStreak = self:loadMotionStreak(layer, { time = 0.5, pointDistance = 1, size = 22, zorder = 1100 })
            layer._emptyForStreak = U.loadNode():to(layer)
            layer._emptyForStreak:cycle({
                { "fn", function()
                    layer._motionStreak:setPosition(hand:px() + offsetX, hand:py() + OffsetY)
                end },
                { "delay", 1 / 60 },
            })
            if startCallBack then
                startCallBack()
            end
        end },
        { "moveto", 0.5, endPos },
        { "fn", function()
            if layer._emptyForStreak then
                layer._emptyForStreak:stop()
                layer._emptyForStreak:remove()
                layer._emptyForStreak = nil
            end
            if arrow then
                arrow:line({
                    { "union", {
                        { "fadeTo", 0.4, 0 },
                        { "scaleTo", 0.4, 1, 1 },
                    } }
                })
            end
            if endCallBack then
                endCallBack()
            end
        end },
        { "delay", 0.3 },
        { "fadeto", 0.7, 0 },
        -- { "hide" },
        -- { "delay", 0.2 },
        -- { "fadeTo", 0.2, 0 },
        { "fn", function()
            hand:p(startPos):scale(1.2)
        end },
        { "delay", 1 },
    })
    layer._handGuide = hand
    layer._arrowGuide = arrow
end

--移除手指移动引导
function M:removeHandMoveGuide(layer)
    if layer._emptyForStreak then
        layer._emptyForStreak:remove()
        layer._emptyForStreak = nil
    end
    if layer._motionStreak then
        layer._motionStreak:remove()
        layer._motionStreak = nil
    end
    if layer._handGuide then
        layer._handGuide:remove()
        layer._handGuide = nil
    end
    if layer._arrowGuide then
        layer._arrowGuide:remove()
        layer._arrowGuide = nil
    end
end

-- 从table中随即获取一个item，去重(子项为cc.p的无效）
-- param： table table 目标表
-- param： oldItem 要去重的项
function M:getItemForTableExcept(desTable, oldItem)
    T.shuffle(desTable, #desTable)
    local newItem = T.random(desTable)
    if oldItem and type(oldItem) == "table" and T.count(desTable) > 1 then
        for k, v in pairs(oldItem) do
            if newItem == v then
                return self:getItemForTableExcept(desTable, oldItem)
            end
        end
    else
        if oldItem then
            if oldItem == newItem and T.count(desTable) > 1 then
                return self:getItemForTableExcept(desTable, oldItem)
            end
        end
    end

    return newItem
end

-- 移除节点
function M:removeNode(node)
    if node and not tolua.isnull(node) then
        node:remove()
    end
end

--区域限定
function M:dragLimit(node, x, y, offsetXm, offsetXn, offsetYm, offsetYn)
    if tolua.isnull(node) then return x, y end
    local px = x
    local py = y
    if x < offsetXm then px = offsetXm end
    if x > offsetXn then px = offsetXn end
    if y < offsetYm then py = offsetYm end
    if y > offsetYn then py = offsetYn end
    -- if x <= node:cw() * node:anchor().x and y >= V.h - 100  then
    --     return nil, nil
    -- end
    return px, py
end

-- 加载数字
--[[    param:
        value       :显示数值
        imgPre      :图片路径
        margin      :数字间隔
        itemWidth   :宽度
        itemHeight  :长度
    parent:         父类
    pos:            坐标
]]
function M:loadNum(param, parent, pos)
    local value = ifnil(param.value, 0)
    local imgPre = ifnil(param.imgPre, "common/num/")
    local margin = ifnil(param.margin, 2)
    local itemWidth = ifnil(param.itemWidth, 27)
    local itemHeight = ifnil(param.itemHeight, 180)

    local num = U.loadNumLinear({
        value = value,
        imgPre = imgPre,
        margin = margin,
        itemWidth = itemWidth,
        itemHeight = itemHeight,
    }):p(pos):to(parent, 3000)
    return num
end


--求两点间任意点的坐标
function M:getPointBetweenTwo(startP, endP)
    local dp1 = startP
    local dp2 = endP
    local angle1 = PT.quadAngle(dp2, dp1)
    local distance = PT.distance(dp1, dp2)
    local lenth = distance * math.random(10, 90) / 100
    local x = dp1.x + (lenth * math.cos(math.rad(angle1)))
    local y = dp1.y + (lenth * math.sin(math.rad(angle1)))
    return cc.p(x, y)
end


--已知三角形的两点坐标,和三个边长,求第三点的坐标  point1：以此来判定下一点 point2：第二点  lenth1：point1距离所求点的距离  lenth2：point2距离所求点的距离
function M:calculateTriangleThirdPoint(point1, point2, lenth1, lenth2)
    local dp1 = point1
    local dp2 = point2
    local distance = PT.distance(dp1, dp2)

    local angle1 = PT.quadAngle(dp2, dp1)
    local angle2 = math.deg(
    math.acos(
    (math.pow(lenth1, 2) + math.pow(distance, 2) - math.pow(lenth2, 2)) / (2 * lenth1 * distance)
    )
    )

    local ACAngle = angle1 + angle2
    local x = dp1.x + (lenth1 * math.cos(math.rad(ACAngle)))
    local y = dp1.y + (lenth1 * math.sin(math.rad(ACAngle)))
    -- print(x,y)
    return cc.p(x, y)
end

--增加完成的数目
function M:addDoneNum()
    if G_DONE_GAME < 3 then
        G_DONE_GAME = G_DONE_GAME + 1
        ST.setNumber("DONE_GAME_NUM", G_DONE_GAME)
    end
end


-- 关闭广告
-- isAllChannel 是否是所有的渠道
-- isSmallScreen 是否为小屏去广告
function M:closeAd(isAllChannel, isSmallScreen)
    isAllChannel = ifnil(isAllChannel, false)
    isSmallScreen = ifnil(isSmallScreen, false)
    if IS_AD_ON then
        if isAllChannel or BB_CHANNEL_ID == "A005" then
            if isSmallScreen then
                if V.h < 640 then
                    NV.removeAd()
                end
            else
                NV.removeAd()
            end
        end
    end
end

-- 打开广告
-- isAllChannel 是否是所有的渠道
function M:openAd(isAllChannel)
    isAllChannel = ifnil(isAllChannel, true)
    if not IS_AD_ON then
        --所有渠道              --非谷歌渠道
        if isAllChannel or BB_CHANNEL_ID ~= "A005" then
            NV.addAd()
        end
    end
end


-- 多边形polySprite - 计算点
function M:meshVerticesAndTexcoords(row, col, arr)
    if #arr ~= row * col then
        return
    end
    -- 行 列 
    local num = (2 * math.max(row, col) + 1) * (math.min(row, col) - 1)
    local vertices = cc.PointArray:create(num)
    local texcoords = cc.PointArray:create(num)
    local r = row - 1
    local c = col - 1
    local tmp = 1
    -- 优化生成点的数量
    if row < col then
        for i = 0, r - 1 do
            if i % 2 == 0 then
                for j = 0, c do
                    tmp = i * col + j + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + col])
                    texcoords:addControlPoint(cc.p(j / c, i / r))
                    texcoords:addControlPoint(cc.p(j / c, (i + 1) / r))
                end
            else
                for j = c, 0, -1 do
                    tmp = i * col + j + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + col])
                    texcoords:addControlPoint(cc.p(j / c, i / r))
                    texcoords:addControlPoint(cc.p(j / c, (i + 1) / r))
                end
            end
        end
    else
        for i = 0, c - 1 do
            if i % 2 == 0 then
                for j = 0, r do
                    tmp = j * col + i + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + 1])
                    texcoords:addControlPoint(cc.p(i / r, j / c))
                    texcoords:addControlPoint(cc.p((i + 1) / r, j / c))
                end
            else
                for j = r, 0, -1 do
                    tmp = j * col + i + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + 1])
                    texcoords:addControlPoint(cc.p(i / r, j / c))
                    texcoords:addControlPoint(cc.p((i + 1) / r, j / c))
                end

            end
        end
    end
    return num, vertices, texcoords
end


--获取花的坐标
-- id：花的坐标  index:从左到右第几朵  vaseType:1:大花瓶 2:小花盆
function M:getFlowerConfig(id, index, vaseType)
    -- 加载花
    local flipX = false
    local offset = 25
    local pos = { ccp(60, 90), ccp(25, 90), ccp(35, 90) }
    if vaseType == 2 then pos = { ccp(35, 43), ccp(15, 43), ccp(25, 43) } offset = 10 end
    local tier = -1
    local angle = 0
    if index == 3 and id <= 2 then
        tier = -2
        pos[index].y = pos[index].y + 15
    elseif index == 3 and id >= 3 then
        pos[index].y = pos[index].y - 15
    end
    if index == 1 then
        if id == 4 or id == 2 then
            flipX = true
        end
    elseif index == 2 then
        if id == 1 or id == 3 then
            flipX = true
        end
    else
        if id == 2 or id == 4 then
            angle = 10
            pos[index].x = pos[index].x - offset
        else
            angle = -10
            pos[index].x = pos[index].x + offset
        end
    end
    return flipX, angle, pos[index], tier
end

--移除粒子
function M:removeParticle(particle1)
    if not tolua.isnull(particle1) then
        print("移除粒子")
        -- particle1:remove()
        -- particle1 = nil
    end
end

-- --插入移除粒子表
-- function M:insertParticleTb(node, particle)
--     if node and not tolua.isnull(node) then
--         local scene1 = node:getScene()
--         local layer = nil
--         if scene1 and scene1.getMainLayer and not tolua.isnull(scene1:getMainLayer()) then
--             layer = scene1:getMainLayer()
--         end
--         if layer then
--             if not layer._myParticleTb then
--                 layer._myParticleTb = {}
--             end
--             table.insert(layer._myParticleTb, particle)
--             dump(layer._myParticleTb)
--         end
--     end
-- end

-- --移除粒子表
-- function M:removeParticleTb(node)
--     if node and not tolua.isnull(node) then
--         local scene1 = node:getScene()
--         local layer = nil
--         if scene1 and scene1.getMainLayer and not tolua.isnull(scene1:getMainLayer()) then
--             layer = scene1:getMainLayer()
--         end
--         if layer then
--             if layer._myParticleTb then
--                 dump(layer._myParticleTb)
--                 for k, particle in pairs(layer._myParticleTb) do
--                     self:removeParticle(particle)
--                 end
--             end
--         end
--     end
-- end

--插入移除粒子表
function M:insertParticleTb(node1, particle)
    if node1 and not tolua.isnull(node1) then
        if not node1._myParticleTb then
            node1._myParticleTb = {}
        end
        table.insert(node1._myParticleTb, particle)
    end
end

--移除粒子表
function M:removeParticleTb(node1)
    if node1 and not tolua.isnull(node1) then
        if node1._myParticleTb then
            for k, particle in pairs(node1._myParticleTb) do
                self:removeParticle(particle)
            end
        end
    end
end

--移除资源
function M:removeLayerUnusedResource(layer)
    sound.stopAllSounds()
    sound.uncacheAll()
    R.removeAllTextures()
    R.removeAllFrames()
    self:removeParticleTb(layer)
end


-- 白屏切屏
function M.whiteEnterScene(sceneName, mainLayer, parma)
    -- local mask = U.loadNodeMask({ contentSize = cc.size(V.w, V.h), color = ccc3(255, 255, 255), opacity = 0 })
    -- :to(mainLayer, 990000):p(V.w_2, V.h_2)
    -- mask:line({
    --     { "fadeTo", 0.5, 255 },
    --     { "delay", 0.1},
    --     { "fn", function()
    --         game:enterScene(sceneName, parma)-- 切屏 
    --     end },
    -- })
    game:enterScene(sceneName, parma, "fade", 0.5, COLOR3_WHITE)
end

--[[
    layer    加载在哪个层
    params   参数集合

    示例：此处self为mainLayer层

    -- 1、直接洞窥到某个位置
    tools:exitSceneScale(self, {
        pos         = cc.p(480, 270),
        callback    = function ()
            print("回调")
        end
    })

    -- 2、洞窥到某个位置，停留一会后再消失
    tools:exitSceneScale(self, {
        pos         = cc.p(480, 270),
        scale       = 0.5,              -- 停留的大小
        delayTime   = 1,                -- 停留的时间
        callback    = function ()
            print("回调")
        end
    })
    -- 3、洞窥到某个位置，然后自行拿着洞窥对象做操作
    self._holeView = tools:exitSceneScale(self, {
        pos         = cc.p(480, 270),
        scale       = 0.5,              -- 停留的大小
        delayTime   = 1,                -- 停留的时间
        isClose     = false,            -- 不关闭洞窥
        callback    = function ()
            -- self._holeView 即为洞窟返回的对象
            self._holeView:line({
                {"moveTo", 0.5, cc.p(100, 100)},
                {"delay", 0.5},
                {"scaleTo", 0.1, 0},
            })
        end
    })
]]--
function M.exitSceneScale2(layer, params)
    -- 洞窥最后的坐标
    local pos       = ifnil(params.pos,     cc.p(V.w_2, V.h_2))
    -- 洞窥的形状
    local imgPath   = ifnil(params.imgPath, "common/round.png")
    -- 洞窟的时间
    local time      = ifnil(params.time, 0.5)
    -- 停留的大小
    local scale     = ifnil(params.scale,   0)
    -- 第二次缩小关闭的延迟时间
    local delayTime = ifnil(params.delayTime, 0.5)
    -- 是否马上关闭(如果洞窟需要做其他动作，应该设为false不让洞窟关闭，然后自行拿着洞窟对象做相应动作)
    local isClose   = ifnil(params.isClose, true)
    -- 回调函数
    local callback  = ifnil(params.callback, nil)
    -- 背景路径
    local bgPath     = params.bgPath
    -- 模板
    local hole = D.img(imgPath):p(pos)
    -- 初始大小 全屏
    hole:scale(5.5)
    -- 创建一个裁剪节点
    local clip                = CCNodeExtend.extend(cc.ClippingNode:create(hole)):to(layer, 24999)
    clip:setInverted(true)
    clip:setAlphaThreshold(0)
    local black     = D.img(bgPath):to(clip, 25000):anchor(ccp(.5, 0)):p(V.w_2, 0):scale(BG_SCALE)
    hole._clip      = clip
    hole._black     = black
    -- 播放音效[sfx27300017]洞窥-缩小
    soundEffect:playEffectsfx27318006()
    hole:line({
        -- 正常缩小
        A.union({
            { "scaleTo", time, scale},
            { "moveto", time, pos}
        }),
        {"delay", 0.1},
        {"fn", function()
            -- 是否马上关闭 并且 没有马上缩小为0
            if isClose and scale > 0  then
                hole:line({
                    {"delay", delayTime},
                    {"scaleTo", 0.2, scale * 1.2},
                    {"fn", function()
                        soundEffect:playEffectsfx27318015() 
                    end},
                    {"scaleTo", 0.2, 0.0001 },
                    {"delay", 1/60 },
                    {"fn", function()
                        if callback then
                            callback()
                        end
                    end},
                })
            else
                if callback then
                    callback()
                end
            end
        end},
    })
    return hole
end


return M
