--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景背景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Button")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..







----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params) 

end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
	M.super.onRender(self)

	-- 加载结点
    self:loadNode()
end

-- 加载按钮结点
function M:loadNode()
	-- 返回键 
    self:loadBackBtn() 
    -- test
    -- 广告区域
    -- self:loadAdArea()
    -- 快捷按钮
    self:loadQuickBtn()
    -- 加速按钮
    -- self:loadSpeedButton()
end 

-- 广告区域
function M:loadAdArea()
    if not IS_QUICKBTN_OPEN then return end
    U.loadNodeMask({
        contentSize = CCSize(576, 76), 
        color       = COLOR3_GREY,
        opacity     = 80
    }):to(self, 9999):anchor(cc.p(0.5, 1)):p(V.w_2, V.h):unbindTouch()
end

-- 返回键 
function M:loadBackBtn() 
	local button      = U.loadScaleButton({
        imagename      = "g/button/btn_back.png",          -- 按钮图片
        parent         = self,                             -- 父亲节点（选填)
        zorder         = 1000,                             -- 层深度（选填)
        pos            = ccp(getButtonX_Left(),V.h - 60),  -- 位置(默认返回键位置)
        tabsound       = "effect/sfx05700001.mp3",
        issubmit       = false,                             -- 是否只点击一次
        fnClicked      = function ( )
                            self:btnBackEvent()
                        end
    })
    self.btn_back = button

    if self:getScene()._isSelect then
        button:display("g/button/btn_home.png")
    end
end

--按钮返回键点击事件
function M:btnBackEvent()
    self:btnBackOther()
    game:enterScene("select", {}, "fade", 0.5, COLOR3_WHITE)
end

--按钮返回键点击事件其他
function M:btnBackOther()
    
end

--隐藏按钮
function M:hideBtn()
    self.btn_back:hide()
end

-- 加载速度按钮
function M:loadSpeedButton()
    if not IS_QUICKBTN_OPEN then return end
	-- if DebugModel then
		local picNam = {"btn_next", "btn_refresh", "btn_next"}
		for i = 1, 3 do
			local button = U.loadScaleButton({
				imagename      = "g/button/"..picNam[i]..".png",			-- 按钮图片                
				parent         = self,                             			-- 父亲节点（选填)
				pos            = cc.p(V.w_2 + 100*(i - 2), V.h - 138),		-- 位置
				zorder         = 99999,            							-- 层深度（选填)
				scaleTime      = 0.2,      									-- 缩放时间（默认1.0)
				scaleBegan     = 0.3,     									-- 缩放起始效果(默认0.7)                  
				scaleEnd       = 0.5, 										-- 缩放结束效果(默认1.0)
				tabsound 	   = "",       									-- 点击音效    
				issubmit 	   = false,									    -- 是否只点击一次  
				fnClicked      = treater(self, self.onSpeedButton, i)		-- 点击事件
			}):scale(0.5)
			if i == 1 then button:flipX(true) end
		end
	-- end
end

-- 点击速度按钮事件
function M:onSpeedButton(id)
	-- 是否是加速状态
	if id == 1 then
		-- 减速
		cc.Director:getInstance():getScheduler():setTimeScale(0.2)
	elseif id == 2 then
		-- 恢复正常速度
		cc.Director:getInstance():getScheduler():setTimeScale(1)
	elseif id == 3 then
		-- 加速
		cc.Director:getInstance():getScheduler():setTimeScale(10)
	end
end


-- 加载结点[快捷按钮]
function M:loadQuickBtn()
    if not IS_QUICKBTN_OPEN then return end
    -- 添加结点
    local button = U.loadScaleButton({
        -- 按钮图片
        imagename    = "common/beta.png",            
        -- 父亲节点（选填)
        parent        = self,                
        -- 层深度（选填)
        zorder        = 10000,                
        -- 缩放起始效果(默认0.7)
        scaleBegan    = 0.6,                
        -- 缩放结束效果(默认1.0)
        scaleEnd    = 1,                
        -- 位置(默认返回键位置)
        pos            = ccp(getButtonX_Right() -120, V.h - 60),        
        -- 缩放时间（默认1.0）
        scaleTime    = 0.2,
        -- 点击音效
        -- tabsound        = "",                 
        -- 点击事件
        fnClicked    = function()
            game:enterScene("quick")
        end
    })
    self._button = button
    button:unbindTouch()
    self:line({
        { "delay", 0.1 },
        { "fn", function()
            button:bindTouch()
        end } 
    })
end
----------------------
-- 结点析构
----------------------
--[[--

视图析构，处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end



return M
