--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
--[[!--

场景背景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("BaseCookLayer")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..







----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params) 

end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)
    -- 加载空节点
    self:loadEmptynode()
    --加载背景
    self:loadBg()
    --加载窗户
    self:loadWindow()
end

-- 加载空节点
function M:loadEmptynode()
    -- 加载一个空节点
    local node = U.loadNode({}):to(self):bindTouch():scale(1)
    self._node = node
end

--加载背景
function M:loadBg()
    local bg = U.loadBg("common/cook/bg/bg.png"):to(self._node):bindTouch()
    self._bg = bg
    -- local window = D.img("common/cook/bg/window.png"):to(bg):p(258.6, 599.6)
    local goods1 = D.img("common/cook/bg/1.png"):to(bg):p(720.3, 578.4)
    local goods2 = D.img("common/cook/bg/2.png"):to(bg):p(1090.1, 536.1)
end


--加载窗户
function M:loadWindow()
    local win = import("app.common.node.BaseWindow").new({
        layer = self,
    }):to(self._bg):p(250.6, 550.6)
end

----------------------
-- 结点析构
----------------------
--[[--

视图析构，处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end



return M
