--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BaseBox")
M.TAG       = "BaseBox"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --进场位置
    self._enterPos = ifnil(params.enterPos, cc.p(830 + X_OFFSET, 80))
    -- 移动位置
    self._movePos  = ifnil(params.movePos, cc.p(300 + X_OFFSET, 0))
    --退场位置
    self._leavePos = ifnil(params.leavePos, ccp(self._enterPos.x, -100))
    -- 手上的东西
    self._handThing = params.handThing
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    -- 进场
    self:enter()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 加载结点
function M:loadPageNode()
    local box = D.img("common/box.png"):to(self):p(self._enterPos):scale(0):bindTouch()
    self._box = box
    -- 加载瓶子
    if self._layer.loadThing then 
        self._layer:loadThing(self._box)
    end
end

-- 加载遮罩
function M:loadMask()
    -- 创建遮罩
    local mask          = U.loadNodeMask({
        contentSize     = CCSize(V.w, V.h * Y_FACTOR),
        color           = ccc3(0, 0, 0),
        swallowsTouches = true,
        isMultiTouches  = false
    }):anchor(ccp(0, 0)):p(0, 0):scale(1.15)
    :to(self._layer, 300):opacity(150)
    self._mask = mask
end

--进场
function M:enter()
    A.line({
        {"delay", 0.1},
        {"fn",function()
            -- 浮想款出现
            -- soundEffect:playEffectsfx25601010()
            -- 加载遮罩
            self:loadMask()
        end},
        {"union",{
            {"easing", "BackOut", {"scaleto", 1, 1}},
            {"easing", "BackOut", {"moveBy", 1, self._movePos}},
            -- {"scaleto", 0.5, 1},
            -- {"moveBy", 0.5, self._movePos},
            {"fn", function ()
                -- 音效[sfx05700005]
     	        soundEffect:playEffectsfx05700005()
            end}
        }},
        {"fn", function ()
            if self._layer.boxCallEvent then 
                self._layer:boxCallEvent()
            end
        end}
    }):at(self._box)
end

--退场
function M:quit()
    A.line({
        {"delay", 0.5},
        {"fn", function()
            -- 移除遮罩
            self:removeMask()
            self:unbindTouch()
            -- 浮想款消失
            -- soundEffect:playEffectsfx25601012()
        end},
        {"union",{
            {"scaleTo", 0.25, 0},
            {"easing", "BACKIN", {"moveBy", 0.5, ccp(0, 0)}},
        }},
        {"remove"}
    }):at(self._box)
end

-- 移除遮罩
function M:removeMask()
    if not tolua.isnull(self._mask) then
        self._mask:remove()
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
