--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BaseHand")
M.TAG       = "BaseHand"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --进场位置
    self._enterPos = ifnil(params.enterPos, cc.p(830 + X_OFFSET, 80))
    --退场位置
    self._leavePos = ifnil(params.leavePos, ccp(self._enterPos.x, -100))
    -- 手上的东西
    self._handThing= params.handThing
    -- 手的图片名字
    self._handImg = ifnil(params.handImg, "common/hand.png")
    -- 掌心矛点
    self._centerPos = ifnil(params.centerPos, cc.p(0.38, 0.73))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    --房子主题
    self:display(self._handImg):anchor(self._centerPos):p(self._leavePos)
    -- Tools:adjustAnchor(self)
    --进场
    -- self:enter()
end

-- 加载结点
function M:loadPageNode()
    
end

--进场
function M:enter(callBack, isSound)
    self:stopAllActions()
    self:line({
        { "moveTo", 0.2, self._enterPos},
        { "fn", function ()
            if not isSound then 
                -- 音效[sfx05701002]道具移入（复用）
     	        soundEffect:playEffectsfx05700002()
            end
            if self._handThing then
                self._handThing:line({
                    {"jumpBy", 0.2, cc.p(0, 0), 10, 1 },
                    {"jumpBy", 0.15, cc.p(0, 0), 6, 1 },
                    {"fn", function()
                        Tools:resetParent(self._handThing, self._layer, self:z() + 1)
                        self._handThing._handPos = self._handThing:worldpoint()
                        self._handThing._canTouch = true
                        if self._handThing.openGuide then
                            self._handThing:openGuide()
                        end
                        if callBack then
                            callBack()
                        end
                        self._handThing = nil
                    end }
                })
            end
        end}
    })
end

--退场
function M:quit()
    self:stopAllActions()
    self:line({
        { "moveTo", 0.2, self._leavePos },
    })
end

--获取手心中心点的位置
function M:getCenterPos()
    local anchorNum = self:anchor()
    local handPos = cc.p(self:cw() * anchorNum.x, self:cw() * anchorNum.y)
    return handPos
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
