--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("BaseMm")
M.TAG       = "BaseMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 骨骼信息
    self._file 	=  "bone/cj_mm"
    self._armatureName =  "cj_mm"
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 隐藏蝴蝶结
	self:hideBowknotL()
end

-- 隐藏蝴蝶结
function M:hideBowknotL()
	self:getBone("cmm_hdj1"):hide()
	self:getBone("cmm_hdj2"):hide()
	self:getBone("cmm_hdj3"):hide()
end

--显示蝴蝶结
function M:showBowknotL()
    self:getBone("cmm_hdj1"):show()
    self:getBone("cmm_hdj2"):show()
    self:getBone("cmm_hdj3"):show()
end

function M:hideBowknotR()
	self:getBone("cmm_hdj1_1"):hide()
	self:getBone("cmm_hdj2_1"):hide()
	self:getBone("cmm_hdj3_1"):hide()
end

function M:showBowknotR()
    self:getBone("cmm_hdj1_1"):show()
    self:getBone("cmm_hdj2_1"):show()
    self:getBone("cmm_hdj3_1"):show()
end


-- 看着爸爸
function M:lookAni()
	self:play("mm_chx2")
end

-- 妙妙开心笑
function M:smileAni()
	self:play("mm_xiao")
end

-- 呼吸
function M:breathAni()
	self:play("mm_chx")
end

-- 眯眼呼吸
function M:breathWinkAni()
    self:play("mm_chx1")
end

-- 走路
function M:walkAni()
	self:play("mm_cz")
end

-- 边看边走
function M:walkLookAni()
	self:play("mm_cz1")
end

-- 问爸爸说话（开始）
function M:talkAni1_1()
	self:play("mm_csh1")
end

-- 问爸爸说话（循环）
function M:talkAni1_2()
	self:play("mm_csh1_1")
end

-- 问爸爸说话（结束）
function M:talkAni1_3()
	self:play("mm_csh1_2")
end

-- 帮忙说话（开始）
function M:talkAni2_1()
	self:play("mm_csh2")
end

-- 帮忙说话（循环）
function M:talkAni2_2()
	self:play("mm_csh2_1")
end

-- 帮忙说话（结束）
function M:talkAni2_3()
	self:play("mm_csh2_2")
end

-- 开心说话（开始）
function M:talkAni3_1()
	self:play("mm_csh3")
end

-- 开心说话（循环）
function M:talkAni3_2()
	self:play("mm_csh3_1")
end

-- 开心说话（结束）
function M:talkAni3_3()
	self:play("mm_csh3_2")
end

-- 疑问说话 (开始)
function M:talkAni4_1()
	self:play("mm_csh4")
end

-- 疑问说话 (循环)
function M:talkAni4_2()
	self:play("mm_csh4_1")
end

-- 疑问说话 (结束)
function M:talkAni4_3()
	self:play("mm_csh4_2")
end

-- 被摸（开始）
function M:beTouched1_1()
	self:play("mm_bm1")
end

-- 被摸（循环）
function M:beTouched1_2()
    self:play("mm_bm1_1")
end

-- 被摸（结束）
function M:beTouched1_3()
    self:play("mm_bm1_2")
end

--激励
function M:excitationAni()
    self:play("mm_jl")
end

--点头
function M:nodeHeadAni()
	self:play("mm_dt")
end

--厨房说话（开始）
function M:talkKitchenAni1_1()
    self:play("mm_csh5")
end

--厨房说话（循环）
function M:talkKitchenAni1_2()
    self:play("mm_csh5_1")
end

--厨房说话（结束）
function M:talkKitchenAni1_3()
    self:play("mm_csh5_2")
end

--看着浮想框
function M:lookKitchenAni()
 	self:play("mm_chx3")
end

function M:movementHandler( __evtType, __moveId )
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
