--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("BaseMom")
M.TAG       = "BaseMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 骨骼信息
    self._file 	=  "bone/cj_qmm"
    self._armatureName =  "cj_qmm"
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 隐藏蝴蝶结
	self:hideBowknotL()
end

-- 隐藏蝴蝶结
function M:hideBowknotL()
    self:getBone("cqmm_ts"):hide()
end

-- 显示左边
function M:showBowknotL()
	self:getBone("cqmm_ts"):hide()
	self:getBone("cqmm_ts1"):show()
end

-- 显示右边
function M:showBowknotR()
	self:getBone("cqmm_ts1"):hide()
	self:getBone("cqmm_ts"):show()
end

-- 妈妈待机
function M:standbyAni()
	self:play("qmm_dj0")
end

function M:hearAni()
	self:play("qmm_csh4_1_1")
end

-- 呼吸（拿着购物袋）
function M:breathGoodsAni()
	self:play("qmm_chx2")
end

-- 回应路人招呼
function M:smile()
	self:play("qmm_chx20")
end

-- 买完之后说话（开始）
function M:afterBuyTalkAni1_1()
	self:play("qmm_csh5")
end

-- 买完之后说话（循环）
function M:afterBuyTalkAni1_2()
	self:play("qmm_csh5_1")
end

-- 买完之后说话（结束）
function M:afterBuyTalkAni1_3()
	self:play("qmm_csh5_2")
end

-- 年货对奇奇说话(开始)
function M:goodsTalkAni1_1()
	self:play("qmm_csh4")
end

-- 年货对奇奇说话(循环)
function M:goodsTalkAni1_2()
	self:play("qmm_csh4_1")
end

-- 年货对奇奇说话(结束)
function M:goodsTalkAni1_3()
	self:play("qmm_csh4_2")
end

-- 呼吸（拿着扫把）
function M:breathBroomAni()
	self:play("qmm_chx")
end

--走路拿着扫把
function M:walkBroomAni()
	self:play("qmm_cz")
end

-- 走路（拿着购物袋）
function M:walkGoods()
	self:play("qmm_zl")
end

--走路正常
function M:walkAni()
	self:play("qmm_zou1")
end

--看门
function M:watchDoorAni()
    self:play("qmm_km")
end

-- 对奇奇说话（开始）
function M:lookTalkAni1_1()
    self:play("qmm_csh1")
end

-- 对奇奇说话（循环）
function M:lookTalkAni1_2()
    self:play("qmm_csh1_1")
end

-- 对奇奇说话（结束）
function M:lookTalkAni1_3()
    self:play("qmm_csh1_2")
end

--呼吸厨房
function M:breathKitchenAni()
	self:play("qmm_chx1")
end

--呼吸厨房
function M:breathKitchenAni2()
    self:play("qmm_chx10")
end

--厨房说话（开始）
function M:talkKitchenAni1_1()
	self:play("qmm_csh2")
end

--厨房说话（循环）
function M:talkKitchenAni1_2()
	self:play("qmm_csh2_1")
end

--厨房说话（结束）
function M:talkKitchenAni1_3()
	self:play("qmm_csh2_2")
end

--厨房说话（开始）
function M:talkKitchenAni2_1()
    self:play("qmm_csh3")
end

--厨房说话（循环）
function M:talkKitchenAni2_2()
    self:play("qmm_csh3_1")
end

--厨房说话（结束）
function M:talkKitchenAni2_3()
    self:play("qmm_csh3_2")
end


--激励
function M:excitationAni()
    self:play("qmm_jl")
end

function M:movementHandler( __evtType, __moveId )
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
