--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
----------------------
-- 类
----------------------
local M    = classSpriteTouch("BaseNode")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..
----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)

    --传参数[层]
    self._layer    = params.layer
    --触控
    self._canTouch = false
    --缩放大小
    self._scaleSize = ifnil(params.scaleSize, 1)
    --进场位置
    self._pos        = ifnil(params.pos, cc.p(800, 200))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

--进场
function M:enter(callBack)
    --进入音效
    self:enterEffect()
    --进场动作
    self:enterAction(callBack)
end

--进场动作
function M:enterAction(callBack)
    self:line({
        { "easing", "backout", { "moveto", 0.5, self._pos },},
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

--进入音效
function M:enterEffect()
    -- 播放音效[sfx05700002]道具移入
    soundEffect:playEffectsfx05700002()
end

--退场
function M:quit(callBack)
	self._canTouch = false
    --退场动作
    self:quitAction(callBack)
end

--退场动作
function M:quitAction(callBack)
    self:unbindTouch():stopAllActions()
    self:line({
        {"easing","backin", { "moveby", 0.5, cc.p(V.w, 0) },},
        { "fn", function()
            if callBack then
                callBack()
            end
        end },
        -- { "remove" }
    })
end

--开始引导
function M:openGuide()
	--开始引导
	Tools:openGuide(self, self._scaleSize)
end

--停止引导
function M:stopGuide()
	--停止引导
	Tools:stopGuide(self)
end

--点击音效
function M:clickEffect()
    -- 播放音效[sfx05700001]通用点击
    soundEffect:playEffectsfx05700001()
end

-- 缩放动作
function M:scaleAction(node, size)
    node = ifnil(node, self)
    size = ifnil(size, 1.1)
    if node._stopScaleAction then
        node:stopAction(node._stopScaleAction)
        node._stopScaleAction = nil
    end
    --点击音效
    self:clickEffect()
    node._scaleAction = A.line({
        { "scaleTo", 0.1, node._scaleSize * size },
    -- { "scaleTo", 0.1, node._scaleSize },
    }):at(node)
end

-- 结束缩放动作
function M:stopScaleAction(node, callBack)
    node = ifnil(node, self)
    if node._scaleAction then
        node:stopAction(node._scaleAction)
        node._scaleAction = nil
    end

    node._stopScaleAction = A.line({
        { "scaleTo", 0.1, node._scaleSize },
        { "fn", function ()
            if callBack then
                callBack()
            end
        end}
    }):at(node)
end

--回到盘子里
function M:goBack(pos, callBack)
    local pos = ifnil(pos, self:getParent():convertToNodeSpace(cc.p(800 + X_OFFSET, 100 + Y_OFFSET)))
    self:line({
        { "union", {
            { "scaleto", 0.3, self._scaleSize },
            { "jumpto", 0.3, pos, 50, 1 },
        } },
        { "fn", function()
            if callBack then
                callBack()
            end
            self._canTouch = true
            -- 开启提示
            self:openGuide()
        end }
    })
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end




----------------------
-- 点击
----------------------
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         self._canTouch = false
    --         return true
    --     end
    -- end
    return true
end

function M:onTouchMoved(x, y, touches)
end

function M:onTouchEnded(x, y, touches)

end




----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)

end


return M
