--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 
----------------------
local M     = classSprite("BaseOkBtn")
M.TAG       = "BaseOkBtn"

----------------------
-- 公共参数
----------------------
-- [常量]
-- ..
----------------------
-- 构造方法
----------------------
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- 进入位置
    self.pos = ifnil(params.pos, cc.p(720 + X_OFFSET, V.h + 200 - Y_OFFSET / 2))
    -- 记录时间
    self.dt = 0
end




----------------------
-- 结点渲染 
----------------------
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 初始化
    self:init()
    -- 加载按钮
    self:loadBtn()
    -- 添加光效
    self:loadLight()
end

-- 初始化
function M:init()
    self:p(self.pos):rotate(90):anchor(cc.p(0.5, 1)):bindTouch()
end

-- 加载按钮
function M:loadBtn()
    local btn  = D.img("common/okbtn/btn.png"):to(self):p(5, -50)
    local tick = D.img("common/okbtn/tick.png"):to(btn):p(75, 170)
    self:bindNodeTouch(btn)
    self._btn  = btn
end

-- 添加光效
function M:loadLight()
    local light = D.img("common/light.png"):to(self, -1):p(5, -10):hide():scale(0):opacity(0)
    self._light = light
	A.cycle({
		{"rotateBy", 4, 360},
    }):at(light)
    local particle = P.newParticle("particle/dagou.plist"):to(self):p(5, -10):hide()
    particle:setPositionType(kCCPositionTypeRelative)
    particle:stopSystem()
    Tools:insertParticleTb(self, particle)
    self._particle = particle
end
----------------------
-- 功能函数
----------------------
-- 进入
function M:enter(time, callBack)
    if self.isEnter then return end
    self.isEnter = true
    time = ifnil(time, 0.5)
    A.line({
        {"delay", time},
        {"union",{
            {"easing", "elasticOut", {"rotateTo", 3, 0}},
            {"fn", function ()
                -- 音效[sfx05700003]
                soundEffect:playEffectsfx05700003()
            end},
            {"line", {
                {"delay", 0.7},
                {"fn", function ()
                    self._light:line({
                        {"show"},
                        {"union", {
                            {"easing", "backout", { "scaleTo", 0.3, 1 },},
                            {"fadeTo", 0.3, 255}
                        }}
                    })
                    self._particle:show()
                    self._particle:resetSystem()
                end}
            }}
        }},
        {"fn", function ()
            if callBack then 
                callBack()
            end
            guideFn:openGuide(self._btn, 0.1, 4)
        end}
    }):at(self)
    self:bindTouch()
end

function M:enter2()
    if self.isEnter then return end
    self.isEnter = true
    -- soundEffect:playEffectsfx24601008() 
    A.line({
        {"easing", "sinein", {"moveTo", 0.3, cc.p(self:px(), V.h + 267 - Y_OFFSET / 2)}},
        {"fn", function ()
            A.cycle({
                {"rotateTo", 1, 2},
                {"rotateTo", 1, -2},
            }):at(self)
        end}
    }):at(self)

    guideFn:openGuide(self._btn, 0.1, 4)
end

-- 退出
function M:quit(time)
    if not tolua.isnull(self._particle) then 
        self._particle:remove()
        self._particle = nil
    end
    if not self.isEnter then return end
    if self:getParent()._ui then
        self:getParent()._ui:unbindTouch()
    end
    self:stopAllActions()
    self:rotate(0)
    time = ifnil(time, 0)

 	self:line({
        {"delay", time},
        {"fn", function()
            -- soundEffect:playEffectsfx24601009() 
        end},
        {"union",{
            {"moveBy", 0.15, ccp(0, -30)},
            {"scaleTo", 0.15, 0.9 , 1.15},
        }},
        {"delay", 0.2},
        {"union",{
            {"easing", "sinein", {"moveTo", 0.2, cc.p(self:px(), V.h + 560)}},
            {"scaleto", 0.2, 1},
        }},
        {"fn", function ()
            self.isEnter = false
            if self:getParent().okNextStep then
                self:getParent():okNextStep()
            end
        end},
        {"delay", .2},
        {"remove"}
    }) 
end

function M:quit2()
    if not self.isEnter then 
        return 
    end 

    self:stopAllActions()
    self:rotate(0)

    -- soundEffect:playEffectsfx24601009()

    self:line({
        {"union",{
            {"easing", "sinein", {"moveTo", 0.3, cc.p(self:px(), V.h + 550)}},
            {"scaleto", 0.3, 1},
        }},
        {"fn", function ()
            self.isEnter = false
        end},
    }) 
end 

----------------------
-- 触控
----------------------
--按钮触控事件
function M:bindNodeTouch(btn)
    --绑定事件(父节点也需要绑定)
    self.isTouch = false
    btn:bindTouch()

    --得到self
    local this = self
    function btn:onTouchBegan(x, y, touches)
        if self.isTouch then return end
        --点击事件
        if this:getParent().okTouchEvent then
            this:getParent():okTouchEvent()
        else
            print("++++++++++++++++++++++++++++++")
        end
        -- 音效[sfx05700001]
     	soundEffect:playEffectsfx05700001()
        self.isTouch = true
        -- soundEffect:playEffectsfx24601001()
        this:quit()
        return true
    end
end

function M:onTouchBegan(x, y, touches)
    
    return true
end
----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    Tools:removeParticleTb(self)
end


return M
