--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BasePopup")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    -- 主层
    self._layer      = params.layer
    -- 触控
    self._canTouch   = false
    --回调函数
    self.callBack    = ifnil(params.callBack, nil)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    --加载背景虚化
    self:loadMask()
    -- 加载裁切
    self:loadClip()
    --加载底图
    self:loadBaseImg()
    --加载卷轴
    self:loadScroll()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("common/popup/1.png"):anchor(cc.p(0.5, 0.5)):opacity(0):z(1500)
    self:p(V.w_2 + 300, V.h + self:ch()):scale(0.2)
end

--加载背景虚化
function M:loadMask()
    local mask = U.loadNodeMask({
        contentSize = CCSize(V.w + 4, V.h + 4),
        color       = COLOR3_BLACK,
        opacity     = 0,
    }):to(self._layer, 1000):p(V.w_2, V.h_2)

    self._mask = mask
end

--加载裁切
function M:loadClip()
    local clipImg = D.img("common/popup/1.png"):p(0, 0):scaleX(0.08)
    self._clipImg = clipImg
    local clip    = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):p(self:cw() / 2, self:ch() / 2)
    self:addChild(clip, -1)
    -- 设置裁剪区域的显示，false为显示裁剪的区域，true为裁剪后的区域(很关键)
    clip:setInverted(false)
    clip:setAlphaThreshold(0)
    self._clip = clip:bindTouch()
end

--加载底图
function M:loadBaseImg()
    local base = D.img("common/popup/1.png"):to(self._clip):bindTouch()
    self._base = base
end

--加载卷轴
function M:loadScroll()
    local posTb = {cc.p(self:cw() / 2 - 2, self:ch() / 2), cc.p(self:cw() / 2 + 2, self:ch() / 2)}
    local scrollL = D.img("common/popup/2.png"):to(self, -1):p(posTb[1]):anchor(ccp(1, 0.5))
    local scrollR = D.img("common/popup/2.png"):to(self, -1):p(posTb[2]):anchor(ccp(0, 0.5))
    scrollL._pos  = posTb[1]
    scrollR._pos  = posTb[2]
    self._scrollL = scrollL
    self._scrollR = scrollR
end


--------------------------
-- 方法
-------------------------- 
--进场
function M:enter()
    self._mask:line({
        { "fadeTo", 0.5, 200 },
        { "fn", function()

        end },
    })
    -- 播放音效[sfx05700006]弹窗（卷轴）
    soundEffect:playEffectsfx05700006()
    local size = 1
    self:line({
        { "union", {
            { "jumpto", 0.4, cc.p(V.w_2 + 300, V.h_2 - 100), 100, 1 },
            { "rotateby", 0.4, -15 },
            { "scaleto", 0.4, size * 0.7}
        } },
        { "union", {
            { "moveby", 0.2, cc.p(0, 150) },
            { "scaleTo", 0.2, size * 1.1, size * 0.6 },
            { "rotateBy", 0.2, 5 }
        } },
        { "scaleTo", 0.1, size * 1.1, size * 0.8 },
        { "union", {
            { "jumpTo", 0.35, cc.p(V.w_2, V.h_2), 50, 1 },
            { "rotateBy", 0.35, 360 + 10 },
            { "scaleTo", 0.35, 1 }
        } },
        { "fn", function()
            --卷轴打开
            self:scrollOpen()
        end }
    })
end


--卷轴打开
function M:scrollOpen()
    local time = 0.5
    local time2 = time --+ 0.1

    self._scrollL:line({
        { "moveto", time2, cc.p(20, self:ch() / 2) }
    })
    self._scrollR:line({
        { "moveto", time2, cc.p(690, self:ch() / 2) }
    })

    self._clipImg:line({
        { "scaleTo", time, 1 },
        { "fn", function ()
            self:line({
                { "scaleto", 0.15, 1.1, 0.9 },
                { "easing", "backout", { "scaleto", 0.3, 1 } },
                { "fn", function ()
                    --进场动作
                    self:enterAction()
                    self._canTouch = true
                end}
            })
        end}
    })
end

--进场动作
function M:enterAction()
    
end

--退场
function M:quit(callBack)
    if self._quit then return end
    self._quit = true
    self._canTouch = false
    Tools:closeAd(false,false)
    -- 播放音效[sfx05700012]卷轴合闭收起
    soundEffect:playEffectsfx05700012()
    self:line({
        { "scaleTo", 0.2, 1.1, 0.8 },
        { "fn", function()
            --卷轴关闭
            self:scrollClose(callBack)
        end },
        { "scaleTo", 0.1, 1 },
    })
end

--卷轴关闭
function M:scrollClose(callBack)
    local time = 0.5
    local time2 = time --+ 0.1

    self._scrollL:line({
        { "moveto", time2, self._scrollL._pos }
    })
    self._scrollR:line({
        { "moveto", time2, self._scrollR._pos }
    })

    self._clipImg:line({
        { "scaleTo", time, 0.08, 1 },
        { "fn", function()
            self._mask:line({
                { "fadeTo", 0.3, 0 },
                { "remove"}
            })
            self:line({
                {"union",{
                    { "rotateBy", 0.5, 360 },
                    { "scaleto", 0.5, 0 },
                }},
                { "hide",},
                { "fn", function()
                    Tools:openAd(true)
                    if self.callBack then
                        self.callBack()
                    end
                    if callBack then
                        callBack()
                    end
                end },
                {"remove",}
            })
        end }
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
  -- [超类调用]
  M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end


----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
