--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BaseProgress")
M.TAG       = "BaseProgress"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer       = params.layer-- 父场景
    self._baseImg     = params.baseImg or "common/progress/base.png"
    -- 进度时间
    self._time        = ifnil(params.time, 3.5)
    -- 百分比  
    self._rate        = 0    
    --缩放大小
    self._scaleSize   = params.scaleSize or 1
    --进度条信息
    self._info        = params.info or {
        imgName       = "common/progress/progress.png",
        mode          = kCCProgressTimerTypeBar,
        midpoint      = ccp(0, 0),
        barChangeRate = ccp(0, 1),
        isAutoRun     = false
    }
    self._offset = ifnil(params.offset, cc.p(0.5, 1.8))
    --进场位置
    self._pos         = ifnil(params.pos, cc.p(800 + X_OFFSET, 250))
    --退场位置
    self._quitDir    = ifnil(params.quitDir, "right")
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    --加载进度条
    self:loadProgressBar()
    --加载其他
    self:loadOther()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

--加载其他
function M:loadOther()
    print("未被重写")
end

-- 图片渲染
function M:loadDisplay()
    self:display(self._baseImg)
    -- local base = D.img("common/progress/base.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2)
end

--进度栏进场
function M:enter(callback)
    if self._enter then return end
    self._enter = true
    -- self:line({
    --     { "show" },
    --     { "easing", "backout", { "scaleTo", 0.5, self._scaleSize } },
    --     { "fn", function()
    --         if callback then
    --             callback()
    --         end
    --     end }
    -- })
    A.line({
        { "easing", "backout", { "moveto", 0.5, self._pos }, },
        { "fn", function()
            self:enterEvent()
            if callback then
                callback()
            end
        end }
    }):at(self)
end

function M:enterEvent()

end

--进度消失
function M:quit(callback)
    if not self._enter then
        return
    end
    self._enter = false
    self:stopAllActions()
    -- self:line({
    --     { "easing", "backin", { "scaleTo", 0.5, 0, self._scaleSize } },
    --     { "fn", function()
    --         if callback then
    --             callback()
    --         end
    --     end }
    -- })
    local pos = self._quitDir == "left" and cc.p(-self:cw(), self:py()) or cc.p(V.w + self:cw(), self:py())
    A.line({
        { "easing", "backin", { "moveto", 0.5,  pos},},
        { "fn", function()
            if callback then
                callback()
            end
        end }
    }):at(self)
end

--加载进度条
function M:loadProgressBar()
    self._progressBar = U.loadProgressBar(self._info):p(self:cw() / 2 + self._offset.x, self:ch() / 2 + self._offset.y):to(self)

    -- -------------------------------------------------
    -- --用于定位粒子
    -- local stencil2 = D.img(self._info.imgName)
    -- self._stencil2 = stencil2
    -- stencil2:setPosition(cc.p(self._progressBar:cw() / 2, 0)):to(self._progressBar, 101):anchor(cc.p(0.5, 1))--:opacity(0)

    self:loadParticle()
end

function M:loadParticle()
    -- -- 加载进度粒子
    local paricle = P.newParticle("particle/jindutiaolizi.plist")
    :to(self._progressBar, 200):p(self._progressBar:cw() / 2, 0):bindTouch():hide()
    Tools:insertParticleTb(self, paricle)
    self._particle = paricle
end

--粒子显示
function M:particleShow()
    if self._particleShow then return end
    self._particleShow = true
    self._particle:show()
    --粒子移动
    self:updateParticle()
end

--粒子移动
function M:updateParticle()
    self:cycle({
        {"delay", 1/60},
        {"fn", function ()
            --获取进度
            local pencent = self:getPencent()
            local rate = pencent / 100
            local y = self._progressBar:ch() * rate
            self._particle:py(y + 1)
        end}
    })
end

--以时间来判断进度条移动
function M:initAction()
    self._progressBar:runAction(CCRepeatForever:create(CCProgressTo:create(self._time, 100)))
    self._progressBar:pause()
end

--开始进度条
function M:start()
    self._progressBar:resume()
    self._stencil2:resume()
end

--停止进度条
function M:stop()
    self._progressBar:pause()
    self._stencil2:pause()
end

--按照百分比
function M:setPercent(rate)
    self._progressBar:setPercentage(rate)
    if self._rate >= 100 then

    end
end

--获取进度
function M:getPencent()
    return self._progressBar:getPercentage()
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if self._particle  and not tolua.isnull(self._particle) then
        self._particle:remove()
        self._particle = nil
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
