--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("BaseQq")
M.TAG       = "BaseQq"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 骨骼信息
    self._file 	=  "bone/cj_qq"
    self._armatureName =  "cj_qq"
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)

end


-- 正面呼吸
function M:breatheFrontAni()
	self:play("qq_hx2")
end

-- 正面走
function M:walkFrontAni()
	self:play("qq_zou1")
end

-- 奇奇待机
function M:standbyAni()
	self:play("qq_dj0")
end

-- 打招呼(开始)
function M:helloAni1_1()
	self:play("qq_zs1")
end

-- 打招呼（循环）
function M:helloAni1_2()
	self:play("qq_zs1_1")
end

-- 打招呼（循环）
function M:helloAni1_3()
	self:play("qq_zs1_2")
end

-- 打招呼（结束）
function M:helloAni1_4()
	self:play("qq_zs1_3")
end

-- 微笑眼呼吸
function M:smile()
	self:play("qq_hx40")
end

-- 问爸爸在干嘛说话（开始）
function M:askTalkAni1_1()
	self:play("qq_csh3")
end

-- 问爸爸在干嘛说话（循环）
function M:askTalkAni1_2()
	self:play("qq_csh3_1")
end

-- 问爸爸在干嘛说话（结束）
function M:askTalkAni1_3()
	self:play("qq_csh3_2")
end

-- 拍胸脯说(开始)
function M:clapTalkAni1_1()
	self:play("qq_csh2")
end

-- 拍胸脯说(循环)
function M:clapTalkAni1_2()
	self:play("qq_csh2_1")
end

-- 拍胸脯说（结束）
function M:clapTalkAni1_3()
	self:play("qq_csh2_2")
end

-- 听妈妈说话(开始)
function M:hearAni1_1()
	self:play("qq_yh1")
end

-- 听妈妈说话(循环)
function M:hearAni1_2()
	self:play("qq_yh1_1")
end

-- 跳跃说话(开始)
function M:jumpTalkAni1_1()
	self:play("qq_tys1")
end

-- 跳跃说话(循环)
function M:jumpTalkAni1_2()
	self:play("qq_tys1_1")
end

-- 跳跃说话(结束)
function M:jumpTalkAni1_3()
	self:play("qq_tys1_2")
end

-- 呼吸
function M:breathAni()
	self:play("qq_hx")
end

--呼吸
function M:breathAni2()
	self:play("qq_hx0")
end

--呼吸（年货）
function M:breathAni4()
	self:play("qq_hx4")
end

--走路（年货）
function M:walkGoodsAni()
	self:play("qq_zl")
end

--走路（年货边做边看）
function M:walkSeeAni()
	self:play("qq_zl1")
end

--走路
function M:walkAni()
	self:play("qq_cz")
end

--看门
function M:watchDoorAni()
	self:play("qq_km")
end

-- 看妈妈说话（开始）
function M:lookTalkAni1_1()
	self:play("qq_csh1")
end

-- 看妈妈说话（循环）
function M:lookTalkAni1_2()
	self:play("qq_csh1_2")
end

-- 看妈妈说话（结束）
function M:lookTalkAni1_3()
	self:play("qq_csh1_3")
end

--激励
function M:excitationAni()
	self:play("qq_jl")
end

function M:movementHandler( __evtType, __moveId )
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
