--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("ThinkBox")
M.TAG       = "ThinkBox"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --id
    self._id       = ifnil(params.id, 1)
    --大小
    self._scaleSize= ifnil(params.scaleSize, 1)
    --位置
    self._pos      = ifnil(params.pos, cc.p(100,100))
    --需要呼吸
    self._needBreath = ifnil(params.needBreath, true)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    local anchorNum = self._id == 1 and cc.p(0.98, 0.09) or cc.p(0.44, 0.02)
    self:display("common/thinkbox/"..self._id..".png"):anchor(anchorNum):scale(0):hide()
end

-- 加载结点
function M:loadPageNode()
    
end

--进场
function M:enter(callBack)
    self:line({
        { "show"},
        { "easing", "backout", { "scaleTo", 0.5, self._scaleSize } },
        { "fn", function()
            if self._needBreath then
                --呼吸动作
                self:breathAct()
            end
            --进场动作
            self:enterAction()
            self._canTouch = true
        end }

    })
end

--音频
function M:enterEffect()
    -- 播放音效[sfx05700009]浮想框出现
    soundEffect:playEffectsfx05700009()
end

--进场动作
function M:enterAction()
    
end

-- 浮想框引导
function M:openGuide()
    if self._guideAct then return end
    local size = self._scaleSize
    --停止呼吸动作
    self:stopBreathAct()
    self._guideAct = A.line({
        {"fn", function ()
            -- 播放音效[sfx05700004]缩放提示
            soundEffect:playEffectsfx05700004()
        end},
        {"cycle", {
            { "fn", function()

            end },
            { "scaleTo", 0.1, size * 1.1, size * 0.9 },
            { "scaleTo", 0.1, size * 0.9, size * 1.1 },
            { "scaleTo", 0.2, size * 1.1, size * 1 },
            { "scaleTo", 0.2, size * 1, size * 1.1 },
            { "scaleTo", 0.2, size * 1 },
        },2},
        {"fn", function ()
            --关闭引导
            self:closeGuide()
            --呼吸动作
            self:breathAct()
        end},
    }):at(self)
end

--关闭引导
function M:closeGuide()
    if self._guideAct then
        self:stopAction(self._guideAct)
        self._guideAct = nil
    end
end

--呼吸动作
function M:breathAct()
    if self._breathAct then return end
    local offset = math.random(5, 8)
    self._breathAct = A.cycle({
        {"union", {
            { "moveto", 1, cc.p(self._pos.x, self._pos.y + offset) },
            { "scaleto", 1, self._scaleSize * 1.1 },
        }},
        { "union", {
            { "moveto", 1, cc.p(self._pos.x, self._pos.y - offset) },
            { "scaleto", 1, self._scaleSize},
        } },
    }):at(self)
end

--停止呼吸动作
function M:stopBreathAct()
    if self._breathAct then
        self:stopAction(self._breathAct)
        self._breathAct = nil
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
