--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BaseWindow")
M.TAG       = "BaseWindow"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --烟花
    self._fireworkTb = {}
    --窗户Id
    self._id    = ifnil(params.id, 1)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("common/win/win"..self._id.."/base.png")
    local pos = self._id == 1 and cc.p(179.1 - 5, 135.1) or cc.p(159.1, 145.1)
    local size = self._id == 1 and 1 or 1.15
    local bg = D.img("common/win/win"..self._id.."/bg.png"):to(self, -5):p(pos):scale(size):bindTouch()
    self._bg = bg
end

-- 加载结点
function M:loadPageNode()
    --加载裁切
    self:loadClip()
    --加载树
    self:loadTree()
    --加载窗帘
    self:loadUp()
    --加载灯笼
    self:loadLantern()
    --加载云
    self:loadCloud()
    --加载烟花
    self:loadFireworks()
end

--加载裁切
function M:loadClip()
    local clipImg = D.img("common/win/win"..self._id.."/bg.png"):p(0, 0)--:scaleX(0.08)
    local clip    = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):p(self._bg:cw() / 2, self._bg:ch() / 2):bindTouch()
    self._bg:addChild(clip, 1)
    -- 设置裁剪区域的显示，false为显示裁剪的区域，true为裁剪后的区域(很关键)
    clip:setInverted(false)
    clip:setAlphaThreshold(0)
    self._clip = clip
end

--加载树
function M:loadTree()
    local posTb = self._id == 1 and {cc.p(-134.3, -123.1), cc.p(-126.3, -155.0),} or { cc.p(-104.3, -23.1), cc.p(-155.3, -75),}
    local tree1 = D.img("common/win/win"..self._id.."/tree1.png"):to(self._clip, 10):p(posTb[1]):anchor(cc.p(0.3, 0.1))
    commonAct:breathing(tree1)
    local tree2 = D.img("common/win/win"..self._id.."/tree2.png"):to(self._clip, 10):p(posTb[2]):anchor(cc.p(0, 0.05))
    commonAct:breathing(tree2)
end

--加载窗帘
function M:loadUp()
    if self._id == 2 then return end
    local up1 = D.img("common/win/win1/up.png"):to(self):p(87.8, 275.7):anchor(cc.p(0.5, 1))
    commonAct:breathing2(up1)
    local up2 = D.img("common/win/win1/up.png"):to(self):p(272, 275.7):anchor(cc.p(0.5, 1))
    commonAct:breathing2(up2)
end

--加载灯笼
function M:loadLantern()
    local posTb = {cc.p(61.1, 16.4),cc.p(-47.3, 18.0),cc.p(76.2, -38.4),cc.p(115, -2.8),cc.p(-64.9, -33.6),}
    local idTb  = {1, 2, 3, 3, 2}
    for i, v in ipairs(posTb) do
        local lantern = D.img("common/win/lantern/"..idTb[i]..".png"):to(self._clip, 5):p(v)
        --灯笼运动
        self:lanternAct(lantern)
    end
end

--灯笼运动
function M:lanternAct(lantern)
    local time = math.random(150, 200) / 100
    lantern:cycle({
        { "moveBY", time, cc.p(0, 10) },
        { "moveBY", time, cc.p(0, -10) },
        { "moveBY", time, cc.p(0, 10) },
        { "moveBY", time, cc.p(0, -10) },
    })
end

--加载云
function M:loadCloud()
    local posTb = { cc.p(61.1, 16.4), cc.p(-47.3, 18), cc.p(76.2, -38.4), }
    for i, v in ipairs(posTb) do
        local pos1 = cc.p(v.x, v.y + math.random(-50, 50))
        local cloud = D.img("common/win/cloud/" .. math.random(1, 2) .. ".png"):to(self._clip, 1):p(pos1)
        cloud._pos = pos1
        --云朵移动
        self:cloudMoveAct(cloud, 1)

        local pos2 = cc.p(v.x + 200, v.y + math.random(-50, 50))
        local cloud = D.img("common/win/cloud/" .. math.random(1, 2) .. ".png"):to(self._clip, 1):p(pos2)
        cloud._pos = pos2
        --云朵移动
        self:cloudMoveAct(cloud, 2)
    end
end

--云朵移动
function M:cloudMoveAct(cloud, type)
    local time = math.random(200, 250) / 10
    if type == 1 then
        cloud:line({
            { "moveby", time/3, cc.p(-250, 0) },
            { "fn", function()
                cloud:p(cloud._pos.x + 200, cloud._pos.y)
                self:cloudMoveAct(cloud, 2)
            end }
        })
    else
        cloud:cycle({
            { "moveby", time, cc.p(-750, 0) },
            { "fn", function()
                cloud:p(cloud._pos.x + 200, cloud._pos.y)
            end }
        })
    end

end

--加载烟花
function M:loadFireworks()
    local posTb = { cc.p(61.1, 16.4), cc.p(-47.3, 18), cc.p(76.2, -65.4), cc.p(-62.3, -58.2),} 
    for i, v in ipairs(posTb) do
        local fireworks = D.img("common/win/"..i.."/"..i.."_1.png"):to(self._clip, 1):p(v):scale(1.7)
        fireworks._id = i
        table.insert(self._fireworkTb, fireworks)
    end
    --烟花绽放
    self:fireworksRound()
end

--烟花动作
function M:fireworksAct(fireworks)
    fireworks:line({
        { "image", "common/win/"..fireworks._id.."/"..fireworks._id.."_", 15, 1 / 22 }
    })
end

--烟花绽放
function M:fireworksRound()
    self:cycle({
        {"fn", function ()
            for i, v in ipairs(self._fireworkTb) do
                v:line({
                    { "Delay", (i - 1) * 0.3 },
                    { "fn", function()
                        self:fireworksAct(v)
                    end }
                })
            end
        end},
        {"Delay", 2},
    })
end

--加载其他
function M:loadOther()
    
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
