--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------

local M     = classSpriteTouch("ScrollUi")
M.TAG       = "ScrollUi"

----------------------
-- 公共参数
----------------------

-- [常量]
-- ..

-- [操作变量]
-- ..

----------------------
-- 构造方法
----------------------

--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]

function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params)
	-- 图片路径
	self._picPath 		= params.picPath
	-- 主场景
	self._layer 		= params.layer
	-- 坐标
    self._pos         	= ifnil(params.pos, cc.p(0, 0))
    --进场位置
    self._enterPos      = ifnil(params.enterPos, cc.p(875 + X_OFFSET, 250 + Y_OFFSET))
	-- 缩放系数
	self._scaleNum  	= ifnil(params.scaleNum, 1)
	-- 父类
	self._parent      	= ifnil(params.parent, self._layer)
	-- 在父类上的层级
    self._zOrder      	= ifnil(params.zOrder, 0)    
    -- 是否允许滚动
    self._arrowScroll   = ifnil(params.arrowScroll, true)
    -- 滚动栏内显示个数
    self._showNumber    = ifnil(params.showNumber, 3)
    --自动进场
    self._autoEnter     = ifnil(params.autoEnter, true)
end

----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]

function M:onRender()
    -- [超类调用]
	M.super.onRender(self)
	-- 加载图片
    self:loadPicture()
    -- 加载clipingNode
    self:loadClipingNode()
    -- 加载滚动栏
    self:loadScrollView()
    -- 加载粒子
    -- self:loadParticle()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    if self._autoEnter then
        -- 入场动作
        self:enter()
    end
end

----------------------
-- 加载
----------------------

-- 加载图片
function M:loadPicture()
    self:display(self._picPath)
        :p(self._pos):scale(self._scaleNum)
end

-- 加载clipingNode
function M:loadClipingNode()
    local node = D.img("common/ui/mask.png")
        :p(self:cw()/2, self:ch()/2 + 0.6):scaleY(0.977)
    local mclip = CCNodeExtend.extend(CCClippingNode:create(node))
    mclip:setInverted(false)
    mclip:setAlphaThreshold(0)
    self:addChild(mclip, 1000)
    self._mclip = mclip
    self._mclip:bindTouch()
end

-- 加载滚动栏
function M:loadScrollView()
    local sprite     = require("app.common.node.ScrollView")
    local scrollView = sprite.new({
        layer           = self._layer,
        uiBar           = self,
        pos             = ccp(self:cw() * 0.5, self:ch() * 0.5),
        arrowScroll     = self._arrowScroll,
        showNumber      = self._showNumber,
        showRatio       = 0.80
    }):to(self._mclip)
    self._scrollView = scrollView
end

-- 入场动作
function M:enter(callBack)
    A.line({
        {"delay", 0.5},
        -- 出场动作
        {"union", {
            {"easing", "BACKOUT", {"moveto", 0.5, self._enterPos}},
            {"fn", function()
                -- 音效[sfx05703007]
                 soundEffect:playEffectsfx05703007()
                 if callBack then
                    callBack()
                end
            end}
        }}
    }):at(self)
end

-- 退场动作
function M:quit(callBack)
    A.line({
        {"easing", "BACKIN", {"moveTo", 0.3, self._pos}},
        {"fn", function ()
            if callBack then
                callBack()
            end
        end}
        -- {"remove"},
    }):at(self)
end


-- 加载粒子
function M:loadParticle()
    local particle = P.newParticle("particle/uilantw.plist"):to(self, 100):p(10, 380)
    Tools:insertParticleTb(self, particle)
    particle:cycle({
        {"moveTo", 0.3, cc.p(182.0, 380)},
        {"moveTo", 0.6, cc.p(182.0, 10)},
        {"moveTo", 0.3, cc.p(10, 10)},
        {"moveTo", 0.6, cc.p(10, 380)},
    })
end

----------------------
-- 结点析构
----------------------

function M:onDestructor()
  	-- [超类调用]
  	M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------

--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]

function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end

----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]

function M:onTouchHandled(event, x, y)

end

----------------------
-- 验证
----------------------

-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end

return M
