--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[--

	主控制层

]]

----------------------
-- 类
----------------------
local ScrollView = require("app.common.node.ScrollUiEx")
local M = classSpriteTouch("ScrollViewEx")
-- M.TAG = "ScrollViewEx"
----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..



M.DIRECTION_VERTICAL   = 1
M.DIRECTION_HORIZONTAL = 2

----------------------
-- 构造方法
----------------------
function M:ctor(params)
	-- params.swallowsTouches  = true
	self.params = params
	self.layer  = params.layer
	self.arrowOffset = params.arrowOffset or 10
	self.isTouchScrollView = false
	self.items 	= {} --or params.items
	self.arrows = {}
	self._bgImgName 				= "tfgoodswalk/ui/ui/uiBar.png" 		-- 背景图片路径
	self._arrowImgName 				= "tfgoodswalk/ui/ui/btnup.png"		-- 箭头图片路径
	-- 是否可以点击
	self.canClick = ifnil(params.canClick, true)
	-- 只能点击一次
	self.isClick  = true
end








----------------------
-- 触控事件
----------------------
function M:onTouchBegan(x, y, touches)
	NV.spriteCppCrashPath(D.getRunningScene().name.."-ScrollViewEx-began")
	local locateP = self.scrollView:convertToNodeSpace(ccp(x, y))
	if cc.rectContainsPoint(self.scrollView.touchRect, locateP) then
		self.isTouchScrollView = true
		self.scrollView:onTouchBegan(x, y, touches)
	end
	self:arrowHandler(x, y)
	return SIGN_TOUCH_BEGAN_SWALLOWS
end

function M:onTouchMoved(x, y, touches)
	if self.isTouchScrollView then
		self.scrollView:onTouchMoved(x, y, touches)
	end
end

function M:onTouchEnded(x, y, touches)
	NV.spriteCppCrashPath(D.getRunningScene().name.."-ScrollViewEx-end")
	if self.isTouchScrollView then
		self.scrollView:onTouchEnded(x, y, touches)
		self.isTouchScrollView = false
	end
end








----------------------
-- 结点渲染
----------------------
function M:onRender()
	-- 加载滚屏背景
    self:loadBg()
    -- 加载滚屏
	self:loadScrollView()
	-- 加载箭头
	self:loadArrows()
	-- 箭头显示控制
	self:arrowControl(1)
	-- 添加物品
	self:loadItem()
end

function M:loadItem()
	if self.layer.addItems then
		T.clear(self.items)
		self.layer:addItems() 
	end
end

-- 加载背景
function M:loadBg()
	local bar = D.img(self._bgImgName)
	local size = bar:getContentSize()

	bar:to(self, -1):p(size.width * 0.5, size.height * 0.5)
	self:setContentSize(size)
end

-- 加载滚屏
function M:loadScrollView()
	local size = self:getContentSize()
	local touchRect = self.params.rect
	local centerX = (size.width - touchRect.width) * 0.5
	local centerY = (size.height - touchRect.height) * 0.5

	local ScrollView = import("app.common.node.ScrollUiEx")
	local scrollView = ScrollView.new(self.params)
	CCNodeExtend.extend(scrollView)
	scrollView:to(self):p(centerX, centerY)

	scrollView:addEventListener("ScrollView", handler(self, self.scrollListener))

	self.scrollView = scrollView
end

-- 加载箭头
function M:loadArrows()
	local size = self:getContentSize()
	self.arrows["arrowU"] = self:loadArrow(-1, ccp(size.width * 0.5, size.height - self.arrowOffset))
	self.arrows["arrowD"] = self:loadArrow(1, ccp(size.width * 0.5, self.arrowOffset))
end

-- 加载箭头
function M:loadArrow(dir, pos)
	local arrow = D.img(self._arrowImgName):to(self):p(pos)
	arrow.dir = dir
	arrow:setFlipY(dir == 1)
	return arrow
end


----------------------
-- 逻辑处理
----------------------
-- 滚屏的监听函数
function M:scrollListener(args)
	local event = string.upper(args.event)
	local target = args.target
	local data = args.data
	if event == "TAP" then
		self:tapHandler(target, data)
	elseif event == "SCROLLTOITEM" then
		self:scrollHandler(target, data)
	end
end

-- 滚动处理函数
function M:scrollHandler(target, data)
	local curIndex = self.scrollView:getCurrentIndex()
	self:arrowControl(curIndex)
end

-- 点击的处理函数
function M:tapHandler(target, data)
	-- print(self.canClick, self.isClick)
	if not self.canClick then return end
	if not self.isClick then return end
	self.isClick = false
	local touchP = data.touchP
	for i, v in ipairs(self.items) do
		local rect = v:getCascadeBoundingBox()
		if not IS_BUYTB[i] then 
			if cc.rectContainsPoint(v:getCascadeBoundingBox(), touchP) then
				v:onTouchEvent(touchP.x, touchP.y)
				break
			else
				self.isClick = true
			end
		else
			self.isClick = true
		end
	end
end


-- 点击箭头的处理函数
function M:arrowHandler(x, y)
	local touchP = ccp(x, y)
	local locateP = self:convertToNodeSpace(touchP)
	for _, arrow in pairs(self.arrows) do
		if cc.rectContainsPoint(arrow:getBoundingBox(), locateP) then
			-- 音效[sfx05700004]
			soundEffect:playEffectsfx05700001()
			A.line({
				{"scaleTo", 0.1, 1.2},
				{"fn", function()
					self:scrollToNext(arrow.dir, true)
				end},
				{"scaleTo", 0.05, 1.0},
			}):at(arrow)
		end
	end
end

-- 添加物件
function M:addItem(item)
	table.insert(self.items, item)
	self.scrollView:addItem(item)
	self:demandArrows()
end

-- 排列物品
function M:reorderAllItems(orders)
	local itemsBuy = {}
	local itemsNotBuy = {}
	orders = orders or {}

	-- 物品分类
	for i = #self.items, 1, -1 do
		local item = table.remove(self.items, i)
		if item:getState() == "STATE_BUY" then
			table.insert(itemsBuy, item)
		else
			table.insert(itemsNotBuy, item)
		end
	end
	-- 物品排序
	self:sortItems(itemsNotBuy, orders)
	self:sortItems(itemsBuy, orders)
	-- 排序后的物品整合
	for _, item in ipairs(itemsBuy) do
		table.insert(itemsNotBuy, item)
	end
	-- 重新排序
	self.scrollView:setItems(itemsNotBuy)
	self.scrollView:reorderAllItems()
	self.items = itemsNotBuy
end

-- 排序物品
function M:sortItems(items, orders)
	local curIndex = 0
	for _, itemType in ipairs(orders) do
		for i, item in ipairs(items) do
			if item:getType() == itemType then
				curIndex = curIndex + 1
				table.remove(items, i)
				table.insert(items, curIndex, item)
			end
		end
	end
end

function M:scrollToNext(dir, animated, time, easing)
	local curIndex = self.scrollView:getCurrentIndex()
	local newIndex = curIndex + dir 
	self:scrollToItem(newIndex, animated, time, easing)
end

-- 滚动物件
function M:scrollToItem(index, animated, time, easing)
	self.scrollView:scrollToItem(index, animated, time, easing)
end

-- 改变物品显示
function M:chagneShows(index, isWalk)
	isWalk = isWalk or false
	self.items[index]:color(ccc3(80, 80, 80))
	self.items[index]._bg:color(ccc3(80, 80, 80))
	local pos = ccp(self.items[index]:cw()/2, self.items[index]:ch()/2)
	local tick = D.img("tfgoodswalk/ui/ui/tick.png"):to(self.items[index]):p(pos):scale(0):opacity(0)
	if isWalk then 
		tick:scale(1):opacity(255)
	else
		A.line({
			{"union",{
				{"scaleTo", 0.2, 1},
				{"fadein", 0.2},
			}},
			{"fn", function ()
				commonAct:nodeScale(tick, 0.5, 0.5)
				A.line({
					{"scaleTo", 0.1, 1.1},
					{"scaleTo", 0.1, 1},
				}):at(self.items[index])
			end}
		}):at(tick)
	end
end

-- 在指定位置添加物件
function M:insertItemAtIndex(item, index)
    table.insert(self.items, index, item)
    self:reorderAllItems()
end

-- 箭头显示控制
function M:arrowControl(index)
	local itemNum = self.scrollView:getItemNum()

	if #self.items <= 3 then
		return
	end

	for _, arrow in pairs(self.arrows) do
		arrow:setVisible(true)
	end

	if index <= 1 then
		self.arrows["arrowU"]:enableTouch(false)
	elseif index >= itemNum - 2 then
		self.arrows["arrowD"]:enableTouch(false)
	end
end


--小于3项，箭头隐藏
function M:demandArrows()
	local visble = true
	if #self.items <= 3 then
		visble = false
	end

	for _, arrow in pairs(self.arrows) do
		arrow:setVisible(visble)
	end
end





----------------------
-- 结点析构
----------------------
function M:onDestructor()
    
end



return M
