--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..

local DragonBone = bb.si.DragonBone






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- 播放速度
    self._speed             = nil
    -- 骨骼索引
    self._armatureIndex     = 1
    -- 是否循环
    self._isLoop            = 0
    -- 文件路径集合
    self._pathTable         = {}
    -- 骨骼名集合
    self._armatureNameTable = {}
    -- 动作集合
    self._movNameTable      = {}
    -- 骨头名集合
    self._boneTab           = {}
    self._actionPreTab      = {}
    self._actionPreIndex    = 1
    self._actionTextTab     = {}
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 获取指定目录下的所有文件
    self:getAllFileWithSpecifiedPath()
    -- 加载背景
    self:loadBackground()
    -- 读取文件
    self:readFileAndInsertMovLineInTable()
    -- 加载骨骼ui
    self:loadUIListView(0)
    -- 加载骨骼范围遮罩
    self:loadDragonBoneMask()

    -- 加载文本
    self:loadTexts()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
    -- 连贯动作
    self:loadActionsBtn()
    -- 加载按钮
    self:loadLoopButton()
    self:setCurrentItem(1)
end

-- 加载文字
function M:loadText(text, partent, position, dimensions)
    fontSize = fontSize or 20
    color = color or ccc3(255, 255, 255)
    -- 文字
    local lb = U.loadLabelTTF({ 
        text        = text,
        fontSize    = fontSize, 
        color       = color,
        position    = position,
        dimensions  = dimensions
    }):to(partent)
    return lb
end

-- 清除显示动作列表
function M:clearActionTextTab()
    T.clear(self._actionPreTab)
    for i, item in ipairs(self._actionTextTab) do
        if item and not tolua.isnull(item) then
            item:remove()
        end
    end
    self._actionPreIndex = 1
    self._startPreview = false
    T.clear(self._actionTextTab)
end

-- 加载按钮
function M:loadButton(labelName,pos,callback)
    local node = CCNodeExtend.extend(display.newRoundedRect(cc.size(100, 50), 10, {
        fillColor = cc.c4f(0.22,0.22,0.22,0.47),
        borderColor = cc.c4f(0.784,0.784,0.784,0.47),
        borderWidth = 2
    })):p(pos):to(self,10000)
    node.label = self:loadText(labelName, node, cc.p(50,25))
    node:bindTouch()
    node.callback = callback
    function node:onTouchBegan(x, y, touches)
        self:scale(1.1)
        return SIGN_TOUCH_BEGAN_SWALLOWS 
    end
    function node:onTouchEnded(x, y, touches)
        self:scale(1)
        if self.callback then
            self.callback()
        end
    end
    return node
end

-- 连贯动作
function M:loadActionsBtn()
    self:loadButton("连贯动作",cc.p(460, V.h - 40),function ()
        if tolua.isnull(self._previewMask) then
            self._preview = true
            T.clear(self._actionPreTab)
            -- 加载预览遮罩
            self:loadPreviewMask()
        else
            self._preview = false
            self._previewMask:remove()
            self._previewMask = nil
        end
    end)
end

-- 加载循环按钮
function M:loadLoopButton()
    local labelTable = {"默认","循环","不循环"}
    self._isLoop = 0
    self.loopButton = self:loadButton("默认",cc.p(V.w-65, V.h - 40),function ()
        self._isLoop = (self._isLoop+1)%3
        self.loopButton.label:setString(labelTable[self._isLoop+1]) 
    end)
end

-- 加载连贯动作遮罩
function M:loadPreviewMask()
    if self._previewMask or not self._actionUi then return end
    -- 清除数据
    self:clearActionTextTab()
    local previewMask = self:createNode("PreviewMask",{
        layer = self
    }):p(cc.p(V.w_2+190, 150)):to(self, 100):bindTouchLocate()
    self._previewMask = previewMask
end

-- 切换粒子层
function M:loadParticleLayer()
    if self:getScene().getParticleViewLayer then
        self:getScene():getParticleViewLayer():show()
    else
        local particleViewLayer = import("app.dragonbone.layer.ParticleViewLayer").new({}):to(self:getScene(), 10):to(0, 0)
    end
    self:hide()
end

-- 获取指定目录下的所有文件
function M:getAllFileWithSpecifiedPath()
    local fiedPath = device.cachePath..BB_HOT_UPDATE_PATH.."newyear/res/img/common/bone"
    if iswindows() then
        fiedPath = device.cachePath..BB_HOT_UPDATE_PATH.."newyear\\res\\img\\common\\bone"
    end
    local filepathes = IO.filepathesType(fiedPath, "xml", true, true)
    for i, item in ipairs(filepathes) do
        local info = IO.pathinfo(item)
        -- print(info["dirname"] .. info["basename"])
        table.insert(self._pathTable, info["dirname"] .. info["basename"])
    end
end

-- 加载背景
function M:loadBackground()
    local background = U.loadNodeMask({ 
        contentSize = CCSize(V.w * 2, V.h * 2),
        color       = COLOR3_WHITE,
        opacity     = 100,
    }):pc():to(self, -100)
end

-- 读取文件并且获取动作行到表格中
function M:readFileAndInsertMovLineInTable()
    -- 使用到的骨骼文件
    self._pathTableNew = {}
    for i = 1, #self._pathTable do
        local path = self._pathTable[i]..".xml"
        local file = io.open(path, "r")                                 -- 打开xml文件
        local line = file:read()                                        -- 读取第一行
        local movNameTable = {}
        local armatureNameTable = {}
        while (line) do
            local hasArmatureName = string.find(line,'armature name')   -- 查找骨骼名所在行
            local hasMovName      = string.find(line,'mov name')        -- 查找骨骼动作名所在行
            if hasMovName then
                local stringTable = S.split(line, "\"")                 -- 以"为分界线拆分字符串并保存到表格中
                local name        = stringTable[2]                      -- 表格中的第2个就是动作名
                table.insert(movNameTable, name)                        -- 加入到动作名表格
            end
            if hasArmatureName then
                local stringTable = S.split(line, "\"")                 -- 以"为分界线拆分字符串并保存到表格中
                local name        = stringTable[2]                      -- 表格中的第2个就是骨骼名
                table.insert(armatureNameTable, name)                   -- 加入到骨骼名预存表格
                table.insert(self._armatureNameTable, name)             -- 加入到骨骼名表格
                table.insert(self._pathTableNew, self._pathTable[i])    -- 每个骨骼存储一次文件名
            end
            line = file:read()                                          -- 读取下一行
        end
        file:close();                                                   -- 关闭xml文件
        if T.count(armatureNameTable) == 1 then
            table.insert(self._movNameTable, movNameTable)
        else-- 区分一套骨骼文件里的多个骨骼
            local tab = {}
            for i, item in ipairs(armatureNameTable) do
                table.insert(tab, {})
            end
            for i = 1, #movNameTable do
                local name = S.split(movNameTable[i], "_")                 -- 以_为分界线拆分字符串并保存到表格中
                for j, item in ipairs(armatureNameTable) do                -- 按顺序与预存骨骼名对比分类
                    if item == name[1] then
                        table.insert(tab[j], movNameTable[i])
                        break
                    end
                end
            end
            for i = 1, #armatureNameTable do
                table.insert(self._movNameTable, tab[i])                    -- 插入动作表
            end
        end
    end
end

-- 加载骨头名称
function M:loadBoneTab()
    T.clear(self._boneTab)
    for i, item in ipairs(T.keys(self._dragon:getBoneDic())) do
        table.insert(self._boneTab, item)
    end
    self:loadUIListView(2)
end

-- 加载UI
function M:loadUIListView(id)
    local pos = cc.p(0, 0)
    local hight = V.h
    if id == 1 then
        hight = V.h / 2 - 10
        pos = cc.p(200, V.h / 2 + 10)
    elseif id == 2 then
        pos = cc.p(200, 5)
        hight = V.h / 2 - 5
    end
    local ui = CCNodeExtend.extend(cc.ui.UIListView.new ({
                bgColor = cc.c4b(200, 200, 200, 120),
                -- bgScale9 = true,
                viewRect = cc.rect(0, 0, V.w*0.2, hight),
                direction = cc.ui.UIScrollView.DIRECTION_VERTICAL,
                -- scrollbarImgV = "bar.png"
            }))
        :addTo(self):p(pos)
        ui:setContentSize(cc.size(V.w*0.2, hight))
        ui:onTouch(handler(self, self.uiListViewTouchListener))
    self:onTouchUI(ui)
    ui._id = id
    self:loadUiItem(ui)
    if id == 1 then
        self._actionUi = ui
    elseif id == 2 then
        self._boneUi = ui
    else
        self._armatureUi = ui
    end
end

-- 加载UI子项
function M:loadUiItem(ui)
    -- print(self._armatureIndex)
    local tab = self._armatureNameTable
    if ui._id == 1 then
        tab = self._movNameTable[self._armatureIndex]
        table.sort(tab, function(a, b)
            return (a < b)
        end)
    elseif ui._id == 2 then
        tab = self._boneTab
        table.sort(tab, function(a, b)
            return (a < b)
        end)
    end
    for i,v in ipairs(tab) do
        local item = ui:newItem()
 		local content = U.loadLabelTTF({ 
	        text        = v,      
	        fontSize    = 25, 
	        color       = COLOR3_WHITE,
	        position    = ccp(200, V.h - 60 * ((i - 1) % 8) - Y_OFFSET),
	    })
        item.label = content
        item = CCNodeExtend.extend(item)
        item:addContent(content)
        item:setItemSize(content:getContentSize().width, content:getContentSize().height + 20)
        ui:addItem(item)
    end
    ui:reload()
end

-- 删除ui
function M:removeUi()
    -- 动作ui
    if self._actionUi then
        if self.lastActionChooseditem then
            self.lastActionChooseditem:remove()
            self.lastActionChooseditem = nil
        end
        self._actionUi:remove()
        self._actionUi = nil
    end
    -- 骨头ui
    if self._boneUi then
        if self.lastBoneChooseditem then
            self.lastBoneChooseditem:remove()
            self.lastBoneChooseditem = nil
        end
        self._boneUi:remove()
        self._boneUi = nil
    end 
    -- 连贯动作遮罩
    if self._previewMask then
        self:clearActionTextTab()
        self._previewMask:remove()
        self._previewMask = nil
        self._preview = false
    end
end

function M:setCurrentItem(index)
    -- 删除旧ui
    self:removeUi()
    self._armatureIndex = 1
    self:setChoosedItem(self._armatureUi.items_[self._armatureIndex], 0)
    -- 加载动作ui
    self:loadUIListView(1)
    -- 加载新骨骼
    self:loadDragonBone()
    -- 加载骨骼名
    self:loadBoneTab()
end
-- ui监听
function M:uiListViewTouchListener(event)
    local listView = event.listView
    if "clicked" == event.name and not tolua.isnull(event.item) then
        local item = CCNodeExtend.extend(event.item)
       self:setChoosedItem(item, listView._id)
        item:line({
            {"shake", 0.3, 7, 7},
            {"fn", function()
                if listView._id == 0 then
                    -- 删除旧ui
                    self:removeUi()
                    self._armatureIndex = event.itemPos
                    -- 加载动作ui
                    self:loadUIListView(1)
                    -- 加载新骨骼
                    self:loadDragonBone()
                    -- 加载骨骼名
                    self:loadBoneTab()
                elseif listView._id == 1 then
                    local action = self._movNameTable[self._armatureIndex][event.itemPos]
                    -- 播放动作
                    self:playAnimation(action)
                    -- 连贯动作预览
                    if self._preview then
                        table.insert(self._actionPreTab, action)
                        self._previewMask:showActionName()
                    end
                    if self._startPreview then
                        self._actionPreIndex = 1
                        self._startPreview = false
                    end
                elseif listView._id == 2 then
                    -- 对应骨头闪烁
                    self:boneBlink(self._boneTab[event.itemPos], item)
                end
            end}
        })
    end
end

-- 重新绑定触控
function M:onTouchUI(ui)
    ui:bindTouch()
    --------------------------
    -- 触控
    -------------------------- 
    function ui:onTouchBegan(x, y, touches)
        self.prevX_ = x
		self.prevY_ = y
		self.bDrag_ = false
		local x,y = self.scrollNode:getPosition()
		self.position_ = {x = x, y = y}
		transition.stopTarget(self.scrollNode)
		self:callListener_{name = "began", x = x, y = y}
		self:enableScrollBar()
		self.scaleToWorldSpace_ = self:scaleToParent_()
        return SIGN_TOUCH_BEGAN_SWALLOWS 
    end
    
    function ui:onTouchMoved(x, y, touches)
        if self:isShake(cc.p(x, y)) then
			return
		end
		self.bDrag_       = true
		self.speed.x      = x - self.prevX_
		self.speed.y      = y - self.prevY_
        self.prevX_ = x 
        self.prevY_ = y
		if self.direction == self.DIRECTION_VERTICAL then
			self.speed.x = 0
		elseif self.direction == self.DIRECTION_HORIZONTAL then
			self.speed.y = 0
		end
		self:scrollBy(self.speed.x, self.speed.y)
		self:callListener_({name = "moved", x = x, y = y})
    end
    
    function ui:onTouchEnded(x, y, touches)
        if self.bDrag_ then
			self.bDrag_ = false
			self:scrollAuto()
			self:callListener_({name = "ended", x = x, y = y})
			self:disableScrollBar()
        else
			self:callListener_({name = "clicked", x = x, y = y})
		end
    end
end



-- 加载骨骼范围遮罩
function M:loadDragonBoneMask()
    local mask = U.loadNodeMask({ 
        contentSize = CCSize(250, 350),
        opacity     = 0,
    }):p(700, 300):to(self, -50)
    self._mask = mask
end

-- 加载骨骼
function M:loadDragonBone()
    if self._dragon then
        self._dragon:remove()
        self._dragon = nil
    end
    local stringTable = S.split(self._pathTableNew[self._armatureIndex], "bone")
    DragonBone.addFile("bone" .. stringTable[#stringTable])
    local name    = self._armatureNameTable[self._armatureIndex]
    local dragon  = DragonBone.createArmature(name):to(self._mask):bindTouchLocate()
    local anchor  = dragon:getAnchorPoint()
    local posX    = self._mask:cw() * anchor.x
    local posY    = self._mask:ch() * anchor.y
    local scaleX  = 1 / dragon:cw() * self._mask:cw()
    local scaleY  = 1 / dragon:ch() * self._mask:ch()
    dragon:p(posX, posY)
    if scaleX < scaleY then
        dragon:scale(scaleX)
    else
        dragon:scale(scaleY)
    end
    self._dragon = dragon
    -- dragon
    dragon.getAnimation().setMovementEventCallFunc(dragon.getAnimation(), handler(self, self.movementHandler))
end

-----------------------------------
-- 骨骼监听
-----------------------------------
-- 监听
function M:movementHandler(armature, movementType, movementID)
    if T.isEmpty(self._actionPreTab) then return end
    if not self._startPreview then return end
    -- if not self._preview then return end
    if movementType == 1 or movementType == 2 then
        if T.hasValue(self._actionPreTab, movementID) then
            if self._actionPreIndex + 1 <= T.count(self._actionPreTab) then
                self._actionPreIndex = self._actionPreIndex + 1
                self._previewMask:nowPlayAction(self._actionPreIndex)
                self:playAnimation(self._actionPreTab[self._actionPreIndex])
            end
        end
    end
end

-- 播放骨骼动作
function M:playAnimation(name)
    if self._isLoop == 1 then
        self._dragon:play(name, self._speed, {loop = 1})
    elseif self._isLoop == 2 then
        self._dragon:play(name, self._speed, {loop = 0})
    elseif self._isLoop == 0 then
        self._dragon:play(name, self._speed)
    end
end

function M:boneBlink(name, item)
    self._lastBoneName = name
    if self._dragon:getBone(name).isHide then
        self._dragon:getBone(name):setOpacity(255) 
        self._dragon:getBone(name).isHide = false
        item.label:setColor(COLOR3_WHITE)
    else
        self._dragon:getBone(name):setOpacity(0) 
        self._dragon:getBone(name).isHide = true
        item.label:setColor(ccc3(0, 255, 255))
    end
end

-- 循环按钮事件
function M:touchLoopButton(button)
    self._isLoop = self._isLoop + 1
    if self._isLoop == 1 then
        button:setString("循环")
    elseif self._isLoop == 2 then
        button:setString("不循环")
    else
        button:setString("默认")
        self._isLoop = 0
    end
end

-- 加载文本
function M:loadTexts()
    local text = U.loadLabelTTF({ 
        text     = "当前骨骼大小不为实际大小", 
        fontSize = 25, 
        color    = COLOR3_BLACK,
        position = ccp(self._mask:px(), self._mask:py() - 250),
    }):to(self)
end

function M:setChoosedItem(item, id)
    if id == 0 then
        if not self.lastChooseditem then
            self.lastChooseditem = item
            item.label:setColor(ccc3(255, 0, 255))
        elseif self.lastChooseditem == item then
            item.label:setColor(ccc3(255, 0, 255))
            self.lastChooseditem = item
        else
            self.lastChooseditem.label:setColor(COLOR3_WHITE)
            item.label:setColor(ccc3(255, 0, 255))
            self.lastChooseditem = item
        end
    elseif id == 1 then
        if not self.lastActionChooseditem then
            self.lastActionChooseditem = item
            item.label:setColor(ccc3(255, 255, 0))
        elseif self.lastActionChooseditem == item then
            item.label:setColor(ccc3(255, 255, 0))
            self.lastActionChooseditem = item
        else
            self.lastActionChooseditem.label:setColor(COLOR3_WHITE)
            item.label:setColor(ccc3(255, 255, 0))
            self.lastActionChooseditem = item
        end
    elseif id == 2 then
        -- if not self.lastBoneChooseditem then
        --     self.lastBoneChooseditem = item
        --     item.label:setColor(ccc3(0, 255, 255))
        -- elseif self.lastBoneChooseditem == item then
        --     item.label:setColor(ccc3(0, 255, 255))
        --     self.lastBoneChooseditem = item
        -- else
        --     self.lastBoneChooseditem.label:setColor(COLOR3_WHITE)
        --     item.label:setColor(ccc3(0, 255, 255))
        --     self.lastBoneChooseditem = item
        -- end
    end
end

-- 加载其他
function M:loadRenderOtherwise()

end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end

return M
