--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSprite("PreviewMask")
M.TAG       = "PreviewMask"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._mainLayer     = params.layer
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)

    self:setContentSize(CCSize(400, 200))
    U.loadNodeMask({ 
        contentSize = CCSize(400, 200),
        color       = ccc3(0, 0, 0),
        opacity     = 100,
    }):anchor(cc.p(0, 0)):to(self):unbindTouch()

    -- 加载开始按钮
    self:loadPreviewBtn(1)
    self:loadPreviewBtn(2)
end

-- 显示动作
function M:showActionName(index)
    local main = self._mainLayer
    local index = ifnil(index, #main._actionPreTab)
    local partInteger, partMod = N.mod(index - 1, 8)
    local pos = cc.p(80 + partInteger * 130, 190 - partMod * 25)
    local actionName = main:loadText(main._actionPreTab[index], self, pos,cc.size(100,25)):scale(1.2):bindTouch()
    actionName._label = main._actionPreTab[index]
    table.insert(main._actionTextTab, actionName)
    self:setTouch(actionName)
end

-- 重新加载
function M:resetLoad()
    local main = self._mainLayer
    -- 清除现在的
    for i, item in ipairs(main._actionTextTab) do
        Tools:removeNode(item)
    end
    T.clear(main._actionTextTab)
    -- 重新渲染
    for i, item in ipairs(main._actionPreTab) do
        self:showActionName(i)
    end
end

-- 点击清除
function M:setTouch(node)
    local main = self._mainLayer
    
    --------------------------
    -- 触控
    -------------------------- 
    local parent = self
    function node:onTouchBegan(x, y, touches)
        --  触控有效
        T.removeOrder(main._actionPreTab, self._label)
        -- 重新渲染
        parent:resetLoad()
        -- return SIGN_TOUCH_BEGAN_SWALLOWS 
    end

end

-- 当前播放动作的改变颜色
function M:nowPlayAction(index)
    local main = self._mainLayer
    print(index)
    main._actionTextTab[index]:color(cc.c3b(0, 255, 0))
    if index > 1 then
        main._actionTextTab[index - 1]:color(cc.c3b(255, 0, 0))
    end
end

-- 重置颜色
function M:resetColor()
    local main = self._mainLayer
    for i, item in ipairs(main._actionTextTab) do
        item:color(cc.c3b(255, 0, 0))
    end
end

-- 预览开始
function M:loadPreviewBtn(id)
    local main = self._mainLayer
    local taxtName = "预览开始"
    local pos = cc.p(350, 212)
    if id == 2 then
        taxtName = "清除"
        pos = cc.p(260, 212)
    end
    local text = main:loadText(taxtName, self, pos)--:hide()
    text:bindTouch()
    text._id = id
	text:z(10000)
    local parent = self
    function text:onTouchBegan(x, y, touches)
        self:scale(1.1)
		return SIGN_TOUCH_BEGAN_SWALLOWS 
    end
    function text:onTouchEnded(x, y, touches)
        self:scale(1)
        if self._id== 1 then
            -- dump(main._actionPreTab)
            -- if main._preview then
            if T.isNotEmpty(main._actionPreTab) then
                main._actionPreIndex = 1
                -- 重置颜色
                parent:resetColor()
                -- 播放改颜色
                parent:nowPlayAction(1)
                main:playAnimation(main._actionPreTab[1])
                main._startPreview = true
            end
            -- end
        elseif self._id == 2 then
            main:clearActionTextTab()
        end
    end
end
----------------------
-- 结点析构
----------------------
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end


----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
