--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class("Main", import("app.common.layer.BaseCookLayer"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --调料
    self._seasonTb = {}
    --正在倒
    self._isPourNow = false
    --是否结束
    self._isOver    = false
    --点击中
    self._isTouch   = false
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 播放音效[sfx05704016]调料瓶落下
    soundEffect:playEffectsfx05704016()
    for k, v in pairs(self._seasonTb) do
        v:line({
            {"Delay", 0.1 * (k-1) },
            {"fn", function ()
                v:enter(function ()
                    if k == 1 then
                        Tools:openAd(false)
                    end
                end)
            end}
        })
    end
    -- 播放配音[v057088]有调料，饺子会更好吃
    soundVoice:playEffectv057088()
end

-- 加载结点
function M:loadPageNode()
    -- 加载桌布
    self:loadTablecloth()
    --加载盘子
    self:loadPlate()
    --加载托盘
    self:loadTray()
    --加载调料
    self:loadSeason()
    -- 加载ok按钮
    self:loadOkBtn()
end

-- 加载ok按钮
function M:loadOkBtn()
    local okBtn = import("app.common.node.BaseOkBtn").new({
        imgName = "common/okbtn/line.png",
        pos    = cc.p(720 + X_OFFSET, V.h + 250 - Y_OFFSET / 2),
    }):to(self, 999)
    self._okBtn = okBtn
end

-- 加载桌布
function M:loadTablecloth()
    local tablecloth = D.img("evefishingredient/tablecloth.png"):to(self):p(475 + X_OFFSET, 178.1)
end

--加载盘子
function M:loadPlate()
    local plate = import("app.evedumplingadd.node.Plate").new({
        layer = self,
        pos    = cc.p(285 + X_OFFSET, 200),
        scaleSize = 0.8
    }):to(self):scale(1)
    plate:p(280 + X_OFFSET, 200)
    self._plate = plate
    self._dish  = plate._dish
end

--加载托盘
function M:loadTray()
    local tray = import("app.evedumplingadd.node.Tray").new({
        layer  = self,
    }):to(self):p(710.5 + X_OFFSET, 192.2 - 45)
    self._tray = tray
end

--加载调料
function M:loadSeason()
    local offset = -45
    local posTb = {cc.p(623.7 + X_OFFSET, 197.8 + offset), cc.p(716.7 + X_OFFSET, 132.5 + offset), cc.p(797.7 + X_OFFSET, 195 + offset)}
    local zTb   = {5, 10, 8}
    local anchorTb = { cc.p(0.5, 0.1), cc.p(0.5, 0), cc.p(0.5, 0) }
    for i, v in ipairs(posTb) do
        local season = import("app.evedumplingadd.node.Season").new({
            layer = self,
            id    = i,
            pos   = v,
            zorder= zTb[i], 
            anchor= anchorTb[i]
        }):to(self):z(zTb[i])
        season:p(v.x, V.h + season:ch())
        table.insert(self._seasonTb, season)
    end
end

--延迟点击按钮
function M:delayTouchOkBtn()
    if self._laterTimeAct then return end
    if not self._okBtn.isEnter then return end
    if self._isTouch then return end
    self._laterTimeAct = A.line({
        { "delay", 3 },
        { "fn", function()
            if not tolua.isnull(self._okBtn._btn) then
                self._canTouch = false
                self._isOver= true
                self._okBtn._btn:onTouchBegan()
            end
        end }
    }):at(self)
end

--停止点击按钮
function M:stopTouchOkBtn()
    if self._laterTimeAct then
        self:stopAction(self._laterTimeAct)
        self._laterTimeAct = nil
    end
end

--选择按钮
function M:okNextStep()
    --判断调味品是否在盘子上
    local allIn = self:getSeasonInTray()
    if allIn then
       --选择结束
        self:chooseOver() 
    end
end

--点击ok按钮
function M:okTouchEvent()
    self._isOver = true
    self._canTouch = false
end


--判断调味品是否在盘子上
function M:getSeasonInTray()
    local allIn = true
    for i, v in ipairs(self._seasonTb) do
        if not v._inTray then
            allIn = false
        end
    end
    return allIn
end

--选择结束
function M:chooseOver()
    if self._chooseOver then return end
    self._chooseOver = true
    -- 播放配音
    soundVoice:playEffectv057047()
    self._canTouch = false
    --调味瓶切换父节点
    for k, v in pairs(self._seasonTb) do
        Tools:resetParent(v._shadow, v, -1)
        Tools:resetParent(v, self._tray, v._zorder)
        if v._id == 1 and v._isUse then
            v:display("evedumplingadd/season/1/18.png")
        end
    end
    self._tray:quit(function()
        -- 播放音效[sfx05704021]盘子居中展示
        soundEffect:playEffectsfx05704021()
        self._plate:line({
            { "jumpto", 0.5, cc.p(V.w_2, V.h_2), 100, 1 },
            { "fn", function()
                -- 加载居中展示的光和粒子
                Tools:loadLightAndParticle(self._plate, self, nil, 4, 2)
            end },
            { "delay", 2 },
            { "fn", function()
                --进入下个场景
                self:enterNextScene()
            end }
        })
    end)
end

--进入下个场景
function M:enterNextScene()
    G_DONE_FOOD_COPUNT = G_DONE_FOOD_COPUNT + 1
    if G_DONE_FOOD_COPUNT == 1 then
        game:enterScene("evekitchen", {enterNum = 2, fromWhere = 2}, "fade", 0.5, COLOR3_WHITE)
        -- Tools.whiteEnterScene("evekitchen", self:getScene(), {enterNum = 2, fromWhere = 2})
    else
        G_DONE_FOOD_COPUNT = 0
        game:enterScene("eveputfood", {}, "fade", 0.5, COLOR3_WHITE)
        -- Tools.whiteEnterScene("eveputfood", self:getScene(), {})
    end
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
