--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 调味碟类
----------------------
local M     = classSpriteTouch("Dish")
M.TAG       = "Dish"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --当前显示的动画 0：无 1：醋 2：番茄酱 3：辣椒粉
    self._showSeason = 0
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingadd/dish/1.png")
    local mask  = D.img("evedumplingadd/dish/2.png"):to(self, 10):p(self:cw()/2, self:ch() / 2)
    self._mask  = mask
    local light = D.img("evedumplingadd/dish/light.png"):to(self, 11):p(69.9, 62.8):scale(0.99):hide():opacity(0)
    self._light = light

    local shadow = D.img("evedumplingadd/dish/shaow.png"):to(self, -1):p(68.5, 41.9)
end

-- 加载结点
function M:loadPageNode()
    -- 加载醋
    self:loadVinegar()
    -- 加载番茄酱
    self:loadKetchup()
    -- 加载辣椒粉
    self:loadPepper()
end

--加载醋
function M:loadVinegar()
    -- self:getVinegarPos()
    local vinegar = D.img("evedumplingadd/dish/1/1.png"):to(self):p(self:cw() / 2, self:ch() / 2 - 10):hide()
    self._vinegar = vinegar
end

--获取醋的坐标
function M:getVinegarPos()
    -- local test = D.img("evedumplingadd/season/1/7.png"):to(self):p(141.4, 73.8):anchor(cc.p(0.5, 0.1))
    return self:convertToWorldSpace(cc.p(141.4, 73.8))
end

--醋的动画
function M:vinegarAct()
    self._showSeason = 1
    self._vinegar:line({
        { "show"},
        { "image", "evedumplingadd/dish/1/", 11, 1 / 10 }
    })
end

--加载番茄酱
function M:loadKetchup()
    -- self:getKetchupPos()
    local ketchup = D.img("evedumplingadd/dish/2/1.png"):to(self):p(self:cw() / 2, self:ch() / 2 - 10):hide()
    self._ketchup = ketchup
end

--获取番茄酱的坐标
function M:getKetchupPos()
    -- local test = D.img("evedumplingadd/season/2.png"):to(self, 999):p(204.9, 232.2):anchor(cc.p(0.5, 0)):rotate(-120)
    -- local act = D.img("evedumplingadd/season/2/7.png"):to(test, 999):anchor(cc.p(0.5, 1)):p(46.6, 154.2):rotate(120)
    return self:convertToWorldSpace(cc.p(204.9, 232.2))
end

--番茄酱的动画
function M:ketchupAct()
    self._showSeason = 2
    self._ketchup:line({
        { "show" },
        { "image", "evedumplingadd/dish/2/", 8, 1 / 10 }
    })
end

--加载辣椒粉
function M:loadPepper()
    -- self:getPepperPos()
    local pepper = D.img("evedumplingadd/dish/3/1.png"):to(self):p(self:cw() / 2, self:ch() / 2 - 10):hide()
    self._pepper = pepper
end

--获取辣椒瓶的坐标
function M:getPepperPos()
    -- local test = D.img("evedumplingadd/season/2.png"):to(self, 999):p(204.9, 232.2):anchor(cc.p(0.5, 0)):rotate(-120)
    -- local act = D.img("evedumplingadd/season/2/7.png"):to(test, 999):anchor(cc.p(0.5, 1)):p(46.6, 154.2):rotate(120)
    return self:convertToWorldSpace(cc.p(204.9, 232.2))
end

--番茄酱的动画
function M:pepperAct()
    self._showSeason = 3
    self._pepper:line({
        { "show" },
        { "image", "evedumplingadd/dish/3/", 7, 1 / 10 }
    })
end

--调料消失
function M:seasonHide()
    if self._showSeason == 1 then
        self._showSeason = 0
        self._vinegar:hide():display("evedumplingadd/dish/1/1.png")
    elseif self._showSeason == 2 then
        self._showSeason = 0
        self._ketchup:hide():display("evedumplingadd/dish/2/1.png")
    elseif self._showSeason == 3 then
        self._showSeason = 0
        self._pepper:hide():display("evedumplingadd/dish/3/1.png")
    end
end

--发光
function M:shineAct()
    if self._flashAction then return end
    self._light:show()
    local time2 = 0.7
    self._flashAction = A.cycle({
        { "fadeTo", time2, 255 },
        { "fadeTo", time2, 0 },
    }):at(self._light)
end

--停止放光
function M:stopShineAct()
    if self._flashAction then
        self._light:hide()
        self._light:opacity(0)
        self._light:stopAction(self._flashAction)
        self._flashAction = nil
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
