--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 调味品类
----------------------
local M     = class("Season", import("app.common.node.BaseNode"))
M.TAG       = "Season"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    --id
    self._id       = ifnil(params.id, 1)
    --层级
    self._zorder   = ifnil(params.zorder, 1)
    --锚点
    self._anchor   = ifnil(params.anchor, cc.p(0.5,0.5))
    --是否使用过
    self._isUse    = false
    --是否在盘子上
    self._inTray   = true
    --是否在倒酱料
    self._isPour   = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingadd/season/"..self._id..".png"):anchor(self._anchor)

    local help = D.img("common/help.png"):to(self):p(self:cw() / 2, self:ch() / 2 - 15):hide()
    self._helpNode = help
end

-- 加载结点
function M:loadPageNode()
    if self._id == 1 then
        --加载盖子
        self:loadLid()
    end
    --加载影子
    self:loadShadow()
end

--加载影子
function M:loadShadow()
    local offsetX = self._id == 1 and 5 or 0
    local offsetY = 10
    local shadow = D.img("evedumplingadd/season/"..self._id.."_1.png"):to(self._layer, self:z()):p(self._pos.x + offsetX, self._pos.y + offsetY):scale(0)
    self._shadow = shadow
end

--加载盖子
function M:loadLid()
    local lid = D.img("evedumplingadd/season/1/lid/1.png"):to(self):p(99,179)
    self._lid = lid
end

--进入音效
function M:enterEffect()

end

--进场动作
function M:enterAction(callBack)
    self._shadow:line({
        {"scaleTo", 0.5, 1}
    })
    self:line({
        { "moveto", 0.5, self._pos },
        A.union({
            { "jumpBy", 0.2, cc.p(0, 0), 25, 1 },
            { "rotateTo", 0.1, 3 },
        }),
        A.union({
            { "jumpBy", 0.1, cc.p(0, 0), 10, 1 },
            { "rotateTo", 0.05, -2 },
        }),
        { "rotateTo", 0.05, 2 },
        { "rotateTo", 0.05, -2 },
        { "rotateTo", 0.03, 1 },
        { "rotateTo", 0.03, -1 },
        { "rotateTo", 0.02, 0 },
        { "fn", function()
            self._canTouch = true
            if callBack then
                callBack()
            end
        end }
    })
end

--与碟子碰撞检测
function M:collisionDetection()
    if self._isPour then
        return
    end
    local dish = self._layer._dish
    local dis = ccpDistance(self._helpNode:worldpoint(), dish:worldpoint())
    if dis < 125 then
        --到碟子上方
        self:jumptoDish()
        return true
    end
    return false
end

--到碟子上方
function M:jumptoDish()
    self._isPour= true
    self._isUse = true
    G_DUMPLINGS_ADD = self._id
    --调料消失
    self._layer._dish:seasonHide()
    self._layer._canTouch = false
    if self._id == 1 then
        --醋动作
        self:vinegarAct()
    elseif self._id == 2 then
        --番茄酱动作
        self:ketchupAct()
    elseif self._id == 3 then
        --辣椒粉动作
        self:pepperAct()
    end
end

--返回
function M:goBack(openTouch, callBack, needEffect)
    openTouch = ifnil(openTouch, true)
    needEffect= ifnil(needEffect, true)
    if needEffect then
        -- 播放音效[sfx05704017]瓶罐放错位置弹回
        soundEffect:playEffectsfx05704017()
    end
    self._shadow:scale(0)
    self._shadow:line({
        {"show"},
        { "scaleTo", 0.3, 1 }
    })
    self:line({
        {"union", {
            {"rotateTo", 0.3, 0},
            { "jumpto", 0.3, self._pos, 50, 1 },
        }},
        { "fn", function()
            self:z(self._zorder)
        end },
        A.union({
            { "jumpBy", 0.2, cc.p(0, 0), 25, 1 },
            { "rotateTo", 0.1, 3 },
        }),
        A.union({
            { "jumpBy", 0.1, cc.p(0, 0), 10, 1 },
            { "rotateTo", 0.05, -2 },
        }),
        { "rotateTo", 0.05, 2 },
        { "rotateTo", 0.05, -2 },
        { "rotateTo", 0.03, 1 },
        { "rotateTo", 0.03, -1 },
        { "rotateTo", 0.02, 0 },
        { "fn", function()
            self._inTray = true
            if openTouch then
                self._canTouch = true
            end
            if not self._layer._isOver then
                --延迟点击按钮
                self._layer:delayTouchOkBtn()
            end
            if callBack then
                callBack()
            end
        end }
    })
end

--醋动作
function M:vinegarAct()
    local dish = self._layer._dish
    --获取醋的坐标
    local pos = dish:getVinegarPos()
    self:line({
        {"moveto", 0.5, pos}, 
        {"fn", function ()
            -- 播放音效[sfx05704019]倒酱油到调料碗
            soundEffect:playEffectsfx05704019()
            self._lid:line({
                { "union", {
                    { "cycle", {
                        { "image", "evedumplingadd/season/1/lid/", 2, 1 / 15 }
                    }, 3 },
                    { "moveby", 6 / 15, cc.p(0, 15) }
                } },
                { "easing", "ELASTICIN", { "moveBy", 0.3, ccp(0, V.h) }, 2 },
                { "hide" },
                { "fn", function()
                    self:line({
                        { "image", "evedumplingadd/season/1/", 18, 1 / 10 },
                        { "fn", function ()
                            self._lid:line({
                                {"show"},
                                { "easing", "ELASTICOUT", { "moveBy", 0.3, ccp(0, -V.h) }, 2 },
                                { "union", {
                                    { "cycle", {
                                        { "image", "evedumplingadd/season/1/lid/", 2, 1 / 15 }
                                    }, 3 },
                                    { "moveby", 6 / 15, cc.p(0, -15) }
                                } },
                                {"fn", function ()
                                    --完成
                                    self:doneFinish()    
                                end}
                            })
                        end}
                    })
                    self:line({
                        {"delay",6/10},
                        {"fn", function ()
                            dish:vinegarAct()
                        end}
                    })
                end }
            })      
        end}
    })
end

--番茄酱动作
function M:ketchupAct()
    local dish = self._layer._dish
    --获取番茄酱的坐标
    local pos = dish:getKetchupPos()
    
    self:line({
        {"union",{
            {"rotateTo", 0.5, - 120},
            { "moveto", 0.5, pos },
        }},
        { "fn", function()
            -- 播放音效[sfx05704018]挤番茄汁到调料碗
            soundEffect:playEffectsfx05704018()
            local act = D.img("evedumplingadd/season/2/7.png"):to(self, 999):anchor(cc.p(0.5, 1)):p(46.6, 154.2):rotate(120)
            act:line({
                { "image", "evedumplingadd/season/2/", 16, 1 / 10 },
                { "hide"},
                { "fn", function()
                    self:stopAllActions()
                    --完成
                    self:doneFinish()
                end }
            })
            self:cycle({
                { "scaleTo", 0.2, 0.9, 1 },
                { "scaleTo", 0.2, 1, 1 },
            })
            self:line({
                { "delay", 6 / 10 },
                { "fn", function()
                    --番茄酱的动画
                    dish:ketchupAct()
                end }
            })
        end }
    })
end

--辣椒粉动作
function M:pepperAct()
    local dish = self._layer._dish
    --获取番茄酱的坐标
    local pos = dish:getPepperPos()
    self:line({
        { "union", {
            { "rotateTo", 0.5, -120 },
            { "moveto", 0.5, pos },
        } },
        { "fn", function()
            -- 播放音效[sfx05704020]撒辣椒粉到调料碗
            soundEffect:playEffectsfx05704020()
            -- 打开调料粉动作
            self:openPepperOrEssenceAction()
            self:line({
                { "delay", 6 / 10 },
                { "fn", function()
                    --调料粉的动画
                    dish:pepperAct()
                end }
            })
        end },
        { "cycle", {
            { "moveby", 0.1, cc.p(0, 10) },
            { "moveby", 0.1, cc.p(0, -10) },
        }, 7 },
        { "fn", function()
            -- 关闭调味料动作
            self:closePepperOrEssenceAction()
            --完成
            self:doneFinish()
        end },
    })
end

--完成
function M:doneFinish()
    if not self._layer._isOver then
        --谷歌去广告
        Tools:closeAd(false, false)
        self._layer._okBtn:enter(nil, function()
            --延迟点击按钮
            self._layer:delayTouchOkBtn() 
        end) 
    end
    self:goBack(false, function()
        self:bindTouch()
        self._isPour = false
        if self._layer._isOver then
           --判断调味品是否在盘子上
            local allIn = self._layer:getSeasonInTray()
            if allIn then
                --选择结束
                self._layer:chooseOver()
            end 
        else
            self._layer._canTouch = true
            self._canTouch = true
        end
    end, false)
end


--打开调料粉动作
function M:openPepperOrEssenceAction()
    if self._flavouringAction then
        return
    end
    local time = 0.1
    self._flavouringAction = A.cycle({
        { "delay", time },
        { "fn", handlerP(self, self.createFlavoring, 15) },
    }):at(self)
end

-- 关闭调味料动作
function M:closePepperOrEssenceAction()
    if self._flavouringAction then
        self:stopAction(self._flavouringAction)
        self._flavouringAction = nil
    end
end

-- 创建调味料
function M:createFlavoring(number)
    local pos = cc.p(41.6, 139.2)
    for i = 1, number do
        local worldPos    = self:convertToWorldSpace(pos)
        local pos        = nil
        local rotate        = 0
        local scale        = 1
        local endScale    = 1

        rotate = RD.number(1, 360)
        pos    = ccp(worldPos.x + RD.number(-10, 10), worldPos.y + RD.number(-10, 10))
        local ids = { 1, 1, 1, 1, 2, 3 }
        local smallParticle = D.img("evedumplingadd/season/3/" .. RD.number(1, 3) .. ".png")
        :to(self._layer, 500):p(pos):rotate(rotate):scale(scale)
        -- smallParticle._name = flavoring._name
        local posX        = smallParticle:px() + RD.number(-20, 10)
        -- local posY        = smallParticle:py() + RD.number(-180, -90)
        local posY        = smallParticle:py() + RD.number(-100, -20)
        local height        = RD.number(10, 20)
        local newPos        = self:isAtEllipse(posX, posY)
        smallParticle:line {
            A.union({
                { "jumpTo", 0.4, newPos, height, 1 },
                { "scaleTo", 0.4, endScale },
            }),
            { "fn", handlerP(self, self.changeZorder, smallParticle) },
        }
    end
end

-- 判断是否在椭圆内
function M:isAtEllipse(posX, posY)
    local aValue = 220
    local bValue = 200
    local cPoint = ccp(V.w_2 - 106, 233.7)
    local deltaX = posX - cPoint.x
    local deltaY = posY - cPoint.y

    if posX > cPoint.x + aValue then
        posX = cPoint.x + aValue
    elseif posX < cPoint.x - aValue then
        posX = cPoint.x - aValue
    end

    local topY_2 = 1 - math.pow((deltaX / aValue), 2)
    local topY    = math.sqrt(topY_2)
    local topPosY = topY * bValue
    if deltaY > topPosY then
        deltaY = topPosY
    elseif deltaY < -topPosY then
        deltaY = -topPosY
    end
    local newPosX = cPoint.x + deltaX
    local newPosY = cPoint.y + deltaY
    return ccp(newPosX, newPosY)
end


--改变层级
function M:changeZorder(smallParticle)
    smallParticle:z(100):hide()
end

--播放语音
function M:playVoice()
    local nameTb = {"v057044", "v057045", "v057046"}
    soundVoice["playEffect" ..nameTb[self._id]](soundVoice)
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._layer._isTouch = true
            self._inTray = false
            self._canTouch = false
            --停止点击按钮
            self._layer:stopTouchOkBtn()
            local dish = self._layer._dish
            dish:shineAct()
            self:z(99)
            self:scaleAction()
            --播放语音
            self:playVoice()
            self._shadow:hide()
            --  触控有效
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    self:p(x - 30, y)
    bb.si.Tool.limitRectMove({ node = self})
    bb.si.Tool.limitButtonMove({node = self})
    --与碟子碰撞检测
    local result = self:collisionDetection()
    if result then
        self:unbindTouch()
        self:touchEndEvent()
        return SIGN_TOUCH_MOVED_STOP
    end
end

function M:onTouchEnded(x, y, touches)
    self:touchEndEvent()
    --碰撞检测
    local result = self:collisionDetection()
    if not result then
        --回到盘子里
        self:goBack(nil, function ()
            if self._layer._isOver then
                --判断调味品是否在盘子上
                local allIn = self._layer:getSeasonInTray()
                if allIn then
                    --选择结束
                    self._layer:chooseOver()
                end
            end
        end)
    end
end

--点击结束
function M:touchEndEvent()
    self._layer._isTouch = false
    local dish = self._layer._dish
    dish:stopShineAct()
    self:stopScaleAction()
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
