--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class("Main", import("app.common.layer.BaseCookLayer"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --面皮表
    self._toughTb = {}
    --当前第几个
    self._index   = 1
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)
    

    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    local title = "common/help1.png"
    local time = 0.8
    Tools:enterSceneScale(self, title, time)
    self:line({
        { "delay", time - 0.3 },
        { "fn", function()
            self._spoon:enter()
            self._toughTb[self._index]:enter()
        end }
    })
end

-- 加载结点
function M:loadPageNode()
    -- 加载砧板
    self:loadBlock()
    --加载盘子
    self:loadPlate()
    --加载碗
    self:loadBowl()
    --加载勺子
    self:loadSpoon()
    --加载面皮
    self:loadDough()
end

-- 加载砧板
function M:loadBlock()
    local block = D.img("evedumplingfarci/block.png"):to(self._node, 2):p(V.w_2 + 10, 210):scale(0.87)
    local flour = D.img("evedumplingfarci/flour.png"):to(self._node, 2):p(516.4 + X_OFFSET, 213.3):scale(0.87)
end

--加载盘子
function M:loadPlate()
    local plate = D.img("evedumplingfarci/plate.png"):to(self._node):p(100.4 + X_OFFSET, 255.6)
end

--加载碗
function M:loadBowl()
    local bowl = import("app.evedumplingfarci.node.Bowl").new({
        layer    = self
    }):to(self._node, 3):p(810.9 + X_OFFSET, 70.5)
    self._bowl = bowl
end

--加载勺子
function M:loadSpoon()
    local spoon = import("app.evedumplingfarci.node.Spoon").new({
        layer   = self,
        pos     = cc.p(800 + X_OFFSET, 300)
    }):to(self, 20)
    spoon:p(V.w + spoon:cw(), V.h_2)
    self._spoon = spoon
end

--加载面皮
function M:loadDough()
    for i = 1, 4 do
        local dough = import("app.evedumplingfarci.node.Dough").new({
            layer   = self,
            index   = i,
            pos     = cc.p(V.w_2 + 10, 240)
        }):to(self._node, 500)
        local pos = cc.p(-dough:cw(), V.h_2 - 100)
        dough:p(pos)
        --增加触控范围
        dough:expandTouchRange()
        table.insert(self._toughTb, dough)
    end
end

--手指移动引导
function M:handeGuide()
    if self._isHandGuide or self._isOver then return end
    if self._index == 1 then
        --播放饺子音效
        self:playDumplingsEffect()
    end
    local node = self._toughTb[self._index]
    local nodePos = node:point()
    nodePos = cc.p(nodePos.x + 100, nodePos.y + 10)
    self._isHandGuide =  A.line({
        {"Delay", 1},
        {"fn", function ()
            Tools:handMoveGuide(self, nodePos, cc.p(nodePos.x - 180, nodePos.y + 10), nil, nil, true, function()
                --引导动作
                node:guideAct()
            end)
        end}
    }):at(self)
end

--播放饺子音效
function M:playDumplingsEffect()
    if self._dumplingsEffect then return end
    -- 播放配音[v057042]包饺子啦！
    self._dumplingsEffect = soundVoice:playEffectv057042()
    -- local time = soundVoice:soundDuration("v057042", 2)
    -- self:line({
    --     {"delay", time},
    --     {"fn", function ()
    --         -- self._dumplingsEffect = nil
    --     end}
    -- })
end

--停止饺子音效
function M:stopDumplingsEffect()
    if self._dumplingsEffect then
        sound.stopSound(self._dumplingsEffect)
        self._dumplingsEffect = nil
    end
end


-- 移除手指移动引导
function M:removeHandGuide()
    if self._isHandGuide then
        self:stopAction(self._isHandGuide)
        self._isHandGuide = nil
    end
    --移除手指移动引导
    Tools:removeHandMoveGuide(self)
end

--开始点击引导
function M:openTouchGuide(guideNode)
    if self._isTouchGuide then return end
    self._isTouchGuide = true
    local node = self._toughTb[self._index]
    local nodePos = node:point()
    local offset = node._dir == "left" and -60 or 75
    nodePos = cc.p(nodePos.x + offset, nodePos.y + 0)
    Tools:addHand(self, nodePos)
end

-- 移除引导
function M:removeGuide()
    if not self._isTouchGuide then return end
    self._isTouchGuide = false
    -- 移除引导遮罩
    Tools:removeGuideMask(self)
end

--勺子进场
function M:spoonEnter()
    self._index = self._index + 1
    if self._index > 4 then
        --进入下个场景
        self:enterNextScene()
    else
        self._spoon:enter()
        self._toughTb[self._index]:enter()
    end
end

--镜头左移
function M:screenMoveLeft(callBack)
    self._node:line({
        { "moveBy", 0.5, cc.p(100, 0) },
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

--镜头复位
function M:screenMoveReset(callBack)
    self._node:line({
        { "moveto", 0.5, cc.p(0, 0) },
        { "fn", function ()
            if callBack then
                callBack()
            end
        end}
    })
end

--进入下个场景
function M:enterNextScene()
    game:enterScene("evedumplingwater", {}, "fade", 0.5, COLOR3_WHITE)
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
