--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 肉馅碗类
----------------------
local M     = classSpriteTouch("Bowl")
M.TAG       = "Bowl"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --勺子进场坐标
    self._configTb = {
        {
            startConfig = {-22, cc.p(200.4, 270.3),},
            endConfig = { 22, cc.p(276.2, 225.7),},
        },
        {
            startConfig = {-22, cc.p(199.3, 270.2),},
            endConfig = { 22, cc.p(276.1, 225.3),},
        },
        {
            startConfig = {-22, cc.p(199.3, 270.2),},
            endConfig = { 22, cc.p(276.1, 225.3),},
        },
        {
            startConfig = {-22, cc.p(199.3, 270.2),},
            endConfig = { 22, cc.p(276.1, 225.3),},
        },
    }
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingfarci/digani/1.png")
    --加载帧动画
    self:loadAni()
    --加载辅助点
    -- self:loadHelpSpoon()
end

--加载帧动画
function M:loadAni()
    self._index = 1
    local ani = D.img("evedumplingfarci/digani/"..self._index.."/1.png"):to(self):p(189.3, 238.8):hide()
    self._ani = ani
    local mask = D.img("evedumplingfarci/digani/mask.png"):to(self, 10):p(157.4, 233.8):hide()
    self._mask = mask
end

--加载辅助点
function M:loadHelpSpoon()
    local configTb = {
        {
            startConfig = {-22, cc.p(200.4, 270.3),},
            endConfig = { 22, cc.p(276.2, 225.7),},
        },
        {
            startConfig = {-22, cc.p(199.3, 270.2),},
            endConfig = { 22, cc.p(276.1, 225.3),},
        },
        {
            startConfig = {-22, cc.p(199.3, 270.2),},
            endConfig = { 22, cc.p(276.1, 225.3),},
        },
        {
            startConfig = {-22, cc.p(199.3, 270.2),},
            endConfig = { 22, cc.p(276.1, 225.3),},
        },
    }
    local angle = configTb[self._index]["startConfig"][1]
    local pos = configTb[self._index]["startConfig"][2]
    local spoon = D.img("evedumplingfarci/spoon/1.png"):to(self):rotate(angle):p(pos)
end

--获取开始挖的坐标
function M:getStartConfig()
    local config = self._configTb[self._index]["startConfig"]
    local angle = config[1]
    local pos = config[2]
    return angle,pos
end

--获取终点坐标
function M:getEndConfig()
    local config = self._configTb[self._index]["endConfig"]
    local angle = config[1]
    local pos = config[2]
    return angle, pos
end

--开始勺子挖肉的动画
function M:startDigAni(callBack)
    -- 播放音效[sfx05704002]舀起肉馅
    soundEffect:playEffectsfx05704002()
    self._ani:show()
    self._mask:show()
    self._ani:line({
        { "image", "evedumplingfarci/digani/" .. self._index .. "/", 9, 1 / 15.5 },
        { "hide" },
        { "fn", function ()
            self:display("evedumplingfarci/digani/".. self._index + 1 ..".png")
            --挖肉完毕
            self._layer._spoon:digOver()
            if callBack then
               callBack() 
            end
        end}
    })
end

-- 加载结点
function M:loadPageNode()
    
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
