--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 饺子类
----------------------
local M     = classSpriteTouch("Dough")
M.TAG       = "Dough"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    --第几个
    self._index     = ifnil(params.index, 1)
    --状态 1:包起来  2:点击变饺子
    self._type      = 1
    --进场位置
    self._pos       = ifnil(params.pos, cc.p(V.w_2, 250))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingfarci/dough.png")
end

-- 加载结点
function M:loadPageNode()
    --加载捏合的图
    self:loadKnead()
end

--加载捏合的图
function M:loadKnead()
    local points = { cc.p(30.3, 110.4), cc.p(20.8, 92.3), cc.p(14.1, 71), cc.p(20.1, 42.8), cc.p(22.4, 18.3), cc.p(23.4, 8.8),}
    self._skinTb = {}
    for i, v in ipairs(points) do
        local skin = D.img("evedumplingfarci/dumplings/" .. i .. ".png"):p(v):to(self, -1):scale(0)
        table.insert(self._skinTb, skin)
    end
end

--进场
function M:enter(callBack)
    -- 播放音效[sfx05704001]面团弹到砧板上
    soundEffect:playEffectsfx05704001()
    self:line({
        { "jumpTo", 0.5, cc.p(self._pos.x, self._pos.y), 150, 1},
        { "fn", function ()
            local pos = self:worldpoint()
            local particle = Tools:newParticle("particle/fangmianpi.plist", pos.x, pos.y - 80):to(self._layer, self:z()-1)
            Tools:insertParticleTb(self._layer, particle)
        end},
        { "scaleto", 0.2, 1 * 1.1, 1 * 0.95 },
        { "scaleto", 0.15, 1 * 0.98, 1 * 1.05 },
        { "scaleto", 0.1, 1 * 1.05, 1 * 0.95 },
        { "scaleto", 0.1, 1 * 0.98, 1 * 1.05 },
        { "scaleto", 0.1, 1, 1 },
        { "fn", function ()
            self:z(7)
            if callBack then
                callBack()
            end
        end}
    })
end

--倒馅动作
function M:pourAni(callBack)
    -- 播放音效[sfx05704003]倒肉馅及拍打
    soundEffect:playEffectsfx05704003()
    local spoonAni = D.img("evedumplingfarci/spoonani/1.png"):to(self):p(124.2 - 18, 225.8)
    local meat = D.img("evedumplingfarci/meat/2.png"):to(self, 999):p(126.1, 93.6):scale(1):hide()
    self._spoonAni = spoonAni
    self._spoonAni:line({
        { "image", "evedumplingfarci/spoonani/", 6, 1 / 15 },
        { "hide" },
        { "fn", function()
            if callBack then
                callBack()
            end
            meat:line({
                {"show",},
                { "image", "evedumplingfarci/meat/", 2, 1 / 15 },
                { "hide"},
                { "fn", function ()
                    --加载肉
                    self:loadMeat()
                end}
            })
        end }
    })
end

--加载肉
function M:loadMeat()
    local meat = D.img("evedumplingfarci/meat/4.png"):to(self,999):p(123.4,87.1):scale(0.8)
    local pos = self:point()
    meat:line({
        { "delay",0.7},
        { "scaleTo", 0.2, 0.9 },
        { "fn", function()
            local newPos = self:worldpoint()
            local particle = Tools:newParticle("particle/meet.plist", newPos.x, newPos.y - 20):to(self._layer, 15)
            Tools:insertParticleTb(self._layer, particle)
        end },
        { "scaleTo", 0.2, 0.88 },
        { "scaleTo", 0.2, 0.98 },
        { "fn", function()
            local newPos = self:worldpoint()
            local particle = Tools:newParticle("particle/meet.plist", newPos.x, newPos.y - 20):to(self._layer, 15)
            Tools:insertParticleTb(self._layer, particle)
        end },
        { "scaleTo", 0.2, 1 },
        { "hide"},
        { "fn", function ()
            --切换至带肉馅的帧动画
            self:changeType()
            self._canTouch = true
            --手指引导
            self._layer:handeGuide()
        end}
    })

    self:line({
        { "delay", 0.7 },
        { "scaleTo", 0.2, 1.05 },
        { "scaleTo", 0.2, 0.99 },
        { "scaleTo", 0.2, 1.05 },
        { "scaleTo", 0.2, 1 },
    })
end

--切换至带肉馅的帧动画
function M:changeType()
    local pos = self:point()
    self:display("evedumplingfarci/dough/1.png"):p(pos.x - 8, pos.y)
end

--返回帧动画开始坐标
function M:getSpoonStartConfig()
    local pos   = self:convertToWorldSpace(cc.p(174.2, 218.6))
    local angle = -23
    return angle,pos 
end

--返回帧动画结束坐标
function M:getSpoonEndConfig()
    local pos   = self:convertToWorldSpace(cc.p(101.8, 224.8))
    local angle = -73
    return angle,pos 
end

--包起来
function M:wrapAni()
    -- 播放音效[sfx05704004]饺子皮对折
    soundEffect:playEffectsfx05704004()
    self:line({
        { "image", "evedumplingfarci/dough/", 11, 1 / 15 },
        { "fn", function ()
            --开始点击引导
            self._layer:openTouchGuide()
            self._type = 2
            self._canTouch = true
        end}
    })
end

--点击改变
function M:touchChange()
    -- 播放音效[sfx05704005]饺子压边
    soundEffect:playEffectsfx05704005()
    self:line({
        { "scaleto", 0.2, 1.1 },
        { "scaleto", 0.2, 0.9 },
        { "fn", function()
            local xNum = self._dir == "left" and (self:px() - 70) or (self:px() + 70)
            self:display("evedumplingfarci/dumplings/8.png"):px(xNum)
            --加载移动粒子
            self:loadMoveParticle()
            for i = 1, 6 do
                self._skinTb[i]:line({
                    { "delay", (i - 1) * 0.07 },
                    { "union", {
                        { "easing", "backout", { "scaleTo", 0.5, 1 },},
                        { "fadeto", 0.2, 255 }
                    } },
                    {"fn", function ()
                        if i == 6 then
                            --跳到盘子上
                            self:jumpToDish()
                        end
                    end}
                })
            end
        end },
        { "scaleto", 0.15, 1.1 },
        { "scaleto", 0.15, 1 },
    })
end

--加载移动粒子
function M:loadMoveParticle()
    local pos = self._skinTb[1]:worldpoint()
    local offset = self._dir == "left" and 1 or -1
    local newPos = cc.p(pos.x - 20 * offset, pos.y + 20 * offset)
    local particle = Tools:newParticle("particle/huabian_tuowei.plist", newPos.x, newPos.y):to(self._layer, self:z() + 100)
    Tools:insertParticleTb(self._layer, particle)
    particle:line({
        { "moveto", 0.07, cc.p(newPos.x - 20 * offset, newPos.y - 25 * offset) },
        { "moveto", 0.07, cc.p(newPos.x - 30 * offset, newPos.y - 50 * offset) },
        { "moveto", 0.07, cc.p(newPos.x - 40 * offset, newPos.y - 75 * offset) },
        { "moveto", 0.07, cc.p(newPos.x - 30 * offset, newPos.y - 100 * offset) },
        { "moveto", 0.07, cc.p(newPos.x - 20 * offset, newPos.y - 125 * offset) },
        { "moveto", 0.07, cc.p(newPos.x , newPos.y - 150) },
        { "fn", function ()
            particle:stopSystem()
        end},
        { "delay", 0.2},
        { "hide"},
        { "remove"}
    })
end

------------------------------
-- 更换锚点，保持位置不变
------------------------------
function M:changeAnchorP(node, newAP)
    local nowAP = node:anchor()
    local box   = node:getBoundingBox()
    local dx    = (newAP.x - nowAP.x) * box.width
    local dy    = (newAP.y - nowAP.y) * box.height

    local offset = self._dir == "left" and 1 or -1
    node:px(node:px() + dx * offset)
    node:py(node:py() + dy * offset)
    node:anchor(newAP)
end

--跳到盘子上
function M:jumpToDish()
    local points = {cc.p(75 - 25 + X_OFFSET, 280), cc.p(185 - 25 + X_OFFSET, 270), cc.p(70 - 25 + X_OFFSET, 190), cc.p(175 - 25 + X_OFFSET, 193),}
    self:z(20)
    local angle = 90
    local sizeX, sizeY = 0.8,0.8
    self:changeAnchorP(self, cc.p(0.95, 0.5))
    local pos = points[self._index]
    -- 播放音效[sfx05704006]饺子跳到盘子里
    soundEffect:playEffectsfx05704006()

    local shadow = D.img("evedumplingfarci/shadow.png"):to(self._layer._node, self:z()-1):scale(0):p(pos.x, pos.y + 4)
    shadow:line({
        {"delay", 0.2},
        {"scaleto", 0.5, 1}
    })
    self:line({
        {"union",{
            { "rotateTo", 0.5, angle},
            { "jumpTo", 0.5, cc.p(pos.x, pos.y + 50), 100, 1},
            { "scaleto", 0.5, sizeX},
        }},
        { "moveto", 0.1, pos},
        { "scaleto", 0.1, sizeX * 0.93, sizeY * 1.06 },
        { "union", {
            { "jumpby", 0.25, cc.p(0, 0), 10, 1 },
            {"line", {
                { "scaleto", 0.15, sizeX * 1.06, sizeY * 0.95 },
                { "scaleto", 0.1, sizeX * 0.93, sizeY * 1.06 },
            }}
        } },
        { "union", {
            { "jumpBy", 0.25, cc.p(0, 0), 8, 1 },
            { "line", {
                { "scaleto", 0.15, sizeX * 1.05, sizeY * 0.95 },
                { "scaleto", 0.1, sizeX * 0.98, sizeY * 1.03 },
            } }
        } },
        { "scaleto", 0.1, sizeX * 1.03, sizeY * 0.98 },
        { "scaleto", 0.1, sizeX * 0.98, sizeY * 1.03 },
        { "scaleto", 0.1, sizeX * 1.02, sizeY * 0.98 },
        { "scaleto", 0.1, sizeX, sizeY },
        {"fn", function ()
            --勺子进场
            self._layer:spoonEnter()
        end}
    })
end

--引导动作
function M:guideAct()
    if self._guideAct then return end
    self._guideAct = A.line({
        { "image", "evedumplingfarci/dough/", 5, 1 / 15 },
        A.reverse({ "image", "evedumplingfarci/dough/", 5, 1 / 15 }),
        {"fn", function ()
            self._guideAct = nil
        end}
    }):at(self)
end

--停止引导动作
function M:stopGuideAct()
    if self._guideAct then
        self:stopAction(self._guideAct)
        self._guideAct = nil
    end
end

--增加触控范围
function M:expandTouchRange()
    self:bindTouch({ 
        rectFactorX = 1.5,
        rectFactorY = 1.5,
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._canTouch = false
            if self._type == 1 then
                self._touch = cc.p(x, y)
                self._dis = 0
                -- 移除引导
                self._layer:removeHandGuide()
                --停止引导动作
                self:stopGuideAct()
                self:display("evedumplingfarci/dough/1.png")
            else
                -- 移除引导
                self._layer:removeGuide()
            end
            --  触控有效
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    if self._type == 1 and x < self._touch.x  then
        self._dis = self._dis + math.abs(x - self._touch.x)
        if self._dis > 50 then
            self:wrapAni()
            self._dir = "left"
            return SIGN_TOUCH_MOVED_STOP
        end
    elseif self._type == 1 and x > self._touch.x then
        self._dis = self._dis + math.abs(x - self._touch.x)
        if self._dis > 50 then
            self._dir = "right"
            self:wrapAni()
            local time = 0.3
            local size = 1
            self:line({
                {"union", {
                    {"jumpBy", time, cc.p(0, 0), 50, 1},
                    {"rotateby", time, 180},
                    {"line", {
                        { "scaleto", time / 2, 1.1},
                        { "easing", "backout", { "scaleto", time / 2, 1 },},
                    }}
                }},
                { "scaleto", 0.2, size * 1.1, size * 0.95 },
                { "scaleto", 0.2, size * 0.98, size * 1.05 },
                { "scaleto", 0.1, size * 1.02, size * 0.98 },
                { "scaleto", 0.1, size, size },
            })
            return SIGN_TOUCH_MOVED_STOP
        end
    end
end

function M:onTouchEnded(x, y, touches)
    if self._type == 1 then
        --手指引导
        self._layer:handeGuide()
        self._canTouch = true
    else
        self:touchChange()
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
