--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 勺子类
----------------------
local M     = class("Spoon", import("app.common.node.BaseNode"))
M.TAG       = "Spoon"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    --是否可移动
    self._canMove   = true
    --勺子上是否有东西
    self._haveThing = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingfarci/spoon/1.png")
end

-- 加载结点
function M:loadPageNode()
    
end

--碰撞检测
function M:collisionDetection()
    if not self._haveThing then
        --与碗碰撞检测
        self:collisionDetection1()
    else
        --与面皮碰撞检测
        self:collisionDetection2()
    end
end

--与碗碰撞检测
function M:collisionDetection1()
    local bowl = self._layer._bowl
    local dis = ccpDistance(self:point(), bowl:point())
    if dis < 150 then
        self._haveThing = true
        self._canMove = false
         --获取开始挖的坐标
        local angle, pos = bowl:getStartConfig()
        Tools:resetParent(self, bowl, 1)
        self:line({
            {"union",{
                {"moveTo", 0.5, pos},
                {"rotateTo", 0.5, angle},
                {"scaleTo", 0.5, 1}
            }},
            {"hide"},
            {"fn", function ()
                bowl:startDigAni()
            end}
        })
    end
end

--与面皮碰撞检测
function M:collisionDetection2()
    local tough = self._layer._toughTb[self._layer._index]
    local dis = ccpDistance(self:point(), tough:point())
    if dis < 150 then
        self._canMove = false
        --获取开始挖的坐标
        local angle, pos = tough:getSpoonStartConfig()
        self:line({
            { "union", {
                { "moveTo", 0.5, pos },
                { "rotateTo", 0.5, angle },
                { "scaleTo", 0.5, 1 }
            } },
            { "hide" },
            { "fn", function()
                --倒馅动作
                tough:pourAni(handler(self, self.setPourEndPos))
            end }
        })
    end
end

--设置倒馅最后倒完的最后一帧位置
function M:setPourEndPos()
    local tough = self._layer._toughTb[self._layer._index]
    local angle, pos = tough:getSpoonEndConfig()
    self:display("evedumplingfarci/spoon/1.png"):rotate(angle):p(pos):show()
    self:line({
        {"union", {
            { "moveby", 2 / 15, cc.p(5, 5) },
            { "rotateTo", 2 / 15, angle + 5 },
        }},
        { "union", {
            { "moveby", 0.6, cc.p(75, -60) },
            { "rotateTo", 0.6, 40 },
        } },
        { "union", {
            { "moveby", 0.2, cc.p(0, -10) },
            { "rotateBy", 0.2, -20 },
        } },
        { "union", {
            { "moveby", 0.2, cc.p(0, 10) },
           { "rotateBy", 0.2, 20 },
        } },
        { "union", {
            { "moveby", 0.2, cc.p(0, -10) },
            { "rotateBy", 0.2, -20 },
        } },
        { "union", {
            { "moveby", 0.2, cc.p(0, 10) },
            { "rotateBy", 0.2, 20 },
        } },
        {"fn", function ()
            self._haveThing = false
            self:quit()
        end}
    })
end

--退场动作
function M:quitAction(callBack)
    self:scale(1)
    self:line({
        { "union", {
            { "moveby", 0.3, cc.p(200, 10) },
            { "rotateto", 0.3, 0 },
        } },
        { "moveby", 0.4, cc.p(500, 0) },
        { "fn", function()
            if callBack then
                callBack()
            end
        end },
    -- { "remove" }
    })
end

--进场动作
function M:enterAction(callBack)
    self:scale(1):p(V.w + self:cw(), 300)
    self:line({
        { "easing", "backout", { "moveto", 0.5, self._pos },},
        { "fn", function()
            if callBack then
                callBack()
            end
            self._canTouch = true
            self._canMove = true
            --开始引导
            self:openGuide()
        end }
    })
end

--挖肉完毕
function M:digOver()
    local bowl = self._layer._bowl
    local angle, pos = bowl:getEndConfig()
    self:p(pos):rotate(angle)
    self:show()
    self:display("evedumplingfarci/spoon/2.png")
    self:line({
        { "moveby", 0.3, cc.p(0, 50) },
        { "fn", function()
            Tools:resetParent(self, self._layer, 20)
            self:display("evedumplingfarci/spoon/2.png")
            bowl._mask:hide()
            bowl._index = bowl._index + 1
            self._canMove = true
            if not self._isTouch then
                self._canTouch = true
                --开始引导
                self:openGuide()
            end
        end }
    })
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._isTouch = true
            self._canTouch = false
            --停止引导
            self:stopGuide()
            --点击音效
            self:clickEffect()
            self:line({
                { "scaleTo", 0.1, 1.1 },
                { "scaleto", 0.1, 1 }
            })
            --  触控有效
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    if self._canMove then
        self:p(x - 30, y - 40)
        --碰撞检测
        self:collisionDetection()
        bb.si.Tool.limitRectMove({
            node = self,
            -- marginTop = 40,
            boundingRect = cc.rect(15, 20, self:size().width - 45, self:size().height - 30)
        })
        bb.si.Tool.limitButtonMove({node = self})
    end
end

function M:onTouchEnded(x, y, touches)
    self._isTouch = false
    if self._canMove then
        self._canTouch = true
        --开始引导
        self:openGuide()
        self:collisionDetection()
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
