--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class("Main", import("app.common.layer.BaseCookLayer"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch     = true
    -- 虚线表
    self._circleTab    = {}
    -- 配料表
    self._scallionTab  = {}
    -- 计数
    self._count        = 0
    -- 是否停止烟雾
    self._isStopSmoke  = false 
    -- 烟雾索引
    self._smokeIndex   = 0   
    -- 饺子表
    self._dumplingsTb  = {}      
    --碰撞表
    self._collisionTb = {}
    --锅里的坐标
    self._inPotPos = {
        { haveThing = false, pos = cc.p(251 + X_OFFSET, 275) },
        { haveThing = false, pos = cc.p(181 + X_OFFSET, 232) },
        { haveThing = false, pos = cc.p(347 + X_OFFSET, 248) },
        { haveThing = false, pos = cc.p(280 + X_OFFSET, 201) },
    }
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    self._node:scale(1.1):px(0)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    --锅盖进场
    self._cover:coverEnter(function ()
        Tools:openAd(true)
        self._btn._canTouch = true
        guideFn:openGuide(self._btn, 0.1, 3)
    end)
    -- 播放配音
    soundVoice:playEffectv057043()
end

-- 加载结点
function M:loadPageNode()
    -- 加载灶台
    self:loadOven()
    -- 加载盖子
    self:loadCover()
    -- 加载ui
    self:loadUi()
    -- 加载按钮
    self:loadBtn()
    --加载盘子
    self:loadPlate()
    --加载饺子
    self:loadDumplings()
    --加载勺子
    self:loadSpoon()
    --加载盘子
    self:loadPlate2()
end

-- 加载灶台
function M:loadOven()
    local oven  = D.img("evefishboil/oven.png"):to(self._node, 10):p(320 + X_OFFSET, 138):bindTouch():scale(1.13)
    self._oven  = oven
    -- 加载锅
    local pot   = D.img("evefishboil/pot/pot.png"):to(oven, 10):p(199.8, 221.6):bindTouch()
    self._pot   = pot
    local potMask  = D.img("evefishboil/pot/mask.png"):to(pot, 30):p(195.2, 89.8)
    self._potMask = potMask
    -- 加载水
    local water = D.img("evefishboil/pot/water/10001.png"):to(pot, 15):p(189.7 + 5, 130.0 + 20)
    self._water = water
    Tools:shaderWave(water, 0.01, 3, 6, 0)
    -- 加载火焰
    local fire  = D.img("evefishboil/fire/10001.png"):to(pot, -1):p(195.2, 74.7):scale(0):hide()
    self._fire  = fire
    -- 加载上泡泡
    local bubbleup = D.img("evefishboil/pot/bubbleup/10001.png"):to(pot,15):p(189.4, 169.5 + 20):opacity(0):hide()
    self._bubbleup = bubbleup
    -- 加载下泡泡
    local bubbledown = D.img("evefishboil/pot/bubbledown/10001.png"):to(pot,15):p(189.4, 120.7):opacity(0):hide()
    self._bubbledown = bubbledown
    -- 加载引导箭头
    self:loadGuideArrow()
end

-- 加载引导箭头
function M:loadGuideArrow()
    if self._arrow then return end
    local arrow = D.img("common/arrow/1.png"):to(self, 200):p(270.4 + X_OFFSET, 256.9):scale(0.8):hide():opacity(0)
    self._arrow = arrow
end

-- 显示箭头引导
function M:showArrowAction()
    self._arrow:show()
    A.cycle({
        { "show" },
        {"union", {
            {"fadeTo", 0.5, 255},
            { "file", "common/arrow/", 4, 1 / 8 },
        }},
        { "file", "common/arrow/", 4, 1 / 8 },
        { "union", {
            { "fadeTo", 0.5, 0 },
            { "file", "common/arrow/", 4, 1 / 8 },
        } },
        { "hide" },
        { "delay", 3 }
    }):at(self._arrow)
end

-- 隐藏箭头引导
function M:hideArrowAction()
    if self._arrow then
        self._arrow:stopAllActions()
        self._arrow:hide():opacity(0)
    end
end

-- 加载按钮
function M:loadBtn()
    local btn   = import("app.evedumplingwater.node.Btn").new({
        imgName = "evefishboil/btn/10001.png",
        layer   = self,
    }):to(self._oven, 15):p(400.5, 104.4):bindTouch()
    self._btn   = btn
end

-- 加载锅盖
function M:loadCover()
    -- 加载锅盖
    local cover = import("app.evedumplingwater.node.Cover").new({
        imgName = "evefishboil/cover.png",
        layer   = self,
        pos     = cc.p(275 + X_OFFSET, 288)
    }):to(self._node, 100):scale(1.1)
    self._cover = cover
    self._cover:p(275 + X_OFFSET, V.h + cover:ch())
end

-- 加载ui
function M:loadUi()
    local progress = import("app.evedumplingwater.node.Progress").new({
        layer       = self,
        pos         = cc.p(850 + X_OFFSET, 250)
    }):to(self, 55)
    progress:p(V.w + progress:cw(), 250)
    self._progress1 = progress
end

-- ui退场
function M:uiEnter()
    self._progress1:enter()
end

-- 烧水过程
function M:boiling()
    local time = 0
	self._boilingTimer = A.cycle({
        {"fn", function()
			time = time + 1
			-- 锅盖的反馈动画
			self._cover:shakeAct(time)
			if time == 2 then
				-- 锅里冒烟
				self:loadSmoke()
				self:loadSteamParticle()
            elseif time % 7 == 0 then
                -- -- 加载结束
                -- self:boilFinish()
			end
        end},
		{"delay", 0.5},
	}, 12):at(self)
end

-- 加载结束
function M:boilFinish()
    self._cover._canTouch = true
    self._cover:onTouchBegan()
    -- ui退场
    self._progress1:quit()
    --  加载粒子
    self._particle1 = P.newParticle("particle/fish_oil_smoke.plist"):to(self._pot, 999):p(235, 180):scale(1)
    Tools:insertParticleTb(self, self._particl1)
end

--镜头移动
function M:shotMove(type)
    type = ifnil(type, 1)
    A.line({
        {"union", {
            { "scaleTo", 0.5, 1 },
            { "moveto", 0.5, ccp(0, 0) },
        }},
        {"fn", function ()
            if type == 1 then
                self._plate:enter()
            end
        end}
    }):at(self._node)
end

--切换父节点
function M:potChangeParent()
    Tools:resetParent(self._potMask, self, 20)
    Tools:resetParent(self._water, self, 10)
    Tools:resetParent(self._bubbleup, self, 10)
    Tools:resetParent(self._bubbledown, self, 10)
    self._potMask:scale(1.13)
    self._water:scale(1.13)
    self._bubbleup:scale(1.13)
    self._bubbledown:scale(1.13)
    A.cycle({
        { "imagerange", "evefishboil/pot/water/1000", 1, 7, 0.1 },
    }):at(self._water)
    A.cycle({
        { "imagerange", "evefishboil/pot/bubbleup/1000", 1, 7, 0.1 },
    }):at(self._bubbleup)
    A.cycle({
        { "imagerange", "evefishboil/pot/bubbledown/1000", 1, 9, 0.1 },
    }):at(self._bubbledown)
end

--加载烟雾
function M:loadSmoke()
    self._smokeIndex = self._smokeIndex + 1
    if self._smokeIndex > 3 then
        self._smokeIndex = 1
    end
    local index = self._smokeIndex
    local pos = { cc.p(210 + X_OFFSET, 230), cc.p(304 + X_OFFSET, 210), cc.p(395 + X_OFFSET, 235)}
    local moveByPos = { cc.p(-150, 350), cc.p(0, 350), cc.p(150, 350)}
    local smoke = D.img("evefishboil/smoke/"..index..".png"):p(self:convertToWorldSpace(pos[index])):to(self, self:z() + 100):scale(0)
    smoke:line({
        {"union", {
            {"moveBy", 3, moveByPos[index]},
            {"line", {
                {"scaleTo", 2, 1},
                {"fadeOut", 1},
            }},
            {"line", {
                {"delay", 0.5},
                {"fn", function()
                    if not self._isStopSmoke then
                        self:loadSmoke()
                    end
                end},
            }},
        }},
        {"remove"},
    })
end

-- 加载蒸汽粒子
function M:loadSteamParticle()
    local pos = self:convertToWorldSpace(cc.p(self:cw()/2 - 180, self:ch()/2))
    local steamParticle = P.newParticle("particle/zhureqi.plist"):p(pos):to(self._node, 110)
    Tools:insertParticleTb(self, steamParticle)
    steamParticle:setGlobalZOrder(10)
    self._steamParticle = steamParticle
end

-- 移除蒸汽粒子
function M:removeSteamParticle()
    if self._steamParticle then
        self._steamParticle:stopSystem()
        self._steamParticle:remove()
        self._steamParticle = nil
    end
end

-- 停止烟雾
function M:isStopSmokeFlag(isStop)
    self._isStopSmoke = isStop
end

-- 烧水
function M:stopBoiling()
	if self._boilingTimer then
		self:stopAction(self._boilingTimer)
		self._boilingTimer = nil
	end
end

--加载盘子
function M:loadPlate()
    local plate = import("app.evedumplingwater.node.Plate").new({
        layer   = self,
        pos     = cc.p(785 + X_OFFSET, 149)
    }):to(self):scale(0.9)
    plate:p(V.w + plate:cw(), 149)
    self._plate = plate
end

--加载饺子
function M:loadDumplings()
    local points = { cc.p(124, 180), cc.p(231, 180), cc.p(124, 114), cc.p(231, 114),}
    for k, v in pairs(points) do
        local dumplings = import("app.evedumplingwater.node.Dumplings").new({
            layer  = self,
            zorder = k,
            scaleSize = 0.9
        }):to(self._plate):p(v)
        table.insert(self._dumplingsTb, dumplings)
    end
end

--加载勺子
function M:loadSpoon()
    local spoon = import("app.evedumplingwater.node.Spoon").new({
        layer   = self,
        pos     = cc.p(300 + X_OFFSET, 270),
        scaleSize = 0.8
    }):to(self, 99):scale(0.8):rotate(-20):anchor(cc.p(0.25, 0.32))
    self._spoon = spoon
    spoon:p(V.w + spoon:cw(), 270)
end

--盘子退场
function M:plateQuit()
    if self._spoonEnter then return end
    self._spoonEnter = true
    self._plate:quit(function ()
        --加载进度条
        self:loadProgressBar()
        self._spoon:enter()
    end)
end

--加载物理世界
function M:loadbox2dWorld()
    -- 创建物理世界
    self:createWorld()
    -- 物理世界更新
    self:updateWithWorld()
    --切换父节点
    self:potChangeParent()
    -- 创建锅刚体
    self:createPotBody()
    self._canCheck = true
    local node = U.loadNode():to(self):p(V.w_2 - 85, 270 - 50)
    self:createNodeBody(node, -20 ,15,60)
    local node = U.loadNode():to(self):p(150 + X_OFFSET, 270 - 50)
    self:createNodeBody(node, 20, 10, 60)
    local node = U.loadNode():to(self):p(270 + X_OFFSET, 270 - 100)
    self:createNodeBody(node, 90, 15, 90)
end

--加载进度条
function M:loadProgressBar()
    local progress = import("app.common.node.BaseProgress").new({
        layer      = self,
        pos        = cc.p(850 + X_OFFSET, 250),
    }):to(self, 55)
    progress:p(V.w + progress:cw(), 250)
    self._progress = progress
    progress:enter()
end

--加载盘子
function M:loadPlate2()
    local plate2 = import("app.evedumplingwater.node.Plate2").new({
        layer   = self,
        pos     = cc.p(785 + X_OFFSET, 149),
        scaleSize = 0.8
    }):to(self):scale(0.8)
    plate2:p(V.w + plate2:cw(), 149)
    self._plate2 = plate2
end

--开始沸腾音效
function M:playBoilingEffect()
    if self._boilingEffect then return end
    -- 播放音效[sfx05704008]火苗燃烧和水沸腾
    self._boilingEffect = soundEffect:playEffectsfx05704008()
    --开始锅盖音效
    self:playPotEffect()
end

--停止沸腾音效
function M:stopBoilingEffect()
    if self._boilingEffect then
        sound.stopSound(self._boilingEffect)
        self._boilingEffect = nil
    end
end

--开始锅盖音效
function M:playPotEffect()
    if self._potEffect then return end
    -- 播放音效[sfx05704010]锅盖沸腾碰撞
    self._potEffect = soundEffect:playEffectsfx05704010()
end

--停止锅盖音效
function M:stopPotEffect()
    if self._potEffect then
        sound.stopSound(self._potEffect)
        self._potEffect = nil
    end
end

--手指移动引导
function M:handeGuide(startPos, endPos, offsetX, offsetY, startCallBack, endCallBack)
    if self._isHandGuide or self._isOver then return end
    self._isHandGuide = true
    Tools:handMoveGuide(self, startPos, endPos, offsetX, offsetY, nil, startCallBack, endCallBack)
end

-- 移除手指移动引导
function M:removeHandGuide()
    if not self._isHandGuide then return end
    self._isHandGuide = false
    --移除手指移动引导
    Tools:removeHandMoveGuide(self)
end


--进入下个场景
function M:enterNextScene()
    game:enterScene("evedumplingadd", {}, "fade", 0.5, COLOR3_WHITE)
end

----------------------
-- 刚体世界
----------------------
-- 创建物理世界
function M:createWorld()
    self._world = ZBox2D.createWorld(b2Vec2(0, 0), true, true)
    -- ZBox2D.openDebug(self)
end

-- 摧毁物理世界
function M:destroyWorld()
    self:closeUpdateWithWorld()
    if self._world then
        ZBox2D.destroyWorld(self._world)
        self._world = nil
    end
end

-- 物理世界更新
function M:updateWithWorld()
    local worldUpDate = scheduler.scheduleUpdateGlobal(handler(self, self.tickWithWorld))
    self._worldUpDate = worldUpDate
end

-- 关闭物理世界更新
function M:closeUpdateWithWorld()
    if self._worldUpDate then
        SC.close(self._worldUpDate)
        self._worldUpDate = nil
    end
end

-- 物理世界迭代
function M:tickWithWorld(time)
    if not self._world then return end
    local timeStep        = time
    local velocityIterations = 10
    local positionIterations = 10
    self._world:Step(timeStep, velocityIterations, positionIterations)

    local body = self._world:GetBodyList()
    while body do
        if body:GetUserData() and not self._spoon._finish then
            local spr = tolua.cast(body:GetUserData(), "cc.Sprite")
            if body._name == "dumpling" then
                if body:GetAngle() > 0.2 then
                    body:SetTransform(body:GetPosition(), 0.2)
                end
                if body:GetAngle() < -0.2 then
                    body:SetTransform(body:GetPosition(), -0.2)
                end
                local x, y = body:GetPosition().x * PTM_RATIO, body:GetPosition().y * PTM_RATIO
                spr:setPosition(ccp(x, y))
                local rotate = -1 * PT.radians2degrees(body:GetAngle())
                spr:rotation(rotate)
            elseif body._name == "pot" then

            else
                local x, y = body:GetPosition().x * PTM_RATIO , body:GetPosition().y * PTM_RATIO    
                spr:setPosition(ccp(x + 10 , y))
            end
        end
        body = body:GetNext()
    end
end

-- 创建锅刚体
function M:createPotBody()
    local pos = self._pot:worldpoint()
    local bodyInfo = {
        bodyType = b2_staticBody,
        userData = self._pot,
        point    = cc.p(pos.x, pos.y - 5),
        bullet = true,
    }
    local body = ZBox2D.createBody(bodyInfo, "physics/pot.plist", "pot")
    body._name = "pot"
end

--创建水饺刚体
function M:creatDumplingsBody()
    for k, v in pairs(self._dumplingsTb) do
        self:creatJoints(v)
    end
end

-- 创建鼠标关节
function M:createMouseJoint()
    if self._pot.body and self._spoon.body then
        local point = ccp(self._spoon.body:GetWorldCenter().x * 32, self._spoon.body:GetWorldCenter().y * 32)
        local joint = ZBox2D.createMouseJoint(self._pot.body, self._spoon.body, { target = point, maxForce = 4000 })
        return joint
    end
end

-- 摧毁鼠标关节
function M:destroyJoint(joint)
    if joint then
        ZBox2D.destroyJoint(joint, self._world)
    end
end

--距离关节
function M:creatJoints(node)
    node.joint = ZBox2D.createRopeJoint(node.body, self._pot.body, {
        length = bb.UPoint.distance(node:worldpoint(), self._pot:worldpoint()) / PTM_RATIO,
        maxLength = bb.UPoint.distance(node:worldpoint(), self._pot:worldpoint()) / PTM_RATIO + 1.2,
    })
end

-- 摧毁所有刚体
function M:destroyAllBody()
    for i, food in ipairs(self._dumplingsTb) do
        food:destroyBody()
    end
    if self._pot.body then
        ZBox2D.destroyBody(self._pot.body)
    end
    self._spoon:destroyBody()
end

-- 创建底刚体
function M:createNodeBody(node, angle, boxwidth, boxheight)
    boxwidth = boxwidth or 80
    boxheight = boxheight or 8
    local point = node:point()
    -- -- 刚体夹具
    local bodyDef    = b2BodyDef()
    -- 位置
    bodyDef.position = b2Vec2(point.x / PTM_RATIO, (point.y) / PTM_RATIO)

    bodyDef.type    = b2_staticBody
    -- 是否允许休眠
    bodyDef.allowSleep = true
    -- 子弹
    bodyDef.bullet    = true

    -- 创建矩形刚体
    local body = self._world:CreateBody(bodyDef)

    local testFixtureDef = b2FixtureDef()
    local testShape = b2PolygonShape()
    local boxheight = boxheight
    local boxwidth = boxwidth
    testShape:SetAsBox(boxwidth / PTM_RATIO, boxheight / PTM_RATIO)
    testFixtureDef.shape = testShape
    testFixtureDef.friction = 0.1
    testFixtureDef.restitution = 0.1
    testFixtureDef.density = 0.1
    testFixtureDef.linearDamping = 1
    testFixtureDef.angularDamping = 1

    -- 类别标志位
    testFixtureDef.categoryBits = 1
    -- 遮罩标志位 
    testFixtureDef.maskBits    = 6
    body:CreateFixture(testFixtureDef)
    node.body = body
    ZBox2D.setBodyAngle(body, angle)
end

--最后给力
function M:finishLinearVelocity()
    local worldpoint = self._pot:worldpoint()
    local bowlPosX = worldpoint.x
    local bowlPosY = worldpoint.y
    for k, v in pairs(self._dumplingsTb) do
        local posX = v:getPositionX()
        local posY = v:getPositionY()
        local linex = 1
        local liney = 1
        local offset = 3
        if posX < bowlPosX then
            linex = 1
        else
            linex = -1
        end
        if posY < bowlPosY then
            liney = 1
        else
            liney = -1
        end
        v.body:SetLinearVelocity(b2Vec2(offset * linex, 0))
    end
end
----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if self._particle1  and not tolua.isnull(self._particle1) then
        self._particle1:remove()
        self._particle1 = nil
    end
    self:destroyWorld()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
