--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 按钮类
----------------------
local M     = classSpriteTouch("Btn")
M.TAG       = "Btn"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 水动作
function M:waterAct()
    A.line({
        {"show"},
        {"fadein", 1.5}
    }):at(self._layer._bubbleup)
    A.line({
        { "show" },
        { "fadein", 1.5}
    }):at(self._layer._bubbledown)
    A.cycle({
        {"imagerange", "evefishboil/pot/water/1000", 1, 7, 0.1},
    }):at(self._layer._water)
    A.cycle({
        {"imagerange", "evefishboil/pot/bubbleup/1000", 1, 7, 0.1},
    }):at(self._layer._bubbleup)
    A.cycle({
        {"imagerange", "evefishboil/pot/bubbledown/1000", 1, 9, 0.1},
    }):at(self._layer._bubbledown)
end

-- 火动作
function M:fireAct()
    A.line({
        {"show"},
        {"scaleTo", 1, 1.1},
        {"fn", function ()
            -- 水的动作
            self:waterAct()
            -- 加载烧水过程
            self._layer:boiling()
        end}
    }):at(self._layer._fire)
    self._fireAct = A.cycle({
        {"imagerange", "evefishboil/fire/1000", 1, 7, 0.1},
    }):at(self._layer._fire)
end

-- 进度条动作
function M:progressAct()
    self._layer._progress1:progressAct()
end

-- 按钮动作
function M:btnAct()
    A.union({
        {"imagerange", "evefishboil/btn/1000", 1, 6, 0.1},
        {"line", {
            {"delay", 0.5},
            {"fn", function ()
                commonAct:nodeScale(self._layer._btn, 0.5, 0.5)
            end}
        }}
    }):at(self._layer._btn)
end



--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end 
    self._canTouch = false
    guideFn:stopGuide(self)
    -- 播放音效[sfx05704007]炉灶点火
    soundEffect:playEffectsfx05704007()
    self:line({
        {"Delay", 0.5},
        {"fn", function ()
            --开始沸腾音效
            self._layer:playBoilingEffect()
        end}
    })
    local newPos = self:worldpoint()
    local particle = Tools:newParticle("particle/switch.plist", newPos.x, newPos.y):to(self._layer, self:z() + 100)
    Tools:insertParticleTb(self._layer, particle)
    -- 进度条进场
    self._layer:uiEnter()
    -- 按钮动作
    self:btnAct()
    -- 进度条动作
    self:progressAct()
    -- 火焰动作
    self:fireAct()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
