--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 盖子类
----------------------
local M     = classSpriteTouch("Cover")
M.TAG       = "Cover"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    --进场位置
    self._pos      = ifnil(params.pos, cc.p(375 + X_OFFSET - 100, 300))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    --加载亮光
    self:loadLight()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

--加载亮光
function M:loadLight()
    -- 加载亮
    local light = D.img("evefishboil/light.png"):to(self, 100):p(155, 110.7):hide()--:opacity(0)
    self._light = light
end


-- 锅盖引导
function M:coverGuide()
    self._canTouch = true
    self._light:show()
    self._coverGuideAct = A.cycle({
        { "fadein", 0.5 },
        { "delay", 0.3 },
        { "fadeTo", 0.5, 120 },
    }):at(self._light)
end

-- 停止引导
function M:stopCoverGuide()
    --隐藏亮光
    self:hideLight()
    if not tolua.isnull(self._coverGuideAct) then
        self:stopAction(self._coverGuideAct)
        self._coverGuideAct = nil
    end
end

--隐藏亮光
function M:hideLight()
    self._light:hide()
end

--锅盖进场
function M:coverEnter(callBack)
    local pos = self._pos
    self:line({
        {"delay", 0.3},
        {"fn", function ()
            -- 播放音效[sfx05704009]锅盖移入
            soundEffect:playEffectsfx05704009()
        end},
        {"jumpto", 0.3, cc.p(pos.x, pos.y + 50), 100, 1},
        {"moveto", 0.1, pos},
        A.union({
            {"jumpBy", 0.3, cc.p(0, 0), 40, 1},
            {"rotateTo", 0.15, -4},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.2, cc.p(0, 0), 25, 1},
            {"rotateTo", 0.1, 3},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.1, cc.p(0, 0), 10, 1},
            {"rotateTo", 0.05, -2},
        }),
        {"rotateTo", 0.05, 2},
        {"rotateTo", 0.05, -2},
        {"rotateTo", 0.04, 2},
        {"rotateTo", 0.04, -2},
        {"rotateTo", 0.03, 1},
        {"rotateTo", 0.03, -1},    
        {"rotateTo", 0.02, 0},
        {"fn", function()
            if callBack then
                callBack()
            end
		end},
	})
end

-- 锅盖离场
function M:coveOut()
    --谷歌去广告
    Tools:closeAd(false, false)
	self:stop()
    self:rotation(0)
    -- 播放音效[sfx05700007]道具移出
    soundEffect:playEffectsfx05700007()
	self:line({
		--出场动作
		{"easing","ELASTICIN",{"moveBy", .8, ccp(0, V.h)}, 2},
        {"fn", function()
            Tools:openAd(true)
            -- 镜头移动
            self._layer:shotMove()
			self:remove()
            self = nil 
		end},
	})
end

-- 锅盖跳动
function M:shakeAct(time)
    if time == 2 then 
        self:stopShakeAct()
        self._shake = A.cycle({
			{"union", {
            	{"rotateTo", 0.05, 2 },
				{"moveBy", 0.05, cc.p(0, 6)},
			}},
			{"union", {
            	{ "rotateTo", 0.05, -2 },
				{"moveBy", 0.05, cc.p(0, -6)},
			}},
            { "rotateTo", 0.04, 2 },
            { "rotateTo", 0.04, -2 },
			{"union", {
            	{ "rotateTo", 0.03, 1 },
				{"moveBy", 0.03, cc.p(0, 3)},
			}},
            { "rotateTo", 0.03, -1 },    
			{"union", {
            	{ "rotateTo", 0.02, 0 },
				{"moveBy", 0.02, cc.p(0, -3)},
			}},
        }):at(self)
    elseif time == 4 then
        self:stopShakeAct()
        self._shake = A.cycle({
            {"union", {
                { "rotateTo", 0.05, 4},
                {"jumpBy", 0.1, cc.p(0, 0), 10, 1},
            }},
            { "rotateTo", 0.05, -4},
        }):at(self)
    end
end

-- 停止跳动
function M:stopShakeAct()
    if self._shake then
        self:rotation(0)
        self:stopAction(self._shake)
        self._shake = nil
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end 
    self._canTouch = false
    self:coveOut()
    -- 停止烧水
    self._layer:stopBoiling()
    -- 停止烟雾
    self._layer:isStopSmokeFlag(true)
    --停止锅盖音效
    self._layer:stopPotEffect()
    -- 停止引导
    self:stopCoverGuide()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
