--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 饺子类
----------------------
local M     = class("Dumplings", import("app.common.node.BaseNode"))
M.TAG       = "Dumplings"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --层级
    self._zorder  = ifnil(params.zorder, 1)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingwater/dumplings/1.png")
    local cooked = D.img("evedumplingwater/dumplings/2.png"):to(self):p(self:cw()/2, self:ch() / 2):opacity(0):hide()
    self._cooked = cooked
    self._opciatyNum = 0
end

-- 加载结点
function M:loadPageNode()
    --加载影子
    self:loadShadow()
end

--加载影子
function M:loadShadow()
    local shadow = D.img("evedumplingfarci/shadow.png"):to(self, - 1):p(self:cw()/2 - 3, 13)
    self._shadow = shadow
end

--影子切换父节点
function M:shadowChangeP()
    Tools:resetParent(self._shadow, self._layer, self:z()-1)
end

--隐藏影子
function M:hideShadow()
    self._shadow:hide()
end

--与锅碰撞检测
function M:collisionDetection()
    local pot = self._layer._pot

    local dis = ccpDistance(self:point(), pot:worldpoint())
    if dis < 250 then
        --跳到锅里
        self:jumptoPot()
    else
        --回到盘子里
        self:goBack()
    end
end

--跳到锅里
function M:jumptoPot()
    print(self:ch() / 2)
    local points = { cc.p(176.4, 130.5 + 40),cc.p(114.5, 95.9 + 40),cc.p(261, 110.6 + 40),cc.p(201.6, 70 + 40),}
    local angleTb = {-15, 10, 12, -10}
    if not self._layer._index then
        self._layer._index = 0
    end
    self._layer._index = self._layer._index + 1
    local pos = self._layer._pot:convertToWorldSpace(points[self._layer._index])
    Tools:resetParent(self, self._layer, 90)
    --隐藏影子
    self:hideShadow()
    local size = 0.8 
    Tools:changeAnchorP(self, cc.p(0.5, 0.5))
    self:line({
        { "union", {
            { "scaleto", 0.3,  size},
            { "jumpto", 0.3, cc.p(pos.x, pos.y + 100), 30, 1 },
            { "rotateto", 0.3, math.random(-10, 10)}
        } },
        {"fn", function ()
            self:z(16)
            self._test = true
        end},
        { "moveto", 0.3, cc.p(pos.x, pos.y + 10) },
        { "fn", function()
            -- 播放音效[sfx05704011]饺子入水
            soundEffect:playEffectsfx05704011()
            self:z(10)
            local newPos = self:worldpoint()
            local particle = Tools:newParticle("particle/water.plist", newPos.x, newPos.y - 30):to(self._layer, self:z() + 100)            
            Tools:insertParticleTb(self._layer, particle)
        end },
        { "moveto", 0.1, cc.p(pos.x, pos.y) },
        { "fn", function ()
            self._potPos = self:worldpoint()
            -- dump(self._potPos)
            if self._layer._index == 4 then
                --盘子退场
                self._layer:plateQuit()

            end
            --创建水饺刚体
            self:creatDumplingsBody()
        end}
    })
end

--创建水饺刚体
function M:creatDumplingsBody()
    Tools:resetParent(self, self._layer, 3)
    --隐藏影子
    self:hideShadow()
    self:scale(0.8)
    local radius = 32
    local bodyInfo = {
        bodyType    = EBodyType.DYNAMIC,
        userData    = self,
        shape        = { shapeType = EShape.CIRCLE, radius = radius },
        point        = self:point(),
        angle        = -self:getRotation(),
        linearDamping = 5,
        angularDamping = 5,
        restitution    = 0.1,
        friction    = 1,
        density        = 1,
        -- 类别标志位
        categoryBits = 4,
        -- 遮罩标志位 
        maskBits    = 6,
    }
    local body = ZBox2D.createBody(bodyInfo)
    self.body = body
    body._name = "dumpling"
    self._layer:creatJoints(self)
    self:foodFloatAction()
end


-- 食物漂浮动作
function M:foodFloatAction()
    local time = RD.number(15, 30) / 100
    local scale = self:scale()

    -- 食物缩放动作
    self._flostAct3 = A.cycle({
        { "scaleTo", 0.2, 0.98 * scale },
        { "scaleTo", 0.2, 1.02 * scale },
    }):at(self) 

end

function M:stopFloatAction()
    if self._flostAct1 then
        self:stopAction(self._flostAct1)
        self._flostAct1 = nil
    end
    if self._flostAct2 then
        self:stopAction(self._flostAct2)
        self._flostAct2 = nil
    end
    if self._flostAct3 then
        self:stopAction(self._flostAct3)
        self._flostAct3 = nil
    end
end

--回到盘子里
function M:goBack()
    self:z(self._zorder)
    local angle = 0
    local sizeX, sizeY = 1, 1
    -- 播放音效[sfx05700008]没放对地方弹回
    soundEffect:playEffectsfx05700008()
    self._shadow:line({
        {"show"},
        {"scaleTo", 0.3, 1}
    })
    self:line({
        { "union", {
            { "scaleto", 0.3, self._scaleSize },
            { "jumpto", 0.3, self._pos, 50, 1 },
        } },
        { "scaleto", 0.1, self._scaleSize * 1.1, self._scaleSize * 0.95 },
        { "scaleto", 0.1, self._scaleSize * 0.98, self._scaleSize * 1.05 },
        { "scaleto", 0.1, self._scaleSize * 1.05, self._scaleSize * 0.95 },
        { "scaleto", 0.1, self._scaleSize, self._scaleSize },
        { "fn", function()
            self._canTouch = true
        end }
    })
end

-- 摧毁刚体
function M:destroyBody()
    if self.body then
        ZBox2D.destroyBody(self.body)
    end
    self:judgeDis()
    self:line({
        {"moveto", 0.8, self._potPos},
        {"fn", function ()
            local dis    = 5
            local height = 6
            local time = RD.number(10, 30) / 5
            self._flostAct1 = A.cycle({
                { "sinBy", time, ccp(    dis, 0), height, 2 },
                { "sinBy", time, ccp(-2 * dis, 0), height, 2 },
                { "sinBy", time, ccp(    dis, 0), height, 2 },
            }):at(self)
            self._flostAct2 = A.cycle({
                { "rotateBy", 0.15, -2 },
                { "rotateBy", 0.15, 2 },
                { "rotateBy", 0.15, 2 },
                { "rotateBy", 0.15, -2 },
            }):at(self)
        end}
    })
end

function M:judgeDis()
    local dis = 10000
    local target = 0
    for k, v in ipairs(self._layer._inPotPos) do
        if not v.haveThing then
            local dis1 = PT.distance(self:point(), v.pos)
            if dis1 < dis then
                dis = dis1
                target = k
            end
        end
    end
    self._layer._inPotPos[target].haveThing = true
    self._potPos = self._layer._inPotPos[target].pos
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._canTouch = false
            if not self._test then
                self:z(99)
                self:scaleAction()
                self._shadow:hide():scale(0)
            end
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    if not self._test then
        self:p(x - 40, y)
        bb.si.Tool.limitRectMove({
            node = self,
        -- marginTop = 80,
        -- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
        })
        bb.si.Tool.limitButtonMove({node = self})
    end
end

function M:onTouchEnded(x, y, touches)
    if not self._test then
        self:stopScaleAction()
            --与锅碰撞检测
        self:collisionDetection()
    end

end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
