--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = class("Spoon", import("app.common.node.BaseNode"))
M.TAG       = "Spoon"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    -- 状态1         : 搅拌  2: 倒进盘子里
    self._type     = 1
    --行进路线
    self._dumplingsPos    = { ccp(82, 82), ccp(70, 85), ccp(100, 80), ccp(82, 85), ccp(60, 80), 
                              ccp(70, 105),ccp(100, 100), ccp(85, 89), ccp(105, 88) }
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evedumplingwater/spoon/1.png")
    local before = D.img("evedumplingwater/spoon/2.png"):p(self:cw() / 2, self:ch() / 2):to(self)
    local detectNode = D.img("common/help.png"):p(82, 85):to(self):opacity(0)
    self._detectNode = detectNode
end

-- 加载结点
function M:loadPageNode()
    self:loadClipping()
end

--裁切
function M:loadClipping()
    local clipImg = D.img("evedumplingwater/spoon/clip.png"):p(82, 78):scaleX(0.5):scaleY(0.46)
    local clip = CCNodeExtend.extend(cc.ClippingNode:create(clipImg))
    clip:setInverted(false)
    clip:setAlphaThreshold(0)
    self:addChild(clip, 8)
    self._clip    = clip
    -- 水遮罩
    local water = D.img("evedumplingwater/spoon/water.png"):p(90.4, 85):to(self._clip):scale(0):opacity(130)
    self._water = water
end

--加载计时器，用于覆盖
function M:loadScheducle()
    if self._scheducle then
        return
    end
    self._count = 0
    self._scheducle = A.cycle({
        { "delay", 0.1 },
        { "fn", function()
            local dis = bb.UPoint.distance(self._exPoint, self:point())
            self._exPoint = self:point()
            self:logicChangeImage(dis)
        end }
    }):at(self)
end

--停止计时器
function M:stopScheducle()
    if not self._scheducle then
        return
    end
    self:stopAction(self._scheducle)
    self._scheducle = nil
end

--切换图片
function M:logicChangeImage(dis)
    if self._finish or not self._scheducle then return end
    if dis > 6 then
        --粒子显示
        self._layer._progress:particleShow()
        self._count = self._count + 2
        for k, v in pairs(self._layer._dumplingsTb) do
            v._opciatyNum = v._opciatyNum + 2
            if v._opciatyNum > 255 then
                v._opciatyNum = 255
            end
            v._cooked:show():opacity(v._opciatyNum)
        end
    end
    --进度条变化
    self:progressChange()
end

--进度条变化
function M:progressChange()
    --按照百分比
    self._layer._progress:setPercent(self._count)
    if self._count >= 99 then
        self._finish = true
        -- --按照百分比
        self._layer._progress:setPercent(110)
        for k, v in pairs(self._layer._dumplingsTb) do
            v._cooked:opacity(255)
        end
        --开始捞饺子
        self:changeType()
        --关闭引导
        self:closeGuide()
        return
    end
end

--进入音效
function M:enterEffect()
    -- 播放音效[sfx05704014]漏勺移入
    soundEffect:playEffectsfx05704014()
end

--进场动作
function M:enterAction(callBack)
    self:line({
        { "easing", "backout", { "moveto", 0.5, cc.p(self._pos.x, self._pos.y + 50) },},
        { "fn", function ()
            self:z(15)
            self._water:line({ { "scaleTo", 0.3, 0.5, 0.7 } })
        end},
        { "moveto", 0.2, cc.p(self._pos.x, self._pos.y) },
        { "fn", function()
            -- 播放配音[v057052]要搅拌锅里的饺子，就不会粘住哦
            soundVoice:playEffectv057052()
            self._exPoint = self:point()
            if callBack then
                callBack()
            end
            --打开引导
            self:openGuide()
            self._canTouch = true
        end }
    })
end

--打开引导
function M:openGuide()
    if self._guideAct then
        return
    end
    self._guideAct = A.line({
        {"Delay", 3},
        {"fn", function ()
            -- 显示箭头引导
            self._layer:showArrowAction()
        end}
    }):at(self)
end

--关闭引导
function M:closeGuide()
    if self._guideAct then
        self:stopAction(self._guideAct)
        self._guideAct = nil
    end
    -- 隐藏箭头引导
    self._layer:hideArrowAction()
end


--开始捞饺子
function M:changeType()
    self._type = 2
    self._layer._progress:quit(function ()
        self._layer._plate2:enter()
    end)
    --停止计时器
    self:stopScheducle()
    -- 摧毁所有刚体
    self._layer:destroyAllBody()
    -- 摧毁物理世界
    self._layer:destroyWorld()
    -- Tools:changeAnchorP(self, cc.p(0.25, 0.32))
    --自动捞
    self:autoScoopUp()
end


--自动捞
function M:autoScoopUp()
    local posTb = {
        cc.p(322.6 + X_OFFSET, 285.8), cc.p(214.6 + X_OFFSET, 276.3), cc.p(356 + X_OFFSET, 223.8), cc.p(190.9 + X_OFFSET, 219.4), cc.p(277 + X_OFFSET, 185.9),
    }
    --小屏去广告
    Tools:closeAd(true, true)
    self:line({
        { "delay", 0.5 },
        { "fn", function ()
            -- 播放音效[sfx05704015]捞起水饺
            soundEffect:playEffectsfx05704015()
        end},
        { "jumpto", 0.3, posTb[1], 45, 1 },
        { "fn", function ()
            --判断是否是捞到
            self:detectIsScoopUp()
        end},
        { "moveto", 0.5, posTb[2] },
        { "moveto", 0.5, posTb[3] },
        { "moveto", 0.5, posTb[4] },
        { "moveto", 0.5, posTb[5] },
        { "fn", function()
            self._water:line({ { "scaleTo", 0.3, 0 } })
        end },
        {"union",{
            {"rotateTo", 0.3, 0},
            { "moveTo", 0.3, ccp(V.w_2 - 150, 360) },
        }},
        { "fn", function()
            local particle = P.new("particle/loushaoshui.plist"):p(90, 40):to(self, -1):rotate(0)
        end },
        { "moveBy", 0.1, ccp(0, -50) },
        { "moveBy", 0.1, ccp(0, 50) },
        { "moveBy", 0.1, ccp(0, -40) },
        { "moveBy", 0.1, ccp(0, 40) },
        { "fn", function ()
            self._finish = false
            --手指引导
            self:handGuide(0)
        end},
    })
end

--盘子抛动做
function M:spoonJump()
    local size = self:scale()
    Tools:changeAnchorP(self, cc.p(0.5, 0.5))
    A.line({
        { "rotateTo", 0.2, -30 },
        {"fn", function ()
            -- 播放音效[sfx05704025]水饺丢盘子里
            soundEffect:playEffectsfx05704025()
        end},
        A.union({
            { "moveBy", 0.1, ccp(0, -50) },
            {"rotateby", 0.1, -10},
        }),
        A.union({
            { "moveBy", 0.1, ccp(0, 50) },
            { "rotateby", 0.1, 10 },
        }),
        A.union({
            { "moveBy", 0.1, ccp(0, -40) },
            { "rotateby", 0.1, -5 },
        }),
        A.union({
            { "moveBy", 0.1, ccp(0, 40) },
            { "rotateby", 0.1, 5 },
        }),
    }):at(self)
end

--倒到碟子上
function M:pourToPlate()
    --盘子抛动做
    self:spoonJump()
    local time    = 0.1
    for i, food in pairs(self._layer._dumplingsTb) do
        food:line({
            { "delay", 0.25 + time * i },
            {"fn", function ()
                self:allFoodChangeParent(food, i)
                food:z(self:z() + i)
                food:line({
                    { "jumpby", 0.3, ccp(-100, 100), 100, 1 },
                    { "fn", function()
                        food:z(i)
                        self:foodFallDown(food, i)
                    end },
                })
            end},

        })
    end
end

-- 所有食物替换父节点
function M:allFoodChangeParent(food, i)
    Tools:resetParent(food, self._layer, i)
    --隐藏影子
    food:hideShadow()
    food._cooked:show():opacity(255)
end


-- 食物落下动作
function M:foodFallDown(food, index)
    local number = RD.number(100, 120)
    local pos = self._layer._plate2._dumplingsPos[index]

    pos = self._layer._plate2:convertToWorldSpace(pos)
    local scale    = 0.9

    local rotate = N.random(-60, 30)
    local zOrder = RD.number(110, 120)
    local shadow = D.img("evedumplingwater/dumplings/shadow.png"):to(self._layer, food:z() - 1):p(pos.x, pos.y - 35):scale(0)
    shadow:line({
        { "scaleTo", 0.3, 1 },
    })
    food:line({
        A.union({
            { "moveto", 0.3, ccp(pos.x, pos.y)},
            { "scaleTo", 0.3, scale },
            { "rotateto", 0.3, 0 },
        }),
        { "fn", function()
            Tools:changeAnchorP(food, cc.p(0.5, 0))
        end },
        { "scaleto", 0.1, scale * 1.1, scale * 0.95 },
        { "scaleto", 0.1, scale * 0.98, scale * 1.05 },
        { "scaleto", 0.1, scale * 1.05, scale * 0.95 },
        { "scaleto", 0.1, scale, scale },
    })
end

--判断是否是捞到
function M:detectIsScoopUp()
    self:cycle({
        { "delay", 1 / 60 },
        { "fn", function()
            local pos = self:convertToWorldSpace(self._detectNode:point())
            for i, v in ipairs(self._layer._dumplingsTb) do
                if not v._isUp and PT.distance(v:point(), pos) < 50 then
                    v._isUp = true
                    Tools:resetParent(v, self, 1)
                    v:unbindTouch()
                    --隐藏影子
                    v:hideShadow()
                    v._cooked:show():opacity(255)
                    local index = i % 9 + 1
                    v:line({
                        { "moveTo", 0.2, self._dumplingsPos[index] },
                        { "fn", function()
                        end },
                    })
                end
            end
        end },
    })
end

-- 创建食物圆形刚体
function M:creatBody()
    if self._creat then
        return
    end
    self._creat = true
    local radius = 25
    local bodyInfo = {
        bodyType        = EBodyType.DYNAMIC,
        userData        = self,
        shape        = { shapeType = EShape.CIRCLE, radius = radius },
        point        = cc.p(self:point().x + 10, self:point().y),
        angle        = -self:getRotation(),
        linearDamping = 1,
        angularDamping = 0.7,
        restitution    = 0.1,
        friction        = 1,
        density        = 1,
        -- 类别标志位
        categoryBits = 2,
        -- 遮罩标志位 
        maskBits    = 7,
        fixedRotation = true
    }
    local body = ZBox2D.createBody(bodyInfo)
    if body then
        body._name = "spoon"
    end
end

-- 摧毁刚体
function M:destroyBody()
    if self.body then
        ZBox2D.destroyBody(self.body)
    end
end

-- 创建鼠标关节
function M:createMouseJoint()
    if self._joint then return end
    self._joint = self:getParent():createMouseJoint()
end

-- 拖动鼠标关节
function M:moveMouseJoint(x, y)
    if self._joint then
        local posX = x
        local posY = y
        local vec2 = b2Vec2(posX / PTM_RATIO, posY / PTM_RATIO)
        self._joint:SetTarget(vec2)
    end
end

-- 摧毁鼠标关节
function M:destroyMouseJoint()
    if self._joint then
        self:getParent():destroyJoint(self._joint)
        self._joint = nil
    end
end


--搅拌音效
function M:whipEffect()
    if not self._effect then
        local time = 3.8
        if not self._effectIndex then self._effectIndex = 1 end
        if self._effectIndex == 1 then
            self._effect = soundEffect:playEffectsfx05704012()
            self._effectIndex = 2
            time = 2.8
        else
            self._effect = soundEffect:playEffectsfx05704013()
            self._effectIndex = 1
        end
        if not self._effectAct then
           self._effectAct = A.line({
                { "delay", time },
                { "fn", function()
                    if self._effect then
                        sound.stopSound(self._effect)
                        self._effect = nil
                    end
                    self._effectAct = nil
                    --搅拌音效
                    self:whipEffect()
                end }
            }):at(self) 
        end
    end
end

--停止音效
function M:stopWhipEffect()
    if self._effect then
        sound.stopSound(self._effect)
        self._effect = nil
    end
    if self._effectAct then
        self:stopAction(self._effectAct)
        self._effectAct = nil
    end
end

--判断移动
function M:judgeMove()
    if self._judgeMoveAct  then
        self:stopAction(self._judgeMoveAct)
        self._judgeMoveAct = nil
    end
    self._judgeMoveAct = A.line({
        { "delay", 0.5 },
        { "fn", function()
            --停止音效
            self:stopWhipEffect()
        end }
    }):at(self)
end


--与碟子碰撞检测
function M:collisionDetection()
    if self._isPour then
        return
    end
    local plate = self._layer._plate2
    local dis = ccpDistance(self._detectNode:worldpoint(), plate:worldpoint())
    if dis < 125 then
        --到碟子上方
        self:jumpToplate()
        return true
    end
    return false
end

--到碟子上方
function M:jumpToplate()
    self._finish = true
    self:line({
        { "moveto", 0.5, cc.p(850 + X_OFFSET, 350) },
        { "fn", function()
            --倒到碟子上
            self:pourToPlate()
            self:line({
                { "delay", 2 },
                { "fn", function()
                    --进入下个场景
                    self._layer:enterNextScene()
                end }
            })
        end },
    })
end

--手指引导
function M:handGuide(delayTime)
    if self._delayAct then return end
    delayTime = ifnil(delayTime, 3)
    self._delayAct = A.line({
        {"delay", delayTime},
        {"fn", function ()
            local startPos = self:worldpoint()
            local endPos = self._layer._plate2:worldpoint()
            --手指移动引导
            self._layer:handeGuide(startPos, endPos, 5, -10)
        end}
    }):at(self)
end

--停止手指引导
function M:stopHandGuide()
    if self._delayAct then
        self:stopAction(self._delayAct)
        self._delayAct = nil
    end
    -- 移除手指移动引导
    self._layer:removeHandGuide()
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._canTouch then
        if self._finish then return end
        if self._type == 1 then
            --关闭引导
            self:closeGuide()
            --创建刚体
            self:creatBody()
            -- 创建鼠标关节
            self:createMouseJoint()
        elseif self._type == 2 then 
            --停止手指引导
            self:stopHandGuide()  
            self:scaleAction()
        end
        --  触控有效
        return true
    end
end

function M:onTouchMoved(x, y, touches)
    if self._finish then return end
    if self._type == 1 then
        --加载计时器，用于覆盖
        self:loadScheducle()
        self:moveMouseJoint(x - 120, y - 60)
        --搅拌音效
        self:whipEffect()
        --判断移动
        self:judgeMove()
    elseif self._type == 2 then
        self:z(999)
        self:p(x - 150, y - 100)
        bb.si.Tool.limitRectMove({
            node = self,
            marginTop = 0,
            boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
        })
        bb.si.Tool.limitButtonMove({node = self})
        --与碟子碰撞检测
        local result = self:collisionDetection()
        if result then
            self:unbindTouch()
            -- 结束缩放动作
            self:stopScaleAction()
            return SIGN_TOUCH_MOVED_STOP
        end
    end
end

function M:onTouchEnded(x, y, touches)
    if self._finish then return end
    if self._type == 1 then
        self.body:SetLinearDamping(50000)
        --摧毁鼠标关节
        self:destroyMouseJoint()
        --打开引导
        self:openGuide()
    elseif self._type == 2 then
        -- 结束缩放动作
        self:stopScaleAction()
        --碰撞检测
        local result = self:collisionDetection()
        if not result then
            --手指引导
            self:handGuide()
        end
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
