--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Cut")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._mainLayer 		= params.mainLayer
	--加载背景（快捷入口进）
	self._needBg			= ifnil(params.needBg, false)
    --触控
	self._canTouch          = false
	-- 等级
	self._level             = 1									
    -- 切烟花弹开关
    self._cutFireworkSwitch = false	
    --游戏结束
    self._gameOver       	= false
    -- 轮次	
    self._rounds         	= 0
	-- 是否出现特殊烟花
	self._specialFirework   = false								
    -- 当前是否特殊烟花弹模式	
	self._isNowSpecial      = false	
	-- 特殊烟花切割次数
	self._specialFireworkCutNum= 0	
	-- 特殊烟花连击数
	self._specialAddNum     = 0																		
	-- 单局切到正确烟花弹数
	self._cutCorrectNum     = 0									
	-- 单局掉出屏幕烟花弹数
	self._cutErrorNum       = 0									
	-- 可切烟花弹集合
	self._fireworkTb        = {}								
	-- 特殊烟花弹触发距离
	self._specialDis        = 0	
	-- 连续切中个数									
	self._addNum            = 0	
	-- 切开个数	
	self._cutNum            = 0	
	-- 开局引导
    self._firstGuide        = true
    --星星表
    self._starTb            = {}
    --龙烟花
    self._dragonFirework    = false
    -- 当前是否龙烟花弹模式
    self._isNowDragon       = false  
    -- 初始生成道具波数
    self._roundsPropNum     = 0
    --最终倒计时烟花出现
    self._endFireworkShow   = ifnil(params.endFireworkShow, false)
    --是否是最终倒计时烟花
    self._isNowEnd          = false
    --抛起音效总数，最大播放数2，超过部分不播
    self._hurlEffectTb      = {}
    --切音效总数，最大播放数2，最大播放数3，超出范围最先播放的销毁
    self._cutEffectCountTb  = {}
    --切音效表
    self._cutEffectTb       = {}
    --高度
    self._screenHight       = 720
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    if not self._endFireworkShow then
        --预加载图片
        self._mainLayer:initLoadImg(1)
        self._mainLayer:initLoadImg(2)
        if self._mainLayer._firstEnter == "countDown" then --快捷入口进
            self._mainLayer:initLoadImg(3)
            self._endFireworkShow = true
        end
    else
        --卸载图片资源
        -- self._mainLayer:unLoadImg(1)
        self._mainLayer:unLoadImg(2)
        self._mainLayer:initLoadImg(1)
        self._mainLayer:initLoadImg(3)
    end
    -- 加载结点
    self:loadPageNode()
    --加载炸开的烟花
    self:loadSpecialBoom()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    GLOBAL_TOUCH_LOCK = false
    --倒计时烟花
    if self._mainLayer._firstEnter == "countDown" then
        if self._mainLayer._directEnter then    --直接开始倒计时
            self._mainLayer._directEnter = false
            -- self._endFireworkShow = true
            --全部隐藏
            self._mainLayer:allAniHide()
            --上移屏幕
            self:moveToSreen()
        else                                    --前清后开始倒计时
            self._mainLayer.countDownCallBackFn = function ()
                self._endFireworkShow = true
                --上移屏幕
                self:moveToSreen()
            end
            --全体显示
            self._mainLayer:allAniShow()
            --倒计时罚站定位哦
            self._mainLayer:familyStand()
        end
    else                                        --切烟花
        if not self._endFireworkShow then
            --全部隐藏
            self._mainLayer:allAniHide()
        end
        -- 加载ui
        self:loadUi()
        --上移屏幕
        self:moveToSreen()
    end
end

--游戏开始
function M:gameStart()
    Tools:closeAd(true, false)
    if self._endFireworkShow then
        self._canTouch    = false
        self._cutFireworkSwitch = true
        self:loadFireworks()
    else
        if self._firstGuide then
            -- 开局引导
            self:firstGuide()
            self._canTouch    = true
            self._cutFireworkSwitch = true
            -- ui进场
            self:uiEnter()
        else
            self._canTouch    = true
            self._cutFireworkSwitch = true
            self:loadFireworks()
            -- ui进场
            self:uiEnter() 
        end
    end
end

--加载背景
function M:loadBg()
	--远景
	local skyNode = U.loadNode():to(self, 2):bindTouch()
	self._skyNode = skyNode

	-- 屏幕大小的空节点
	local emptyBg = U.loadNode():to(self, 22):bindTouch()
	self._emptyBg = emptyBg
end

--上移屏幕
function M:moveToSreen()
	local time = 3
	local dis  = -self._screenHight * 1.9
	self._skyNode:line({
		{ "easing", "sineinout", { "moveBy", time, cc.p(0, dis) } },
	})
	--画面上移，切换至切烟花场景
    self._mainLayer:screenUp(time, dis, function()
        --游戏开始
        self:gameStart()
	end)
end

-- 加载结点
function M:loadPageNode()
	-- 加载刀光
	self:loadBlade()
	--加载星星
	self:loadStar()
	--加载月亮
	self:loadMoon()
end

--加载月亮
function M:loadMoon()
    if not self._endFireworkShow then return end
    local offset = self._screenHight * 1.9
    local parent = self._skyNode
    local moon = import("app.evefireworkput.node.cut.Moon").new({
        layer  = self,
        enterPos = ccp(790.9 + X_OFFSET, 316.3 + Y_OFFSET + offset)
    }):to(parent, 10):p(790.9 + X_OFFSET + V.w_2, 316.3 + Y_OFFSET + offset):scale(0):hide()
    self._moon = moon
end

--加载星星
function M:loadStar()
    if not self._endFireworkShow then return end
    local offset    = self._screenHight * 1.9
    local parent    = self._skyNode
    local posTb     = { cc.p(172.1 + X_OFFSET, 308.5 + Y_OFFSET), cc.p(829.5 + X_OFFSET, 90.5 + Y_OFFSET), cc.p(207.7 + X_OFFSET, 84 + Y_OFFSET),}
    local flipxTb   = {false,  true ,false,}
    local angleTb   = {-10, 5, 5 }
    local offsetXTb = {-V.w_2, V.w_2, -V.w_2,} 
    for i, v in ipairs(posTb) do
        local star = import("app.evefireworkput.node.cut.Star").new({
            layer = self,
            id    = i,
            enterPos   = ccp(v.x, v.y + offset)
        }):to(parent, 10):p(v.x + offsetXTb[i], v.y + offset):flipX(flipxTb[i]):rotate(angleTb[i]):scale(0):hide()
        table.insert(self._starTb, star)
    end
end

-- 加载ui
function M:loadUi()
    local progress = import("app.evefireworkput.node.cut.Progress").new({
        layer    = self,
        pos      = cc.p(getButtonX_Left(), 220 + Y_OFFSET)
    }):to(self:getScene():getButtonLayer(), 999)
    progress:p(0 - progress:cw(), 220 + Y_OFFSET)
    self._progress = progress
end

-- ui进场
function M:uiEnter()
    self._progress:enter()
end

-- ui 退场
function M:uiQuit()
    self:line({
        {"delay", 0.5},
        {"fn", function ()
            self._progress:quit()
        end}
    })
end

-- 不断的添加烟花
-- param: time   number  时间间隔
-- param: num    number  产生的个数
-- param: speed  number  下落的速度
--加载烟花
function M:loadFireworks(time, num, speed)
	if self._gameOver or not self._cutFireworkSwitch then return end
	-- 出现间隔时间
	local time    = time or T.random(DELAY_TIME[self._level])
	-- 每次出现烟花弹的随机个数，按等级顺序，随机数的起始数值
	local num     = num or N.random(FIREWORK_NUM[self._level][1], FIREWORK_NUM[self._level][2])
	--速度
    local speed   = speed or 100

    self._timer = A.line({
        { "fn", function()
            -- 正常烟花弹
            self._rounds = self._rounds + 1		
            -- 加载特殊烟花弹或道具，每局开始的时候
            self:loadSpecialFireworkAndProp()
            --加载烟花
            for i = 1, num do
            	self:plan(function ()
            		-- 加载烟花蛋
            		if self._cutFireworkSwitch and not self._isNowSpecial and not self._isNowEnd then
            			self:loadSingleFirework(speed)	
            		end
            	end, (i - 1) * 0.1)
            end
        end },
        { "delay", time },
        { "fn", function()
            -- 新一轮的烟花弹
            if self._cutFireworkSwitch and not self._isNowSpecial and not self._isNowEnd then
                self:loadFireworks()            
            end
        end },
    }):at(self)
end

-- 加载特殊烟花
function M:loadSpecialFireworkAndProp()
    -- 特殊烟花
    if self._specialFirework then
        self._rounds = 0
        self._specialFirework = false
        self._isNowSpecial = true
        self:loadSingleFirework(100, 11)		-- 加载特殊烟花，
    elseif self._roundsPropNum ~= 0 then
        if self._rounds == self._roundsPropNum then
            self._roundsPropNum = 0
            self:loadSingleFirework(100, 9)		-- 加载龙烟花
        end
    elseif self._endFireworkShow then
        self._endFireworkShow = false
        self._isNowEnd = true
        self:loadSingleFirework(100, 20)		-- 加载特殊烟花
    end
end

-- 加载烟花弹
function M:loadSingleFirework(speed, fireworkId)
	if self._gameOver or not self._cutFireworkSwitch then return end
    --获取烟花弹的配置
    local id, beginX, beginY, endX, rotateNum, high, time, scaleNum = self:getFireworkConfig(fireworkId, speed)
	-- 节点
	local node
    if id == 11 then --特殊烟花
        node 	= import("app.evefireworkput.node.cut.Special").new({
            layer    = self,
        }):p(beginX, beginY):rotation(rotateNum):to(self, 100):scale(scaleNum):bindTouch()
        self._isCutSpecial = false
    else
		node  = D.img("evefireworkcut/firework/" .. id .. "/1.png"):p(beginX, beginY):rotation(rotateNum):to(self, 97):scale(scaleNum):bindTouch()
    end
    local this = self
    function node.onTouchBegan(x, y, touches)
        if this._canTouch then
		    this:cutFireworkShow(node)
        end
	end
    node._id   = id
    node._endX = endX
	-- 加载白光
	if id == 11 or id == 9 or id == 20 then
		self:loadWhiteLight(node)
	end
	--加入可切除列表
    table.insert(self._fireworkTb, node)
    --旋转	
    node:line({
        {"rotateto", time, N.random(-360, 360)}
    })
	--做呼吸效果
	node:cycle({
		{ "scaleTo", 0.5, scaleNum * 1.1 },
		{ "scaleTo", 0.5, scaleNum * 1 },
    })
    --抛起动作
    self:throwUp(node, id, time, endX, high)
end

--获取烟花弹的配置
function M:getFireworkConfig(fireworkId, speed)
    local num       = N.random(0, 1)
    -- 开始的x
    local beginX    = N.random(100 + X_OFFSET, V.w - 100 - X_OFFSET)
    -- 开始的y
    local beginY    = -100
    -- 结束的x
    local endX      = N.random(100 + X_OFFSET, V.w - 100 - X_OFFSET)
    -- 初始角度
    local rotateNum = N.random(0, 360)
    -- 跳起来的高度
    local high      = N.random(400, V.h - 80)
    -- 跳起的时间
    local time      = N.random(350, 450) / speed
    --缩放大小
    local scaleNum  = N.random(8, 10) / 10
    local id        = nil
    --特殊烟花
    if fireworkId then
        id = fireworkId
        time = 6
        if fireworkId == 9 then  --龙烟花
            beginX  = N.random(200 + X_OFFSET, V.w - 200 - X_OFFSET)
            endX    = N.random(390 + X_OFFSET, 600 + X_OFFSET)
        else                  --倒计时烟花及特殊烟花
            beginX  = V.w_2
            endX    = V.w_2
        end
    else
        if self._level >= 2 then  -- 一个图案烟花，一个普通烟花
            if self._lastItem <= 3 then
                -- 获取食材id（去重）
                id = Tools:getItemForTableExcept({ 4, 5, 6, 7 }, self._lastItem)
                self._lastItem = id
            else
                -- 获取食材id（去重）
                id = Tools:getItemForTableExcept({ 1, 2, 3 }, self._lastItem)
                self._lastItem = id
            end
        else                        --一个普通烟花
            -- 获取食材id（去重）
            id = Tools:getItemForTableExcept({ 1, 2, 3 }, self._lastItem)
            self._lastItem = id
        end
    end
    return id, beginX, beginY, endX, rotateNum, high, time, scaleNum 
end

--抛起动作
function M:throwUp(node, id, time, endX, high)
    if node._id == 20 then
        -- 播放音效[sfx05709006]炸弹飞出来（复用）
        soundEffect:playEffectsfx05709006()
        --加载其他音效
        self:playOtherEffect(node)
        node:line({
            { "jumpto", 1, cc.p(V.w_2, 250 + Y_OFFSET), 100, 1 },
            { "fn", function()
                -- 加载遮罩聚焦
                self:loadGuideMask(node, self, nil, nil, 2, 110)
                self._canTouch    = true
            end }
        })
    else
        --加载烟花弹抛起音效
        self:playHurlEffect(node)
        --加载其他音效
        self:playOtherEffect(node)
        -- 抛起
        node:line({
            { "jumpto", time, cc.p(endX, -80), high, 1 },
            { "fn", function()
                T.removeOrder(self._fireworkTb, node)		-- 列表中剔除，不能切了
                if node._id >= 1 and node._id <= 10 and not node._isCut then
                    self._cutErrorNum = self._cutErrorNum + 1
                end
                --下降爆炸
                self:downAct(node)
            end },
            { "fn", function()
                -- 特殊模式重新开启
                if id == 11 then
                    if not self._isCutSpecial then	-- 退出特殊模式
                        self._isNowSpecial = false
                        self:loadFireworks()			-- 重新生成烟花弹
                    end
                end
            end },
            { "fn", function()    
                Tools:removeNode(node)
            end },
        })
    end
end

--加载烟花弹抛起音效
function M:playHurlEffect(node)
    if #self._hurlEffectTb > 2 then
        return
    end
    local num = RD.numberExcept(6, 8, self._hurlEffectTb)
    table.insert(self._hurlEffectTb, num)
    node._hurlEffect = soundEffect["playEffectsfx0570900" .. num](soundEffect)
    local time = NV.soundDuration("effect/sfx0570900" .. num .. ".mp3", 2)
    local emptyForAct = U.loadNode({}):to(self)
    node.stopCallBack = function ()
        if node._hurlEffect then
            sound.stopSound(node._hurlEffect)
            node._hurlEffect = nil
        end
        if node._hurlEffect1 then
            sound.stopSound(node._hurlEffect1)
            node._hurlEffect1 = nil
        end
        T.removeOrder(self._hurlEffectTb, num)
    end
    emptyForAct:line({
        { "delay", time },
        { "fn", function()
            if node.stopCallBack then
                node.stopCallBack()
                node.stopCallBack = nil
            end
        end },
        {"remove",}
    })
end

--加载其他音效
function M:playOtherEffect(node)
    if node._id == 11 then
        -- 播放音效[sfx05709015]巨型烟花弹飞出来
        node._hurlEffect1 = soundEffect:playEffectsfx05709015()
    elseif node._id == 9 then
        -- 播放音效[sfx05709017]龙烟花飞出来
        node._hurlEffect1 = soundEffect:playEffectsfx05709017()
    elseif node._id == 20 then
        -- 播放音效[sfx05709024]炸弹之花里胡哨
        self._countDownEffect1 = soundEffect:playEffectsfx05709024()
        -- 播放音效[sfx05709025]炸弹粒子特效
        self._countDownEffect2 = soundEffect:playEffectsfx05709025()
    end
end

--停止倒计时烟花的音效
function M:stopCountDownEffect()
    if self._countDownEffect1 then
        sound.stopSound(self._countDownEffect1)
        self._countDownEffect1 = nil
    end
    if self._countDownEffect2 then
        sound.voiceFadeTo(self._countDownEffect2, 0, 1)
        self._countDownEffect2 = nil
    end
end

--加载烟花弹切开音效
function M:playCutEffect(node)
    if #self._cutEffectCountTb > 2 then
        table.remove(self._cutEffectCountTb, 1)
        if self._cutEffectTb[1] then
            sound.stopSound(self._cutEffectTb[1])
            self._cutEffectTb[1] = nil
            table.remove(self._cutEffectTb, 1)
        end
    end
    --停止飞起来的音效
    if node.stopCallBack then
        node.stopCallBack()
        node.stopCallBack = nil
    end
    if node._id >= 4 and node._id <= 7 then
        --加载图案烟花弹切开音效
        self:playCutPatternEffect()
    end
    local num = RD.numberExcept(12, 14, self._cutEffectCountTb)
    table.insert(self._cutEffectCountTb, num)
    local handlerNum = soundEffect["playEffectsfx057090" .. num](soundEffect)
    table.insert(self._cutEffectTb, handlerNum)
    local time = NV.soundDuration("effect/sfx057090" .. num .. ".mp3", 2)
    local emptyForAct = U.loadNode({}):to(self)
    emptyForAct:line({
        { "delay", time },
        { "fn", function()
            T.removeOrder(self._cutEffectCountTb, num)
            T.removeOrder(self._cutEffectTb, handlerNum)
        end },
        { "remove",}
    })
end

--加载图案烟花弹切开音效
function M:playCutPatternEffect()
    local num = math.random(18, 19)
    soundEffect["playEffectsfx057090" .. num](soundEffect)
    local time = NV.soundDuration("effect/sfx057090" .. num .. ".mp3", 2)
end

-- 加载白光
function M:loadWhiteLight(node)
    local pos = cc.p(node:cw()/2, node:ch() / 2 - 12)
    local scaleNum = 1.2
    -- 加载白光
    local light = D.img("common/whitelight.png"):to(node, -2):p(pos):scale(scaleNum)
    -- 旋转
    light:cycle({
        { "rotateBy", 1, 220 },
    })
    self._whiteLight = light
end

-- 升级
function M:upgrade()
    if self._gameOver then return end
    if self._cutCorrectNum >= UPGRADE_GOLD[self._level] and self._level < 3 then	-- 达到升级条件
        self._level = self._level + 1
        self._specialFireworkCutNum = 0					-- 特殊烟花切割次数
        self._specialFirework       = true				-- 是否出现特殊烟花
        self._specialAddNum         = 0                 -- 特殊烟花连击数
    end
end

-- 刀痕
function M:loadBlade()
    -- 残影效果
    -- 参数: 1.间隐的时间, 2.间隐片断的大小, 3.贴图的宽高, 4.颜色值RGB, 5.贴图的路径或者贴图对象 
    self._blade = CCMotionStreak:create(0.3, 1, 20, ccc3(255, 255, 255), "evefireworkcut/streak.png")
    self:addChild(self._blade, 999)
    -- -- 左辅助节点的刀光
    -- self._blade1 = CCMotionStreak:create(0.3, 1, 20, ccc3(255, 255, 255), "evefireworkcut/streak.png")
    -- self:addChild(self._blade1, 999)
    -- -- 有辅助节点的刀光
    -- self._blade2 = CCMotionStreak:create(0.3, 1, 20, ccc3(255, 255, 255), "evefireworkcut/streak.png")
    -- self:addChild(self._blade2, 999)
end

-- 切到烟花弹后表现
function M:cutFireworkShow(node)
	node._isCut = true

    if node._id <= 9 then			-- 正常烟花弹
        node:unbindTouch()
        --加载烟花弹切开音效
        self:playCutEffect(node)
		self:cutNormalFirework(node)	-- 切到正常烟花弹表现
        self:combo(node)            -- 连击显示加数字 
    elseif node._id == 20 then       --倒计时烟花
        node:unbindTouch()
        -- 播放音效[sfx05709026]切开炸弹
        soundEffect:playEffectsfx05709026()
        --停止倒计时烟花的音效
        self:stopCountDownEffect()
        --切到最终烟花
        self:cutEndFirework(node)  -- 切到倒计时烟花弹表现
    elseif node._id == 11 then      --大烟花
        --停止飞起来的音效
        if node.stopCallBack then
            node.stopCallBack()
            node.stopCallBack = nil
        end
		self:cutSpecialFirework(node)	-- 切到特殊烟花弹表现
		self:specialCombo(node)		-- 连击显示加数字
	end
	self:judgeIsOneEnd()			-- 判断本次是否结束
end

-- 切到特殊烟花表现
function M:cutSpecialFirework(node)
    if not node or tolua.isnull(node) then
        return
    end
    self:mainShake()			-- 屏幕震动
    self:fireworkShake(node, 0.5)	-- 烟花震动
    node:splitAct() --裂开
    -- 特殊烟花切割次数
    self._specialFireworkCutNum = self._specialFireworkCutNum + 1
    if self._timer then
        self:stopAction(self._timer)		-- 烟花停止出来
        self._timer = nil
    end
    --特殊烟花倒计时
    self:specialCountDown(node)
end

--特殊烟花倒计时
function M:specialCountDown(node)
    if not self._specialAction then
        --切到特殊烟花第一刀
        self:specialFirstCut(node)
        -- 开始倒计时
        self._specialAction = A.line({
            { "delay", SPECIAL_FIREWORK_TIME }, -- 停3秒可连续切.
            { "fn", function()
                T.removeOrder(self._fireworkTb, node) 				    -- 列表剔除，不能切了 
                if self._nodeAction then								-- 烟花抖动
                    node:stopAction(self._nodeAction)
                    self._nodeAction = nil
                end
                self:fireworkShake(node, 1)								-- 烟花震动
            end },
            { "delay", 0.5 }, -- 展示0.5秒
            { "fn", function()
                if self._specialFireworkCutNum > CUR_SPECIAL_MAX_NUM then	-- 特殊烟花限制最大切次数 
                    self._specialFireworkCutNum = CUR_SPECIAL_MAX_NUM
                end
                node:unbindTouch()
                self._cutNum = self._cutNum + self._specialFireworkCutNum	-- 切割数更新
                self:judgeIsOneEnd()				-- 判断本次是否结束
                self._specialFireworkCutNum = 0		-- 特殊烟花切次数清零
                self:removeGatherEffect()           --移除聚能音效
                self:closeSpecial()					-- 关闭特殊烟花模式
                self:removeGuideMask()				-- 移除遮罩聚焦
                --移除聚能粒子
                self:removeGatherParticle()
                self:specialBomb(node)				-- 特殊烟花炸开
            end },
            { "delay", 1.5 },
            { "fn", function()
                self._roundsPropNum = math.random(1, 2)
                self._specialAction = nil
                -- if self._level == 2 then
                --     --预加载图片
                --     self._mainLayer:initLoadImg(2)
                -- end
                self:loadFireworks()					-- 重新加载道具
            end },
        }):at(self)
    end
end

--切到特殊烟花第一刀
function M:specialFirstCut(node)
    self._isCutSpecial = true			-- 切到了
    node:stopAllActions()				-- 特殊烟花暂停
    self._skyNode:union({				-- 切板移动
        { "scaleTo", 0.5, 1.5 },
        { "moveBy", 0.5, cc.p(-300 - X_OFFSET, -700 - Y_OFFSET) },
    })
    node:line({							-- 特殊烟花蛋移动
        A.union({
            { "scaleTo", 0.5, 1.3 },
            { "moveTo", 0.5, cc.p(V.w_2, V.h_2) },
        }),
        { "fn", function()
            --显示裂开状态
            node:showSplit()
            -- 加载遮罩聚焦
            self:loadGuideMask(node, self, nil, nil, 2, 110)
            --加载聚能粒子
            self:loadGatherParticle()
            --加载聚能音效
            self:loadGatherEffect()
        end },
    })
    if self._whiteLight and not tolua.isnull(self._whiteLight) then
        -- 白光逐渐缩小
        self._whiteLight:line({
            { "scaleTo", SPECIAL_FIREWORK_TIME, 0.75 },
        })
    end
end

--加载聚能粒子
function M:loadGatherParticle()
    if self._gatherParticle then return end
    --聚能粒子
    local newPos = cc.p(V.w_2, V.h_2)
    local gatherParticle = Tools:newParticle("particle/high_juneng.plist", newPos.x, newPos.y):to(self._mainLayer, 222)
    Tools:insertParticleTb(self._mainLayer, gatherParticle)
    self._gatherParticle = gatherParticle
end

--移除聚能粒子
function M:removeGatherParticle()
    -- if self._gatherParticle then
    --     self._gatherParticle:stopSystem()
    --     self._gatherParticle:line({
    --         { "Delay", 0.5 },
    --         { "fn", function()
                if self._gatherParticle and not tolua.isnull(self._gatherParticle) then
                    self._gatherParticle:remove()
                    self._gatherParticle = nil
                end
    --         end },
    --     })
    -- end
end

--加载聚能音效
function M:loadGatherEffect()
    if self._gatherEffect then return end
    -- 播放音效[sfx05709016]巨型烟花弹聚能
    self._gatherEffect = soundEffect:playEffectsfx05709016()
end

--移除聚能音效
function M:removeGatherEffect()
    if self._gatherEffect then
        sound.stopSound(self._gatherEffect)
        self._gatherEffect = nil
    end
end

--加载炸开的烟花
function M:loadSpecialBoom()
    self._specialBombHandler = {}
    --第一个锚点 第二个帧数开始 第三个帧数总数
    local numTb = { { 6, 9 }, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 } }
    local posTb = { cc.p(532.3, 224.3), cc.p(370.5, 371.8), cc.p(380.2, 168.9), cc.p(645, 398.4), cc.p(624.4, 169.5),}
    for fireId = 1, 5 do
        --烟花帧数
        local fireStartNum = numTb[fireId][1]
        local fireCount = numTb[fireId][2]
        local boom = D.img("evefireworkcut/act/" .. "normal" .. "/" .. fireId .. "/" .. fireId .. "_" .. fireStartNum .. ".png")
        :to(self, 90):p(posTb[fireId].x, posTb[fireId].y + Y_OFFSET):hide():scale(1.6)
        table.insert(self._specialBombHandler, function()
            boom:line({
                { "fn", function()
                    boom:display("evefireworkcut/act/" .. "normal" .. "/" .. fireId .. "/" .. fireId .. "_" .. fireStartNum .. ".png"):opacity(255)
                end },
                { "show" },
                { "imagerange", "evefireworkcut/act/" .. "normal" .. "/" .. fireId .. "/" .. fireId .. "_", fireStartNum, fireCount, 1 / 20 },
                { "fadeto", 0.2, 0 },
                { "hide"}
            -- { "remove",}
            })
        end)
    end

    -- local posTb = { cc.p(165.6, 366.1), cc.p(859.9, 219.9), cc.p(650.7, 400.8), cc.p(209.4, 127.2), cc.p(667.9, 95.3) }
    -- local countTb = { 15, 27, 28, 13, 17 }
    -- for id = 1, 5 do
    --     local boom = D.img("evefireworkcut/act/" .. "normal" .. "/" .. id .. "/" .. id .. "_" .. 1 .. ".png")
    --     :to(self, 90):p(posTb[id].x, posTb[id].y + Y_OFFSET):hide():scale(1.6)
    --     table.insert(self._specialBombHandler, function()
    --         boom:line({
    --             { "delay", 0.1 * (id-1)},
    --             { "fn", function()
    --                 boom:display("evefireworkcut/act/" .. "normal" .. "/" .. id .. "/" .. id .. "_" .. 1 .. ".png"):opacity(255)
    --             end },
    --             { "show" },
    --             { "image", "evefireworkcut/act/" .. "normal" .. "/" .. id .. "/" .. id .. "_", countTb[id], 1 / 20 },
    --             { "fadeto", 0.2, 0 },
    --             { "hide" }
    --         -- { "remove",}
    --         })
    --     end)
    -- end
end

--特殊烟花炸开
function M:specialBomb(node)
    for i, v in ipairs(self._specialBombHandler) do
        v()
    end
    self:line({
        { "Delay", 0.5 },
        { "fn", function()
            local particle1 = Tools:newParticle("particle/high_gagaga.plist", V.w_2, V.h_2):to(self, 99)
            Tools:insertParticleTb(self, particle1)
        end }
    })
    self:line({
        { "Delay", 0.3 },
        { "fn", function()
            self:countDownFirework()
        end },
        { "Delay", 0.5 },
        { "fn", function()
            self:countDownFirework()
        end },
    })
    if node then
        -- 特殊烟花炸开
        node:specialBomb()
    end
end

--播放龙烟花
function M:playDragonBoom()
    -- 播放音效[sfx05709020]切开龙烟花,飞出来
    soundEffect:playEffectsfx05709020()
    local dragon = D.img("evefireworkcut/act/dragon/1.png"):to(self, 80):scale(2)
    dragon:p(-dragon:cw()*2, V.h_2)

    local newPos = cc.p(763.4, 143.6)
    local smokeParticle = Tools:newParticle("particle/high_dragon.plist", newPos.x, newPos.y):to(dragon, 222)
    Tools:insertParticleTb(dragon, smokeParticle)
    dragon:cycle({
        { "image", "evefireworkcut/act/dragon/", 6, 1 / 10 },
    })
    dragon:line({
        { "moveBy", 3, cc.p(V.w + dragon:cw() * 2 * 2, 0) },
        { "fn", function ()
            smokeParticle:stopSystem()
        end},
        {"delay", 1},
        {"fn", function ()
            smokeParticle:remove()
        end},
        {"fn", function ()
            Tools:removeParticleTb(dragon)
            if dragon and not tolua.isnull(dragon)then
                dragon:remove()
                dragon = nil
            end
        end},
    })
    dragon:line({
        { "Delay", 1 },
        { "fn", function()
            local particle1 = Tools:newParticle("particle/high_allstar.plist", V.w_2, V.h_2):to(self, 99)
            Tools:insertParticleTb(self, particle1)
        end }
    })
end

-- 关闭特殊模式
function M:closeSpecial(callBack)
    if not self._isNowSpecial then return end
    -- 回归正常
    self._isNowSpecial = false
    --重置天空
    self:resetSkyNode(callBack)
end

--重置天空
function M:resetSkyNode(callBack)
    self._skyNode:line({
        { "union", {
            { "scaleTo", 0.5, 1 },
            { "moveBy", 0.5, cc.p(300 + X_OFFSET, 700 + Y_OFFSET) },
        } },
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

-- 屏幕抖动
function M:mainShake()
    if self._mainShakeAct then
        self:stopAction(self._mainShakeAct)
        self._mainShakeAct = nil
        self:p(cc.p(0, 0))
    end
    local num = 2
    local action = A.cycle({
        { "moveBy", 1 / 60, cc.p(2 * num, 0) },
        { "moveBy", 1 / 60, cc.p(-4 * num, 0) },
        { "moveBy", 1 / 60, cc.p(3 * num, 0) },
        { "moveBy", 1 / 60, cc.p(-3 * num, 0) },
        { "moveBy", 1 / 60, cc.p(2 * num, 0) },
    }, 8)
    self._mainShakeAct = A.line({
        action, 
        {"fn", function ()
            self:p(cc.p(0, 0))
            self._mainShakeAct = nil
        end}
    }):at(self)
end

-- 点击遮罩 
function M:loadGuideMask(node, layer, x, y, scaleNum, opacityNum)
    if self._clip then return end
    scaleNum = ifnil(scaleNum, 1.3)
    opacityNum = ifnil(opacityNum, 200)
    if self._firstGuide or self._isNowEnd then	
        self:loadHandGuide(node)				-- 手指引导
    end
    x = ifnil(x, 0)
    y = ifnil(y, 0)
    local color = ccc3(0, 0, 0)
    if node._id == 11 then
        color = ccc3(255, 255, 255)
    end
    local mask = U.loadNodeMask({
        contentSize = cc.size(V.w * 3 + 2, V.h * 3),
        color        = color
    })
    :anchor(cc.p(0.5, 0.5))
    :p(V.w_2, 0)
    :opacity(opacityNum)
    local nodePos = node:convertToWorldSpaceAR(ccp(0, 0))
    nodePos = cc.p(nodePos.x + x, nodePos.y + y)
    -- 洞
    local img = "common/focusguide/2.png"
    if node._id == 11 then
        img = "common/focusguide/3.png"
    end
    local hole = D.img(img):p(nodePos):scale(5.9):opacity(opacityNum)
    local hole1 = D.img(img):p(nodePos):scale(5.9):to(self, 500):opacity(opacityNum)
    self._focushole = hole
    self._focushole1 = hole1
    -- ClippingNode 
    self._clip = CCNodeExtend.extend(cc.ClippingNode:create(hole)):to(self, 500)
    self._clip:setInverted(true)
    self._clip:setAlphaThreshold(0) -- 显示透明区域
    self._clip:addChild(mask)

    hole:line({
        { "easing", "SINEOUT", { "scaleTo", 0.3, scaleNum },},    
    })
    hole1:line({
        { "easing", "SINEOUT", { "scaleTo", 0.3, scaleNum },},
    })
end

-- 移除引导遮罩
function M:removeGuideMask()
    self:removeHand()	-- 移除手指引导
    if self._focushole then
        self._focushole:line({
            { "scaleTo", 0.5, 6 },
            { "fn", function()        
                Tools:removeNode(self._focushole)
                self._focushole = nil
                if self._clip then
                    Tools:removeNode(self._clip)
                    self._clip = nil
                end
            end },
        })
    end
    if self._focushole1 then
        self._focushole1:line({
            { "scaleTo", 0.5, 6 },
            { "fn", function()        
                Tools:removeNode(self._focushole1)
                self._focushole1 = nil
            end },
        })
    end
end

-- 手指引导
function M:loadHandGuide(node)
    -- if not self._firstGuide then return end
    local y1 = node:worldpoint().y - 38
    local hande = D.img("common/finger/3.png"):p(404.9 + X_OFFSET, y1):to(self, 100):hide()
    A.cycle({
        { "delay", 1 },
        { "show" },    
        { "moveTo", 1, cc.p(693.9 + X_OFFSET, y1) },
        { "delay", 0.5 },
        { "hide" },
        { "place", cc.p(404.9 + X_OFFSET, y1) },
    }):at(hande)
    self._hande = hande
    -- 刀光
    local motionsrteak = CCMotionStreak:create(0.5, 1, 30, ccc3(255, 255, 255), "evefireworkcut/streak.png")
    CCNodeExtend.extend(motionsrteak)
    self:addChild(motionsrteak, 99)
    self._motionsrteak = motionsrteak
    local y2 = y1 + 38
    motionsrteak:cycle({
        { "place", cc.p(351.9 + X_OFFSET, y2) },
        { "delay", 1 },
        { "show" },    
        { "moveTo", 1, cc.p(663.9 + X_OFFSET, y2) },
        { "delay", 0.5 },
        { "hide" },
    })
end

-- 移除手指
function M:removeHand()
    if self._hande then
        self._hande:stopAllActions()
        self._hande:remove()
        self._hande = nil
    end
    if self._motionsrteak then
        self._motionsrteak:stopAllActions()
        self._motionsrteak:remove()
        self._motionsrteak = nil
    end
end

-- 切到的烟花抖动
function M:fireworkShake(node, time)
    -- 震动
    if self._nodeAction then return end
    local action = A.actionShake({
        time        = time,
        strengthX = 30,
        strengthY = 30,
    })
    self._nodeAction = action
    self:plan(function()
        self._nodeAction = nil
    end, time)
    node:one(action)
end

-- 特殊烟花连击数字
function M:specialCombo(node)
    if self._canSpecialCombo then
        return
    end
    self._canSpecialCombo = true
    local pos = self:tagePoint(cc.pAdd(node:point(), cc.p(0, 60)), 10)
    self._specialAddNum = self._specialAddNum + 1
    local param = {
        value = self._specialAddNum,
        imgPre = "evefireworkcut/num/",
        margin = 20,
        itemWidth = 35,
        itemHeight = 30,
    }

    -- 去掉旧的数字
    if self._specialAdd then
        self._specialAdd:stopAllActions()
        self._specialAdd:remove()
        self._specialAdd = nil
    end
    -- 创建新的连切数
    local specialAdd = Tools:loadNum(param, self, pos):scale(0.8)
    self._specialAdd = specialAdd
    specialAdd:line({					-- 0.1s后再切
        { "delay", 0.1 },
        { "fn", function()
            self._canSpecialCombo = false
        end },
    })
    -- 隐藏
    specialAdd:line({
        { "delay", 1 },
        { "fadeOut", 0.5,},
        { "fn", function()        
            Tools:removeNode(specialAdd)
            self._specialAdd = nil
        end },
    })
end

-- 随机获得下一随机点坐标
function M:tagePoint(pos, radian)
    -- 圆心坐标
    local circle = pos
    -- 随机半径范围
    radian = ifnil(radian, 230)
    -- 随机圆角度
    local angle = math.random(0, 360)
    -- 计算得到 随机角度 后的坐标
    local x, y = radian * math.cos(angle), radian * math.sin(angle)
    -- 加上圆心坐标 得到 真实世界 坐标
    local newPoint = cc.pAdd(circle, ccp(x, y))
    return newPoint
end

-- 正常烟花
function M:cutNormalFirework(node)
	T.removeOrder(self._fireworkTb, node) 		-- 列表剔除，不能切了
	self._cutCorrectNum = self._cutCorrectNum + 1			-- 正确烟花总数，
	self._cutNum = self._cutNum + 1			-- 累计切的次数

	node:hide()
	-- 升级
	self:upgrade()
	-- 进度条增长
    self._progress:progressRise()
    --粒子跳到ui栏
    self:particleFlyToUi(node:worldpoint())
    --切开的粒子
    local pos = node:point()
    local particle1 = Tools:newParticle("particle/high_cut.plist", pos.x, pos.y):to(self, node:z()+1)
    Tools:insertParticleTb(self, particle1)
	-- 加载切开的烟花
    self:loadfireworkcut(node)
    if node._id == 9 then
        --播放龙烟花
        self:playDragonBoom()
    else
        --烟花绽放
        self:fireworkBoom(node)
    end
end

--切到最终烟花
function M:cutEndFirework(node)
    if self._gameOver then return end
    self._gameOver        = true
    self:removeGuideMask()				-- 移除遮罩聚焦
    T.removeOrder(self._fireworkTb, node) 		-- 列表剔除，不能切了
    node:hide()
    -- 加载切开的烟花
    self:loadfireworkcut(node)
    --倒计时烟花绽放
    self:endFireworkBoom(node)
    self:plan(function()
        self._cutFireworkSwitch = false
        self:removeEmptyNode()              -- 移除辅助节点
    end, 0.5)
end

--倒计时烟花绽放
function M:endFireworkBoom(node)
    local pos = cc.p(V.w_2, V.h_2)
    local boom = D.img("evefireworkcut/countDown/1/1_1.png"):to(self, 99):p(pos):scale(2)
    --最终倒计时烟花绽放
    self:endNumBoom(boom, 5)
    --月亮星星进场
    self:moonStarEnter()
end

--倒计时音效
function M:countDownEffect(num)
    local voiceIdTb = {"103", "102", "101", "100", "099"}
    soundVoice["playEffectv057" .. voiceIdTb[num]](soundVoice)

    local effectTb = { "sfx05709027", "sfx05709028", "sfx05709029", "sfx05709030", "sfx05709031",}
    soundEffect["playEffect" .. effectTb[num]](soundEffect)
    if num == 1 then
        -- 播放音效[sfx05709032]狂轰乱炸
        soundEffect:playEffectsfx05709032()
    end
end

--最终倒计时烟花绽放
function M:endNumBoom(node, num)
    local countTb = { 23, 23, 23, 23, 22 }
    -- 倒计时音效
    self:countDownEffect(num)
    local count = countTb[num]
    local imageTable = {}
    for i = 1, count do
        if i % 2 ~= 0 then
            local imgName = "evefireworkcut/countDown/" .. num .. "/" .. num .. "_" .. i .. ".png"
            table.insert(imageTable, imgName)
        end
    end
    local imgCount = #imageTable
    node:line({
        {"union",{
            -- {"line", {
            --     { "image", "evefireworkcut/countDown/" .. num .. "/" .. num .. "_", countTb[num] - 1, 1 / 23 },
            --     { "union", {
            --         { "fadeto", 2 / 23, 0 },
            --         { "imagerange", "evefireworkcut/countDown/" .. num .. "/" .. num .. "_", countTb[num] - 1, 2, 1 / 23 },
            --     } },
            -- }},
            { "filenames", imageTable, 1 / imgCount },
            {"line", {
                {"delay",  (imgCount-2)/imgCount},
                { "fadeto", 2 / imgCount, 0 },
            }},
            {"easing", "backout", { "scaleTo", 0.8, 1.5*2 }}
        }},
        { "fn", function()
            num = num - 1
            if num > 0 then
                --卸载倒计时烟花图片
                self._mainLayer:unloadTexure(num + 1)
                node:display("evefireworkcut/countDown/" .. num .. "/" .. num .. "_1.png"):opacity(255):scale(2)
                self:endNumBoom(node, num)
            else
                -- 播放配音[v057104]新年快乐！
                soundVoice:playEffectv057104()
                --倒计时完成
                self:countDownFirework()
                self:cycle({
                    {"Delay", 1},
                    {"fn", function ()
                        self:countDownFirework()
                    end},
                }, 10)
                --倒计时完，画面下降
                self:countDownFinish()
            end
        end }
    })
end

--倒计时完，画面下降
function M:countDownFinish()
    self:line({
        {"Delay", 2},
        {"fn", function ()
            local time = 2
            local dis = self._screenHight * 1.9
            self._skyNode:line({
                { "easing", "sineinout", { "moveBy", time, cc.p(0, dis) } },
            })
            --全体显示
            self._mainLayer:allAniShow()

            self:line({
                { "delay", 1.2 },
                { "fn", function()
                    --最后鼓掌
                    self._mainLayer:finishClip()
                end }
            })
            self._mainLayer:screenDown()
        end}
    })
end

--倒计时完成，放烟花咯
function M:countDownFirework()
    local offset = self._screenHight * 1.9
    -- 倒计时大烟花
    self:countDownFireworkBig(offset)
    -- 倒计时小烟花
    self:countDownFireworkSmall(offset)
end

-- 倒计时大烟花
function M:countDownFireworkBig(offset)
    --烟花动作
    local function fireworksAct1(fireworks)
        -- local countTb = { 15, 27, 28, 13, 17 }
        local countTbs = { { 6, 9,}, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 } }
        fireworks:line({
            { "delay", math.random(0, 20) / 100 },
            { "show" },
            { "imagerange", "evefireworkcut/act/normal/" .. fireworks._id .. "/" .. fireworks._id .. "_", countTbs[fireworks._id][1], countTbs[fireworks._id][2], 1 / 20 },
            -- { "image", "evefireworkcut/act/normal/" .. fireworks._id .. "/" .. fireworks._id .. "_", countTb[fireworks._id], 1 / 20 },
            { "fadeto", 0.2, 0 },
            { "fn", function ()
                if not tolua.isnull(fireworks) then
                    fireworks:remove()
                    fireworks = nil
                end
            end}
        })
    end
    -- local idTb = { 1, 2, 3, 4, 5, 1 }
    local idTb =  { { 1, 6,}, { 2, 12 }, { 3, 12 }, { 4, 6 }, { 5, 4 }, { 1, 6,} }

    idTb = T.shuffle(idTb, 5)
    local configTb = {
        cc.p(252.2, 313.7 + Y_OFFSET), cc.p(407.8, 232.7 + Y_OFFSET), cc.p(605, 396.1 + Y_OFFSET),
        cc.p(637.6, 139 + Y_OFFSET), cc.p(433.1, 410.5 + Y_OFFSET), cc.p(769.9 - 50, 281.4 + Y_OFFSET),
    }
    for i, v in ipairs(configTb) do
        local boom1 = D.img("evefireworkcut/act/normal/" .. idTb[i][1] .. "/" .. idTb[i][1] .. "_"..idTb[i][2]..".png"):to(self._skyNode, 999):p(v.x, v.y + offset):hide():scale(1.7)
        boom1._id = idTb[i][1]
        fireworksAct1(boom1)
    end
end

-- 倒计时小烟花
function M:countDownFireworkSmall(offset)
    --烟花动作
    local function fireworksAct(fireworks)
        fireworks:line({
            { "delay", math.random(0, 50) / 100 },
            { "image", "common/win/" .. fireworks._id .. "/" .. fireworks._id .. "_", 15, 1 / 12 },
            { "fadeto", 0.2, 0 },
            { "remove",}
        })
    end
    local posTb = { cc.p(203.1, 132.6), cc.p(909.6, 244.4), cc.p(282.9, 199.7), cc.p(803.6, 182.5) }
    for i, v in ipairs(posTb) do
        local fireworks = D.img("common/win/" .. i .. "/" .. i .. "_1.png"):to(self._skyNode, 999):p(v.x, v.y + Y_OFFSET + offset):scale(1.7)
        fireworks._id = i
        fireworksAct(fireworks)
    end
    local posTb = { cc.p(757.1, 74.6), cc.p(343.9, 80.1), cc.p(556.5, 74.3), cc.p(152.7, 269.3) }
    for i, v in ipairs(posTb) do
        local fireworks = D.img("common/win/" .. i .. "/" .. i .. "_1.png"):to(self._skyNode, 999):p(v.x, v.y + Y_OFFSET + offset):scale(1.7)
        fireworks._id = i
        fireworksAct(fireworks)
    end
end

--月亮星星进场
function M:moonStarEnter()
    for i, v in ipairs(self._starTb) do
        v:enter()
    end
    self._moon:enter()
end

-- 加载切开的烟花
function M:loadfireworkcut(node, num)
    local pos = node:point()
    local id = node._id
    local scaleNum = node:scale()
    num = ifnil(num, 2)
    for i = 1, num do
        -- 左右两边
        local int = i % 2 == 1 and -1 or 1
        local img = "evefireworkcut/firework/" .. node._id .. "/1_"..i..".png"
        local Ingredients = D.img(img):p(pos):to(self, 100):scale(scaleNum)
        local angle   = N.random(1, 180)
        local offsetX = angle + 80
        local endX    = pos.x + offsetX * int
        -- 掉落动作
        A.union({
            { "rotateby", 1, angle * int },
            A.line({
                { "jumpto", 1, cc.p(endX, -100), 200, 1 },
                { "fn", function()        
                    Tools:removeNode(Ingredients)    
                end },
            }),
        }):at(Ingredients)
    end
end

--下降爆炸
function M:downAct(node)
	if not node._isCut then
        if node._id ~= 11 and node._id ~= 9 then
            --烟花绽放
            self:fireworkBoom(node)
            local num = math.random(12, 14)
            soundEffect["playEffectsfx057090" .. num](soundEffect)
        end
	end
end

--烟花绽放
function M:fireworkBoom(node)
	local pos = node:point()
	local boomId  = node._id
	local scaleNum = node:scale()

	--index1:普通烟花还是图案烟花 2:烟花的序列
	local idFireWorkTb = {
		{ "normal", { 4, 5 } }, { "normal", { 1, 2, 3} }, { "normal", { 1, 2, 3} },
		{ "pattern", { 1 } }, { "pattern", { 3 } }, { "pattern", { 4} }, { "pattern", { 2 } },
	}
	--第一个锚点 第二个帧数开始 第三个帧数总数
	local numTb        = { normal = { { cc.p(0.5, 0.5), 6, 9, }, { cc.p(0.5, 0.4), 12, 15 }, { cc.p(0.5, 0.4), 12, 16 }, { cc.p(0.5, 0.5), 6, 7 }, { cc.p(0.5, 0.4), 4, 13 } },
					      pattern = { { cc.p(0.5, 0.5), 1, 17 }, { cc.p(0.5, 0.5), 1, 17 }, { cc.p(0.5, 0.5), 1, 15 }, { cc.p(0.5, 0.5), 1, 17 } } }
	--烟花类型
	local fireType     = idFireWorkTb[boomId][1]
	--烟花id
	local fireId       = T.random(idFireWorkTb[boomId][2])
	--烟花帧数
	local fireStartNum = numTb[fireType][fireId][2]
	local fireCount    = numTb[fireType][fireId][3]
    local anchorNum    = numTb[fireType][fireId][1]
    
    local scaleSize = 1.5 * 2
	local boom = D.img("evefireworkcut/act/"..fireType.."/"..fireId.."/"..fireId.."_"..fireStartNum..".png"):to(self, 90):p(pos):anchor(anchorNum):scale(scaleSize)
	boom:line({
		{ "imagerange", "evefireworkcut/act/" .. fireType .. "/" .. fireId .. "/" .. fireId .. "_", fireStartNum, fireCount, 1 / 20 },
		{ "fadeto", 0.2, 0},
		{ "remove",}
    })
    
    local particleNameTb = {
        normal = {nil, nil, nil, nil, nil,},
        pattern = {"high_heart", "high_star", "high_panda", "high_star",}
     }
    local name = particleNameTb[fireType][fireId]
    if name then
        local particle1 = Tools:newParticle("particle/" .. name .. ".plist", pos.x, pos.y):to(self, 99)
        Tools:insertParticleTb(self, particle1)

    end
end

-- 连击显示加数
function M:combo(node)
	self._addNum = self._addNum + 1
	if self._addNum > 2 and self._addNum <= 7 then-- 3-7之间显示
        if self._add then-- 去掉旧的数字
            self._add:stopAllActions()
            self._add:remove()
            self._add = nil
        end
        -- 创建连击数字, 限制在屏幕内
        local pos = node:point()
        if pos.y > V.h - 80 then
            pos = cc.p(pos.x, V.h - 80)
        elseif pos.y < 20 then
            pos = cc.p(pos.x, 20)
        elseif pos.x > V.w - X_OFFSET - 10 then
            pos = cc.p(V.w - X_OFFSET - 10, pos.x)
        end
        local add = D.imgp("evefireworkcut/add/" .. self._addNum .. ".png", pos):to(self, 1000):scale(0)
        self._add = add
        add:union({
            { "scaleTo", 0.15, 1 },
            { "jumpBy", 0.15, cc.p(0, 0), 40, 1 },
        })
        add:line({
            { "delay", 1 },
            { "fadeOut", 0.5,},
            { "fn", function()
                self._add = nil
            end },
            { "fn", function()        
                Tools:removeNode(add)    
            end },
        })
    end
    if not self._addAction then
        self._addAction = A.line({	-- 0.2秒缓冲时间
            { "delay", 0.2 },
            { "fn", function()
                if self._addNum > 2 then
                    if not self._isNowSpecial then-- 粒子飞到杯子,非特殊烟花模式
                        self._cutNum = self._cutNum + self._addNum-- 切割数更新
                        self:judgeIsOneEnd()			-- 判断本次是否结束
                    end
                end
                self._addNum = 0-- 重置
                self._addAction = nil
            end },
        }):at(self)
    end
end

-- 创建刀光辅助空节点
function M:loadEmptyNode(x, y)
    if self._emptyNode and not tolua.isnull(self._emptyNode) then
        return
	end
	--刀光辅助结点
	local node = C.loadNode():p(x, y):to(self, 10001)
	self._emptyNode = node
	-- 刀光粒子
	local particle1 = P.newParticle("particle/tuowei1.plist"):p(cc.p(0, 0)):to(node)
	local particle2 = P.newParticle("particle/tuowei2.plist"):p(cc.p(0, 0)):to(node)
    Tools:insertParticleTb(node, particle1)
    Tools:insertParticleTb(node, particle2)
    Tools:insertParticleTb(self, particle1)
    Tools:insertParticleTb(self, particle2)

	self._emptyNode._particle1 = particle1
	self._emptyNode._particle2 = particle2
end

-- 移除辅助节点
function M:removeEmptyNode()
    self:removeLeftRightNode()
    if self._emptyNode and not tolua.isnull(self._emptyNode) then
        Tools:removeParticleTb(self._emptyNode)
        self._emptyNode:remove()
        self._emptyNode = nil
    end
end

-- 移除扩大范围节点
function M:removeLeftRightNode()
    if not self._emptyNode or tolua.isnull(self._emptyNode) then
        return
    end
    -- 原有刀光粒子
    if self._emptyNode and self._emptyNode._LeftNode and self._emptyNode._particle1 then
        self._emptyNode._particle1:remove()
        self._emptyNode._particle1 = nil
        local particle1 = P.newParticle("particle/tuowei1.plist"):p(cc.p(0, 0)):to(self._emptyNode)
        Tools:insertParticleTb(self, particle1)
        Tools:insertParticleTb(self._emptyNode, particle1)
        self._emptyNode._particle1 = particle1
    end
    -- 原有刀光粒子
    if self._emptyNode and self._emptyNode._LeftNode and self._emptyNode._particle2 then
        self._emptyNode._particle2:remove()
        self._emptyNode._particle2 = nil
        local particle2 = P.newParticle("particle/tuowei2.plist"):p(cc.p(0, 0)):to(self._emptyNode)
        Tools:insertParticleTb(self, particle2)
        Tools:insertParticleTb(self._emptyNode, particle1)
        self._emptyNode._particle1 = particle2
    end
    -- 左右霹雳刀节点粒子移除
    if self._emptyNode and self._emptyNode._LeftNode then
        self._emptyNode._LeftNode:remove()
        self._emptyNode._LeftNode = nil
    end
    if self._emptyNode and self._emptyNode._RightNode then
        self._emptyNode._RightNode:remove()
        self._emptyNode._RightNode = nil
    end
end

-- 计算 转向 角度
function M:rotateToAngle(nextPoint, point)
    local myPoint = point or self:point()
    -- 计算两点的差异
    local pointOffset = ccpSub(nextPoint, myPoint)
    -- 算出弧度
    local angle = ccpToAngle(pointOffset)
    -- 将弧度转换为角度
    local degree = PT.radians2degrees(angle) -- 象限坐标和角色转向坐标正负相反
	degree = -degree + 90                    -- +90是初始角度，使头朝坐标轴y正方向
    -- 转向正常角度
    return degree
end

-- 碰撞检测
function M:detectCollision(point, params)
    -- 参数赋值
    local node        = params.node
    local factorNode    = params.factorNode
    local factorNodeX    = ifnil(params.factorNodeX, 1)
    local factorNodeY    = ifnil(params.factorNodeY, 1)

    if factorNode then
        factorNodeX = factorNode
        factorNodeY = factorNode
    end

    local box1 = node:getContentSize()
    local width, height, x, y
    x = node:point().x - box1.width * node:anchor().x * node:scaleX()
    y = node:point().y - box1.height * node:anchor().y * node:scaleY()

    width = box1.width * node:scaleX()
    height = box1.height * node:scaleY()
    box1 = cc.rect(
    x + width * (1 - factorNodeX) * 0.5,
    y + height * (1 - factorNodeY) * 0.5,
    width * factorNodeX,
    height * factorNodeY
    )

    local pos = node:getParent():convertToWorldSpace(cc.p(box1.x, box1.y))
    box1 = CCRect(pos.x, pos.y, box1.width, box1.height)
    return cc.rectContainsPoint(box1, point)
end

--刀痕移动
function M:bladeMove(x, y)
	-- 切痕
	if self._blade then
		-- 刀光音效
		self:bladeEffect(x, y)
		-- 加载霹雳刀辅助结点
		-- self:loadLeftRightNode()
		-- 刀光定位置                    
		self._blade:setPosition(CCPointMake(x, y))
		-- 计算旋转角度	
		local rotateNum = self:rotateToAngle(cc.p(x, y), self._startPos)
		-- 辅助节点实时更新
		if self._emptyNode and not tolua.isnull(self._emptyNode) then
			self._emptyNode:p(x, y):rotate(rotateNum)
		end
		self._startPos = cc.p(x, y)
	end
end

--刀光音效
function M:bladeEffect(x, y)
    if not self._cutEffect and PT.d(cc.p(x, y), self._startPos) > 10 then
        local num = math.random(9, 11)
        local time
        if num == 9 then
            self._cutEffect = soundEffect["playEffectsfx05709009"](soundEffect)
            time = NV.soundDuration("effect/sfx05709009.mp3", 0.4)
        else
            self._cutEffect = soundEffect["playEffectsfx057090" .. num](soundEffect)
            time = NV.soundDuration("effect/sfx057090" .. num .. ".mp3", 0.4)
        end
        self:line({
            { "delay", time },
            { "fn", function()
                self._cutEffect = nil
            end }
        })
    end
end

--判断是否切到烟花
function M:judgeCutFireWork(x, y)
	for _, v in pairs(self._fireworkTb) do    
		if not v or tolua.isnull(v) then
		else
			if v._id == 11 then                     --特殊大烟花弹
				if v:isVisible() and self:detectCollision(cc.p(x, y), { node = v, factorNode = 1 }) then
					if PT.d(cc.p(x, y), self._startPos) > self._specialDis then
						self._specialDis = 30
						self:cutFireworkShow(v)		-- 切到东西
					end
				end
			else									-- 除了特殊烟花弹以外的
				if v:isVisible() and self:detectCollision(cc.p(x, y), { node = v, factorNode = 1 }) then
					self:cutFireworkShow(v)			-- 切到东西
                    self:restartUp()				-- 引导没全切，重新抛起
				end
			end
		end
	end
end

--星星月亮幸福
function M:allHappy(type)
    for i, v in ipairs(self._starTb) do
        v:feedbackAni2()
    end
    self._moon:feedbackAni3()
end

-- 判断本次是否结束
function M:judgeIsOneEnd()
    if self._cutCorrectNum >= UPGRADE_GOLD[4] then
       -- 切结束
        self:cutOver() 
    end
end

-- 切结束
function M:cutOver()
    if self._gameOver then return end
    self._gameOver        = true
    self:plan(function()
        self._cutFireworkSwitch = false    	-- 关闭切烟花
        self:remainFirework()                  -- 剩余烟花炸开
        self:removeEmptyNode()              -- 移除辅助节点
        -- ui 退场
        self:uiQuit()
    end, 0.5)
end

-- 残余烟花炸开
function M:remainFirework()
    self._cutFireworkSwitch        = false		-- 切烟花开关
    -- 停止特殊烟花的动作
    if self._specialAction then
        self:stopAction(self._specialAction)
        self._specialAction = nil
    end
    for i, v in ipairs(self._fireworkTb) do
        if v and v._id then
            if v._id ~= 11 or v._id ~= 9 then
                v:hide()
                v._isCut = true
                --烟花绽放
                self:fireworkBoom(v)
            elseif v._id == 9 then
                v:hide()
                v._isCut = true
                --播放龙烟花
                self:playDragonBoom()
            end
        end
    end
    self:closeSpecial()		-- 关闭特殊模式

    self:line({
        {"Delay", 0.5},
        {"fn", function ()
            --下移屏幕
            self:downSreen()
        end}
    })
end

--下移屏幕
function M:downSreen()
    local time = 3
    local dis = self._screenHight * 1.9
    self._skyNode:line({
        { "easing", "sineinout", { "moveBy", time, cc.p(0, dis) } },
    })
    --全体显示
    self._mainLayer:allAniShow()

    self._mainLayer.countDownCallBackFn = function()
        -- local countTb = { 23, 23, 23, 23, 22 }
        -- for i, v in ipairs(countTb) do
        --     Tools:addTextureAsync("evefireworkcut/countDown/" .. i .. "/" .. i .. "_", 1, v)
        -- end
        --加载倒计时烟花层
        self._mainLayer:loadCutLayer(true)
    end
    self:line({
        {"delay", 1},
        {"fn", function ()
            --倒计时罚站定位哦
            self._mainLayer:familyStand()
        end}
    })
    self._mainLayer:screenDown(function()

    end)
end

-- 开局引导
function M:firstGuide()
    local pos = { cc.p(250 + X_OFFSET, -320 + Y_OFFSET), cc.p(500 + X_OFFSET, -320 + Y_OFFSET), cc.p(750 + X_OFFSET, -320 + Y_OFFSET) }
    local endX = { 450 + X_OFFSET, 500 + X_OFFSET, 550 + X_OFFSET }
    for i = 1, 3 do
        -- 获取食材id（去重）
        local id = Tools:getItemForTableExcept({ 1, 2, 3 }, self._lastItem)
        self._lastItem = id
        local imgName = "evefireworkcut/firework/" .. id .. "/1.png"
        local node = D.img(imgName):p(pos[i]):rotation(N.random(0, 360)):to(self, 97):scale(N.random(8, 10) / 10):bindTouch()

        node._id = id
        table.insert(self._fireworkTb, node)
        node:line({
            { "delay", 2 },
            { "fn", function()
                -- 已经切了，没必要了
                if self._firstGuide then
                    self._startGuide = true		-- 有进入引导
                    node:stopAllActions()
                    self:loadGuideMask(self._fireworkTb[2], self)
                end
            end },
        })
        node._endX = endX[i]
        -- 抛起
        node:line({
            A.union({
                { "jumpto", 3, cc.p(node._endX, -100), 500, 1 },
                { "rotateto", 3, N.random(-360, 360) }
            }),
            { "fn", function()
                T.removeOrder(self._fireworkTb, node)		-- 列表中剔除，不能切了	
                --下降爆炸
                self:downAct(node)
            end },
            { "fn", function()        
                Tools:removeNode(node)    
            end },
        })
    end
end

-- 首次引导没全切，重新抛起
function M:restartUp()
    if not self._firstGuide then return end
    if not self._isNowEnd then
        -- 播放配音[v057091]哇！好漂亮啊
        soundVoice:playEffectv057091()
    end
    self._firstGuide = false
    self:removeGuideMask()		-- 移除遮罩
    self:loadFireworks()
    if not self._startGuide then return end	-- 已经切了，没必要了
    for i, v in ipairs(self._fireworkTb) do
        if v then
            -- 抛起
            v:stopAllActions()
            v:line({
                A.union({
                    { "jumpto", 1, cc.p(v._endX, -100), 50, 1 },
                    { "rotateto", 1, N.random(-360, 360) }
                }),
                { "fn", function()
                    T.removeOrder(self._fireworkTb, v)		-- 列表中剔除，不能切了
                end },
                { "fn", function()        
                    Tools:removeNode(v)    
                end },
            })    
        end
    end
end

--粒子跳到ui栏
function M:particleFlyToUi(startP)
    local paricle = P.newParticle("particle/drg_jindutiao_tuowei2.plist")
    :to(self:getScene():getButtonLayer(), 1000):p(startP):bindTouch()
    Tools:insertParticleTb(self, paricle)

    local pos = self._progress._showParticle:worldpoint()
    paricle:line({
        { "jumpTo", 0.5, pos, 100, 1 },
        { "fn", function()        
            Tools:removeNode(paricle)    
        end },
    })
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
	if self._blade and self._canTouch and self._cutFireworkSwitch and not self._gameOver then
		-- 创建霹雳刀空节点
		self:loadEmptyNode(x, y)
		self._blade:reset()
		self._startPos = cc.p(x, y)
		return true
	end
end

function M:onTouchMoved(x, y, touches)
	if not self._cutFireworkSwitch then return end
	if not self._emptyNode or tolua.isnull(self._emptyNode) then return end
	-- xpcall(function()
		if PT.d(cc.p(x, y), self._startPos) > 2 then
			--判断是否切到烟花
			self:judgeCutFireWork(x, y)
			--刀痕移动
			self:bladeMove(x, y)
		end
	-- end, __G__TRACKBACK__)  
end

function M:onTouchEnded(x, y, touches)
	self:removeEmptyNode()		-- 移除空辅助节点
	if self._blade then
		self._blade:reset()
	end
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end



----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
    GLOBAL_TOUCH_LOCK = true
    --停止所有动作
	ND.stopActionCascade(self)
    Tools:removeLayerUnusedResource(self)
end

return M
