--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --初始图缩放大小
    self._scaleSize = BG_SCALE --0.58
    --计数
    self._count = 0
    --动物表
    self._aniTb = {}

    --跳过前情直接进入
    self._directEnter = self:getScene()._directEnter
    --进入场景名 put:放置烟花 cut 切烟花  countDown:倒计时
    self._firstEnter = self:getScene()._firstEnter
    --前情回调函数
    self.antecedentsCallBackFn = nil
    --倒计时回调函数
    self.countDownCallBackFn = nil
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- for i = 1, 4 do
    --     Tools:addTexture("common/win/" .. i .. "/" .. i .. "_", 1, 15)
    -- end
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 播放音效[057BGM10]舞龙
    sound:play057BGM10()
end

--加载背景
function M:loadBg()
    --远景
    local bgNodeFar = U.loadNode():to(self, 2)--:bindTouch()
    self._bgNodeFar = bgNodeFar
    --中景
    local bgNodeMid = U.loadNode():to(self, 4)--:bindTouch()
    self._bgNodeMid = bgNodeMid
    --近景
    local bgNodeNear = U.loadNode():to(self, 6)--:bindTouch()
    self._bgNodeNear = bgNodeNear
    --超近景
    local bgNodeNear2 = U.loadNode():to(self, 8)--:bindTouch()
    self._bgNodeNear2 = bgNodeNear2

    --加载近景
    self:loadNearBg()
    --加载远景
    self:loadFarBg()
    --加载中景
    self:loadMidBg()
end

--加载近景
function M:loadNearBg()
    local door = import("app.evefireworkput.node.Door").new({
        layer = self,
        parent = self._bgNodeNear,
        scaleSize = self._scaleSize
    }):to(self._bgNodeNear):p(V.w_2, 330):scale(self._scaleSize)
    self._door = door
    --加载梅花
    self:loadFlower()
end

--加载梅花
function M:loadFlower()
    local flower1 = D.img("evefireworkput/bg/flower/1.png"):to(self._bgNodeNear2):p(980.2 + X_OFFSET * 2, 380.1):scale(self._scaleSize):anchor(cc.p(0.89, 0.27))
    local flower2 = D.img("evefireworkput/bg/flower/2.png"):to(self._bgNodeNear2):p(1000.2 + X_OFFSET * 2, 480.1):scale(self._scaleSize):anchor(cc.p(0.98, 0.2))
    commonAct:breathing(flower1, self._scaleSize)
    commonAct:breathing(flower2, self._scaleSize)
end

--加载远景
function M:loadFarBg()
    --山
    local mountainPosTb = { cc.p(50.2 + X_OFFSET, 465), cc.p(546.6 + X_OFFSET, 536.3), cc.p(941.2 + X_OFFSET, 507),}
    for i, v in ipairs(mountainPosTb) do
        local mountain = D.img("evefireworkput/bg/mountain/" .. i .. ".png"):to(self._bgNodeFar, 2):p(v):scale(self._scaleSize*2)
    end

    local sky = import("app.evefireworkput.node.Sky").new({
        layer     = self,
        belong    = self._bgNodeFar,
        scaleSize = self._scaleSize,
        pos    = cc.p(V.w_2, 401)
    }):to(self._bgNodeFar, 1)
end


--加载中景
function M:loadMidBg()
    local pointsL = { cc.p(156.6 + X_OFFSET, 440.8), cc.p(-30 + X_OFFSET, 406.9) }
    for i, v in ipairs(pointsL) do
        local roomL = D.img("evefireworkput/bg/room/left/" .. i .. ".png"):to(self._bgNodeMid, 2):p(v):scale(self._scaleSize)
        if i == 2 then
            commonAct:breathing(roomL, self._scaleSize)
        end
    end
    local pointsR = { cc.p(1000 + X_OFFSET, 415.1), cc.p(838.8 + X_OFFSET, 429.3) }
    for i, v in ipairs(pointsR) do
        local roomR = D.img("evefireworkput/bg/room/right/" .. i .. ".png"):to(self._bgNodeMid):p(v):scale(self._scaleSize)
        if i == 1 then
            commonAct:breathing(roomR, self._scaleSize)
        end
    end

    local tree1 = D.img("evefireworkput/bg/room/left/2.png"):to(self._bgNodeMid, 2):p(171.7 + X_OFFSET, 277.5):scale(self._scaleSize)
    local tree2 = D.img("evefireworkput/bg/room/left/2.png"):to(self._bgNodeMid, 2):p(875.5 + X_OFFSET, 283.3):scale(self._scaleSize)
    commonAct:breathing(tree1, self._scaleSize)
    commonAct:breathing(tree2, self._scaleSize)
    --加载竹子
    local points = { cc.p(60 + X_OFFSET, 300.1), cc.p(60 + X_OFFSET, 300.1) }
    local anchorTb = { cc.p(0.8, 0), cc.p(0.1, 0) }
    for i, v in ipairs(points) do
        local bamboo = D.img("evefireworkput/bg/bamboo/" .. i .. ".png"):to(self._bgNodeMid, 1):p(v):scale(self._scaleSize):anchor(anchorTb[i])
        commonAct:breathing(bamboo, self._scaleSize, nil, 0.5)
    end
end

-- 加载结点
function M:loadPageNode()
    --加载爸爸
    self:loadDad()
    --加载妙妙
    self:loadMm()
    --加载妈妈
    self:loadMom()
    --加载奇奇
    self:loadQq()
    if self:getScene()._firstEnter == "put" then
        --加载放置烟花层
        self:loadPutLayer()
    elseif self:getScene()._firstEnter == "countDown"  or self:getScene()._firstEnter == "cut" then
        --预加载图片
        -- self:initLoadImg()
        --加载切烟花层
        self:loadCutLayer()
    end
end


--加载爸爸
function M:loadDad()
    local enterPos = cc.p(395.9 + X_OFFSET, 218.7)
    local dad = import("app.evefireworkput.node.AniDad").new({
        layer    = self,
        enterPos = enterPos,
        scaleSize = 0.8
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x, enterPos.y)
    self._dad = dad
    table.insert(self._aniTb, dad)
end

--加载妈妈
function M:loadMom()
    local enterPos = cc.p(560.1 + X_OFFSET, 206.3)
    local mom = import("app.evefireworkput.node.AniMom").new({
        layer    = self,
        enterPos = enterPos,
        scaleSize = 0.8
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x, enterPos.y)
    self._mom = mom
    table.insert(self._aniTb, mom)
end

--加载奇奇
function M:loadQq()
    local enterPos = cc.p(550 + X_OFFSET, 120.8)
    local qq = import("app.evefireworkput.node.AniQq").new({
        layer    = self,
        enterPos = enterPos,
        scaleSize = 0.8
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x, enterPos.y)
    self._qq = qq
    table.insert(self._aniTb, qq)
end

--加载妙妙
function M:loadMm()
    local enterPos = cc.p(420 + X_OFFSET, 120.7)
    local mm = import("app.evefireworkput.node.AniMm").new({
        layer    = self,
        enterPos = enterPos,
        scaleSize = 0.8
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x, enterPos.y)
    self._mm = mm
    table.insert(self._aniTb, mm)
end

-- 全家人在院子里准备放烟花，奇奇妙妙开心蹦跳，爸爸妈妈进行安全提示，“宝贝们，烟花是很危险的，要站远一点看鸭
-- 前情
function M:antecedents()
    -- 播放配音[v057090]放烟花咯
    soundVoice:playEffectv057090()
    -- 播放配音[v057093]放烟花咯
    soundVoice:playEffectv057093()
    --蹦跳
    self._qq:jumpAni()
    --蹦跳
    self._mm:jumpAni()
    --鼓掌
    self._mom:clapAni()
    self._dad:clapAni()
end

--开始说话
function M:startTalk()
    --低头说话（循环）
    self._mom:bowTalkAni1()
    -- self._dad:bowTalkAni1()
    -- 看老婆笑
    self._dad:watchSmileAni1()

    self._qq:listenAni1()
    self._mm:listenAni1()
end

--说话动作
--宝贝们，烟花是很危险的，要站远一点看鸭”
function M:momAndDadTalkAct()
    --低头说话（循环）
    self._mom:bowTalkAni2()
    -- 播放配音[v057096]宝贝们，烟花是很危险的，要站远一点看哟
    soundVoice:playEffectv057096()
    local time = soundVoice:soundDuration("v057096", 3)
    self:line({
        { "Delay", time },
        { "fn", function()
            --低头说话（结束）
            self._mom:bowTalkAni3()
            -- 看老婆笑（结束）
            self._dad:watchSmileAni3()
            self._qq:listenAni3()
            self._mm:listenAni3()
        end },
        {"delay", 0.5},
        {"fn", function ()
            self._mom:walkOutScreen()
            self._dad:walkOutScreen()
            self._qq:walkOutScreen()
            self._mm:walkOutScreen()
        end},
        {"Delay", 1.5},
        {"fn", function ()
            if self.antecedentsCallBackFn then
                self.antecedentsCallBackFn()
            end
        end}
    })
end

--全体显示
function M:allAniShow()
    for i, v in ipairs(self._aniTb) do
        v:p(v._enterPos):show():scale(v._scaleSize)
        v:breathAni()
    end
end

--倒计时罚站定位哦
function M:familyStand()
    --全部抬头看
    self:allLookUp()
    self:line({
        {"Delay", 1},
        {"fn", function ()
            --说话动作“除夕就要结束，新的一年要到啦，咱们一家人来倒计时吧~”
            self._mom:talkAct()
            self._mm:watchAni1()
            self._qq:watchAni1()
            --转头看妈妈
            self._dad:lookMomAni1()
        end}
    })
end

-- “好耶好耶！”
function M:qqAndMmTalk()
    self._dad:lookMomAni3()
    self._mm:watchAni3()
    self._qq:watchAni3()
    -- 播放配音[v057092]好耶好耶！
    soundVoice:playEffectv057092()
    -- 播放配音[v057094]好耶！
    soundVoice:playEffectv057094()

    local time = soundVoice:soundDuration("v057092", 2)
    self:line({
        {"Delay", time},
        {"fn", function ()
            self._qq:watchAni4()
            self._mm:watchAni4()
            if self.countDownCallBackFn then
                self.countDownCallBackFn()
            end
        end}
    })
end

--全部隐藏
function M:allAniHide()
    for i, v in ipairs(self._aniTb) do
        v:hide()
    end
end

--全部抬头看
function M:allLookUp()
    -- 播放音效[sfx05709022]一家人惊叹
    soundEffect:playEffectsfx05709022()
    for i, v in ipairs(self._aniTb) do
        --抬头看烟花（开始）
        v:riseAni1()
    end
end

--画面上移，切换至切烟花场景
function M:screenUp(time, dis, callBack)
    -- 播放音效[sfx05709023]场景升上空
    soundEffect:playEffectsfx05709023()
    time = ifnil(time, 2)
    dis = ifnil(dis, -500)
    local first = false
    function upAct(node)
        node:line({
            { "easing", "sineinout", { "moveBy", time, cc.p(0, dis) } },
            { "fn", function()
                if callBack and not first then
                    first = true
                    callBack()
                end
            end }
        })
    end
    upAct(self._bgNodeFar)
    upAct(self._bgNodeMid)
    upAct(self._bgNodeNear)
    upAct(self._bgNodeNear2)
end

--画面下移
function M:screenDown(callBack)
    local time2 = 2
    local first = false
    function upAct(node)
        node:line({
            { "easing", "sineinout", { "moveto", time2, cc.p(0, 0) } },
            { "fn", function()
                if callBack and not first then
                    first = true
                    callBack()
                end
            end }
        })
    end
    upAct(self._bgNodeFar)
    upAct(self._bgNodeMid)
    upAct(self._bgNodeNear)
    upAct(self._bgNodeNear2)
end

--移除其它层
function M:removeOtherLayer()
    --移除其它层
    self:getScene():removeOtherLayer()
end

--加载放置烟花层
function M:loadPutLayer()
    --移除其它层
    self:removeOtherLayer()
    return self:getScene():loadPutLayer(self)
end

--加载切烟花层
function M:loadCutLayer(isEnd)
    --移除其它层
    self:removeOtherLayer()
    local needBg = self:getScene()._firstEnter == "cut" and true or false
    isEnd = ifnil(isEnd, false)
    local endFireworkShow = isEnd
    return self:getScene():loadCutLayer(self, needBg, endFireworkShow)
end

--最后鼓掌
function M:finishClip()
    for i, v in ipairs(self._aniTb) do
        v._finish = true
    end
    -- 播放音效[sfx05709038]一家人开心欢呼
    soundEffect:playEffectsfx05709038()
    --蹦跳
    self._qq:jumpAni()
    --蹦跳
    self._mm:jumpAni()
    --鼓掌
    self._mom:clapAni()
    self._dad:clapAni()
    self:line({
        {"Delay", 1},
        {"fn", function ()
            --进入下个场景
            self:enterNextScene()
        end}
    })
end


--进入下个场景
function M:enterNextScene()
    local mask = U.loadNodeMask({
        contentSize = CCSize(V.w + 20, V.h + 20),
        color        = ccc3(0, 0, 0)
    }):anchor(cc.p(0, 0)):p(0, 0):opacity(0)
    :to(self, 99999)
    mask:line({
        {"fadeto", 1, 255},
        {"fn", function ()
            umengOP.recordEVEEnd()
            --增加完成的数目
            Tools:addDoneNum()
            game:enterScene("nyvisit", {}, "fade", 0.5, COLOR3_BLACK)
        end}
    })
end

--预加载图片
function M:initLoadImg(type)
    type = ifnil(type, 1)
    if type == 1 then
        local countTbs = {{ 6, 9,}, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 }}
        -- local countTb = { 15, 14, 15, 13, 17 }
        for i, v in ipairs(countTbs) do
            Tools:addTextureAsync("evefireworkcut/act/normal/" .. i .. "/" .. i .. "_", v[1], v[2] + v[1])
        end
    elseif type == 2 then
        local countTb = { 17, 17, 15, 17 }
        for i, v in ipairs(countTb) do
            Tools:addTextureAsync("evefireworkcut/act/pattern/" .. i .. "/" .. i .. "_", 1, v)
        end
        Tools:addTextureAsync("evefireworkcut/act/dragon/", 1, 6)
    elseif type == 3 then
        for i = 1, 5 do
            --加载倒计时烟花图片
            self:loadNumTexture(i)
        end
    end
    -- for i = 1, 4 do
    --     Tools:addTexture("common/win/" .. i .. "/" .. i .. "_", 1, 15)
    -- end
end


--预加载图片
function M:unLoadImg(type)
    type = ifnil(type, 1)
    if type == 1 then
        -- local countTb = { 15, 14, 15, 13, 17 }
        local countTbs = { { 6, 9,}, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 } }
        for i, v in ipairs(countTbs) do
            Tools:unloadTexure("evefireworkcut/act/normal/" .. i .. "/" .. i .. "_", v[1], v[2] + v[1])
        end
    elseif type == 2 then
        local countTb = { 17, 17, 15, 17 }
        for i, v in ipairs(countTb) do
            Tools:unloadTexure("evefireworkcut/act/pattern/" .. i .. "/" .. i .. "_", 1, v)
        end
        Tools:unloadTexure("evefireworkcut/act/dragon/", 1, 6)
    elseif type == 3 then
        for i = 1, 5 do
            --卸载倒计时烟花图片
            self:unloadTexure(i)
        end
    end
end

--加载倒计时烟花图片
function M:loadNumTexture(num)
    local countTb = { 23, 23, 23, 23, 22 }
    local count = countTb[num]
    for i = 1, count do
        if i%2 ~= 0 then
            local imgName = "evefireworkcut/countDown/" .. num .. "/" .. num .. "_"..i..".png"
            R.loadTextureAsync(imgName, function() end)
        end
    end
    -- Tools:addTextureAsync("evefireworkcut/countDown/" .. num .. "/" .. num .. "_", 1, count)
end

--卸载倒计时烟花图片
function M:unloadTexure(num)
    local countTb = { 23, 23, 23, 23, 22 }
    local count = countTb[num]
    for i = 1, count do
        if i % 2 ~= 0 then
            local imgName = "evefireworkcut/countDown/" .. num .. "/" .. num .. "_" .. i .. ".png"
            R.unloadTexture(imgName)
        end
    end
    -- Tools:unloadTexure("evefireworkcut/countDown/" .. num .. "/" .. num .. "_", 1, count)
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    GLOBAL_TOUCH_LOCK = true
    sound.stopAllSounds()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
