--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Put")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --主层
    self._mainLayer = params.mainLayer
    --触控
    self._canTouch  = false
    --初始图缩放大小
    self._scaleSize = BG_SCALE
    --计数
    self._count     = 0
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    GLOBAL_TOUCH_LOCK = false
    if self._mainLayer._directEnter then
        self._mainLayer._directEnter = false
        --全部隐藏
        self._mainLayer:allAniHide()
        --ui进场
        self:uiEnter()
    else
        self._mainLayer.antecedentsCallBackFn = function()
            --ui进场
            self:uiEnter()
        end
        self._mainLayer:antecedents()
    end
end

--加载背景
function M:loadBg()
    --放置位置
    local putAreaNode = U.loadNode():to(self, 1000)
    self._putAreaNode = putAreaNode
    
    local light = U.loadBg("evefireworkput/light.png"):to(self, 1500):opacity(0):scale(BG_SCALE*2)
    self._light = light

    local mask = U.loadBg("evefireworkput/mask.png"):to(self, 900):opacity(0):scale(BG_SCALE * 2)
    self._mask = mask

    local pos = ccp(V.w_2, 80)
    local placeParticle = P.newParticle("particle/yanhuaweizhi.plist"):p(pos):to(self._putAreaNode, 110)
    Tools:insertParticleTb(self, placeParticle)
    self._placeParticle = placeParticle
    self._isResetParticle = true
    --停止增加粒子
    self:stopPlaceParticle()
end

--显示位置粒子
function M:resetPlaceParticle()
    if self._isResetParticle then
        return
    end
    self._isResetParticle = true
    self._placeParticle:resetSystem()
end

--停止位置粒子
function M:stopPlaceParticle()
    if self._isResetParticle then
        self._isResetParticle = false
        self._placeParticle:stopSystem()
    end
end

function M:maskFadeIn()
    --亮起来
    self._mask:line({
        {"show"},
        { "fadeto", 1.3, 255 },
    })
end

function M:maskFadeOut()
    self._mask:stopAllActions()
    --亮起来
    self._mask:line({
        { "fadeto", 0.8, 0 },
        { "hide"}
    })
end

-- 加载结点
function M:loadPageNode()
    --加载烟花UI
    self:loadFireworkScrolUi()
end

-- 加载滚动Ui栏
function M:loadScrolUi(index, isScrol)
    local ui = import("app.common.node.ScrollUi").new({
        picPath     = "common/ui/uiBar.png",
        layer       = self,
        pos         = cc.p(1200 + X_OFFSET, 250 + Y_OFFSET),
        zOrder      = 100,
        showNumber  = 4,
        arrowScroll = isScrol,
        autoEnter   = false,
    }):to(self, 200):scale(1)
    self._ui = ui
end

--加载烟花UI
function M:loadFireworkScrolUi()
    -- 加载通用ui栏
    self:loadScrolUi(4, false)
    local itemTab = {}
    for i = 1, 4 do
        local item  = import("app.evefireworkput.node.put.Item").new({
            imgName   = "common/ui/item.png",
            type      = i,
            layer     = self,
            mainLayer = self._mainLayer,
            bar       = self._ui
        })
        item._itemSize = 0
        table.insert(itemTab, item)
    end
    -- 在滚动栏中添加初始项
    self._ui._scrollView:addItemToScrollView(itemTab)
end

--ui进场
function M:uiEnter()
    if self._count > 3 then
        -- 播放配音[v057095]呵呵，放烟花真开心
        soundVoice:playEffectv057095()
        local time1 = soundVoice:soundDuration("v057095", 2)
        local time2 = soundVoice:soundDuration("v057098", 2)
        self:line({
            {"Delay", time1},
            {"fn", function ()
                -- 播放配音[v057098]孩子们！快抬头看~
                soundVoice:playEffectv057098()
            end},
            {"Delay", time2},
            {"fn", function ()
                --加载切烟花层
                self._mainLayer:loadCutLayer()
            end}
        })
        return
    end
    self._count = self._count + 1
    self._ui:enter(function ()
        self._canTouch = true
    end)
end

--ui退场
function M:uiQuit()
    self:line({
        {"Delay", 0.5},
        {"fn", function ()
            self._ui:quit()      
        end}
    })
end

--画面上移
function M:screenUp(time, dis)
    local mainLayer = self._mainLayer
    mainLayer:screenUp(time, dis)
end

--画面下移
function M:screenDown(callBack)
    local mainLayer = self._mainLayer
    mainLayer:screenDown(callBack)
end

--进入下个场景
function M:enterNextScene()
    
end

-- 加载其他
function M:loadRenderOtherwise()

end

--移除大资源
function M:removeBigTexture()
    local imgTb = {
        "evefireworkput/light.png",
        "evefireworkput/mask.png"
    }
    for k, v in pairs(imgTb) do
        R.unloadTexture(v)
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if self._placeParticle  and not tolua.isnull(self._placeParticle) then
        self._placeParticle:remove()
        self._placeParticle = nil
    end
    GLOBAL_TOUCH_LOCK = true
    self:removeBigTexture()
    Tools:removeLayerUnusedResource(self)
end

return M
